/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.baseimpl;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.rmi.RemoteException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.ejb.EJBException;
import javax.ejb.NoSuchEJBException;
import jeus.ejb.MethodInterfaceType;
import jeus.ejb.baseimpl.BusinessInterfaceInfo;
import jeus.ejb.baseimpl.BusinessObject;
import jeus.ejb.baseimpl.EJBIfObjectType;
import jeus.ejb.baseimpl.LocalBusinessObjectClientHandler;
import jeus.ejb.baseimpl.RemoteInvokerHandler;
import jeus.ejb.baseimpl.RemoteInvokerServer;
import jeus.ejb.bean.rmi.StatefulSessionStubClusterSupport;
import jeus.ejb.bean.rmi.StatelessSessionStubClusterSupport;
import jeus.ejb.bean.rmi.StubClusterSupport;
import jeus.ejb.client.RemoteBusinessObjectClientHandler;
import jeus.ejb.container3.SessionContainer;
import jeus.ejb.interceptor.InvocationRequest;
import jeus.ejb.interceptor.InvocationType;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_EJB12;

public class BusinessObjectHandler
implements BusinessObject,
RemoteInvokerHandler,
InvocationHandler {
    public static String classname = BusinessObjectHandler.class.getName();
    protected static JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)classname);
    protected SessionContainer container;
    protected String ejbId;
    private ConcurrentMap<Class, Object> localProxyCache = new ConcurrentHashMap<Class, Object>();
    private ConcurrentMap<Class, Object> remoteProxyCache = new ConcurrentHashMap<Class, Object>();
    protected boolean active;
    protected RemoteInvokerServer remoteInvoker;
    protected String sessionID;

    public synchronized void _activate(SessionContainer container, String sessionID) {
        assert (container != null && sessionID != null);
        this.container = container;
        this.sessionID = sessionID;
        this.active = true;
        this.ejbId = container.getEJBId();
    }

    public synchronized void _deactivate() {
        this.unexport();
        this.container = null;
        this.sessionID = null;
        this.active = false;
        this.remoteProxyCache.clear();
    }

    private synchronized void export() throws RemoteException {
        if (this.remoteInvoker == null) {
            this.remoteInvoker = new RemoteInvokerServer(this, this.container.getRemoteInvocationManager(), this.container.getRemoteExporter());
        }
        if (!this.remoteInvoker.isExported()) {
            this.remoteInvoker.export();
            if (logger.isLoggable(JeusMessage_EJB12._9002_LEVEL)) {
                logger.log(JeusMessage_EJB12._9002_LEVEL, JeusMessage_EJB12._9002, (Object)this.toString());
            }
        }
    }

    private synchronized void unexport() {
        if (this.remoteInvoker != null) {
            this.remoteInvoker.unexport(true);
            if (logger.isLoggable(JeusMessage_EJB12._9003_LEVEL)) {
                logger.log(JeusMessage_EJB12._9003_LEVEL, JeusMessage_EJB12._9003, (Object)this.toString());
            }
        }
    }

    public String _getSessionID() {
        return this.sessionID;
    }

    public void _setSessionID(String sessionID) {
        this.sessionID = sessionID;
    }

    public SessionContainer _getContainer() {
        return this.container;
    }

    public void _setContainer(SessionContainer container) {
        this.container = container;
    }

    public EJBIfObjectType _getIfObjectType() {
        return EJBIfObjectType.BUSINESSOBJECT;
    }

    public Object getClientProxy(String interfaze) throws ClassNotFoundException, IllegalArgumentException, IOException {
        Class<?> interfaceCls = this.container.getClassLoader().loadClass(interfaze);
        return this.getClientProxy(interfaceCls);
    }

    public Object getClientProxy(Class interfaze) throws IllegalArgumentException, IOException {
        BusinessInterfaceInfo bizIntf;
        if (interfaze == null) {
            throw new IllegalArgumentException("null parameter");
        }
        String internalSessionId = this.sessionID;
        if (this.sessionID != null && this.sessionID.length() > 0) {
            internalSessionId = this.sessionID.substring(0, this.sessionID.indexOf(46));
        }
        if ((bizIntf = this.container.getBusinessInterfaceInfo(interfaze)) == null) {
            throw new IllegalArgumentException(interfaze.getName() + " is not valid business interface");
        }
        LocalBusinessObjectClientHandler localHandler = null;
        RemoteBusinessObjectClientHandler handler = null;
        Object localProxy = null;
        Object remotProxy = null;
        if (!bizIntf.isRemote()) {
            localProxy = this.localProxyCache.get(interfaze);
            if (localProxy == null) {
                localHandler = new LocalBusinessObjectClientHandler(this.ejbId, internalSessionId, interfaze, this);
                localProxy = bizIntf.newProxyInstance(localHandler);
                this.localProxyCache.putIfAbsent(interfaze, localProxy);
            } else {
                localHandler = (LocalBusinessObjectClientHandler)Proxy.getInvocationHandler(localProxy);
            }
        }
        if (bizIntf.isRemote()) {
            remotProxy = this.remoteProxyCache.get(interfaze);
            if (remotProxy == null) {
                this.export();
                handler = new RemoteBusinessObjectClientHandler(this.ejbId, internalSessionId, interfaze, this.remoteInvoker.getStub());
                remotProxy = bizIntf.newProxyInstance(handler);
                if (this.container.isClustered()) {
                    StubClusterSupport clusterSupport = this.container.isStateful() ? new StatefulSessionStubClusterSupport(handler, interfaze.getName(), this.sessionID) : new StatelessSessionStubClusterSupport(handler, interfaze.getName());
                    handler.setStubClusterSupport(clusterSupport, this.container.getBeanInfo().getRemoteIdempotentMethods());
                }
                this.remoteProxyCache.putIfAbsent(interfaze, remotProxy);
            } else {
                handler = (RemoteBusinessObjectClientHandler)Proxy.getInvocationHandler(remotProxy);
                if (this.container.isClustered() && this.container.isStateful()) {
                    handler.setSessionID(this.sessionID);
                }
            }
            if (this.container.isLocalInvocationOptimized()) {
                handler.setLocalCallHandler(interfaze, this);
            }
            return remotProxy;
        }
        return localProxy;
    }

    public Object invoke(String interfaze, String signature, Object[] args) throws Exception {
        if (!this.active) {
            throw new NoSuchEJBException();
        }
        Class<?> interfaceCls = this.container.getClassLoader().loadClass(interfaze);
        BusinessInterfaceInfo bizIntf = this.container.getBusinessInterfaceInfo(interfaceCls);
        if (bizIntf == null) {
            throw new EJBException(interfaze + " is not valid business interface");
        }
        MethodInterfaceType methodIntfType = bizIntf.remote ? MethodInterfaceType.Remote : MethodInterfaceType.Local;
        Method beanMethod = this.container.getBeanMethodWithSignature(signature);
        InvocationRequest request = InvocationRequest.create(InvocationType.BUSINESS_METHOD, null, beanMethod, args);
        request.setCaller(this);
        request.setMethodInterfaceType(methodIntfType);
        request.setInvokedInterface(bizIntf.getInterfaze());
        return this.container.invoke(request);
    }

    public Object invoke(Object interfaceObj, Method method, Object[] args) throws Exception {
        assert (interfaceObj instanceof Class);
        Class interfaze = (Class)interfaceObj;
        if (!this.active) {
            throw new NoSuchEJBException("unexported object");
        }
        BusinessInterfaceInfo bizIntf = this.container.getBusinessInterfaceInfo(interfaze);
        if (bizIntf == null) {
            throw new EJBException(interfaze.getName() + " is not valid business interface");
        }
        MethodInterfaceType methodIntfType = bizIntf.remote ? MethodInterfaceType.Remote : MethodInterfaceType.Local;
        Method beanMethod = this.container.getBeanMethodWithInterfaceMethod(method);
        InvocationRequest request = InvocationRequest.create(InvocationType.BUSINESS_METHOD, null, beanMethod, args);
        request.setCaller(this);
        request.setMethodInterfaceType(methodIntfType);
        request.setInvokedInterface(bizIntf.getInterfaze());
        return this.container.invoke(request);
    }
}

