/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.baseimpl;

import java.io.Serializable;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;
import jeus.ejb.EJBServerUtils;
import jeus.ejb.baseimpl.EJBContextImpl;
import jeus.ejb.baseimpl.SessionContextImpl;
import jeus.ejb.container3.StatefulSessionContainer;
import jeus.transaction.TxHelper;
import jeus.transaction.UserTransactionImpl;

public class EJBUserTransactionImpl
implements UserTransaction,
Serializable {
    private UserTransaction ut = TxHelper.getUserTransaction();
    protected static final EJBUserTransactionImpl instance = new EJBUserTransactionImpl();
    private static final String MSG_INVALID_STATE = "This UserTransaction is only for EJB. Cannot call methods outside EJB.";

    public static EJBUserTransactionImpl getInstance() {
        return instance;
    }

    protected EJBUserTransactionImpl() {
    }

    public void begin() throws NotSupportedException, SystemException {
        EJBContextImpl context = (EJBContextImpl)EJBServerUtils.getCurrentEJBContext();
        if (context == null) {
            throw new IllegalStateException(MSG_INVALID_STATE);
        }
        context.checkOperationsAllowed(1100);
        this.ut.begin();
        if (context instanceof SessionContextImpl && ((SessionContextImpl)context).isStateful()) {
            StatefulSessionContainer container = (StatefulSessionContainer)context.getContainer();
            container.associatesExtendedEMsWithTx((SessionContextImpl)context);
        }
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        EJBContextImpl context = (EJBContextImpl)EJBServerUtils.getCurrentEJBContext();
        if (context == null) {
            throw new IllegalStateException(MSG_INVALID_STATE);
        }
        context.checkOperationsAllowed(1100);
        this.ut.commit();
    }

    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        EJBContextImpl context = (EJBContextImpl)EJBServerUtils.getCurrentEJBContext();
        if (context == null) {
            throw new IllegalStateException(MSG_INVALID_STATE);
        }
        context.checkOperationsAllowed(1100);
        this.ut.rollback();
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        EJBContextImpl context = (EJBContextImpl)EJBServerUtils.getCurrentEJBContext();
        if (context == null) {
            throw new IllegalStateException(MSG_INVALID_STATE);
        }
        context.checkOperationsAllowed(1100);
        this.ut.setRollbackOnly();
    }

    public int getStatus() throws SystemException {
        EJBContextImpl context = (EJBContextImpl)EJBServerUtils.getCurrentEJBContext();
        if (context == null) {
            throw new IllegalStateException(MSG_INVALID_STATE);
        }
        context.checkOperationsAllowed(1100);
        return this.ut.getStatus();
    }

    public void setTransactionTimeout(int seconds) throws SystemException {
        EJBContextImpl context = (EJBContextImpl)EJBServerUtils.getCurrentEJBContext();
        if (context == null) {
            throw new IllegalStateException(MSG_INVALID_STATE);
        }
        context.checkOperationsAllowed(1100);
        this.ut.setTransactionTimeout(seconds);
    }

    public boolean getRollbackOnly() {
        EJBContextImpl context = (EJBContextImpl)EJBServerUtils.getCurrentEJBContext();
        if (context == null) {
            throw new IllegalStateException(MSG_INVALID_STATE);
        }
        context.checkOperationsAllowed(1100);
        return UserTransactionImpl.getRollbackOnly();
    }
}

