/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.bean.objectbase;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.rmi.RemoteException;
import javax.ejb.EJBHome;
import javax.ejb.EJBMetaData;
import javax.naming.InitialContext;
import javax.rmi.PortableRemoteObject;
import jeus.jndi.objectfactory.CosNamingResourceFactory;
import jeus.util.ErrorMsgManager;
import jeus.util.JeusException;
import jeus.util.JeusPort;
import jeus.util.JeusRuntimeException;
import jeus.util.message.JeusMessage_EJB2;
import jeus.util.properties.JeusNetPropertyValues;

public class IIOPEJBMetaDataImpl
implements EJBMetaData,
Serializable {
    transient EJBHome ejbHomeStub = null;
    private String hostName;
    private int port;
    private String exportName;
    private String homeClassName;
    private transient Class ejbHomeClass;
    private transient Class pKeyClass;
    private transient Class ejbObjectClass;
    private boolean isSessionBean;
    private boolean isStatelessSessionBean;

    public IIOPEJBMetaDataImpl(EJBHome ejbHomeStub, String str, Class ejbHomeClass, Class ejbObjectClass, Class pKeyClass, boolean isSessionBean, boolean isStatelessSessionBean) throws RemoteException {
        this.ejbHomeStub = ejbHomeStub;
        this.homeClassName = ejbHomeStub.getClass().getName();
        this.exportName = str;
        try {
            this.hostName = JeusNetPropertyValues.LOCAL_FULL_HOSTNAME;
            this.port = JeusPort.TnameServ;
        }
        catch (Throwable ex) {
            throw new JeusException(JeusMessage_EJB2._2003, ex);
        }
        this.pKeyClass = pKeyClass;
        this.ejbHomeClass = ejbHomeClass;
        this.ejbObjectClass = ejbObjectClass;
        this.isSessionBean = isSessionBean;
        this.isStatelessSessionBean = isStatelessSessionBean;
    }

    public Class getHomeInterfaceClass() {
        return this.ejbHomeClass;
    }

    public Class getRemoteInterfaceClass() {
        return this.ejbObjectClass;
    }

    public EJBHome getEJBHome() {
        return this.ejbHomeStub;
    }

    public Class getPrimaryKeyClass() {
        if (this.pKeyClass == null) {
            throw new JeusRuntimeException(ErrorMsgManager.getLocalizedString((int)JeusMessage_EJB2._2009));
        }
        return this.pKeyClass;
    }

    public boolean isSession() {
        return this.isSessionBean;
    }

    public boolean isStatelessSession() {
        return this.isStatelessSessionBean;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.homeClassName = in.readUTF();
        this.ejbHomeStub = this.innerGetEJBHome();
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            this.ejbHomeClass = loader.loadClass(this.homeClassName);
            String name = in.readUTF();
            this.pKeyClass = name.equals("null") ? null : loader.loadClass(name);
            name = in.readUTF();
            this.ejbObjectClass = loader.loadClass(name);
        }
        catch (Exception ex) {
            this.ejbHomeClass = Class.forName(this.homeClassName);
            String name = in.readUTF();
            this.pKeyClass = name.equals("null") ? null : Class.forName(name);
            name = in.readUTF();
            this.ejbObjectClass = Class.forName(name);
        }
    }

    private EJBHome innerGetEJBHome() throws RemoteException {
        if (this.ejbHomeStub == null) {
            try {
                InitialContext ctx = CosNamingResourceFactory.getCNCtx(this.hostName + ":" + this.port);
                Object obj = ctx.lookup(this.exportName);
                try {
                    this.ejbHomeStub = (EJBHome)PortableRemoteObject.narrow((Object)obj, obj.getClass().getClassLoader().loadClass(this.homeClassName));
                }
                catch (Throwable e) {
                    this.ejbHomeStub = (EJBHome)PortableRemoteObject.narrow((Object)obj, EJBHome.class);
                }
            }
            catch (Exception ex) {
                throw new RemoteException(ErrorMsgManager.getLocalizedString((int)JeusMessage_EJB2._2012, (Object[])new Object[]{this.exportName, this.hostName, String.valueOf(this.port)}), ex);
            }
        }
        return this.ejbHomeStub;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeUTF(this.ejbHomeClass.getName());
        if (this.pKeyClass != null) {
            out.writeUTF(this.pKeyClass.getName());
        } else {
            out.writeUTF("null");
        }
        out.writeUTF(this.ejbObjectClass.getName());
    }
}

