/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.bean.objectbase;

import javax.ejb.EJBException;
import javax.ejb.NoSuchObjectLocalException;
import javax.ejb.Timer;
import javax.ejb.TimerHandle;
import jeus.ejb.BeanContext;
import jeus.ejb.BeanState;
import jeus.ejb.EJBServerUtils;
import jeus.ejb.bean.objectbase.TimerImpl;
import jeus.ejb.container.TimerContainer;
import jeus.util.ErrorMsgManager;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_EJB2;

public class TimerHandleImpl
implements TimerHandle {
    private static final long serialVersionUID = -7920545908935129546L;
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.ejb.timer.handle");
    private Long timerId = null;

    public TimerHandleImpl(Long timerId) {
        if (logger.isLoggable(JeusMessage_EJB2._2301_LEVEL)) {
            logger.logp(JeusMessage_EJB2._2301_LEVEL, "TimerHandleImpl", "<init>", JeusMessage_EJB2._2301, (Object)timerId);
        }
        this.timerId = timerId;
    }

    public Timer getTimer() throws IllegalStateException, NoSuchObjectLocalException, EJBException {
        TimerImpl timer = null;
        BeanContext context = (BeanContext)EJBServerUtils.getCurrentEJBContext();
        if (context == null) {
            if (logger.isLoggable(JeusMessage_EJB2._2303_LEVEL)) {
                logger.logp(JeusMessage_EJB2._2303_LEVEL, "TimerHandleImpl", "getTimer", JeusMessage_EJB2._2303);
            }
            throw new IllegalStateException(ErrorMsgManager.getLocalizedString((int)JeusMessage_EJB2._2303));
        }
        BeanState status = context.getStatus();
        switch (status) {
            case DEP_INJECTION: 
            case POST_CONSTRUCT: 
            case PRE_DESTROY: 
            case PRE_PASSIVATE: 
            case POST_ACTIVATE: 
            case AFTER_COMPLETION: 
            case BMP_FIND: 
            case EJB_HOME: {
                if (logger.isLoggable(JeusMessage_EJB2._2304_LEVEL)) {
                    logger.logp(JeusMessage_EJB2._2304_LEVEL, "TimerHandleImpl", "getTimer", JeusMessage_EJB2._2304, (Object)status);
                }
                throw new IllegalStateException(ErrorMsgManager.getLocalizedString((int)JeusMessage_EJB2._2304, (Object)((Object)status)));
            }
        }
        TimerContainer timerContainer = TimerContainer.currentTimerContainer();
        if (timerContainer != null) {
            if (!timerContainer.timerExists(this.timerId)) {
                if (logger.isLoggable(JeusMessage_EJB2._2306_LEVEL)) {
                    logger.logp(JeusMessage_EJB2._2306_LEVEL, "TimerHandleImpl", "getTimer", JeusMessage_EJB2._2306, (Object)this.timerId);
                }
                throw new NoSuchObjectLocalException(ErrorMsgManager.getLocalizedString((int)JeusMessage_EJB2._2306, (Object)this.timerId));
            }
        } else {
            if (logger.isLoggable(JeusMessage_EJB2._2307_LEVEL)) {
                logger.logp(JeusMessage_EJB2._2307_LEVEL, "TimerHandleImpl", "getTimer", JeusMessage_EJB2._2307);
            }
            throw new EJBException(ErrorMsgManager.getLocalizedString((int)JeusMessage_EJB2._2307));
        }
        timer = new TimerImpl(this.timerId, timerContainer);
        return timer;
    }
}

