/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.bean.rmi;

import java.rmi.server.RemoteCall;
import java.rmi.server.RemoteRef;
import java.rmi.server.RemoteStub;
import jeus.ejb.bean.objectbase.JEUSClusterStub;
import jeus.ejb.bean.rmi.InterceptorContextProviderImpl;
import jeus.ejb.bean.rmi.StubClusterSupport;
import jeus.jndi.jns.common.DynamicLinkRef;
import jeus.rmi.spec.ClientInterceptor;
import jeus.rmi.spec.InterceptorContextProvider;

public abstract class RMIStub
extends RemoteStub
implements JEUSClusterStub {
    private static final long serialVersionUID = 8968326776380616953L;
    private static ThreadLocal clientInvoker = new ThreadLocal();
    protected StubClusterSupport clusterSupport;
    private ClientInterceptor stubClientInterceptor;
    public static final int EJB_RMI_VERSION = 0;

    public RMIStub(RemoteRef ref) {
        super(ref);
    }

    public RMIStub() {
    }

    protected void callClientInterceptors(RemoteCall call) throws Exception {
        if (this.stubClientInterceptor != null) {
            InterceptorContextProvider interceptorContextProvider = (InterceptorContextProvider)clientInvoker.get();
            if (interceptorContextProvider == null) {
                interceptorContextProvider = new InterceptorContextProviderImpl();
                clientInvoker.set(interceptorContextProvider);
            } else {
                interceptorContextProvider.getContext().clear();
            }
            this.stubClientInterceptor.intercept(call.getOutputStream(), interceptorContextProvider);
        }
    }

    protected void setException(Exception ex) throws Exception {
        if (this.stubClientInterceptor != null) {
            InterceptorContextProviderImpl interceptedClientInvoker = (InterceptorContextProviderImpl)clientInvoker.get();
            try {
                this.stubClientInterceptor.exceptionOccurred(ex, interceptedClientInvoker);
            }
            catch (Throwable e) {
                if (e instanceof Exception) {
                    throw (Exception)e;
                }
                throw (Error)e;
            }
        } else {
            throw ex;
        }
    }

    protected void callAfterClientInterceptors(RemoteCall call) throws Exception {
        if (this.stubClientInterceptor != null) {
            InterceptorContextProvider interceptorContextProvider = (InterceptorContextProvider)clientInvoker.get();
            this.stubClientInterceptor.afterIntercept(call.getInputStream(), interceptorContextProvider);
        }
    }

    public StubClusterSupport getClusterSupport() {
        return this.clusterSupport;
    }

    public void __setClusterSupport(StubClusterSupport clusterSupport) {
        this.clusterSupport = clusterSupport;
    }

    public void __jeus_setCluster(String exportName, DynamicLinkRef list) {
        this.clusterSupport.__jeus_setCluster(exportName, list);
    }

    public void setClientInterceptor(ClientInterceptor stubClientInterceptor) {
        this.stubClientInterceptor = stubClientInterceptor;
    }
}

