/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.compiler;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.ejb.EnterpriseBean;
import javax.ejb.FinderException;
import jeus.descriptor.ejb.TransactionInfo;
import jeus.ejb.compiler.ClassInfo;
import jeus.ejb.compiler.EJBSourceGenerator;
import jeus.ejb.compiler.EJBSourceGeneratorException;
import jeus.ejb.compiler.HomeInfo;
import jeus.ejb.compiler.InterfaceInfo;
import jeus.ejb.schema.BeanSchema;
import jeus.ejb.schema.CMPFieldRW;
import jeus.ejb.schema.CMRFieldRW;
import jeus.ejb.schema.cmp20.CMPFieldRWForCMP20;
import jeus.ejb.util.CodeWriter;
import jeus.ejb.util.MethodConvertor;
import jeus.util.ErrorMsgManager;
import jeus.util.StringUtil;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_EJB11;
import jeus.util.properties.JeusEJBProperties;
import jeus.xml.binding.ejbHelper.BeanPair;
import jeus.xml.binding.ejbHelper.CMEntityBeanPair;
import jeus.xml.binding.ejbHelper.EntityBeanPair;
import jeus.xml.binding.ejbHelper.FindMethodPair;
import jeus.xml.binding.ejbHelper.RelationshipRolePair;
import jeus.xml.binding.ejbHelper.SessionBeanPair;
import jeus.xml.binding.ejbHelper.StatefulSessionBeanPair;
import jeus.xml.binding.j2ee.CmpFieldType;
import jeus.xml.binding.jeusDD.ClusteringType;
import jeus.xml.binding.jeusDD.CmFieldType;
import jeus.xml.binding.jeusDD.MethodParamType;
import jeus.xml.binding.jeusDD.MethodParamsType;

public class BeanInfo
extends ClassInfo {
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.ejb.compiler.info");
    private HomeInfo homeInfo;
    public String beanClassName;
    public Class beanClassObject;
    public Method[] beanMethods;
    public String beanPackageName;
    public boolean isEntity;
    public boolean isStatelessSession;
    public boolean isConManaged;
    public boolean isBeanManaged;
    public int engineType;
    public boolean isContainerManagedTX = true;
    public boolean isStatefulCluster;
    public List nmMethods;
    public boolean isReadOnlyBean;
    protected ArrayList excludeTable;
    protected ArrayList uncheckTable;
    protected ArrayList securityInfo;
    protected Map transactionInfo;
    static final int TYPE_OBJECT = 0;
    static final int TYPE_LOCAL_OBJECT = 1;
    static final int TYPE_HOME = 2;
    static final int TYPE_LOCAL_HOME = 3;
    public static final int TYPE_BEAN = 4;
    public static final int TYPE_SERVICE_ENDPOINT = 5;
    public List findMethods;
    private String isDelayDatabaseInsertUntil;
    private String moduleName;
    private String ejbName;
    private boolean useAccessControl;
    private ArrayList methodDeclList = new ArrayList();
    static final int TYPE_CMP = 4;
    static final int TYPE_BMP = 3;
    static final int TYPE_STATELESS = 1;
    static final int TYPE_STATEFUL = 2;
    private int unspecifiedTransactionType;
    private boolean defaultIncludeUpdate;
    Class abstractBeanClassObject;
    String baseImplClassName;
    String abstractClassName;
    String abstractClassPackageName;
    private String fullAbstractClassName;
    private String fullBaseImplClassName;
    boolean enableInstantQL;

    void initEJBBeanInfo(EJBSourceGenerator generator) throws EJBSourceGeneratorException {
        this.generator = generator;
        ClassLoader loader = generator.getClassLoader();
        BeanPair deployD = generator.getDescriptor();
        this.homeInfo = generator.getHomeInfo();
        try {
            this.beanClassObject = loader.loadClass(deployD.getOriginalEJBBeanClassName());
        }
        catch (ClassNotFoundException ex) {
            throw new EJBSourceGeneratorException(JeusMessage_EJB11._7001, (Throwable)ex);
        }
        if (!EnterpriseBean.class.isAssignableFrom(this.beanClassObject)) {
            throw new EJBSourceGeneratorException(JeusMessage_EJB11._7002);
        }
        this.beanClassName = StringUtil.cutPackagePart((String)this.beanClassObject.getName());
        this.beanMethods = this.beanClassObject.getMethods();
    }

    void postInitBeanInfo(BeanPair deployD) throws EJBSourceGeneratorException {
        String longName;
        int index;
        if (!this.isEntity) {
            this.isContainerManagedTX = ((SessionBeanPair)deployD).isContainerManagedTX();
        } else {
            this.defaultIncludeUpdate = ((EntityBeanPair)deployD).getDefaultIncludeUpdate();
            if (this.isConManaged) {
                CMEntityBeanPair desc = (CMEntityBeanPair)deployD;
                this.isDelayDatabaseInsertUntil = desc.getDelayDatabaseInsertUntil();
                this.findMethods = desc.getFindMethods();
            }
        }
        if (deployD instanceof StatefulSessionBeanPair && this.isClusteredDescriptor(deployD)) {
            this.isStatefulCluster = true;
        }
        if ((index = (longName = this.beanClassObject.getName()).lastIndexOf(46)) == -1) {
            throw new EJBSourceGeneratorException(JeusMessage_EJB11._7003);
        }
        this.beanPackageName = longName.substring(0, index);
        this.useAccessControl = deployD.isUseAccessControl();
    }

    boolean isClusteredDescriptor(BeanPair deployD) {
        ClusteringType clustering = deployD.getClusterDesc();
        return clustering != null && clustering.isEnableClustering() != false;
    }

    private static String attachTypePostfix(int intType, String method) {
        switch (intType) {
            case 0: {
                return method + "R";
            }
            case 1: {
                return method + "L";
            }
            case 2: {
                return method + "RH";
            }
            case 3: {
                return method + "LH";
            }
            case 5: {
                return method + "S";
            }
            case 4: {
                return method;
            }
        }
        return null;
    }

    protected int getTxAttribute(Method m, int type) throws EJBSourceGeneratorException {
        if (this.homeInfo.isDefaultLocalHome(type)) {
            return 2;
        }
        if (this.transactionInfo == null && this.unspecifiedTransactionType >= 0) {
            return this.unspecifiedTransactionType;
        }
        return BeanInfo.getTxAttributeWithTxInfo(m, type, this.transactionInfo, this.unspecifiedTransactionType, 2);
    }

    public static int getTxAttributeWithTxInfo(Method m, int type, Map transactionInfo, int unspecifiedTransactionType, int defaultTxAttribute) {
        Integer txAttribute = null;
        String method = MethodConvertor.getMethodDeclaration(m);
        String temp = BeanInfo.attachTypePostfix(type, method);
        if (transactionInfo != null && (txAttribute = (Integer)transactionInfo.get(temp)) == null && (txAttribute = (Integer)transactionInfo.get(method)) == null && (txAttribute = (Integer)transactionInfo.get(BeanInfo.attachTypePostfix(type, m.getName() + "()"))) == null && (txAttribute = (Integer)transactionInfo.get(m.getName() + "()")) == null) {
            txAttribute = (Integer)transactionInfo.get("*");
        }
        if (txAttribute != null) {
            return txAttribute;
        }
        if (unspecifiedTransactionType >= 0) {
            return unspecifiedTransactionType;
        }
        String systemProperty = JeusEJBProperties.DEFAULT_EJB_TX_ATTRIBUTE;
        if (systemProperty == null) {
            return defaultTxAttribute;
        }
        return TransactionInfo.getTransactionType(systemProperty);
    }

    void initializeMethodAttributeTable(ArrayList excludeTable, ArrayList uncheckTable) {
        this.excludeTable = excludeTable == null ? new ArrayList() : excludeTable;
        this.uncheckTable = uncheckTable == null ? new ArrayList() : uncheckTable;
    }

    void setTransactionInfo(Map info) {
        this.transactionInfo = info;
    }

    void setSecurityInfo(ArrayList info) {
        this.securityInfo = info;
    }

    void setGenerator(EJBSourceGenerator g) {
        this.generator = g;
    }

    int getBeanType() {
        if (this.isEntity) {
            if (this.isConManaged) {
                return 4;
            }
            return 3;
        }
        if (this.isStatelessSession) {
            return 1;
        }
        return 2;
    }

    void initBaseBeanInfo(EJBSourceGenerator generator, CMEntityBeanPair desc) throws EJBSourceGeneratorException {
        this.findMethods = desc.getFindMethods();
        String beanClassNameAtSchema = desc.getFullEJBBeanClassName();
        this.generator = generator;
        ClassLoader loader = generator.getClassLoader();
        int index = beanClassNameAtSchema.lastIndexOf(46);
        if (index == -1) {
            throw new EJBSourceGeneratorException(JeusMessage_EJB11._7003);
        }
        this.abstractClassName = StringUtil.getClassName((String)desc.getFullEJBBeanClassName());
        this.abstractClassPackageName = beanClassNameAtSchema.substring(0, index);
        this.baseImplClassName = this.abstractClassName + "BaseImpl";
        this.fullBaseImplClassName = this.abstractClassPackageName + "." + this.baseImplClassName;
        int hashCode = this.fullBaseImplClassName.hashCode();
        this.baseImplClassName = this.baseImplClassName + (hashCode & Integer.MAX_VALUE);
        this.baseImplClassName = InterfaceInfo.checkImplName(this.baseImplClassName);
        this.fullBaseImplClassName = this.abstractClassPackageName + "." + this.baseImplClassName;
        this.fullAbstractClassName = this.abstractClassPackageName + "." + this.abstractClassName;
        try {
            this.abstractBeanClassObject = loader.loadClass(this.getFullAbstractClassName());
        }
        catch (ClassNotFoundException ex) {
            throw new EJBSourceGeneratorException(JeusMessage_EJB11._7006, (Throwable)ex);
        }
    }

    String getFullAbstractClassName() {
        return this.fullAbstractClassName;
    }

    String getFullBaseImplClassName() {
        return this.fullBaseImplClassName;
    }

    String getBeanClassName(String moduleName, CMEntityBeanPair beanPair) {
        String beanClassName = beanPair.getFullEJBBeanClassName();
        int packageIndex = beanClassName.lastIndexOf(".");
        String className = beanClassName.substring(packageIndex + 1) + "_" + StringUtil.replaceToValidClassName((String)moduleName) + "BaseImpl";
        String packageName = packageIndex >= 0 ? beanClassName.substring(0, packageIndex + 1) : "";
        String tmp = packageName + className;
        int hashCode = tmp.hashCode();
        className = beanClassName.substring(packageIndex + 1) + "BaseImpl";
        className = className + (hashCode & Integer.MAX_VALUE);
        className = InterfaceInfo.checkImplName(className);
        tmp = packageName + className;
        return tmp;
    }

    void writeCMPBaseImpl(OutputStream out, BeanSchema bSchema) throws Exception {
        int i;
        int i2;
        Constructor cons;
        if (logger.isLoggable(JeusMessage_EJB11._7065_LEVEL)) {
            logger.log(JeusMessage_EJB11._7065_LEVEL, JeusMessage_EJB11._7065, (Object)(this.abstractClassPackageName + "." + this.baseImplClassName));
        }
        CodeWriter codewriter = new CodeWriter(out);
        codewriter.write("package " + this.abstractClassPackageName + ";");
        codewriter.write("");
        codewriter.write("import jeus.util.message.JeusMessage_EJB11;");
        codewriter.write("import jeus.util.Serializer;");
        codewriter.write("");
        codewriter.write("public class " + this.baseImplClassName + " extends " + this.abstractClassName + " implements jeus.ejb.bean.objectbase.FieldAccessor");
        codewriter.write("{");
        codewriter.write("");
        codewriter.TabIn();
        try {
            cons = this.abstractBeanClassObject.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new EJBSourceGeneratorException(JeusMessage_EJB11._7007);
        }
        Class<?>[] exceptions = cons.getExceptionTypes();
        codewriter.cwrite("public " + this.baseImplClassName + "()");
        for (int i3 = 0; i3 < exceptions.length; ++i3) {
            if (i3 == 0) {
                codewriter.cwrite(" throws ");
            } else {
                codewriter.cwrite(", ");
            }
            codewriter.cwrite(exceptions[i3].getName());
        }
        codewriter.write("");
        codewriter.write("{");
        codewriter.write("\tsuper();");
        codewriter.write("}");
        Method[] methods = this.abstractBeanClassObject.getMethods();
        ArrayList unUsedMethods = this.getAccessMethods(methods);
        String[] fields = new String[methods.length];
        String[] fieldTypes = new String[methods.length];
        int numFields = 0;
        CMEntityBeanPair beanPair = bSchema.beanPair;
        ArrayList cmFiledsRWs = new ArrayList();
        cmFiledsRWs = bSchema.sqlGen.cmFieldRWs;
        List cmFields = beanPair.getCMFieldsInJar();
        for (int i4 = 0; i4 < cmFields.size(); ++i4) {
            CmpFieldType cmField = (CmpFieldType)cmFields.get(i4);
            String fieldName = cmField.getFieldName().getValue();
            CmFieldType cmFieldInDD = beanPair.getCMFieldInDD(fieldName);
            String getMethodName = "get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
            String setMethodName = "set" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
            String fieldType = null;
            for (int j = 0; j < methods.length; ++j) {
                if (!methods[j].getName().equals(getMethodName) || methods[j].getParameterTypes().length != 0) continue;
                unUsedMethods.remove(methods[j]);
                this.checkDeclarationOfSetter(methods, setMethodName, unUsedMethods);
                Class<?> type = methods[j].getReturnType();
                fieldType = StringUtil.getTypeDeclaration(type);
                Boolean excludeField = cmFieldInDD.isExcludeField();
                if (excludeField != null && excludeField.booleanValue()) {
                    codewriter.write("public " + fieldType + " " + getMethodName + "()");
                    codewriter.write("{");
                    codewriter.TabIn();
                    codewriter.write("\tthrow new jeus.util.JeusRuntimeException(\"" + ErrorMsgManager.getLocalizedString((int)JeusMessage_EJB11._7008) + "\");");
                    codewriter.TabOut();
                    codewriter.write("}");
                    codewriter.write("");
                    codewriter.write("public void " + setMethodName + "(" + fieldType + " " + fieldName + ")");
                    codewriter.write("{");
                    codewriter.TabIn();
                    codewriter.write("\tthrow new jeus.util.JeusRuntimeException(\"" + ErrorMsgManager.getLocalizedString((int)JeusMessage_EJB11._7008) + "\");");
                    codewriter.TabOut();
                    codewriter.write("}");
                } else {
                    fields[numFields] = fieldName;
                    fieldTypes[numFields] = fieldType;
                    this.writeFieldDeclaration(codewriter, fieldType, fieldName);
                    codewriter.write("public " + fieldType + " " + getMethodName + "()");
                    codewriter.write("{");
                    codewriter.TabIn();
                    if (!beanPair.isSetAsPkeyField(fieldName)) {
                        this.writePostLoadBlock(codewriter, numFields, 0);
                    }
                    if (this.isPrimitiveClass(type)) {
                        codewriter.write("return " + fieldName + ";");
                    } else {
                        if (!Serializable.class.isAssignableFrom(type) && !type.isInterface()) {
                            throw new EJBSourceGeneratorException(JeusMessage_EJB11._7009);
                        }
                        if (Cloneable.class.isAssignableFrom(type)) {
                            codewriter.write("if(" + fieldName + " != null) {");
                            codewriter.write("\treturn (" + fieldType + ")" + fieldName + ".clone();");
                            codewriter.write("}");
                            codewriter.write("return null;");
                        } else {
                            codewriter.write("if(" + fieldName + " != null) {");
                            codewriter.write("\treturn (" + fieldType + ") Serializer.cloneObjectStatic(" + fieldName + ");");
                            codewriter.write("}");
                            codewriter.write("return null;");
                        }
                    }
                    codewriter.TabOut();
                    codewriter.write("}");
                    codewriter.write("");
                    codewriter.write("public void " + setMethodName + "(" + fieldType + " " + fieldName + ")");
                    codewriter.write("{");
                    codewriter.TabIn();
                    codewriter.write("_modified[" + numFields + "] = true;");
                    CMPFieldRWForCMP20 cmpFieldRW = (CMPFieldRWForCMP20)cmFiledsRWs.get(i4);
                    int[] cmrIndx = cmpFieldRW.getSharedCMRFiledIndex();
                    if (cmrIndx != null) {
                        for (int k = 0; k < cmrIndx.length; ++k) {
                            codewriter.write("_modified[" + cmrIndx[k] + "] = false;");
                        }
                    }
                    if (this.isPrimitiveClass(type)) {
                        codewriter.write("this." + fieldName + " = " + fieldName + ";");
                    } else {
                        if (!Serializable.class.isAssignableFrom(type) && !type.isInterface()) {
                            throw new EJBSourceGeneratorException(JeusMessage_EJB11._7009);
                        }
                        if (Cloneable.class.isAssignableFrom(type)) {
                            codewriter.write("if(" + fieldName + " != null) {");
                            codewriter.write("\tthis." + fieldName + " = (" + fieldType + ")" + fieldName + ".clone();");
                            codewriter.write("}else {");
                            codewriter.write("\tthis." + fieldName + " = null;");
                            codewriter.write("}");
                        } else {
                            codewriter.write("if(" + fieldName + " != null) {");
                            codewriter.write("\tthis." + fieldName + " = (" + fieldType + ") Serializer.cloneObjectStatic(" + fieldName + ");");
                            codewriter.write("}else {");
                            codewriter.write("\tthis." + fieldName + " = null;");
                            codewriter.write("}");
                        }
                    }
                    codewriter.TabOut();
                    codewriter.write("}");
                }
                ++numFields;
            }
            if (fieldType != null) continue;
            throw new EJBSourceGeneratorException(JeusMessage_EJB11._7010, getMethodName);
        }
        int loadedIndex = 1;
        int cmrFieldIdx = cmFields.size();
        for (i2 = 0; i2 < bSchema.relations.size(); ++i2) {
            RelationshipRolePair relation = (RelationshipRolePair)bSchema.relations.elementAt(i2);
            CMRFieldRW cmrFieldRW = relation.getFieldRW();
            String fieldName = relation.getCMRFieldName();
            String getMethodName = "get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
            String setMethodName = "set" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
            String fieldType = null;
            if (!BeanSchema.isContainerDefinedCMRField(fieldName)) {
                this.checkDeclarationOfSetter(methods, setMethodName, unUsedMethods);
                fieldType = this.checkDeclarationOfGetter(methods, getMethodName, unUsedMethods, fieldName);
            } else {
                fieldType = relation.isMultipleRelationType() ? "java.util.Collection" : "javax.ejb.EJBLocalObject";
            }
            fields[numFields] = fieldName;
            fieldTypes[numFields] = fieldType;
            this.writeFieldDeclaration(codewriter, fieldType, fieldName);
            if (!BeanSchema.isContainerDefinedCMRField(fieldName)) {
                codewriter.cwrite("public ");
            } else {
                codewriter.cwrite("private ");
            }
            codewriter.write("" + fieldType + " " + getMethodName + "()");
            codewriter.write("{");
            codewriter.TabIn();
            int ridx = relation.isManagedRelationType() ? 0 : loadedIndex++;
            this.writePostLoadBlock(codewriter, numFields, ridx);
            if (relation.isMultipleRelationType()) {
                codewriter.write("\t((jeus.ejb.schema.cmp20.RelationSet)" + fieldName + ").setTransaction(jeus.transaction.TransactionManagerImpl.txManager.getTransaction());");
            }
            codewriter.write("return " + fieldName + ";");
            codewriter.TabOut();
            codewriter.write("}");
            codewriter.write("");
            if (!BeanSchema.isContainerDefinedCMRField(fieldName)) {
                codewriter.cwrite("public ");
            } else {
                codewriter.cwrite("private ");
            }
            codewriter.write(" void " + setMethodName + "(" + fieldType + " " + fieldName + ")");
            codewriter.write("{");
            codewriter.TabIn();
            if (relation.isSingleRelation()) {
                codewriter.write("if(_loaded[" + ridx + "] && this." + fieldName + " == " + fieldName + ") {");
                codewriter.write("\treturn;");
                codewriter.write("}");
            }
            codewriter.write("this." + fieldName + " = (" + fieldType + ")_cmEntityContainer.rMan.manageRelation(this," + cmrFieldIdx + "," + fieldName + ");");
            codewriter.write("_modified[" + numFields + "] = true;");
            CMPFieldRW[] cmpFields = cmrFieldRW.getSharedCMPFiledRWIndex();
            if (cmpFields != null) {
                for (int k = 0; k < cmpFields.length; ++k) {
                    codewriter.write("_modified[" + cmpFields[k].fieldIdx + "] = false;");
                }
            }
            codewriter.TabOut();
            codewriter.write("}");
            ++numFields;
            ++cmrFieldIdx;
        }
        if (unUsedMethods.size() != 0) {
            String methodList = "";
            for (int i5 = 0; i5 < unUsedMethods.size(); ++i5) {
                if (i5 != 0) {
                    methodList = methodList + ", ";
                }
                methodList = methodList + ((Method)unUsedMethods.get(i5)).getName();
            }
            throw new EJBSourceGeneratorException(JeusMessage_EJB11._7012, methodList);
        }
        for (i2 = 0; i2 < methods.length; ++i2) {
            int j;
            if (!methods[i2].getName().startsWith("ejbSelect")) continue;
            Method m = methods[i2];
            codewriter.cwrite("public " + StringUtil.getTypeDeclaration(m.getReturnType()) + " " + m.getName() + "(");
            Class<?>[] params = m.getParameterTypes();
            for (int j2 = 0; j2 < params.length; ++j2) {
                if (j2 != 0) {
                    codewriter.cwrite(", ");
                }
                codewriter.cwrite(StringUtil.getTypeDeclaration(params[j2]) + " arg" + j2);
            }
            codewriter.cwrite(") ");
            boolean hasFindException = false;
            Class<?>[] exceptions1 = m.getExceptionTypes();
            for (j = 0; j < exceptions1.length; ++j) {
                if (j == 0) {
                    codewriter.cwrite("throws ");
                } else {
                    codewriter.cwrite(", ");
                }
                codewriter.cwrite(exceptions1[j].getName());
                if (hasFindException) continue;
                hasFindException = FinderException.class.equals(exceptions1[j]);
            }
            if (!Collection.class.isAssignableFrom(m.getReturnType()) && !hasFindException) {
                throw new EJBSourceGeneratorException(JeusMessage_EJB11._7013, m.getName());
            }
            codewriter.write("");
            codewriter.write("{");
            codewriter.TabIn();
            codewriter.write("java.lang.Object[] findargs = new Object[" + params.length + "];");
            for (j = 0; j < params.length; ++j) {
                if (!params[j].isPrimitive()) {
                    codewriter.write("findargs[" + j + "] = arg" + j + ";");
                    continue;
                }
                String wrapper = this.getWrapperClassName(params[j]);
                codewriter.write("findargs[" + j + "] = new " + wrapper + "(arg" + j + ");");
            }
            codewriter.write("boolean isIncludeUpdate = " + this.getIncludeUpdate(m) + ";");
            if (!m.getReturnType().isPrimitive()) {
                codewriter.write("return (" + m.getReturnType().getName() + ")_cmEntityContainer.cmEJBSelect(\"" + MethodConvertor.getMethodDeclaration(m) + "\", findargs, isIncludeUpdate);");
            } else {
                codewriter.write("return ((" + this.getWrapperClassName(m.getReturnType()) + ")_cmEntityContainer.cmEJBSelect(\"" + MethodConvertor.getMethodDeclaration(m) + "\", findargs, isIncludeUpdate))." + this.getValueString(m.getReturnType()) + "();");
            }
            codewriter.TabOut();
            codewriter.write("}");
        }
        String[] types1 = new String[]{"Boolean", "Byte", "Charactor", "Short", "Int", "Float", "Double", "Long", ""};
        String[] types2 = new String[]{"boolean", "byte", "char", "short", "int", "float", "double", "long", "Object"};
        for (i = 0; i < types1.length; ++i) {
            int j;
            codewriter.write("public " + types2[i] + " _get" + types1[i] + "(int idx, boolean direct)");
            codewriter.write("{");
            codewriter.TabIn();
            codewriter.write("switch(idx)");
            codewriter.write("{");
            codewriter.TabIn();
            for (j = 0; j < numFields; ++j) {
                if (!fieldTypes[j].equals(types2[i]) && (!types2[i].equals("Object") || StringUtil.isMemberOf((String)fieldTypes[j], (String[])types2, (int)(types2.length - 1)))) continue;
                codewriter.write("case " + j + ":");
                codewriter.write("\tif(direct)");
                codewriter.write("\t\treturn this." + fields[j] + ";");
                codewriter.write("\telse");
                codewriter.write("\t\treturn get" + fields[j].substring(0, 1).toUpperCase() + fields[j].substring(1) + "();");
            }
            codewriter.write("default:");
            codewriter.write("\tthrow new javax.ejb.EJBException(\"field index and field type don't match\");");
            codewriter.TabOut();
            codewriter.write("}");
            codewriter.TabOut();
            codewriter.write("}");
            codewriter.write("");
            codewriter.write("public void _set" + types1[i] + "(int idx, " + types2[i] + " _fValue, boolean direct)");
            codewriter.write("{");
            codewriter.TabIn();
            codewriter.write("switch(idx)");
            codewriter.write("{");
            codewriter.TabIn();
            for (j = 0; j < numFields; ++j) {
                if (!fieldTypes[j].equals(types2[i]) && (!types2[i].equals("Object") || StringUtil.isMemberOf((String)fieldTypes[j], (String[])types2, (int)(types2.length - 1)))) continue;
                codewriter.write("case " + j + ":");
                codewriter.write("\tif(!direct)");
                codewriter.write("\t\t_modified[" + j + "] = true;");
                codewriter.write("\tthis." + fields[j] + " = (" + fieldTypes[j] + ")_fValue;");
                codewriter.write("break;");
            }
            codewriter.write("default:");
            codewriter.write("\tthrow new javax.ejb.EJBException(\"field index and field type don't match\");");
            codewriter.TabOut();
            codewriter.write("}");
            codewriter.TabOut();
            codewriter.write("}");
            codewriter.write("");
        }
        codewriter.write("private jeus.ejb.container.CMEntityContainer _cmEntityContainer;");
        codewriter.write("private jeus.ejb.bean.objectbase.EJBLocalObjectImpl _ejbLocalObject;");
        codewriter.write("private boolean[] _loaded = new boolean[" + loadedIndex + "];");
        codewriter.write("private boolean[] _modified = new boolean[" + numFields + "];");
        codewriter.write("public void _init(jeus.ejb.container.CMEntityContainer _cmEntityContainer, jeus.ejb.bean.objectbase.EJBLocalObjectImpl _ejbLocalObject)");
        codewriter.write("{");
        codewriter.write("\tthis._cmEntityContainer = _cmEntityContainer;");
        codewriter.write("\tthis._ejbLocalObject = _ejbLocalObject;");
        codewriter.write("}");
        codewriter.write("public jeus.ejb.bean.objectbase.EJBLocalObjectImpl getEJBLocalObjectImpl()");
        codewriter.write("{");
        codewriter.write("\treturn _ejbLocalObject;");
        codewriter.write("}");
        codewriter.write("public void _setLoadInfo()");
        codewriter.write("{");
        for (i = 0; i < loadedIndex; ++i) {
            codewriter.write("\t_loaded[" + i + "] = true;");
        }
        codewriter.write("}");
        codewriter.write("public void _clearLoadInfo()");
        codewriter.write("{");
        for (i = 0; i < loadedIndex; ++i) {
            codewriter.write("\t_loaded[" + i + "] = false;");
        }
        codewriter.write("}");
        codewriter.write("public boolean[] _getModifiedInfo()");
        codewriter.write("{");
        codewriter.write("\treturn _modified;");
        codewriter.write("}");
        codewriter.write("public void _clearModifiedInfo()");
        codewriter.write("{");
        for (i = 0; i < numFields; ++i) {
            codewriter.write("\t_modified[" + i + "] = false;");
        }
        codewriter.write("}");
        codewriter.write("public void _postCreation()");
        codewriter.write("{");
        for (i = 0; i < cmFields.size(); ++i) {
            codewriter.write("\t_modified[" + i + "] = false;");
        }
        for (i = 0; i < bSchema.relations.size(); ++i) {
            RelationshipRolePair relation = (RelationshipRolePair)bSchema.relations.elementAt(i);
            if (!relation.isManagedRelationType()) continue;
            codewriter.write("\t_modified[" + (i + cmFields.size()) + "] = false;");
        }
        codewriter.write("}");
        codewriter.write("public void _initFields()");
        codewriter.write("{");
        for (i = 0; i < cmFields.size(); ++i) {
            codewriter.write("\t" + fields[i] + " = " + this.getInitialValueString(fieldTypes[i]) + ";");
        }
        for (i = 0; i < bSchema.relations.size(); ++i) {
            RelationshipRolePair relation = (RelationshipRolePair)bSchema.relations.elementAt(i);
            if (relation.isMultipleRelationType()) {
                codewriter.write("\t" + fields[cmFields.size() + i] + " = new jeus.ejb.schema.cmp20.RelationSet(null, _cmEntityContainer," + (cmFields.size() + i) + ", _ejbLocalObject," + (this.generator.getModuleName().hashCode() + relation.getTargetEJBName().hashCode()) + ");");
                continue;
            }
            codewriter.write("\t" + fields[cmFields.size() + i] + " = null;");
        }
        for (i = 0; i < loadedIndex; ++i) {
            codewriter.write("\t_loaded[" + i + "] = true;");
        }
        codewriter.write("}");
        codewriter.TabOut();
        codewriter.write("}");
        codewriter.close();
    }

    private void writePostLoadBlock(CodeWriter codewriter, int modifiedIndex, int ridx) throws IOException {
        codewriter.write("if(!_modified[" + modifiedIndex + "] && !_loaded[" + ridx + "])");
        codewriter.write("{");
        codewriter.write("\t_cmEntityContainer.cmEJBPostLoad(this," + ridx + ");");
        codewriter.write("\t_loaded[" + ridx + "] = true;");
        codewriter.write("}");
    }

    private void writeFieldDeclaration(CodeWriter codewriter, String fieldType, String fieldName) throws IOException {
        codewriter.write("public " + fieldType + " " + fieldName + ";");
        codewriter.write("");
    }

    private String checkDeclarationOfGetter(Method[] methods, String getMethodName, ArrayList unUsedMethods, String fieldName) throws EJBSourceGeneratorException {
        int j;
        for (j = 0; j < methods.length; ++j) {
            if (!methods[j].getName().equals(getMethodName) || methods[j].getParameterTypes().length != 0) continue;
            unUsedMethods.remove(methods[j]);
            break;
        }
        if (j == methods.length) {
            throw new EJBSourceGeneratorException(JeusMessage_EJB11._7010, fieldName);
        }
        return StringUtil.getTypeDeclaration(methods[j].getReturnType());
    }

    private void checkDeclarationOfSetter(Method[] methods, String setMethodName, ArrayList unUsedMethods) throws EJBSourceGeneratorException {
        int k;
        for (k = 0; k < methods.length; ++k) {
            if (!methods[k].getName().equals(setMethodName) || methods[k].getParameterTypes().length != 1) continue;
            unUsedMethods.remove(methods[k]);
            break;
        }
        if (k == methods.length) {
            throw new EJBSourceGeneratorException(JeusMessage_EJB11._7014, setMethodName);
        }
    }

    private ArrayList getAccessMethods(Method[] methods) throws Exception {
        ArrayList<Method> list = new ArrayList<Method>();
        for (int i = 0; i < methods.length; ++i) {
            if (!Modifier.isAbstract(methods[i].getModifiers()) || !methods[i].getName().startsWith("get") && !methods[i].getName().startsWith("set")) continue;
            list.add(methods[i]);
        }
        return list;
    }

    private boolean isPrimitiveClass(Class cl) {
        return cl.isPrimitive() || String.class.equals((Object)cl) || Boolean.class.equals((Object)cl) || Byte.class.equals((Object)cl) || Character.class.equals((Object)cl) || Short.class.equals((Object)cl) || Integer.class.equals((Object)cl) || Long.class.equals((Object)cl) || Float.class.equals((Object)cl) || Double.class.equals((Object)cl) || BigDecimal.class.equals((Object)cl);
    }

    private String getValueString(Class cl) {
        if (cl == Boolean.TYPE) {
            return "booleanValue";
        }
        if (cl == Byte.TYPE) {
            return "byteValue";
        }
        if (cl == Character.TYPE) {
            return "charValue";
        }
        if (cl == Short.TYPE) {
            return "shortValue";
        }
        if (cl == Integer.TYPE) {
            return "intValue";
        }
        if (cl == Long.TYPE) {
            return "longValue";
        }
        if (cl == Float.TYPE) {
            return "floatValue";
        }
        return "doubleValue";
    }

    private String getInitialValueString(String typeStr) {
        if (typeStr.equals("boolean")) {
            return "false";
        }
        if (typeStr.equals("byte") || typeStr.equals("char") || typeStr.equals("short") || typeStr.equals("int") || typeStr.equals("long") || typeStr.equals("float") || typeStr.equals("double")) {
            return "(" + typeStr + ")0";
        }
        return "null";
    }

    public void setEnableInstantQL() {
        this.enableInstantQL = true;
    }

    public boolean getIncludeUpdate(Method m) {
        for (int i = 0; i < this.findMethods.size(); ++i) {
            FindMethodPair findMethod = (FindMethodPair)this.findMethods.get(i);
            if (!BeanPair.matchMethod(findMethod, m)) continue;
            return findMethod.isIncludeUpdates();
        }
        return this.defaultIncludeUpdate;
    }

    public String isDelayDatabaseInsertUntil() {
        return this.isDelayDatabaseInsertUntil;
    }

    public boolean isAllNMMethods() {
        if (this.nmMethods.size() != 1) {
            return false;
        }
        MethodParamType method = (MethodParamType)this.nmMethods.get(0);
        return method.getMethodName().equals("*");
    }

    public String getPolicyID() {
        return this.moduleName;
    }

    public void setSecurityPolicyID(String moduleName) {
        this.moduleName = moduleName;
    }

    public String getEjbName() {
        return this.ejbName;
    }

    public void setEjbName(String beanNameInDescriptor) {
        this.ejbName = beanNameInDescriptor;
    }

    public boolean isUseAccessControl() {
        return this.useAccessControl;
    }

    public void putMethodField(String methodDeclaration, int methodID) {
        if (methodID != this.methodDeclList.size()) {
            throw new RuntimeException("The methodID is wrong. Internal Exception!!");
        }
        this.methodDeclList.add(methodDeclaration);
    }

    public void setUnspecifiedTransactionType(String unspecifiedTransactionType) {
        this.unspecifiedTransactionType = TransactionInfo.getTransactionType(unspecifiedTransactionType);
    }

    public boolean isNonModifyingMethod(Method m) {
        for (int i = 0; i < this.nmMethods.size(); ++i) {
            MethodParamType methodParamType = (MethodParamType)this.nmMethods.get(i);
            if (!m.getName().equals(methodParamType.getMethodName())) continue;
            MethodParamsType params = methodParamType.getMethodParams();
            if (params == null) {
                return true;
            }
            List paramList = params.getMethodParam();
            Class<?>[] paramClasses = m.getParameterTypes();
            if (paramClasses.length != paramList.size()) {
                return false;
            }
            for (int j = 0; j < paramList.size(); ++j) {
                String s = (String)paramList.get(j);
                if (s.equals(paramClasses[j].getName())) continue;
                return false;
            }
        }
        return false;
    }
}

