/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.compiler;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import jeus.deploy.archivist.FileArchive;
import jeus.ejb.compiler.EJBSourceGeneratorException;
import jeus.ejb.util.EJBCompiler;
import jeus.service.archive.ArchiveArrayClassLoader;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_EJB11;

public abstract class EJBCodeGenerator {
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.ejb.compiler.generator");
    protected static final int CW_BUFFER = 4096;
    protected static final String fs = System.getProperty("file.separator");
    protected static final char fsc = fs.charAt(0);
    protected static String clsp = File.separator.equals("/") ? new String(":") : new String(";");
    protected String moduleName;
    FileArchive tempArchive;
    ArchiveArrayClassLoader loader;
    FileArchive jarArchive;
    protected EJBCompiler compiler;

    public EJBCodeGenerator(EJBCompiler compiler) {
        this.compiler = compiler;
    }

    public EJBCodeGenerator(FileArchive jarArchive, FileArchive tempArchive, String moduleName, ArchiveArrayClassLoader loader, EJBCompiler compiler) {
        this.jarArchive = jarArchive;
        this.tempArchive = tempArchive;
        this.moduleName = moduleName;
        this.loader = loader;
        this.compiler = compiler;
    }

    protected void compile_generatedFiles(int type, String[] sourceFileNames, String[] classes, boolean force) throws EJBSourceGeneratorException {
        try {
            this.compiler.addCompile(type, sourceFileNames, classes, force);
        }
        catch (Throwable t) {
            throw new EJBSourceGeneratorException(JeusMessage_EJB11._7016, t);
        }
    }

    OutputStream makeFileOf(String className) throws IOException {
        return new BufferedOutputStream(this.tempArchive.addEntry(className.replace('.', fsc) + ".java"), 4096);
    }
}

