/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.compiler;

import java.io.IOException;
import jeus.ejb.util.CodeWriter;
import jeus.ejb.util.WrapperGenerator;
import jeus.util.properties.JeusPropertyValues;

public abstract class IIOPGenerator
extends WrapperGenerator {
    public IIOPGenerator(String path, String packageName, String implClassName, String interfaceName, ClassLoader loader) {
        super(path, packageName, implClassName, interfaceName, loader);
    }

    protected void generateWrapperIIOPMethod(CodeWriter codewriter, boolean isHome, String classObjectName) throws IOException {
        codewriter.TabIn();
        String returnType = this.getReturnType(isHome);
        codewriter.write("public " + returnType + " getIIOPStub() throws jeus.ejb.container.ContainerException {");
        codewriter.write("    try {");
        codewriter.write("        if (delegate.container.ejbPOA == null) {");
        codewriter.write("            /**");
        codewriter.write("             * \uc774 \uacbd\uc6b0\ub294 interroperability\ub97c \uc4f0\uc9c0 \uc54a\uc744 \ub54c RMI-IIOP\ub97c \uc4f8\ub824\uace0 \ud558\ub294 \uacbd\uc6b0\uc774\ub2e4.");
        codewriter.write("             */");
        codewriter.write("            javax.rmi.CORBA.Stub stub = (javax.rmi.CORBA.Stub) javax.rmi.PortableRemoteObject.toStub(this);");
        codewriter.write("            stub.connect(jeus.ejb.ejbserver.EJBORBManager.getDefaultORB());");
        codewriter.write("            return (" + returnType + ") stub;");
        codewriter.write("        } else {");
        codewriter.write("            org.omg.PortableServer.POA poa = (org.omg.PortableServer.POA) delegate.container.ejbPOA;");
        codewriter.write("            org.omg.PortableServer.Servant tie = (org.omg.PortableServer.Servant) javax.rmi.CORBA.Util.getTie(this);");
        codewriter.write("            byte[] id = poa.activate_object(tie);");
        codewriter.write("            org.omg.CORBA.portable.ObjectImpl objImpl = (org.omg.CORBA.portable.ObjectImpl) poa.create_reference_with_id(id, tie._all_interfaces(poa, id)[0]);");
        if (JeusPropertyValues.JAVA_VERSION < 1.5f) {
            codewriter.write("            javax.rmi.CORBA.Stub stub = com.sun.corba.ee.internal.util.Utility.loadStub(objImpl, " + classObjectName + ".class);");
        } else {
            codewriter.write("            java.rmi.Remote stub = com.sun.corba.ee.impl.util.Utility.loadStub(objImpl, " + classObjectName + ".class);");
        }
        codewriter.write("            return (" + returnType + ") stub;");
        codewriter.write("        }");
        codewriter.write("    } catch (Throwable t) {");
        codewriter.write("        throw new jeus.ejb.container.ContainerException(jeus.util.message.JeusMessage_EJB3._2924, new String[] {" + (isHome ? "\"home\"" : "\"object\"") + ", this.toString()}, t);");
        codewriter.write("    }");
        codewriter.write("}");
        codewriter.TabOut();
    }

    private String getReturnType(boolean isHome) {
        return isHome ? "javax.ejb.EJBHome" : "javax.ejb.EJBObject";
    }

    protected void generateAdditionalMethod(CodeWriter codewriter) throws IOException {
        this.generateWrapperIIOPMethod(codewriter, this.isHome(), this.interfaceName);
        this.generateWrapperExportMethod(codewriter);
        this.generateWrapperUnExportMethod(codewriter);
    }

    protected abstract boolean isHome();

    protected void generateWrapperExportMethod(CodeWriter codewriter) throws IOException {
        codewriter.TabIn();
        codewriter.write("public void export() throws java.rmi.RemoteException");
        codewriter.write("{");
        codewriter.TabIn();
        codewriter.write("javax.rmi.PortableRemoteObject.exportObject(this);");
        codewriter.TabOut();
        codewriter.write("}");
        codewriter.TabOut();
    }

    protected void generateWrapperUnExportMethod(CodeWriter codewriter) throws IOException {
        codewriter.TabIn();
        codewriter.write("public void unexport() throws java.rmi.NoSuchObjectException");
        codewriter.write("{");
        codewriter.TabIn();
        codewriter.write("javax.rmi.PortableRemoteObject.unexportObject(this);");
        codewriter.TabOut();
        codewriter.write("}");
        codewriter.TabOut();
    }

    protected void generatePreInvoke(CodeWriter codewriter) throws IOException {
        codewriter.write("String thName = Thread.currentThread().getName();");
        codewriter.write("Thread.currentThread().setName(\"jeus.corba.iiop_\" + thName);");
        codewriter.write("jeus.security.base.Subject runAs = delegate.container.getRunAsSubject();");
        codewriter.write("if (runAs != null) {");
        codewriter.write("\ttry {");
        codewriter.write("\t\tjeus.security.container.ejb.EJBSecurity.setEJBRunAsIdentity(runAs);");
        codewriter.write("\t} catch (Exception ex) {");
        codewriter.write("\t\tex.printStackTrace();");
        codewriter.write("\t}");
        codewriter.write("}");
    }

    protected void generatePostInvoke(CodeWriter codewriter) throws IOException {
        codewriter.write("Thread.currentThread().setName(thName);");
        codewriter.write("if (runAs != null) {");
        codewriter.write("\ttry {");
        codewriter.write("\t\tjeus.security.container.ejb.EJBSecurity.clearEJBRunAsIdentity();");
        codewriter.write("\t} catch (Exception ex) {");
        codewriter.write("\t\tex.printStackTrace();");
        codewriter.write("\t}");
        codewriter.write("}");
    }

    public String generateClassName() {
        return this.ImplClassName + "_IIOP";
    }
}

