/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.compiler;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.ArrayList;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;
import jeus.ejb.bean.objectbase.EJBInstanceFinder;
import jeus.ejb.compiler.BeanInfo;
import jeus.ejb.compiler.ClassInfo;
import jeus.ejb.compiler.EJBSourceGeneratorException;
import jeus.ejb.ejbserver.EJBServerAlreadyDownException;
import jeus.ejb.util.CodeWriter;
import jeus.ejb.util.MethodConvertor;
import jeus.util.ErrorMsgManager;
import jeus.util.JeusBootstrapPropertyValues;
import jeus.util.StringUtil;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_EJB11;
import jeus.util.message.JeusMessage_EJB12;
import jeus.xml.binding.ejbHelper.BeanPair;

public abstract class InterfaceInfo
extends ClassInfo {
    private static final JeusLogger logger;
    protected BeanInfo beanInfo;
    protected String className = null;
    protected String localClassName = null;
    protected Class classObject = null;
    protected Class localClassObject = null;
    protected Method[] classMethods;
    protected Method[] localClassMethods;
    protected String baseClassName;
    protected String localBaseClassName;
    protected String implClassName = "";
    protected String localImplClassName = "";
    protected String classPackageName = "";
    protected String localClassPackageName = "";
    protected String fullClassName;
    protected String fullImplClassName;
    protected String fullLocalClassName;
    protected String fullLocalImplClassName;
    private static int implNameLimit;
    private static Method[] localObjectBaseMethods;
    private static Method[] localHomeBaseMethods;

    static String checkImplName(String name) {
        char head;
        if (name.length() > implNameLimit) {
            name = name.substring(name.length() - implNameLimit);
        }
        if (!Character.isJavaIdentifierStart(head = name.charAt(0))) {
            name = "a" + name;
        }
        return name;
    }

    protected Method[] getApplicationMethods(boolean isEJBHome, boolean isLocalIntf) throws EJBSourceGeneratorException {
        try {
            Method[] appMethods;
            Method[] baseMethods;
            if (isEJBHome) {
                if (isLocalIntf) {
                    baseMethods = EJBLocalHome.class.getMethods();
                    appMethods = this.localClassObject.getMethods();
                } else {
                    baseMethods = EJBHome.class.getMethods();
                    appMethods = this.classObject.getMethods();
                }
            } else if (isLocalIntf) {
                baseMethods = EJBLocalObject.class.getMethods();
                appMethods = this.localClassObject.getMethods();
            } else {
                baseMethods = EJBObject.class.getMethods();
                appMethods = this.classObject.getMethods();
            }
            ArrayList result = new ArrayList();
            block2: for (int i = 0; i < appMethods.length; ++i) {
                for (int j = 0; j < baseMethods.length; ++j) {
                    if (appMethods[i].equals(baseMethods[j])) continue block2;
                }
                result.add(appMethods[i]);
            }
            Method[] resultMethods = new Method[]{};
            if (result.size() == 0) {
                return resultMethods;
            }
            Method[] methodlist = result.toArray(resultMethods);
            result = this.removeDuplicateMethods(methodlist);
            return result.toArray(resultMethods);
        }
        catch (Throwable t) {
            throw new EJBSourceGeneratorException(JeusMessage_EJB11._7061, t);
        }
    }

    private boolean isSubExceptions(Class[] exceptions1, Class[] exceptions2) {
        for (int k = 0; k < exceptions2.length; ++k) {
            int j;
            if (RuntimeException.class.isAssignableFrom(exceptions2[k])) continue;
            for (j = 0; j < exceptions1.length && !exceptions1[j].isAssignableFrom(exceptions2[k]); ++j) {
            }
            if (j != exceptions1.length) continue;
            return false;
        }
        return true;
    }

    String getImplClassName(BeanPair deployD, String moduleDomain) {
        String implClassName = StringUtil.replaceToValidClassName((String)(MethodConvertor.removeSlash(deployD.getBeanName()) + moduleDomain)) + this.getImplClassPostfix();
        int hashCode = (this.classPackageName + "." + implClassName).hashCode();
        implClassName = StringUtil.replaceToValidClassName((String)MethodConvertor.removeSlash(deployD.getBeanName())) + this.getImplClassPostfix();
        implClassName = implClassName + (hashCode & Integer.MAX_VALUE);
        implClassName = InterfaceInfo.checkImplName(implClassName);
        return implClassName;
    }

    String getLocalImplClassName(BeanPair deployD, String moduleDomain) {
        String implClassName = StringUtil.replaceToValidClassName((String)(MethodConvertor.removeSlash(deployD.getBeanName()) + moduleDomain)) + this.getLocalImplClassPostfix();
        int hashCode = (this.localClassPackageName + "." + implClassName).hashCode();
        implClassName = StringUtil.replaceToValidClassName((String)MethodConvertor.removeSlash(deployD.getBeanName())) + this.getLocalImplClassPostfix();
        implClassName = implClassName + (hashCode & Integer.MAX_VALUE);
        implClassName = InterfaceInfo.checkImplName(implClassName);
        return implClassName;
    }

    protected abstract String getLocalImplClassPostfix();

    protected abstract String getImplClassPostfix();

    public String getFullImplClassName() {
        return this.fullImplClassName;
    }

    public String getLocalFullImplClassName() {
        return this.fullLocalImplClassName;
    }

    public String getFullClassName() {
        return this.fullClassName;
    }

    public String getLocalFullClassName() {
        return this.fullLocalClassName;
    }

    String getFullImplClassNameAtFastDeploy(BeanPair deployD, String moduleDomain) {
        return this.classPackageName + "." + this.getImplClassName(deployD, moduleDomain);
    }

    String getLocalFullImplClassNameAtFastDeploy(BeanPair deployD, String moduleDomain) {
        return this.localClassPackageName + "." + this.getLocalImplClassName(deployD, moduleDomain);
    }

    protected void postInitialize() {
        this.fullClassName = this.classPackageName + "." + this.className;
        this.fullImplClassName = this.classPackageName + "." + this.implClassName;
        this.fullLocalClassName = this.localClassPackageName + "." + this.localClassName;
        this.fullLocalImplClassName = this.localClassPackageName + "." + this.localImplClassName;
    }

    protected void writeResourceAccessor(CodeWriter codewriter, String[] resourceNames) throws IOException {
        for (int i = 0; i < resourceNames.length; ++i) {
            codewriter.write("public EJBMethodPermission get" + StringUtil.getUpperLeadString((String)resourceNames[i]) + "()");
            codewriter.write("{");
            codewriter.write("\treturn " + resourceNames[i] + ";");
            codewriter.write("}");
        }
    }

    protected void writeResourceInitialization(CodeWriter codewriter, String[] resourceNames, String[] resourceMethodNames, String[] resourceMethodParamClasses, boolean isLocalIntf, boolean onlyDeclaration) throws IOException {
        for (int i = 0; i < resourceNames.length; ++i) {
            codewriter.write("");
            codewriter.write("transient private static EJBMethodPermission " + resourceNames[i] + ";");
            codewriter.write("");
            if (onlyDeclaration) continue;
            codewriter.write("static {");
            codewriter.TabIn();
            codewriter.write("try {");
            codewriter.TabIn();
            codewriter.write(resourceNames[i] + " = new EJBMethodPermission(" + "\"" + this.beanInfo.getEjbName() + "\", " + "\"" + this.getGenerationInterface(isLocalIntf) + "\", " + (isLocalIntf ? this.localClassName : this.className) + ".class.getMethod(\"" + resourceMethodNames[i] + "\", new Class[] {" + resourceMethodParamClasses[i] + "} ));");
            codewriter.TabOut();
            codewriter.write("} catch (NoSuchMethodException ex) { ex.printStackTrace(); throw new RuntimeException(ex.getMessage());}");
            codewriter.TabOut();
            codewriter.write("}");
            codewriter.write("");
        }
    }

    protected boolean CheckMappedInterfaceMethod(String mathodName, Method method, boolean isObject) {
        Class<?>[] paramTypes = method.getParameterTypes();
        if (logger.isLoggable(JeusMessage_EJB12._9008_LEVEL)) {
            logger.log(JeusMessage_EJB12._9008_LEVEL, JeusMessage_EJB12._9008, (Object)method);
        }
        block0: for (int i = 0; i < this.beanInfo.beanMethods.length; ++i) {
            Method beanMethod = this.beanInfo.beanMethods[i];
            if (!beanMethod.getName().equals(mathodName)) continue;
            if (logger.isLoggable(JeusMessage_EJB12._9009_LEVEL)) {
                logger.log(JeusMessage_EJB12._9009_LEVEL, JeusMessage_EJB12._9009, (Object)beanMethod);
            }
            Class<?> beanReturnType = beanMethod.getReturnType();
            Class<?> interfaceReturnType = method.getReturnType();
            if (isObject && beanReturnType != interfaceReturnType) {
                if (!logger.isLoggable(JeusMessage_EJB12._9010_LEVEL)) continue;
                logger.log(JeusMessage_EJB12._9010_LEVEL, JeusMessage_EJB12._9010, new Object[]{beanReturnType, beanReturnType.getClassLoader(), interfaceReturnType, interfaceReturnType.getClassLoader()});
                continue;
            }
            Class<?>[] beanParamTypes = beanMethod.getParameterTypes();
            if (paramTypes.length != beanParamTypes.length) {
                if (!logger.isLoggable(JeusMessage_EJB12._9011_LEVEL)) continue;
                logger.log(JeusMessage_EJB12._9011_LEVEL, JeusMessage_EJB12._9011, new Object[]{paramTypes.length, beanParamTypes.length});
                continue;
            }
            for (int k = 0; k < paramTypes.length; ++k) {
                if (paramTypes[k] == beanParamTypes[k]) continue;
                if (!logger.isLoggable(JeusMessage_EJB12._9012_LEVEL)) continue block0;
                logger.log(JeusMessage_EJB12._9012_LEVEL, JeusMessage_EJB12._9012, new Object[]{k, paramTypes[k], beanParamTypes[k]});
                continue block0;
            }
            return true;
        }
        return false;
    }

    protected void writeResourceFieldDeclaration(CodeWriter codewriter, int methodID, boolean isLocalIntf, Method m, boolean isHome) throws IOException {
        codewriter.write("");
        if (!isHome && this.beanInfo.isUseAccessControl()) {
            codewriter.write("transient private static Method method" + methodID + "Obj;");
        }
        codewriter.write("transient private static EJBMethodPermission method" + methodID + "Rsc;");
        codewriter.write("");
        codewriter.write("static {");
        codewriter.TabIn();
        codewriter.write("try {");
        codewriter.TabIn();
        if (!isHome && this.beanInfo.isUseAccessControl()) {
            codewriter.write("method" + methodID + "Obj = " + this.beanInfo.beanClassName + ".class.getMethod(\"" + m.getName() + "\", new Class[] {" + this.makeClassArrayConstant(m.getParameterTypes()) + "});");
        }
        codewriter.write("Method methodObj = ");
        codewriter.write("\t" + (isLocalIntf ? this.localClassName : this.className) + ".class.getMethod(\"" + m.getName() + "\", new Class[] {" + this.makeClassArrayConstant(m.getParameterTypes()) + "});");
        codewriter.write("method" + methodID + "Rsc = new EJBMethodPermission(" + "\"" + this.beanInfo.getEjbName() + "\", " + "\"" + this.getGenerationInterface(isLocalIntf) + "\", " + "methodObj);");
        codewriter.TabOut();
        codewriter.write("} catch (NoSuchMethodException ex) { ex.printStackTrace(); throw new RuntimeException(ex.getMessage()); }");
        codewriter.TabOut();
        codewriter.write("}");
        codewriter.write("");
    }

    protected void writeMethodFieldDeclaration(CodeWriter codewriter, String methodName, Method m) throws IOException {
        codewriter.write("");
        codewriter.write("transient private static Method method" + methodName + "Obj;");
        codewriter.write("static {");
        codewriter.TabIn();
        codewriter.write("try {");
        codewriter.TabIn();
        codewriter.write("method" + methodName + "Obj = " + this.beanInfo.beanClassName + ".class.getMethod(\"" + m.getName() + "\", new Class[] {" + this.makeClassArrayConstant(m.getParameterTypes()) + "});");
        codewriter.TabOut();
        codewriter.write("} catch (NoSuchMethodException ex) { ex.printStackTrace(); throw new RuntimeException(ex.getMessage());}");
        codewriter.TabOut();
        codewriter.write("}");
        codewriter.write("");
    }

    private String makeClassArrayConstant(Class[] parameterTypes) {
        StringBuffer array = new StringBuffer();
        if (parameterTypes.length > 0) {
            array.append(MethodConvertor.translateToParamType(parameterTypes[0])).append(".class");
            for (int i = 1; i < parameterTypes.length; ++i) {
                Class parameterType = parameterTypes[i];
                array.append(", ").append(MethodConvertor.translateToParamType(parameterType)).append(".class");
            }
        }
        return array.toString();
    }

    protected void writeSuspendChecking(CodeWriter codewriter, boolean isLocalIntf, boolean isClustered) throws IOException {
        codewriter.write("if(container.isSuspended())");
        codewriter.write("\tthrow new " + (isLocalIntf ? "javax.ejb.EJBException" : (isClustered ? EJBServerAlreadyDownException.class.getName() : "java.rmi.RemoteException")) + "(\"" + ErrorMsgManager.getLocalizedString((int)JeusMessage_EJB11._7057) + "\");");
    }

    protected void writeSecurityChecking(CodeWriter codewriter, boolean isLocalIntf, Method m, String soapMessageInstanceName, int methodID, boolean isUseAccessControl) throws IOException {
        if (soapMessageInstanceName == null || isUseAccessControl) {
            codewriter.write("Object[] args = new Object[] {" + this.getArgumentArray(m) + " };");
        }
        codewriter.write("try {");
        codewriter.TabIn();
        codewriter.write("try {");
        codewriter.TabIn();
        codewriter.write("EJBSecurity.setEJBSecurityContext(\"" + this.beanInfo.getPolicyID() + "\", " + "ejbBean, " + (soapMessageInstanceName == null ? "args" : "null") + ", " + (soapMessageInstanceName == null ? "null" : soapMessageInstanceName) + ");");
        codewriter.TabOut();
        codewriter.write("} catch (Throwable t) {");
        codewriter.TabIn();
        codewriter.write("throw new JeusRuntimeException(\"internal error during setEJBSecurityContext\", t);");
        codewriter.TabOut();
        codewriter.write("}");
        codewriter.write("isSetEJBSecurityContext = true;");
        codewriter.writeTry("EJBSecurity.checkEJBMethodPermission(method" + methodID + "Rsc);", new String[][]{{"jeus.security.base.SecurityException", "throw new " + (isLocalIntf ? "javax.ejb.EJBException" : "java.rmi.RemoteException") + "(\"" + ErrorMsgManager.getLocalizedString((int)JeusMessage_EJB11._7058, (Object)MethodConvertor.getMethodDeclaration(m)) + "\", ex);"}, {"jeus.security.base.ServiceException", "throw new JeusRuntimeException(\"internal error during checkEJBMethodPermission\", ex);"}});
        this.writeSettingRunAsPrincipal(codewriter, isLocalIntf, m);
        codewriter.TabOut();
        codewriter.write("} catch(" + (isLocalIntf ? "javax.ejb.EJBException" : "java.rmi.RemoteException") + " e) {");
        codewriter.write("\tlogger.log(Level." + JeusMessage_EJB11._7060_LEVEL.toString() + ", \"" + ErrorMsgManager.getLocalizedString((int)JeusMessage_EJB11._7060) + "\",e);");
        codewriter.write("\tthrow e;");
        codewriter.write("}");
        codewriter.write("");
        codewriter.TabOut();
    }

    private String getArgumentArray(Method m) {
        StringBuffer buffer = new StringBuffer();
        Class<?>[] params = m.getParameterTypes();
        if (params.length > 0) {
            if (params[0].isPrimitive()) {
                buffer.append("new ").append(this.getWrapperClassName(params[0])).append("(").append("arg0").append(")");
            } else {
                buffer.append("arg0");
            }
            for (int i = 1; i < params.length; ++i) {
                if (params[i].isPrimitive()) {
                    buffer.append(", new ").append(this.getWrapperClassName(params[i])).append("(").append("arg").append(i).append(")");
                    continue;
                }
                buffer.append(", arg").append(i);
            }
        }
        return buffer.toString();
    }

    protected abstract String getGenerationInterface(boolean var1);

    protected abstract int getGenerationType(boolean var1);

    protected void writeSettingEnvironment(CodeWriter codewriter, boolean isLocalIntf, Method m) throws IOException {
        codewriter.write("ExecutionContextStack.push(container.getContextMap());");
        this.writeRunAsVariable(codewriter, isLocalIntf, m);
    }

    void writeRunAsVariable(CodeWriter codewriter, boolean isLocalIntf, Method m) throws IOException {
        codewriter.write("boolean isSetEJBSecurityContext = false;");
        codewriter.write("jeus.security.base.Subject runAsPrincipal = container.getRunAsSubject();");
    }

    private void writeSettingRunAsPrincipal(CodeWriter codewriter, boolean isLocalIntf, Method m) throws IOException {
        codewriter.write("try {");
        codewriter.TabIn();
        codewriter.write("if (runAsPrincipal != null)");
        codewriter.TabIn();
        codewriter.write("EJBSecurity.setEJBRunAsIdentity(runAsPrincipal);");
        codewriter.TabOut();
        codewriter.TabOut();
        codewriter.write("} catch(Exception se) {");
        codewriter.write("\tlogger.log(Level." + JeusMessage_EJB11._7060_LEVEL.toString() + ", \"" + ErrorMsgManager.getLocalizedString((int)JeusMessage_EJB11._7060) + "\",se);");
        codewriter.write("\tthrow new " + (isLocalIntf ? "javax.ejb.EJBException" : "java.rmi.RemoteException") + "(\"" + ErrorMsgManager.getLocalizedString((int)JeusMessage_EJB11._7059, (Object)MethodConvertor.getMethodDeclaration(m)) + "\");");
        codewriter.write("}");
    }

    protected void writeInitializingReturnValueForNormalMethod(Method m, CodeWriter codewriter) throws IOException {
        if (!m.getReturnType().isPrimitive()) {
            codewriter.write(StringUtil.getTypeDeclaration(m.getReturnType()) + " returnValue = null;");
        } else if (m.getReturnType() != Void.TYPE) {
            if (m.getReturnType() == Boolean.TYPE) {
                codewriter.write(StringUtil.getTypeDeclaration(m.getReturnType()) + " returnValue = false;");
            } else {
                codewriter.write(StringUtil.getTypeDeclaration(m.getReturnType()) + " returnValue = 0;");
            }
        }
    }

    protected void writeRecoveringEnvironment(CodeWriter codewriter, Method m, boolean doesPutSecurityClear) throws IOException {
        if (doesPutSecurityClear) {
            codewriter.writeTry("if (runAsPrincipal != null)" + JeusBootstrapPropertyValues.lineSeparator + "\tEJBSecurity.clearEJBRunAsIdentity();" + JeusBootstrapPropertyValues.lineSeparator + "if (isSetEJBSecurityContext)" + JeusBootstrapPropertyValues.lineSeparator + "\tEJBSecurity.clearEJBSecurityContext();", new String[][]{{"Throwable", "throw new JeusRuntimeException(\"internal error during checkEJBMethodPermission\", ex);"}});
        }
        codewriter.write("ExecutionContextStack.pop();");
    }

    protected void writeExceptionHandler(CodeWriter codewriter, Class[] exceptions) throws IOException {
        codewriter.write("if(request.exception != null)");
        codewriter.write("{");
        codewriter.TabIn();
        this.writeExceptionHandlerPerClass(codewriter);
        boolean addRuntimeException = true;
        for (int i = 0; i < exceptions.length; ++i) {
            if (exceptions[i].getName().equals("java.rmi.RemoteException")) continue;
            codewriter.write("else if(request.exception instanceof " + exceptions[i].getName() + ") {");
            codewriter.write("\tthrow (" + exceptions[i].getName() + ")request.exception;");
            codewriter.write("} ");
            if (!exceptions[i].getName().equals("java.lang.RuntimeException")) continue;
            addRuntimeException = false;
        }
        if (addRuntimeException) {
            codewriter.write("else if(request.exception instanceof java.lang.RuntimeException) {");
            codewriter.write("\tthrow (java.lang.RuntimeException)request.exception; ");
            codewriter.write("} ");
        }
        codewriter.write("else {");
        codewriter.write("\tthrow new java.rmi.RemoteException(\"" + ErrorMsgManager.getLocalizedString((int)JeusMessage_EJB11._7062) + "\", request.exception);");
        codewriter.write("}");
        codewriter.TabOut();
        codewriter.write("}");
    }

    protected abstract void writeExceptionHandlerPerClass(CodeWriter var1) throws IOException;

    void generateInterfaceMethod(CodeWriter codewriter, Method m, int methodType, boolean isLocalIntf, boolean isHome, int methodID) throws IOException {
        this.writeResourceFieldDeclaration(codewriter, methodID, isLocalIntf, m, isHome);
        Class[] params = this.writeMethodSignature(codewriter, m, isLocalIntf);
        Class[] exceptions = this.writeMethodExceptionSignature(m, codewriter, isLocalIntf);
        codewriter.write("{");
        codewriter.TabIn();
        this.writeSuspendChecking(codewriter, isLocalIntf, this.beanInfo.isClusteredDescriptor(this.generator.getDescriptor()));
        this.writeSettingEnvironment(codewriter, isLocalIntf, m);
        this.writeWorkingBody(codewriter, methodType, m, isLocalIntf, params, exceptions, methodID);
        codewriter.TabOut();
        codewriter.write("}");
    }

    private Class[] writeMethodExceptionSignature(Method m, CodeWriter codewriter, boolean isLocalIntf) throws IOException {
        Class[] exceptions = m.getExceptionTypes();
        boolean hasRemoteException = false;
        for (int i = 0; i < exceptions.length; ++i) {
            if (i == 0) {
                codewriter.cwrite("throws ");
            } else {
                codewriter.cwrite(", ");
            }
            codewriter.cwrite(exceptions[i].getName());
            if (!exceptions[i].equals(RemoteException.class)) continue;
            hasRemoteException = true;
        }
        if (!hasRemoteException && isLocalIntf) {
            if (exceptions.length == 0) {
                codewriter.cwrite("throws ");
            } else {
                codewriter.cwrite(", ");
            }
            codewriter.cwrite("java.rmi.RemoteException");
        }
        codewriter.write("");
        return exceptions;
    }

    private Class[] writeMethodSignature(CodeWriter codewriter, Method m, boolean isLocalIntf) throws IOException {
        codewriter.cwrite("public ");
        codewriter.cwrite(StringUtil.getTypeDeclaration(m.getReturnType()) + " ");
        codewriter.cwrite((isLocalIntf ? "__" : "") + m.getName() + "(");
        Class[] params = m.getParameterTypes();
        for (int i = 0; i < params.length; ++i) {
            if (i != 0) {
                codewriter.cwrite(", ");
            }
            codewriter.cwrite(StringUtil.getTypeDeclaration((Class)params[i]) + " arg" + i);
        }
        codewriter.cwrite(") ");
        return params;
    }

    protected abstract void writeWorkingBody(CodeWriter var1, int var2, Method var3, boolean var4, Class[] var5, Class[] var6, int var7) throws IOException;

    protected abstract void writeResourceCodes(CodeWriter var1) throws IOException;

    protected abstract void writeInterfaceMethods(CodeWriter var1) throws IOException;

    public String[] generateInterfaceClass(OutputStream out) throws EJBSourceGeneratorException, IOException {
        if (logger.isLoggable(JeusMessage_EJB11._7063_LEVEL)) {
            logger.log(JeusMessage_EJB11._7063_LEVEL, JeusMessage_EJB11._7063, (Object[])new String[]{this.classPackageName, this.implClassName});
        }
        CodeWriter codewriter = new CodeWriter(out);
        codewriter.write("package " + this.classPackageName + ";");
        codewriter.write("");
        codewriter.write("import javax.ejb.*;");
        codewriter.write("import java.rmi.*;");
        codewriter.write("import javax.rmi.*;");
        codewriter.write("import java.security.*;");
        codewriter.write("import jeus.ejb.bean.*;");
        codewriter.write("import jeus.ejb.bean.objectbase.*;");
        codewriter.write("import jeus.ejb.bean.context.*;");
        codewriter.write("import jeus.util.*;");
        codewriter.write("import jeus.ejb.util.*;");
        codewriter.write("import java.util.logging.*;");
        codewriter.write("import jeus.security.container.ejb.EJBSecurity;");
        codewriter.write("import java.lang.reflect.*;");
        codewriter.write("import javax.security.jacc.*;");
        codewriter.write("import jeus.ejb.container.*;");
        codewriter.write("import javax.xml.soap.SOAPMessage;");
        codewriter.write("import java.rmi.server.*;");
        codewriter.write("import jeus.util.message.*;");
        if (!this.beanInfo.beanPackageName.equals(this.classPackageName)) {
            codewriter.write("import " + this.beanInfo.beanPackageName + ".*;");
        }
        codewriter.write("");
        codewriter.write("public final class " + this.implClassName + " extends " + this.baseClassName);
        String[] implementedInterfaces = this.writeImplementedInterfaceSignature(codewriter);
        codewriter.write("");
        codewriter.write("{");
        codewriter.TabIn();
        codewriter.write("public " + this.implClassName + "() throws RemoteException {");
        codewriter.write("\tsuper();");
        codewriter.write("}");
        this.writeInterfaceMethods(codewriter);
        this.writeResourceCodes(codewriter);
        codewriter.TabOut();
        codewriter.write("}");
        codewriter.close();
        return implementedInterfaces;
    }

    protected abstract String[] writeImplementedInterfaceSignature(CodeWriter var1) throws IOException;

    protected boolean isMemberOf(Method m, Method[] gr) {
        for (int i = 0; i < gr.length; ++i) {
            if (!m.equals(gr[i])) continue;
            return true;
        }
        return false;
    }

    public void generateLocalInterfaceClass(OutputStream out, boolean isHome) throws EJBSourceGeneratorException, IOException {
        this.localClassMethods = this.getApplicationMethods(isHome);
        if (logger.isLoggable(JeusMessage_EJB11._7064_LEVEL)) {
            logger.log(JeusMessage_EJB11._7064_LEVEL, JeusMessage_EJB11._7064, (Object)this.fullLocalImplClassName);
        }
        CodeWriter codewriter = new CodeWriter(out);
        codewriter.write("package " + this.localClassPackageName + ";");
        codewriter.write("");
        codewriter.write("import javax.ejb.*;");
        codewriter.write("import jeus.ejb.bean.*;");
        codewriter.write("import jeus.ejb.bean.objectbase.*;");
        codewriter.write("import jeus.ejb.bean.context.*;");
        codewriter.write("import jeus.util.*;");
        codewriter.write("import jeus.ejb.util.*;");
        if (!this.localClassPackageName.equals(this.classPackageName)) {
            codewriter.write("import " + this.classPackageName + ".*;");
        }
        codewriter.write("");
        codewriter.write("public final class " + this.localImplClassName + " extends " + this.localBaseClassName);
        codewriter.cwrite("\timplements " + this.localClassName);
        if (isHome && this.beanInfo.enableInstantQL) {
            codewriter.write(", jeus.ejb.bean.objectbase.EJBInstanceFinder");
        }
        codewriter.write("");
        codewriter.write("{");
        codewriter.TabIn();
        codewriter.write("public " + this.localImplClassName + "(){");
        codewriter.write("\tsuper();");
        codewriter.write("}");
        for (int i = 0; i < this.localClassMethods.length; ++i) {
            int j;
            Method m = this.localClassMethods[i];
            boolean isBaseMethod = isHome ? this.isMemberOf(m, localHomeBaseMethods) : this.isMemberOf(m, localObjectBaseMethods);
            codewriter.write("");
            Class[] params = this.writeMethodSignature(codewriter, m, false);
            Class<?>[] exceptions = m.getExceptionTypes();
            for (j = 0; j < exceptions.length; ++j) {
                if (j == 0) {
                    codewriter.cwrite("throws ");
                } else {
                    codewriter.cwrite(", ");
                }
                codewriter.cwrite(exceptions[j].getName());
            }
            codewriter.write("");
            codewriter.write("{");
            codewriter.TabIn();
            codewriter.write("if(unexported)");
            codewriter.write("\tthrow new javax.ejb.NoSuchObjectLocalException();");
            if (!isBaseMethod) {
                codewriter.write("try {");
                codewriter.write("\t");
            }
            if (m.getReturnType() != Void.TYPE) {
                codewriter.cwrite("return (" + StringUtil.getTypeDeclaration(m.getReturnType()) + ")");
            }
            codewriter.cwrite("delegate.__" + m.getName() + "(");
            for (j = 0; j < params.length; ++j) {
                if (j != 0) {
                    codewriter.cwrite(", ");
                }
                codewriter.cwrite("arg" + j);
            }
            codewriter.write(");");
            if (!isBaseMethod) {
                codewriter.write("} catch(javax.transaction.TransactionRolledbackException ex1) {");
                codewriter.write("\tif(ex1.detail instanceof java.lang.Exception)");
                codewriter.write("\tthrow new javax.ejb.TransactionRolledbackLocalException(\"\", (java.lang.Exception)ex1.detail);");
                codewriter.write("\telse");
                codewriter.write("\tthrow new javax.ejb.TransactionRolledbackLocalException(\"\", ex1);");
                codewriter.write("} catch(javax.transaction.TransactionRequiredException ex2) {");
                codewriter.write("\tthrow new javax.ejb.TransactionRequiredLocalException(jeus.util.ErrorMsgManager.getLocalizedString(ex2));");
                codewriter.write("} catch(java.rmi.NoSuchObjectException ex3) {");
                codewriter.write("\tif(ex3.detail instanceof java.lang.Exception)");
                codewriter.write("\tthrow new javax.ejb.NoSuchObjectLocalException(\"\", (java.lang.Exception)ex3.detail);");
                codewriter.write("\telse");
                codewriter.write("\tthrow new javax.ejb.NoSuchObjectLocalException(\"\", ex3);");
                codewriter.write("} catch(java.rmi.RemoteException ex4) {");
                codewriter.write("\tthrow new javax.ejb.EJBException(\"\", ex4);");
                codewriter.write("}");
            }
            codewriter.TabOut();
            codewriter.write("}");
        }
        codewriter.write("private " + this.implClassName + " delegate;");
        codewriter.write("public void setDelegate(Object delegate)");
        codewriter.write("{");
        codewriter.write("\tthis.delegate = (" + this.implClassName + ")delegate;");
        codewriter.write("}");
        codewriter.write("public " + (isHome ? "jeus.ejb.bean.objectbase.EJBHomeImpl" : "jeus.ejb.bean.objectbase.EJBObjectImpl") + " getDelegate()");
        codewriter.write("{");
        codewriter.write("\treturn delegate;");
        codewriter.write("}");
        codewriter.write("private static int interfaceHash = " + this.generator.getHashValue() + ";");
        codewriter.write("public int getInterfaceHash()");
        codewriter.write("{");
        codewriter.write("\treturn interfaceHash;");
        codewriter.write("}");
        codewriter.TabOut();
        codewriter.write("}");
        codewriter.close();
    }

    private Method[] getApplicationMethods(boolean isEJBHome) throws EJBSourceGeneratorException {
        try {
            Method[] methodlist = this.localClassObject.getMethods();
            ArrayList result = this.removeDuplicateMethods(methodlist);
            if (isEJBHome && this.beanInfo.enableInstantQL) {
                Method findMethod = EJBInstanceFinder.class.getMethod("findWithInstantQL", String.class);
                result.add(findMethod);
            }
            return result.toArray(new Method[0]);
        }
        catch (Throwable t) {
            throw new EJBSourceGeneratorException(JeusMessage_EJB11._7061, t);
        }
    }

    private ArrayList removeDuplicateMethods(Method[] methodlist) {
        block0: for (int i = 0; i < methodlist.length - 1; ++i) {
            Method method1 = methodlist[i];
            if (method1 == null) continue;
            Class<?>[] paramTypes1 = method1.getParameterTypes();
            Class[] exceptions1 = method1.getExceptionTypes();
            block1: for (int j = i + 1; j < methodlist.length; ++j) {
                Class<?>[] paramTypes2;
                Method method2 = methodlist[j];
                if (method2 == null || !method2.getName().equals(method1.getName()) || paramTypes1.length != (paramTypes2 = method2.getParameterTypes()).length) continue;
                for (int k = 0; k < paramTypes1.length; ++k) {
                    if (paramTypes1[k] != paramTypes2[k]) continue block1;
                }
                Class[] exceptions2 = method2.getExceptionTypes();
                if (this.isSubExceptions(exceptions1, exceptions2)) {
                    methodlist[j] = null;
                    continue;
                }
                if (!this.isSubExceptions(exceptions2, exceptions1)) continue;
                methodlist[i] = null;
                continue block0;
            }
        }
        ArrayList<Method> result = new ArrayList<Method>();
        for (int i = 0; i < methodlist.length; ++i) {
            if (methodlist[i] == null) continue;
            result.add(methodlist[i]);
        }
        return result;
    }

    protected void writeTypeConversion(CodeWriter codewriter, Class returnType, String methodName) throws IOException {
        if (returnType.isPrimitive()) {
            codewriter.write("Object obj = EJBSecurity.runEJBBusinessCode(ejbBean, " + methodName + ", args);");
            if (returnType == Boolean.TYPE) {
                codewriter.write("returnValue = ((Boolean) obj).booleanValue();");
            } else if (returnType == Byte.TYPE) {
                codewriter.write("returnValue = ((Byte) obj).byteValue();");
            } else if (returnType == Character.TYPE) {
                codewriter.write("returnValue = ((Character) obj).charValue();");
            } else if (returnType == Short.TYPE) {
                codewriter.write("returnValue = ((Short) obj).shortValue();");
            } else if (returnType == Integer.TYPE) {
                codewriter.write("returnValue = ((Integer) obj).intValue();");
            } else if (returnType == Long.TYPE) {
                codewriter.write("returnValue = ((Long) obj).longValue();");
            } else if (returnType == Float.TYPE) {
                codewriter.write("returnValue = ((Float) obj).floatValue();");
            } else if (returnType == Double.TYPE) {
                codewriter.write("returnValue = ((Double) obj).doubleValue();");
            }
        } else if (returnType.isAssignableFrom(Object.class)) {
            codewriter.write("returnValue = EJBSecurity.runEJBBusinessCode(ejbBean, " + methodName + ", args);");
        } else {
            codewriter.write("returnValue = (" + StringUtil.getTypeDeclaration((Class)returnType) + ") EJBSecurity.runEJBBusinessCode(ejbBean, " + methodName + ", args);");
        }
    }

    static {
        int i;
        logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.ejb.compiler.info");
        implNameLimit = 40;
        ArrayList<Method> list = new ArrayList<Method>();
        localObjectBaseMethods = EJBLocalObject.class.getMethods();
        for (i = 0; i < localObjectBaseMethods.length; ++i) {
            if (localObjectBaseMethods[i].getName().equals("remove")) continue;
            list.add(localObjectBaseMethods[i]);
        }
        localObjectBaseMethods = list.toArray(new Method[0]);
        list.clear();
        localHomeBaseMethods = EJBLocalObject.class.getMethods();
        for (i = 0; i < localHomeBaseMethods.length; ++i) {
            if (localHomeBaseMethods[i].getName().equals("remove")) continue;
            list.add(localHomeBaseMethods[i]);
        }
        localHomeBaseMethods = list.toArray(new Method[0]);
    }
}

