/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.compiler;

import java.io.IOException;
import java.lang.reflect.Method;
import java.rmi.Remote;
import jeus.ejb.compiler.EJBSourceGenerator;
import jeus.ejb.compiler.EJBSourceGeneratorException;
import jeus.ejb.compiler.ObjectInfo;
import jeus.ejb.util.CodeWriter;
import jeus.util.StringUtil;
import jeus.util.message.JeusMessage_EJB11;
import jeus.xml.binding.ejbHelper.BeanPair;
import jeus.xml.binding.ejbHelper.StatelessSessionBeanPair;

public class ServiceEndpointInfo
extends ObjectInfo {
    void initEJBObjectInfo(EJBSourceGenerator generator) throws EJBSourceGeneratorException {
        this.generator = generator;
        this.beanInfo = generator.getBeanInfo();
        ClassLoader loader = generator.getClassLoader();
        StatelessSessionBeanPair deployD = (StatelessSessionBeanPair)generator.getDescriptor();
        String moduleDomain = generator.getModuleDomain();
        this.sqlGen = generator.sqlGen;
        try {
            this.classObject = loader.loadClass(deployD.getServiceEndpointClassName());
        }
        catch (ClassNotFoundException ex) {
            throw new EJBSourceGeneratorException(JeusMessage_EJB11._7082);
        }
        if (!Remote.class.isAssignableFrom(this.classObject)) {
            throw new EJBSourceGeneratorException("The webservice endpoint class should implements java.rmi.Remote interface");
        }
        this.baseClassName = "EJBStatelessSessionObjectImpl";
        this.beanInfo.isStatelessSession = true;
        this.implClassName = this.getImplClassName(deployD, moduleDomain);
        this.className = StringUtil.cutPackagePart((String)this.classObject.getName());
        this.classMethods = this.classObject.getMethods();
        this.postInitialize();
    }

    void setObjectPackageName(BeanPair deployD) throws EJBSourceGeneratorException {
        String endpointClassName = ((StatelessSessionBeanPair)deployD).getServiceEndpointClassName();
        int index = endpointClassName.lastIndexOf(46);
        if (index == -1) {
            throw new EJBSourceGeneratorException(JeusMessage_EJB11._7080);
        }
        this.classPackageName = endpointClassName.substring(0, index);
    }

    protected String getImplClassPostfix() {
        return "EndpointImpl";
    }

    protected void writeInterfaceMethods(CodeWriter codewriter) throws IOException {
        this.generateUserDefinedMethods(codewriter, this.classMethods, false);
    }

    protected int getGenerationType(boolean isLocalIntf) {
        return 5;
    }

    protected void writeResourceCodes(CodeWriter codewriter) throws IOException {
        this.writeResourceAccessor(codewriter, this.remoteResources);
        this.writeResourceAccessor(codewriter, this.localResources);
        codewriter.cwrite("private static int type = 3;");
        codewriter.write("public int __jeus_getType()");
        codewriter.write("{");
        codewriter.write("\treturn type;");
        codewriter.write("}");
    }

    protected void writeResourceAccessor(CodeWriter codewriter, String[] resourceNames) throws IOException {
        for (int i = 0; i < resourceNames.length; ++i) {
            codewriter.write("public EJBMethodPermission get" + StringUtil.getUpperLeadString((String)resourceNames[i]) + "()");
            codewriter.write("{");
            codewriter.write("\treturn null;");
            codewriter.write("}");
        }
    }

    protected String getGenerationInterface(boolean isLocalIntf) {
        return "ServiceEndpoint";
    }

    protected void writeSecurityChecking(CodeWriter codewriter, boolean isLocalIntf, Method m, int methodID) throws IOException {
        codewriter.write("SOAPMessage message = com.tmax.axis.MessageContext.getCurrentContext().getMessage();");
        this.writeSecurityChecking(codewriter, isLocalIntf, m, "message", methodID, this.beanInfo.isUseAccessControl());
    }

    protected void writeStatusRecoveringCode(CodeWriter codewriter) throws IOException {
        codewriter.write("request.ejbContext.status = EJBContextStatus.NONE;");
    }

    protected void writeStatusSettingCode(CodeWriter codewriter) throws IOException {
        codewriter.write("request.requestStatus = EJBContextStatus.WEBENDPOINT;");
    }
}

