/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.connector;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.concurrent.atomic.AtomicBoolean;
import jeus.ejb.connector.EJBMessageEndpoint;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_EJB12;

public class MessageEndpointHandler
implements InvocationHandler {
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.ejb.connector.message");
    private EJBMessageEndpoint mep;
    private volatile boolean isReleased;
    private final AtomicBoolean isRunning = new AtomicBoolean(false);
    private boolean beforeDeliveryCalled = false;

    public MessageEndpointHandler(EJBMessageEndpoint me) {
        this.mep = me;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            Object returnValue;
            block27: {
                String methodClassName = method.getDeclaringClass().getName();
                String methodName = method.getName();
                returnValue = null;
                if (methodClassName.equals("java.lang.Object")) {
                    return this.invokeJavaObjectMethod(this, method, args);
                }
                if (logger.isLoggable(JeusMessage_EJB12._9014_LEVEL)) {
                    logger.log(JeusMessage_EJB12._9014_LEVEL, JeusMessage_EJB12._9014, new Object[]{this.hashCode(), methodName, Thread.currentThread()});
                }
                if (!this.isRunning.compareAndSet(false, true)) {
                    throw new IllegalStateException("Concurrent access to MessageEndpoint is not allowed");
                }
                try {
                    if (this.isReleased) {
                        throw new IllegalStateException("This MessageEndpoint was released and is not available anymore");
                    }
                    if (methodClassName.equals("javax.resource.spi.endpoint.MessageEndpoint")) {
                        if (methodName.equals("beforeDelivery")) {
                            if (!this.beforeDeliveryCalled) {
                                Method onMessageMethod = (Method)args[0];
                                this.mep.beforeDelivery(onMessageMethod);
                            }
                            this.beforeDeliveryCalled = true;
                            break block27;
                        }
                        if (methodName.equals("afterDelivery")) {
                            try {
                                if (this.beforeDeliveryCalled) {
                                    this.mep.afterDelivery();
                                }
                                break block27;
                            }
                            finally {
                                this.beforeDeliveryCalled = false;
                            }
                        }
                        if (methodName.equals("release")) {
                            try {
                                this.mep.release();
                                break block27;
                            }
                            finally {
                                this.isReleased = true;
                                this.mep = null;
                            }
                        }
                        throw new RuntimeException(methodName);
                    }
                    if (!this.beforeDeliveryCalled) {
                        this.mep.beforeDelivery(method);
                    }
                    try {
                        returnValue = this.mep.onMessage(method, args);
                    }
                    finally {
                        if (!this.beforeDeliveryCalled) {
                            this.mep.afterDelivery();
                        }
                    }
                }
                finally {
                    this.isRunning.set(false);
                }
            }
            return returnValue;
        }
        catch (Throwable t) {
            if (logger.isLoggable(JeusMessage_EJB12._9015_LEVEL)) {
                logger.log(JeusMessage_EJB12._9015_LEVEL, JeusMessage_EJB12._9015, t);
            }
            throw t;
        }
    }

    private Object invokeJavaObjectMethod(InvocationHandler handler, Method method, Object[] args) throws RuntimeException {
        Object returnValue = null;
        switch (method.getName().charAt(0)) {
            case 'e': {
                Object other = Proxy.isProxyClass(args[0].getClass()) ? Proxy.getInvocationHandler(args[0]) : args[0];
                returnValue = new Boolean(handler.equals(other));
                break;
            }
            case 'h': {
                returnValue = new Integer(handler.hashCode());
                break;
            }
            case 't': {
                returnValue = handler.toString();
                break;
            }
            default: {
                throw new RuntimeException(method.getName());
            }
        }
        return returnValue;
    }
}

