/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.container;

import java.util.HashMap;
import jeus.ejb.BeanContainer;
import jeus.ejb.EJBDeploymentException;
import jeus.ejb.EJBStatus;
import jeus.ejb.container.AbstractContainer;
import jeus.ejb.container.BMEntityContainer;
import jeus.ejb.container.CMEntityContainer;
import jeus.ejb.container.ContainerException;
import jeus.ejb.container3.MessageDrivenContainer;
import jeus.ejb.container3.StatefulSessionContainer;
import jeus.ejb.container3.StatelessSessionContainer;
import jeus.ejb.metadata.BeanInfo;
import jeus.ejb.metadata.EntityBeanInfo;
import jeus.ejb.metadata.MessageDrivenBeanInfo;
import jeus.ejb.metadata.SessionBeanInfo;
import jeus.service.archive.ArchiveArrayClassLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanContainerFactory {
    public static BeanContainer createBeanContainer(BeanInfo beanInfo, ArchiveArrayClassLoader loader, String securityDomain, HashMap<String, Integer> beanTransactionInfo) throws EJBDeploymentException {
        AbstractContainer container = null;
        try {
            switch (beanInfo.getEJBType()) {
                case SESSION: {
                    SessionBeanInfo sessionInfo = (SessionBeanInfo)beanInfo;
                    if (sessionInfo.isStateful()) {
                        container = new StatefulSessionContainer(sessionInfo, loader, securityDomain);
                        break;
                    }
                    container = new StatelessSessionContainer(sessionInfo, loader, securityDomain);
                    break;
                }
                case MESSAGE_DRIVEN: {
                    container = new MessageDrivenContainer((MessageDrivenBeanInfo)beanInfo, loader, securityDomain);
                    break;
                }
                case ENTITY: {
                    EntityBeanInfo entityBeanInfo = (EntityBeanInfo)beanInfo;
                    if (entityBeanInfo.isCMP()) {
                        container = new CMEntityContainer(entityBeanInfo, beanTransactionInfo, loader, securityDomain);
                        break;
                    }
                    container = new BMEntityContainer(entityBeanInfo, beanTransactionInfo, loader, securityDomain);
                    break;
                }
                default: {
                    throw new Error("Unknown EJB Type");
                }
            }
        }
        catch (ContainerException e) {
            throw new EJBDeploymentException((Throwable)((Object)e));
        }
        try {
            ((AbstractContainer)container).postConstruct();
        }
        catch (EJBDeploymentException ex) {
            container.status.set(EJBStatus.DEPLOYMENT_FAILED);
            throw ex;
        }
        catch (Throwable t) {
            container.status.set(EJBStatus.DEPLOYMENT_FAILED);
            throw new EJBDeploymentException(t);
        }
        container.status.set(EJBStatus.DEPLOYED);
        return container;
    }
}

