/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.container;

import java.lang.reflect.Method;
import java.rmi.RemoteException;
import javax.jms.JMSException;
import javax.jms.ServerSession;
import javax.jms.Session;
import jeus.ejb.baseimpl.MessageDrivenContextImpl;
import jeus.ejb.container.MDServerSessionPoolImpl;
import jeus.ejb.container3.MessageDrivenContainer;
import jeus.ejb.ejbserver.ActiveManager;
import jeus.ejb.interceptor.InvocationRequest;
import jeus.ejb.interceptor.InvocationType;
import jeus.jms.wrapper.SessionWrapper;
import jeus.transaction.TMService;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_EJB5;

public class MDServerSessionImpl
implements ServerSession,
Runnable {
    private final boolean accessControl;
    private final Session session;
    private MessageDrivenContainer container;
    private MDServerSessionPoolImpl pool;
    private MessageDrivenContextImpl context;
    private static Method runMethod;
    private JeusLogger logger;

    public MDServerSessionImpl(Session session, MDServerSessionPoolImpl pool, MessageDrivenContextImpl context, MessageDrivenContainer container, boolean accessControl) throws JMSException, NoSuchMethodException {
        runMethod = Session.class.getMethod("run", new Class[0]);
        this.logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.ejb.container.beanContainer.mdb.serversession");
        this.pool = pool;
        this.context = context;
        this.container = container;
        this.accessControl = accessControl;
        this.session = session instanceof SessionWrapper ? ((SessionWrapper)session).getDelegate() : session;
        this.initialize();
    }

    private void initialize() throws JMSException, NoSuchMethodException {
        this.context.setSession(this.session);
        this.session.setMessageListener(this.context.getMessageListener());
        TMService.associateNullTransaction();
    }

    public Session getSession() {
        return this.session;
    }

    public void start() throws JMSException {
        try {
            this.container.execute(this);
        }
        catch (InterruptedException e) {
            throw new JMSException("Exception during executing bean : " + e.toString());
        }
    }

    public void run() {
        try {
            this.acquireTicket();
            InvocationRequest request = InvocationRequest.create(InvocationType.ONMESSAGE_METHOD, this.session, runMethod, null);
            request.setCaller(this);
            this.container.invoke(request);
        }
        catch (Throwable e) {
            this.logger.logp(JeusMessage_EJB5._3901_LEVEL, "MDServerSessionThread", "run", JeusMessage_EJB5._3901, e);
        }
        this.releaseTicket();
        this.returnToPool();
    }

    private void acquireTicket() {
        ActiveManager activeManager = ActiveManager.currentActiveManager();
        if (activeManager != null) {
            activeManager.getTicket();
        }
    }

    private void releaseTicket() {
        ActiveManager activeManager = ActiveManager.currentActiveManager();
        if (activeManager != null) {
            activeManager.returnTicket();
        }
    }

    private void returnToPool() {
        try {
            this.pool.putObject(this);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public MessageDrivenContextImpl getEjbContext() {
        return this.context;
    }
}

