/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.container;

import java.util.Collection;
import java.util.Iterator;
import javax.ejb.EJBLocalObject;
import javax.transaction.Transaction;
import jeus.ejb.bean.objectbase.EJBLocalObjectImpl;
import jeus.ejb.bean.objectbase.FieldAccessor;
import jeus.ejb.container.CMEntityContainer;
import jeus.ejb.container.ContainerException;
import jeus.ejb.persistence.database.PLException;
import jeus.ejb.schema.CMRFieldRW;
import jeus.ejb.schema.cmp20.RelationSet;
import jeus.transaction.TransactionImpl;
import jeus.util.ErrorMsgManager;
import jeus.util.JeusRuntimeException;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_EJB6;
import jeus.xml.binding.ejbHelper.RelationshipRolePair;

public class RelationManager {
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.ejb.schema.relation");
    private int engineType;
    private RelationshipRolePair[] rdescs;
    private int cmrFieldIdxBase;
    public CMRFieldRW[] cmrFieldRWs;
    public int[] pairFieldIdx;
    private boolean[] needToReload;

    public RelationManager(RelationshipRolePair[] rdescs, int cmrFieldIdxBase) throws Exception {
        try {
            this.rdescs = rdescs;
            this.cmrFieldIdxBase = cmrFieldIdxBase;
            this.cmrFieldRWs = new CMRFieldRW[cmrFieldIdxBase + rdescs.length];
            this.pairFieldIdx = new int[cmrFieldIdxBase + rdescs.length];
            this.needToReload = new boolean[cmrFieldIdxBase + rdescs.length];
            for (int i = 0; i < rdescs.length; ++i) {
                RelationshipRolePair rDesc = rdescs[i];
                int fieldIndex = cmrFieldIdxBase + i;
                this.cmrFieldRWs[fieldIndex] = rDesc.getFieldRW();
                RelationshipRolePair pairDesc = rDesc.getPair();
                this.pairFieldIdx[fieldIndex] = pairDesc.getFieldRW().fieldIdx;
                this.needToReload[fieldIndex] = !rDesc.isNeedUpdate();
            }
        }
        catch (Throwable t) {
            throw new ContainerException(JeusMessage_EJB6._4152, t);
        }
        if (logger.isLoggable(JeusMessage_EJB6._4153_LEVEL)) {
            logger.logp(JeusMessage_EJB6._4153_LEVEL, "RelationManager", "<init>", JeusMessage_EJB6._4153);
        }
    }

    public void setContainer(CMEntityContainer con) {
        this.engineType = con.getEngineType();
        for (int i = this.cmrFieldIdxBase; i < this.cmrFieldRWs.length; ++i) {
            this.cmrFieldRWs[i].myContainer = con;
        }
    }

    public int getEngineType() {
        return this.engineType;
    }

    public RelationshipRolePair[] getEJBRDescs() {
        return this.rdescs;
    }

    public void createRelationFromPair(FieldAccessor bean, int fieldIdx, EJBLocalObject targetObject) {
        CMRFieldRW fieldRW = this.cmrFieldRWs[fieldIdx];
        if (fieldRW.isCollection) {
            RelationSet set = (RelationSet)bean._get(fieldIdx, false);
            set.innerAdd(targetObject);
        } else {
            bean._set(fieldIdx, targetObject, false);
        }
    }

    public void removeRelationFromPair(FieldAccessor bean, int fieldIdx, EJBLocalObject targetObject) {
        CMRFieldRW fieldRW = this.cmrFieldRWs[fieldIdx];
        if (fieldRW.isCollection) {
            RelationSet set = (RelationSet)bean._get(fieldIdx, false);
            set.innerRemove(targetObject);
        } else {
            bean._set(fieldIdx, null, false);
        }
    }

    public void addRelation(EJBLocalObject bean, int cmrFieldIdx, EJBLocalObject targetObject) {
        EJBLocalObjectImpl pairOfTargetObject;
        if (this.cmrFieldRWs[cmrFieldIdx].type == 3 && (pairOfTargetObject = (EJBLocalObjectImpl)((EJBLocalObjectImpl)targetObject)._getRelation(this.pairFieldIdx[cmrFieldIdx])) != null) {
            pairOfTargetObject._removeRelation(cmrFieldIdx, null);
        }
        ((EJBLocalObjectImpl)targetObject)._createRelation(this.pairFieldIdx[cmrFieldIdx], bean);
    }

    public void removeRelation(EJBLocalObject bean, int cmrFieldIdx, EJBLocalObject targetObject) {
        ((EJBLocalObjectImpl)targetObject)._removeRelation(this.pairFieldIdx[cmrFieldIdx], bean);
    }

    public Object manageRelation(FieldAccessor beanA, int cmrFieldIdx, Object targetObjectB) {
        CMRFieldRW fieldRW = this.cmrFieldRWs[cmrFieldIdx];
        int pairInterfaceHash = fieldRW.pairInterfaceHash;
        boolean isRelationSet = true;
        switch (this.cmrFieldRWs[cmrFieldIdx].type) {
            case 0: 
            case 1: {
                EJBLocalObjectImpl pairA;
                if (targetObjectB != null && (((EJBLocalObjectImpl)targetObjectB).isUnexported() || ((EJBLocalObjectImpl)targetObjectB).getInterfaceHash() != pairInterfaceHash)) {
                    throw new IllegalArgumentException(ErrorMsgManager.getLocalizedString((int)JeusMessage_EJB6._4166));
                }
                EJBLocalObjectImpl pairB = (EJBLocalObjectImpl)beanA._get(cmrFieldIdx, false);
                if (pairB != null) {
                    pairB._removeRelation(this.pairFieldIdx[cmrFieldIdx], null);
                }
                if (targetObjectB != null && (pairA = (EJBLocalObjectImpl)((EJBLocalObjectImpl)targetObjectB)._getRelation(this.pairFieldIdx[cmrFieldIdx])) != null) {
                    pairA._removeRelation(cmrFieldIdx, null);
                }
                ((EJBLocalObjectImpl)targetObjectB)._createRelation(this.pairFieldIdx[cmrFieldIdx], beanA.getEJBLocalObjectImpl());
                fieldRW.updateSharedCMPField(beanA, targetObjectB);
                return targetObjectB;
            }
            case 2: {
                if (targetObjectB != null && (((EJBLocalObjectImpl)targetObjectB).isUnexported() || ((EJBLocalObjectImpl)targetObjectB).getInterfaceHash() != pairInterfaceHash)) {
                    throw new IllegalArgumentException(ErrorMsgManager.getLocalizedString((int)JeusMessage_EJB6._4170));
                }
                EJBLocalObjectImpl pairB = (EJBLocalObjectImpl)beanA._get(cmrFieldIdx, false);
                if (pairB != null) {
                    pairB._removeRelation(this.pairFieldIdx[cmrFieldIdx], beanA.getEJBLocalObjectImpl());
                }
                if (targetObjectB != null) {
                    ((EJBLocalObjectImpl)targetObjectB)._createRelation(this.pairFieldIdx[cmrFieldIdx], beanA.getEJBLocalObjectImpl());
                }
                fieldRW.updateSharedCMPField(beanA, targetObjectB);
                return targetObjectB;
            }
            case 3: {
                EJBLocalObjectImpl[] objectImpls;
                isRelationSet = targetObjectB instanceof RelationSet;
                try {
                    objectImpls = this.checkIllegalArgument(targetObjectB, fieldRW, isRelationSet);
                }
                catch (PLException ex) {
                    throw new JeusRuntimeException(JeusMessage_EJB6._4173, (Throwable)((Object)ex));
                }
                RelationSet setA = (RelationSet)beanA._get(cmrFieldIdx, false);
                Iterator iter = setA.getInnerIterator();
                while (iter.hasNext()) {
                    ((EJBLocalObjectImpl)iter.next())._removeRelation(this.pairFieldIdx[cmrFieldIdx], null);
                }
                setA.innerClear();
                for (int i = 0; i < objectImpls.length; ++i) {
                    objectImpls[i]._createRelation(this.pairFieldIdx[cmrFieldIdx], beanA.getEJBLocalObjectImpl());
                }
                setA.addAll((Collection)targetObjectB);
                if (isRelationSet) {
                    ((RelationSet)targetObjectB).innerClear();
                }
                return setA;
            }
            case 4: 
            case 5: {
                int i;
                isRelationSet = targetObjectB instanceof RelationSet;
                try {
                    this.checkIllegalArgument(targetObjectB, fieldRW, isRelationSet);
                }
                catch (PLException ex) {
                    throw new JeusRuntimeException(JeusMessage_EJB6._4177, (Throwable)((Object)ex));
                }
                RelationSet setA = (RelationSet)beanA._get(cmrFieldIdx, false);
                EJBLocalObjectImpl[][] lists = setA.set((Collection)targetObjectB);
                for (i = 0; i < lists[0].length; ++i) {
                    lists[0][i]._removeRelation(this.pairFieldIdx[cmrFieldIdx], beanA.getEJBLocalObjectImpl());
                }
                for (i = 0; i < lists[1].length; ++i) {
                    lists[1][i]._createRelation(this.pairFieldIdx[cmrFieldIdx], beanA.getEJBLocalObjectImpl());
                }
                return setA;
            }
        }
        return null;
    }

    private EJBLocalObjectImpl[] checkIllegalArgument(Object targetObjectB, CMRFieldRW fieldRW, boolean isRelationSet) throws PLException {
        int size;
        Iterator iter;
        if (targetObjectB == null) {
            throw new IllegalArgumentException(ErrorMsgManager.getLocalizedString((int)JeusMessage_EJB6._4180));
        }
        CMEntityContainer pairContainer = fieldRW.pairContainer;
        if (pairContainer == null) {
            fieldRW.setPairContainer();
            pairContainer = fieldRW.pairContainer;
        }
        Class localObjectClass = pairContainer.ejbLocalObjectClass;
        if (isRelationSet) {
            RelationSet set = (RelationSet)targetObjectB;
            iter = set.getInnerIterator();
            size = set.size();
        } else {
            Collection collection = (Collection)targetObjectB;
            iter = collection.iterator();
            size = collection.size();
        }
        EJBLocalObjectImpl[] objectImpls = new EJBLocalObjectImpl[size];
        int i = 0;
        while (iter.hasNext()) {
            EJBLocalObjectImpl impl = (EJBLocalObjectImpl)iter.next();
            if (!localObjectClass.isAssignableFrom(impl.getClass())) {
                throw new IllegalArgumentException(ErrorMsgManager.getLocalizedString((int)JeusMessage_EJB6._4181, (Object)impl.toString()));
            }
            objectImpls[i] = impl;
            ++i;
        }
        return objectImpls;
    }

    public void removeRelations(FieldAccessor ejbBean, int[] removeFieldIdx, Transaction tx) throws Exception {
        for (int i = 0; i < removeFieldIdx.length; ++i) {
            int idx = removeFieldIdx[i];
            if (this.needToReload[idx] && tx != null) {
                ((TransactionImpl)tx).flush();
            }
            Object ref = ejbBean._get(idx, false);
            if (this.cmrFieldRWs[idx].isCollection) {
                Iterator iter = ((RelationSet)ref).getInnerIterator();
                while (iter.hasNext()) {
                    EJBLocalObjectImpl relation = (EJBLocalObjectImpl)iter.next();
                    EJBLocalObjectImpl ejbLocalObjectImpl = ejbBean.getEJBLocalObjectImpl();
                    relation._removeRelation(this.pairFieldIdx[idx], ejbLocalObjectImpl);
                }
                continue;
            }
            if (ref == null) continue;
            ((EJBLocalObjectImpl)ref)._removeRelation(this.pairFieldIdx[idx], ejbBean.getEJBLocalObjectImpl());
        }
    }

    public Object[] getFieldValuesForCascadeRemove(FieldAccessor ejbBean, int[] casDelFieldIdx) throws Exception {
        Object[] fieldValues = new Object[casDelFieldIdx.length];
        for (int i = 0; i < casDelFieldIdx.length; ++i) {
            fieldValues[i] = ejbBean._get(casDelFieldIdx[i], true);
        }
        return fieldValues;
    }

    public void cascadeRemove(int[] casDelFieldIdx, Object[] fieldValues) throws Exception {
        for (int i = 0; i < casDelFieldIdx.length; ++i) {
            int idx = casDelFieldIdx[i];
            Object ref = fieldValues[i];
            if (this.cmrFieldRWs[idx].isCollection) {
                Iterator iter = ((RelationSet)ref).getInnerIterator();
                while (iter.hasNext()) {
                    ((EJBLocalObject)iter.next()).remove();
                }
                continue;
            }
            if (ref == null) continue;
            ((EJBLocalObject)ref).remove();
        }
    }
}

