/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.container;

import java.util.ArrayList;
import jeus.ejb.container.ActiveResourceManagable;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_EJB6;

public class SessionManager {
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.ejb.container.cache");
    protected int degree;
    protected Element[] lists;
    protected Object[] syncs;
    protected int size = 0;
    protected int idx = 0;
    protected Element element = null;
    protected static final int NUM_SYNC = 128;

    public SessionManager(int degree) {
        int i;
        this.degree = degree;
        this.lists = new Element[degree];
        this.syncs = new Object[128];
        for (i = 0; i < degree; ++i) {
            this.lists[i] = null;
        }
        for (i = 0; i < 128; ++i) {
            this.syncs[i] = new Object();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addElement(ActiveResourceManagable obj) {
        int index = obj.getHashCode() % this.degree;
        Object object = this.syncs[index % 128];
        synchronized (object) {
            Element e;
            this.lists[index] = e = new Element(this.lists[index], obj);
            SessionManager sessionManager = this;
            synchronized (sessionManager) {
                ++this.size;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeElement(ActiveResourceManagable obj) {
        int index = obj.getHashCode() % this.degree;
        Object object = this.syncs[index % 128];
        synchronized (object) {
            Element curr = this.lists[index];
            Element prev = null;
            while (curr != null) {
                if (obj.isSame(curr.object.getIdentity())) {
                    if (prev != null) {
                        prev.next = curr.next;
                    } else {
                        this.lists[index] = curr.next;
                    }
                    SessionManager sessionManager = this;
                    synchronized (sessionManager) {
                        --this.size;
                    }
                }
                prev = curr;
                curr = curr.next;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateElement(ActiveResourceManagable obj) {
        int index = obj.getHashCode() % this.degree;
        Object object = this.syncs[index % 128];
        synchronized (object) {
            Element e;
            Element curr = this.lists[index];
            while (curr != null) {
                if (obj.isSame(curr.object.getIdentity())) {
                    curr.object = obj;
                    return;
                }
                curr = curr.next;
            }
            this.lists[index] = e = new Element(this.lists[index], obj);
            SessionManager sessionManager = this;
            synchronized (sessionManager) {
                ++this.size;
            }
        }
    }

    public Object getFirstElement() {
        this.idx = 0;
        while (this.lists[this.idx] == null) {
            ++this.idx;
            if (this.idx != this.degree) continue;
            return null;
        }
        this.element = this.lists[this.idx];
        return this.lists[this.idx].object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActiveResourceManagable get(Object identity, int hash) {
        int index = hash % this.degree;
        Object object = this.syncs[index % 128];
        synchronized (object) {
            Element curr = this.lists[index];
            while (curr != null) {
                if (curr.object.isSame(identity)) {
                    return curr.object;
                }
                curr = curr.next;
            }
            return null;
        }
    }

    public Object getNext() {
        this.element = this.element.next;
        while (this.element == null) {
            ++this.idx;
            if (this.idx == this.degree) {
                return null;
            }
            this.element = this.lists[this.idx];
        }
        return this.element.object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCurrent() {
        if (logger.isLoggable(JeusMessage_EJB6._4351_LEVEL)) {
            logger.logp(JeusMessage_EJB6._4351_LEVEL, "SessionManager", "removeCurrent", JeusMessage_EJB6._4351, (Object)this.element);
        }
        Object object = this.syncs[this.idx % 128];
        synchronized (object) {
            Element curr = this.lists[this.idx];
            Element prev = null;
            do {
                if (this.element == curr) {
                    if (prev != null) {
                        prev.next = curr.next;
                    } else {
                        this.lists[this.idx] = curr.next;
                    }
                    SessionManager sessionManager = this;
                    synchronized (sessionManager) {
                        --this.size;
                    }
                }
                prev = curr;
            } while ((curr = curr.next) != null);
        }
    }

    public ArrayList removeAll() {
        int i;
        ArrayList<ActiveResourceManagable> list = new ArrayList<ActiveResourceManagable>();
        for (i = 0; i < this.degree; ++i) {
            Element elem = this.lists[i];
            while (elem != null) {
                list.add(elem.object);
                elem = elem.next;
            }
            this.lists[i] = null;
        }
        for (i = 0; i < 128; ++i) {
            this.syncs[i] = null;
        }
        return list;
    }

    public synchronized int size() {
        return this.size;
    }

    protected static class Element {
        public Element next;
        public ActiveResourceManagable object;

        public Element(Element next, ActiveResourceManagable object) {
            this.next = next;
            this.object = object;
        }
    }
}

