/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.container;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.NoSuchObjectLocalException;
import javax.naming.InitialContext;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.xml.bind.JAXBException;
import jeus.deploy.archivist.AbstractArchive;
import jeus.deploy.archivist.FileArchive;
import jeus.deploy.io.runtime.EjbRuntimeDDFile;
import jeus.ejb.BeanContainer;
import jeus.ejb.EJBEngine;
import jeus.ejb.container.AbstractContainer;
import jeus.ejb.container.ContainerException;
import jeus.ejb.container.EJBTimerTask;
import jeus.ejb.container.TimerState;
import jeus.ejb.container.TimerSynch;
import jeus.ejb.ejbserver.EJBServerException;
import jeus.ejb.timer.containers.TimerLocal;
import jeus.ejb.timer.containers.TimerLocalHome;
import jeus.ejb.timer.containers.TimerPrimaryKey;
import jeus.server.enginecontainer.EngineContainer;
import jeus.transaction.TMService;
import jeus.transaction.TxHelper;
import jeus.util.ErrorMsgManager;
import jeus.util.JeusRuntimeException;
import jeus.util.PooledExecutorFactory;
import jeus.util.concurrent50.concurrent.ThreadPoolExecutor;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_EJB12;
import jeus.util.message.JeusMessage_EJB4;
import jeus.util.message.JeusMessage_EJB7;
import jeus.xml.binding.jeusDD.CreatingTableType;
import jeus.xml.binding.jeusDD.DbVendorType;
import jeus.xml.binding.jeusDD.DurableSettingType;
import jeus.xml.binding.jeusDD.DurableTimerServiceType;
import jeus.xml.binding.jeusDD.EngineType;
import jeus.xml.binding.jeusDD.JeusBeanType;
import jeus.xml.binding.jeusDD.JeusEjbDdType;
import jeus.xml.binding.jeusDD.ObjectFactory;
import jeus.xml.binding.jeusDD.PoolingType;
import jeus.xml.binding.jeusDD.SchemaInfoType;
import jeus.xml.binding.jeusDD.TimerServiceType;
import org.xml.sax.SAXException;

public class TimerContainer {
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.ejb.timer");
    private static long nextTimerId = 0L;
    private long minDeliveryInterval;
    private int maxRedeliveryCount;
    private long redeliveryInterval;
    private ThreadPoolExecutor executionPool;
    private Hashtable<Long, TimerState> timerCache = new Hashtable();
    private Timer ejbTimer = new Timer();
    private TransactionManager txManager = TxHelper.getTransactionManager();
    private boolean supportDurable;
    private static final String TIMER_BEAN_NAME = "JeusTimerBean";
    private static final String TIMER_BEAN_JNDI_NAME = "_JeusTimerBean_";
    private TimerLocalHome timerBeanHome;
    private static final boolean debug = false;

    public static TimerContainer currentTimerContainer() {
        EJBEngine engine = EJBEngine.getDefaultEngine();
        if (engine != null) {
            return engine.getTimerContainer();
        }
        return null;
    }

    public void init(TimerServiceType timerD) throws EJBServerException {
        if (logger.isLoggable(JeusMessage_EJB7._4751_LEVEL)) {
            logger.logp(JeusMessage_EJB7._4751_LEVEL, "TimerContainer", "<init>", JeusMessage_EJB7._4751);
        }
        this.minDeliveryInterval = timerD.getMinDeliveryInterval();
        if (logger.isLoggable(JeusMessage_EJB7._4752_LEVEL)) {
            logger.logp(JeusMessage_EJB7._4752_LEVEL, "TimerContainer", "<init>", JeusMessage_EJB7._4752, (Object)String.valueOf(this.minDeliveryInterval));
        }
        this.maxRedeliveryCount = timerD.getMaxRedeliveryCount();
        if (logger.isLoggable(JeusMessage_EJB7._4753_LEVEL)) {
            logger.logp(JeusMessage_EJB7._4753_LEVEL, "TimerContainer", "<init>", JeusMessage_EJB7._4753, (Object)String.valueOf(this.maxRedeliveryCount));
        }
        this.redeliveryInterval = timerD.getRedeliveryInterval();
        if (logger.isLoggable(JeusMessage_EJB7._4754_LEVEL)) {
            logger.logp(JeusMessage_EJB7._4754_LEVEL, "TimerContainer", "<init>", JeusMessage_EJB7._4754, (Object)String.valueOf(this.redeliveryInterval));
        }
        PoolingType poolType = timerD.getThreadPool();
        this.executionPool = (ThreadPoolExecutor)PooledExecutorFactory.createPooledExecutor((String)"EJBTimerExecutor", (int)poolType.getMax(), (int)poolType.getMin(), (long)poolType.getPeriod());
        DurableSettingType durableSetting = timerD.getDurableSetting();
        if (durableSetting != null) {
            if (logger.isLoggable(JeusMessage_EJB7._4755_LEVEL)) {
                logger.logp(JeusMessage_EJB7._4755_LEVEL, "TimerContainer", "<init>", JeusMessage_EJB7._4755);
            }
            this.supportDurable = true;
            try {
                this.setTimerBeanDDFile(durableSetting);
                this.deployTimerBean();
                InitialContext ctx = new InitialContext();
                this.timerBeanHome = (TimerLocalHome)ctx.lookup(TIMER_BEAN_JNDI_NAME);
                if (logger.isLoggable(JeusMessage_EJB7._4757_LEVEL)) {
                    logger.logp(JeusMessage_EJB7._4757_LEVEL, "TimerContainer", "<init>", JeusMessage_EJB7._4757);
                }
            }
            catch (Exception ex) {
                throw new EJBServerException(JeusMessage_EJB7._4758, (Throwable)ex);
            }
        }
    }

    private void deployTimerBean() throws Exception, JAXBException {
        EngineContainer.deploySystemApp("JeusTimerBean.jar");
        if (logger.isLoggable(JeusMessage_EJB7._4760_LEVEL)) {
            logger.logp(JeusMessage_EJB7._4760_LEVEL, "TimerContainer", "deployTimerBean", JeusMessage_EJB7._4760);
        }
    }

    private void setTimerBeanDDFile(DurableSettingType durableSetting) throws IOException, JAXBException, SAXException {
        String dataSourceName = durableSetting.getDataSourceName();
        String dbVendor = durableSetting.getDbVendor().value();
        String tableName = durableSetting.getTableName();
        String engineType = durableSetting.getEngineType().value();
        FileArchive earHomeArchive = (FileArchive)EngineContainer.getArchiveFromDeploymentHome(TIMER_BEAN_NAME + File.separator + TIMER_BEAN_NAME);
        EjbRuntimeDDFile runtimeFile = new EjbRuntimeDDFile();
        JeusEjbDdType ejbDD = (JeusEjbDdType)runtimeFile.getDeploymentDescriptor((AbstractArchive)earHomeArchive);
        JeusBeanType bean = (JeusBeanType)ejbDD.getBeanlist().getJeusBean().get(0);
        ObjectFactory objectFactory = new ObjectFactory();
        bean.getPersistenceOptimize().setEngineType(EngineType.valueOf((String)engineType));
        SchemaInfoType schema = objectFactory.createSchemaInfoType();
        schema.setDataSourceName(dataSourceName);
        schema.setDbVendor(DbVendorType.valueOf((String)dbVendor));
        schema.setTableName(tableName);
        CreatingTableType creatingTable = objectFactory.createCreatingTableType();
        creatingTable.setUseExistingTable(objectFactory.createEmptyType());
        schema.setCreatingTable(creatingTable);
        bean.setSchemaInfo(schema);
        ObjectFactory fac = new ObjectFactory();
        runtimeFile.marshalDescriptor((Object)fac.createJeusEjbDd(ejbDD), (AbstractArchive)earHomeArchive);
        if (logger.isLoggable(JeusMessage_EJB7._4762_LEVEL)) {
            logger.logp(JeusMessage_EJB7._4762_LEVEL, "TimerContainer", "setTimerBeanDDFile", JeusMessage_EJB7._4762);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void destroyTimers(String moduleName, String beanName, DurableTimerServiceType durableSetting) {
        if (logger.isLoggable(JeusMessage_EJB7._4763_LEVEL)) {
            logger.logp(JeusMessage_EJB7._4763_LEVEL, "TimerContainer", "destroyTimers", JeusMessage_EJB7._4763, new Object[]{beanName, moduleName});
        }
        TimerState nextTimerState = null;
        Long nextTimerId = null;
        BeanContainer container = this.getContainer(moduleName, beanName);
        if (container != null) {
            Enumeration e = container.getTimerIds();
            while (e.hasMoreElements()) {
                block24: {
                    nextTimerId = (Long)e.nextElement();
                    nextTimerState = this.getTimerState(nextTimerId);
                    if (nextTimerState != null) {
                        TimerState timerState = nextTimerState;
                        synchronized (timerState) {
                            if (nextTimerState.isScheduled()) {
                                if (logger.isLoggable(JeusMessage_EJB7._4764_LEVEL)) {
                                    logger.logp(JeusMessage_EJB7._4764_LEVEL, "TimerContainer", "destroyTimers", JeusMessage_EJB7._4764, (Object)nextTimerId);
                                }
                                EJBTimerTask timerTask = nextTimerState.getCurrentTimerTask();
                                timerTask.cancel();
                            }
                        }
                    }
                    if (!logger.isLoggable(JeusMessage_EJB7._4765_LEVEL)) break block24;
                    logger.logp(JeusMessage_EJB7._4765_LEVEL, "TimerContainer", "destroyTimers", JeusMessage_EJB7._4765);
                }
                Object var12_11 = null;
                if (nextTimerState == null) continue;
                this.timerCache.remove(nextTimerId);
                if (!nextTimerState.isEnableDurable() || !durableSetting.isDeleteDurableTimersAtUndeploy().booleanValue()) continue;
                try {
                    if (logger.isLoggable(JeusMessage_EJB7._4767_LEVEL)) {
                        logger.logp(JeusMessage_EJB7._4767_LEVEL, "TimerContainer", "destroyTimers", JeusMessage_EJB7._4767, (Object)nextTimerId);
                    }
                    this.timerBeanHome.remove(new TimerPrimaryKey(nextTimerId));
                    this.printTimerIdsInDB();
                    if (!logger.isLoggable(JeusMessage_EJB7._4768_LEVEL)) continue;
                    logger.logp(JeusMessage_EJB7._4768_LEVEL, "TimerContainer", "destroyTimers", JeusMessage_EJB7._4768);
                }
                catch (Exception e1) {
                    if (!logger.isLoggable(JeusMessage_EJB7._4769_LEVEL)) continue;
                    logger.logp(JeusMessage_EJB7._4769_LEVEL, "TimerContainer", "destroyTimers", JeusMessage_EJB7._4769, (Object)e);
                }
                continue;
                {
                    catch (Exception ex) {
                        if (logger.isLoggable(JeusMessage_EJB7._4766_LEVEL)) {
                            logger.logp(JeusMessage_EJB7._4766_LEVEL, "TimerContainer", "destroyTimers", JeusMessage_EJB7._4766, (Throwable)ex);
                        }
                        var12_11 = null;
                        if (nextTimerState == null) continue;
                        this.timerCache.remove(nextTimerId);
                        if (!nextTimerState.isEnableDurable() || !durableSetting.isDeleteDurableTimersAtUndeploy().booleanValue()) continue;
                        try {
                            if (logger.isLoggable(JeusMessage_EJB7._4767_LEVEL)) {
                                logger.logp(JeusMessage_EJB7._4767_LEVEL, "TimerContainer", "destroyTimers", JeusMessage_EJB7._4767, (Object)nextTimerId);
                            }
                            this.timerBeanHome.remove(new TimerPrimaryKey(nextTimerId));
                            this.printTimerIdsInDB();
                            if (!logger.isLoggable(JeusMessage_EJB7._4768_LEVEL)) continue;
                            logger.logp(JeusMessage_EJB7._4768_LEVEL, "TimerContainer", "destroyTimers", JeusMessage_EJB7._4768);
                        }
                        catch (Exception e1) {
                            if (!logger.isLoggable(JeusMessage_EJB7._4769_LEVEL)) continue;
                            logger.logp(JeusMessage_EJB7._4769_LEVEL, "TimerContainer", "destroyTimers", JeusMessage_EJB7._4769, (Object)e);
                        }
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    block25: {
                        var12_11 = null;
                        if (nextTimerState != null) {
                            this.timerCache.remove(nextTimerId);
                            if (nextTimerState.isEnableDurable() && durableSetting.isDeleteDurableTimersAtUndeploy().booleanValue()) {
                                try {
                                    if (logger.isLoggable(JeusMessage_EJB7._4767_LEVEL)) {
                                        logger.logp(JeusMessage_EJB7._4767_LEVEL, "TimerContainer", "destroyTimers", JeusMessage_EJB7._4767, (Object)nextTimerId);
                                    }
                                    this.timerBeanHome.remove(new TimerPrimaryKey(nextTimerId));
                                    this.printTimerIdsInDB();
                                    if (logger.isLoggable(JeusMessage_EJB7._4768_LEVEL)) {
                                        logger.logp(JeusMessage_EJB7._4768_LEVEL, "TimerContainer", "destroyTimers", JeusMessage_EJB7._4768);
                                    }
                                }
                                catch (Exception e1) {
                                    if (!logger.isLoggable(JeusMessage_EJB7._4769_LEVEL)) break block25;
                                    logger.logp(JeusMessage_EJB7._4769_LEVEL, "TimerContainer", "destroyTimers", JeusMessage_EJB7._4769, (Object)e);
                                }
                            }
                        }
                    }
                    throw throwable;
                }
            }
        }
    }

    private void printTimerIdsInDB() {
    }

    public void rescheduleTask(Long timerId, Date expiration) {
        this.scheduleTask(timerId, expiration, true);
    }

    public void scheduleTask(Long timerId, Date expiration) {
        this.scheduleTask(timerId, expiration, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleTask(Long timerId, Date expiration, boolean rescheduled) {
        TimerState timerState;
        if (logger.isLoggable(JeusMessage_EJB7._4770_LEVEL)) {
            logger.logp(JeusMessage_EJB7._4770_LEVEL, "TimerContainer", "scheduleTask", JeusMessage_EJB7._4770, new Object[]{timerId, expiration});
        }
        if ((timerState = this.getTimerState(timerId)) != null) {
            TimerState timerState2 = timerState;
            synchronized (timerState2) {
                Date now;
                Date cutoff;
                if (!rescheduled && expiration.before(cutoff = new Date((now = new Date()).getTime() + this.getMinimumDeliveryInterval()))) {
                    expiration = cutoff;
                }
                EJBTimerTask timerTask = new EJBTimerTask(expiration, timerId, this);
                if (rescheduled) {
                    timerState.rescheduled(timerTask);
                } else {
                    timerState.scheduled(timerTask);
                }
                this.ejbTimer.schedule((TimerTask)timerTask, expiration);
            }
        }
        if (logger.isLoggable(JeusMessage_EJB7._4771_LEVEL)) {
            logger.logp(JeusMessage_EJB7._4771_LEVEL, "TimerContainer", "scheduleTask", JeusMessage_EJB7._4771, (Object)timerId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelTimer(Long timerId) throws NoSuchObjectLocalException, Exception {
        TimerState timerState;
        if (logger.isLoggable(JeusMessage_EJB7._4772_LEVEL)) {
            logger.logp(JeusMessage_EJB7._4772_LEVEL, "TimerContainer", "cancelTimer", JeusMessage_EJB7._4772, (Object)String.valueOf(timerId));
        }
        if ((timerState = this.getTimerState(timerId)) == null) {
            if (logger.isLoggable(JeusMessage_EJB7._4773_LEVEL)) {
                logger.logp(JeusMessage_EJB7._4773_LEVEL, "TimerContainer", "cancelTimer", JeusMessage_EJB7._4773);
            }
            throw new NoSuchObjectLocalException(ErrorMsgManager.getLocalizedString((int)JeusMessage_EJB7._4773));
        }
        TimerState timerState2 = timerState;
        synchronized (timerState2) {
            Transaction transaction = this.txManager.getTransaction();
            if (timerState.isCancelled(transaction)) {
                if (logger.isLoggable(JeusMessage_EJB7._4774_LEVEL)) {
                    logger.logp(JeusMessage_EJB7._4774_LEVEL, "TimerContainer", "cancelTimer", JeusMessage_EJB7._4774, (Object)timerId);
                }
                throw new NoSuchObjectLocalException(ErrorMsgManager.getLocalizedString((int)JeusMessage_EJB7._4774, (Object)timerId));
            }
            while (timerState.isWaitCanceled()) {
                if (logger.isLoggable(JeusMessage_EJB7._4775_LEVEL)) {
                    logger.logp(JeusMessage_EJB7._4775_LEVEL, "TimerContainer", "cancelTimer", JeusMessage_EJB7._4775);
                }
                timerState.wait();
                if (!timerState.isCancelled(transaction)) continue;
                if (logger.isLoggable(JeusMessage_EJB7._4776_LEVEL)) {
                    logger.logp(JeusMessage_EJB7._4776_LEVEL, "TimerContainer", "cancelTimer", JeusMessage_EJB7._4776);
                }
                throw new NoSuchObjectLocalException(ErrorMsgManager.getLocalizedString((int)JeusMessage_EJB7._4776));
            }
            if (timerState.isEnableDurable()) {
                if (logger.isLoggable(JeusMessage_EJB7._4777_LEVEL)) {
                    logger.logp(JeusMessage_EJB7._4777_LEVEL, "TimerContainer", "cancelTimer", JeusMessage_EJB7._4777);
                }
                this.timerBeanHome.remove(new TimerPrimaryKey(timerId));
                this.printTimerIdsInDB();
            }
            boolean isCreated = timerState.isCreated();
            Date nextTimeout = this.cancelTask(timerState);
            if (transaction != null && transaction != TMService.nullTransaction) {
                if (logger.isLoggable(JeusMessage_EJB7._4778_LEVEL)) {
                    logger.logp(JeusMessage_EJB7._4778_LEVEL, "TimerContainer", "cancelTimer", JeusMessage_EJB7._4778);
                }
                timerState.setTransaction(transaction, false);
                if (isCreated) {
                    this.expungeTimer(timerId);
                } else {
                    TimerSynch timerSynch = new TimerSynch(timerId, 1, nextTimeout);
                    transaction.registerSynchronization((Synchronization)timerSynch);
                    if (logger.isLoggable(JeusMessage_EJB7._4780_LEVEL)) {
                        logger.logp(JeusMessage_EJB7._4780_LEVEL, "TimerContainer", "cancelTimer", JeusMessage_EJB7._4780);
                    }
                }
            } else {
                this.expungeTimer(timerId);
            }
        }
        if (logger.isLoggable(JeusMessage_EJB7._4781_LEVEL)) {
            logger.logp(JeusMessage_EJB7._4781_LEVEL, "TimerContainer", "cancelTimer", JeusMessage_EJB7._4781);
        }
    }

    private Date cancelTask(TimerState timerState) {
        if (logger.isLoggable(JeusMessage_EJB7._4782_LEVEL)) {
            logger.logp(JeusMessage_EJB7._4782_LEVEL, "TimerContainer", "cancelTask", JeusMessage_EJB7._4782, (Object)timerState);
        }
        Date timeout = null;
        if (timerState.isCreated()) {
            if (logger.isLoggable(JeusMessage_EJB7._4783_LEVEL)) {
                logger.logp(JeusMessage_EJB7._4783_LEVEL, "TimerContainer", "cancelTask", JeusMessage_EJB7._4783);
            }
            timeout = timerState.getInitialExpiration();
        } else if (timerState.isScheduled()) {
            if (logger.isLoggable(JeusMessage_EJB7._4784_LEVEL)) {
                logger.logp(JeusMessage_EJB7._4784_LEVEL, "TimerContainer", "cancelTask", JeusMessage_EJB7._4784);
            }
            EJBTimerTask timerTask = timerState.getCurrentTimerTask();
            timeout = timerTask.getTimeout();
            timerTask.cancel();
        }
        timerState.cancelled();
        if (logger.isLoggable(JeusMessage_EJB7._4785_LEVEL)) {
            logger.logp(JeusMessage_EJB7._4785_LEVEL, "TimerContainer", "cancelTask", JeusMessage_EJB7._4785, (Object)String.valueOf(timeout));
        }
        return timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Serializable getInfo(Long timerId) throws NoSuchObjectLocalException {
        Serializable info;
        TimerState timerState;
        if (logger.isLoggable(JeusMessage_EJB7._4786_LEVEL)) {
            logger.logp(JeusMessage_EJB7._4786_LEVEL, "TimerContainer", "getInfo", JeusMessage_EJB7._4786, (Object)timerId);
        }
        if ((timerState = this.getTimerState(timerId)) == null) {
            if (logger.isLoggable(JeusMessage_EJB7._4787_LEVEL)) {
                logger.logp(JeusMessage_EJB7._4787_LEVEL, "TimerContainer", "getInfo", JeusMessage_EJB7._4787);
            }
            throw new NoSuchObjectLocalException(ErrorMsgManager.getLocalizedString((int)JeusMessage_EJB7._4787));
        }
        TimerState timerState2 = timerState;
        synchronized (timerState2) {
            if (timerState.isScheduled() || timerState.isBeingDelivered()) {
                info = timerState.getInfo();
            } else {
                try {
                    Transaction tx = this.txManager.getTransaction();
                    if (timerState.isCancelled(tx)) {
                        if (logger.isLoggable(JeusMessage_EJB7._4788_LEVEL)) {
                            logger.logp(JeusMessage_EJB7._4788_LEVEL, "TimerContainer", "getInfo", JeusMessage_EJB7._4788);
                        }
                        throw new NoSuchObjectLocalException(ErrorMsgManager.getLocalizedString((int)JeusMessage_EJB7._4788));
                    }
                }
                catch (SystemException e) {
                    throw new EJBException((Exception)((Object)e));
                }
                info = timerState.getInfo();
            }
        }
        if (logger.isLoggable(JeusMessage_EJB7._4789_LEVEL)) {
            logger.logp(JeusMessage_EJB7._4789_LEVEL, "TimerContainer", "getInfo", JeusMessage_EJB7._4789, new Object[]{info, timerId});
        }
        return info;
    }

    public void expungeTimer(Long timerId) {
        TimerState timerState;
        if (logger.isLoggable(JeusMessage_EJB7._4790_LEVEL)) {
            logger.logp(JeusMessage_EJB7._4790_LEVEL, "TimerContainer", "expungeTimer", JeusMessage_EJB7._4790, (Object)timerId);
        }
        if ((timerState = this.getTimerState(timerId)) != null) {
            BeanContainer container = timerState.getContainer();
            Object pk = timerState.getPrimaryKey();
            container.remove(pk, timerId);
            this.timerCache.remove(timerId);
        }
    }

    private Date calcNextFixedRateExpiration(TimerState timerState) {
        Date initialExpiration;
        if (logger.isLoggable(JeusMessage_EJB7._4791_LEVEL)) {
            logger.logp(JeusMessage_EJB7._4791_LEVEL, "TimerContainer", "calcNextFixedRateExpiration", JeusMessage_EJB7._4791, (Object)timerState.getTimerId());
        }
        if (!timerState.isPeriodic()) {
            if (logger.isLoggable(JeusMessage_EJB7._4792_LEVEL)) {
                logger.logp(JeusMessage_EJB7._4792_LEVEL, "TimerContainer", "calcNextFixedRateExpiration", JeusMessage_EJB7._4792, (Object)timerState.getTimerId());
            }
            throw new IllegalStateException();
        }
        Date now = new Date();
        long nowMillis = now.getTime();
        long timeSinceInitialExpire = nowMillis - (initialExpiration = timerState.getInitialExpiration()).getTime();
        long timeTillNextExpire = timeSinceInitialExpire % timerState.getIntervalDuration();
        timeTillNextExpire = timeTillNextExpire != 0L ? timerState.getIntervalDuration() - timeTillNextExpire : timerState.getIntervalDuration();
        Date expirationTime = new Date(nowMillis + timeTillNextExpire);
        if (logger.isLoggable(JeusMessage_EJB7._4793_LEVEL)) {
            logger.logp(JeusMessage_EJB7._4793_LEVEL, "TimerContainer", "calcNextFixedRateExpiration", JeusMessage_EJB7._4793, (Object)expirationTime);
        }
        return expirationTime;
    }

    public Long createTimer(String moduleName, String beanName, Object primaryKey, long initialDuration, long intervalDuration, Serializable info, boolean isEnableDurable) throws CreateException {
        Date initialExpiration = new Date(System.currentTimeMillis() + initialDuration);
        return this.createTimer(moduleName, beanName, primaryKey, initialExpiration, intervalDuration, info, isEnableDurable, true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long createTimer(String moduleName, String beanName, Object primaryKey, Date initialExpiration, long intervalDuration, Serializable info, boolean isEnableDurable, boolean createTimerForDurable, Long timerId) throws CreateException {
        BeanContainer container;
        if (logger.isLoggable(JeusMessage_EJB7._4794_LEVEL)) {
            logger.logp(JeusMessage_EJB7._4794_LEVEL, "TimerContainer", "createTimer", JeusMessage_EJB7._4794, new Object[]{beanName, moduleName, initialExpiration, new Long(intervalDuration)});
        }
        if (!this.supportDurable) {
            isEnableDurable = false;
        }
        if ((container = this.getContainer(moduleName, beanName)) == null) {
            if (logger.isLoggable(JeusMessage_EJB7._4795_LEVEL)) {
                logger.logp(JeusMessage_EJB7._4795_LEVEL, "TimerContainer", "createTimer", JeusMessage_EJB7._4795, new Object[]{beanName, moduleName});
            }
            throw new CreateException(ErrorMsgManager.getLocalizedString((int)JeusMessage_EJB7._4795, (Object[])new Object[]{beanName, moduleName}));
        }
        if (!container.isTimedObject()) {
            if (logger.isLoggable(JeusMessage_EJB7._4796_LEVEL)) {
                logger.logp(JeusMessage_EJB7._4796_LEVEL, "TimerContainer", "createTimer", JeusMessage_EJB7._4796);
            }
            throw new CreateException(ErrorMsgManager.getLocalizedString((int)JeusMessage_EJB7._4796));
        }
        if (timerId == null) {
            timerId = TimerContainer.getNextTimerId();
        }
        container.addTimerId(primaryKey, timerId);
        String ejbId = container.getEJBId();
        TimerState timerState = new TimerState(timerId, info, initialExpiration, intervalDuration, container, primaryKey, isEnableDurable);
        if (isEnableDurable) {
            timerState.setClassLoader(Thread.currentThread().getContextClassLoader());
        }
        TimerState timerState2 = timerState;
        synchronized (timerState2) {
            try {
                Transaction transaction;
                if (isEnableDurable && createTimerForDurable) {
                    if (logger.isLoggable(JeusMessage_EJB7._4797_LEVEL)) {
                        logger.logp(JeusMessage_EJB7._4797_LEVEL, "TimerContainer", "createTimer", JeusMessage_EJB7._4797, (Object)timerId);
                    }
                    this.timerBeanHome.create(timerId, ejbId, primaryKey, initialExpiration, intervalDuration, info);
                    if (logger.isLoggable(JeusMessage_EJB7._4798_LEVEL)) {
                        logger.logp(JeusMessage_EJB7._4798_LEVEL, "TimerContainer", "createTimer", JeusMessage_EJB7._4798);
                    }
                    this.printTimerIdsInDB();
                }
                if ((transaction = this.txManager.getTransaction()) != null && transaction != TMService.nullTransaction) {
                    if (logger.isLoggable(JeusMessage_EJB7._4799_LEVEL)) {
                        logger.logp(JeusMessage_EJB7._4799_LEVEL, "TimerContainer", "createTimer", JeusMessage_EJB7._4799, (Object)transaction);
                    }
                    timerState.setTransaction(transaction, true);
                    TimerSynch timerSynch = new TimerSynch(timerId, 0, initialExpiration);
                    transaction.registerSynchronization((Synchronization)timerSynch);
                    if (logger.isLoggable(JeusMessage_EJB7._4800_LEVEL)) {
                        logger.logp(JeusMessage_EJB7._4800_LEVEL, "TimerContainer", "createTimer", JeusMessage_EJB7._4800);
                    }
                    this.timerCache.put(timerId, timerState);
                } else {
                    if (logger.isLoggable(JeusMessage_EJB7._4801_LEVEL)) {
                        logger.logp(JeusMessage_EJB7._4801_LEVEL, "TimerContainer", "createTimer", JeusMessage_EJB7._4801);
                    }
                    this.timerCache.put(timerId, timerState);
                    timerState.setCommitted();
                    this.scheduleTask(timerId, initialExpiration);
                }
            }
            catch (SystemException syse) {
                if (logger.isLoggable(JeusMessage_EJB7._4802_LEVEL)) {
                    logger.logp(JeusMessage_EJB7._4802_LEVEL, "TimerContainer", "createTimer", JeusMessage_EJB7._4802, new Object[]{beanName, moduleName}, (Throwable)syse);
                }
                throw new CreateException(ErrorMsgManager.getLocalizedString((int)JeusMessage_EJB7._4802, (Object[])new Object[]{beanName, moduleName}));
            }
            catch (RollbackException rolle) {
                if (logger.isLoggable(JeusMessage_EJB7._4803_LEVEL)) {
                    logger.logp(JeusMessage_EJB7._4803_LEVEL, "TimerContainer", "createTimer", JeusMessage_EJB7._4803, new Object[]{beanName, moduleName}, (Throwable)rolle);
                }
                throw new CreateException(ErrorMsgManager.getLocalizedString((int)JeusMessage_EJB7._4803, (Object[])new Object[]{beanName, moduleName}));
            }
        }
        if (logger.isLoggable(JeusMessage_EJB7._4804_LEVEL)) {
            logger.logp(JeusMessage_EJB7._4804_LEVEL, "TimerContainer", "createTimer", JeusMessage_EJB7._4804, (Object)timerId);
        }
        return timerId;
    }

    public Collection getTimerIds(String moduleName, String beanName, Object primaryKey) throws NoSuchObjectLocalException {
        Transaction tx;
        if (logger.isLoggable(JeusMessage_EJB7._4805_LEVEL)) {
            logger.logp(JeusMessage_EJB7._4805_LEVEL, "TimerContainer", "getTimerIds", JeusMessage_EJB7._4805, new Object[]{beanName, primaryKey, moduleName});
        }
        HashSet<Long> timerIds = new HashSet<Long>();
        BeanContainer container = this.getContainer(moduleName, beanName);
        try {
            if (logger.isLoggable(JeusMessage_EJB7._4806_LEVEL)) {
                logger.logp(JeusMessage_EJB7._4806_LEVEL, "TimerContainer", "getTimerIds", JeusMessage_EJB7._4806);
            }
            tx = this.txManager.getTransaction();
            if (logger.isLoggable(JeusMessage_EJB7._4807_LEVEL)) {
                logger.logp(JeusMessage_EJB7._4807_LEVEL, "TimerContainer", "getTimerIds", JeusMessage_EJB7._4807);
            }
        }
        catch (SystemException ex) {
            if (logger.isLoggable(JeusMessage_EJB7._4808_LEVEL)) {
                logger.logp(JeusMessage_EJB7._4808_LEVEL, "TimerContainer", "getTimerIds", JeusMessage_EJB7._4808, (Throwable)ex);
            }
            throw new EJBException((Exception)((Object)ex));
        }
        Enumeration e = container.getTimerIds(primaryKey);
        while (e.hasMoreElements()) {
            Long timerID = (Long)e.nextElement();
            TimerState state = this.getTimerState(timerID);
            if (state.isCancelled(tx)) continue;
            if (logger.isLoggable(JeusMessage_EJB7._4809_LEVEL)) {
                logger.logp(JeusMessage_EJB7._4809_LEVEL, "TimerContainer", "getTimerIds", JeusMessage_EJB7._4809, (Object)timerID);
            }
            timerIds.add(timerID);
        }
        if (logger.isLoggable(JeusMessage_EJB7._4810_LEVEL)) {
            logger.logp(JeusMessage_EJB7._4810_LEVEL, "TimerContainer", "getTimerIds", JeusMessage_EJB7._4810, (Object)String.valueOf(timerIds.size()));
        }
        return timerIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date getNextTimeout(Long timerId) throws NoSuchObjectLocalException {
        Date nextTimeout;
        TimerState timerState;
        if (logger.isLoggable(JeusMessage_EJB7._4811_LEVEL)) {
            logger.logp(JeusMessage_EJB7._4811_LEVEL, "TimerContainer", "getNextTimeout", JeusMessage_EJB7._4811, (Object)timerId);
        }
        if ((timerState = this.getTimerState(timerId)) == null) {
            if (logger.isLoggable(JeusMessage_EJB7._4812_LEVEL)) {
                logger.logp(JeusMessage_EJB7._4812_LEVEL, "TimerContainer", "getNextTimeout", JeusMessage_EJB7._4812);
            }
            throw new NoSuchObjectLocalException(ErrorMsgManager.getLocalizedString((int)JeusMessage_EJB7._4812));
        }
        TimerState timerState2 = timerState;
        synchronized (timerState2) {
            if (timerState.isScheduled()) {
                EJBTimerTask currentTask = timerState.getCurrentTimerTask();
                nextTimeout = currentTask.getTimeout();
            } else if (timerState.isBeingDelivered()) {
                nextTimeout = new Date();
            } else {
                try {
                    if (logger.isLoggable(JeusMessage_EJB7._4813_LEVEL)) {
                        logger.logp(JeusMessage_EJB7._4813_LEVEL, "TimerContainer", "getNextTimeout", JeusMessage_EJB7._4813);
                    }
                    Transaction tx = this.txManager.getTransaction();
                    if (logger.isLoggable(JeusMessage_EJB7._4814_LEVEL)) {
                        logger.logp(JeusMessage_EJB7._4814_LEVEL, "TimerContainer", "getNextTimeout", JeusMessage_EJB7._4814);
                    }
                    if (timerState.isCancelled(tx)) {
                        if (logger.isLoggable(JeusMessage_EJB7._4815_LEVEL)) {
                            logger.logp(JeusMessage_EJB7._4815_LEVEL, "TimerContainer", "getNextTimeout", JeusMessage_EJB7._4815);
                        }
                        throw new NoSuchObjectLocalException(ErrorMsgManager.getLocalizedString((int)JeusMessage_EJB7._4815));
                    }
                }
                catch (SystemException e) {
                    if (logger.isLoggable(JeusMessage_EJB7._4816_LEVEL)) {
                        logger.logp(JeusMessage_EJB7._4816_LEVEL, "TimerContainer", "getNextTimeout", JeusMessage_EJB7._4816, (Throwable)e);
                    }
                    throw new EJBException((Exception)((Object)e));
                }
                nextTimeout = timerState.getInitialExpiration();
            }
            if (logger.isLoggable(JeusMessage_EJB7._4817_LEVEL)) {
                logger.logp(JeusMessage_EJB7._4817_LEVEL, "TimerContainer", "getNextTimeout", JeusMessage_EJB7._4817, (Object)nextTimeout);
            }
        }
        return nextTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deliverTimeout(Long timerId) {
        block27: {
            TimerState timerState;
            if (logger.isLoggable(JeusMessage_EJB7._4818_LEVEL)) {
                logger.logp(JeusMessage_EJB7._4818_LEVEL, "TimerContainer", "deliverTimeout", JeusMessage_EJB7._4818, (Object)timerId);
            }
            if ((timerState = this.getTimerState(timerId)) == null) {
                if (logger.isLoggable(JeusMessage_EJB7._4819_LEVEL)) {
                    logger.logp(JeusMessage_EJB7._4819_LEVEL, "TimerContainer", "deliverTimeout", JeusMessage_EJB7._4819);
                }
                return;
            }
            BeanContainer container = timerState.getContainer();
            if (!container.isRunning()) {
                if (logger.isLoggable(JeusMessage_EJB4._3054_LEVEL)) {
                    logger.logp(JeusMessage_EJB4._3054_LEVEL, "Container", "invokeEJBTimeout", JeusMessage_EJB4._3054);
                }
                return;
            }
            try {
                TimerState timerState2 = timerState;
                synchronized (timerState2) {
                    if (container != null) {
                        boolean redeliver;
                        try {
                            if (logger.isLoggable(JeusMessage_EJB7._4820_LEVEL)) {
                                logger.logp(JeusMessage_EJB7._4820_LEVEL, "TimerContainer", "deliverTimeout", JeusMessage_EJB7._4820);
                            }
                            redeliver = container.invokeEJBTimeout(timerState, this);
                            if (logger.isLoggable(JeusMessage_EJB7._4821_LEVEL)) {
                                logger.logp(JeusMessage_EJB7._4821_LEVEL, "TimerContainer", "deliverTimeout", JeusMessage_EJB7._4821);
                            }
                        }
                        catch (ContainerException ex) {
                            if (logger.isLoggable(JeusMessage_EJB12._9022_LEVEL)) {
                                logger.log(JeusMessage_EJB12._9022_LEVEL, JeusMessage_EJB12._9022, (Throwable)((Object)ex));
                            }
                            return;
                        }
                        catch (Throwable e) {
                            if (logger.isLoggable(JeusMessage_EJB7._4822_LEVEL)) {
                                logger.logp(JeusMessage_EJB7._4822_LEVEL, "TimerContainer", "deliverTimeout", JeusMessage_EJB7._4822, (Object)container.getBeanName(), e);
                            }
                            this.tryRedeliverTimeout(timerState, timerId);
                            return;
                        }
                        if (redeliver) {
                            this.tryRedeliverTimeout(timerState, timerId);
                        } else if (timerState.isPeriodic()) {
                            this.prepareNextPeriodicTimeout(timerState, timerId);
                        } else {
                            this.expungeTimer(timerId);
                        }
                    } else {
                        if (logger.isLoggable(JeusMessage_EJB7._4823_LEVEL)) {
                            logger.logp(JeusMessage_EJB7._4823_LEVEL, "TimerContainer", "deliverTimeout", JeusMessage_EJB7._4823, (Object)timerId);
                        }
                        if (timerState.isEnableDurable()) {
                            if (logger.isLoggable(JeusMessage_EJB7._4824_LEVEL)) {
                                logger.logp(JeusMessage_EJB7._4824_LEVEL, "TimerContainer", "deliverTimeout", JeusMessage_EJB7._4824, (Object)timerId);
                            }
                            this.timerBeanHome.remove(new TimerPrimaryKey(timerId));
                            if (logger.isLoggable(JeusMessage_EJB7._4825_LEVEL)) {
                                logger.logp(JeusMessage_EJB7._4825_LEVEL, "TimerContainer", "deliverTimeout", JeusMessage_EJB7._4825);
                            }
                            this.printTimerIdsInDB();
                        }
                        this.expungeTimer(timerId);
                    }
                }
            }
            catch (Throwable e) {
                if (!logger.isLoggable(JeusMessage_EJB7._4826_LEVEL)) break block27;
                logger.logp(JeusMessage_EJB7._4826_LEVEL, "TimerContainer", "deliverTimeout", JeusMessage_EJB7._4826, e);
            }
        }
    }

    private void tryRedeliverTimeout(TimerState timerState, Long timerId) {
        int maxRedeliveryCount;
        if (logger.isLoggable(JeusMessage_EJB7._4827_LEVEL)) {
            logger.logp(JeusMessage_EJB7._4827_LEVEL, "TimerContainer", "tryRedeliverTimeout", JeusMessage_EJB7._4827, (Object)timerId);
        }
        Date now = new Date();
        int numFailedDeliveryCount = timerState.getNumFailedDeliveryCount();
        if (numFailedDeliveryCount < (maxRedeliveryCount = this.getMaxRedeliveryCount())) {
            if (logger.isLoggable(JeusMessage_EJB7._4828_LEVEL)) {
                logger.logp(JeusMessage_EJB7._4828_LEVEL, "TimerContainer", "tryRedeliverTimeout", JeusMessage_EJB7._4828, new Object[]{String.valueOf(numFailedDeliveryCount), String.valueOf(maxRedeliveryCount)});
            }
            Date redeliveryTimeout = new Date(now.getTime() + this.getRedeliveryInterval());
            this.rescheduleTask(timerId, redeliveryTimeout);
        } else if (timerState.isPeriodic()) {
            this.prepareNextPeriodicTimeout(timerState, timerId);
        } else {
            block12: {
                if (timerState.isEnableDurable()) {
                    try {
                        if (logger.isLoggable(JeusMessage_EJB7._4829_LEVEL)) {
                            logger.logp(JeusMessage_EJB7._4829_LEVEL, "TimerContainer", "tryRedeliverTimeout", JeusMessage_EJB7._4829);
                        }
                        this.timerBeanHome.remove(new TimerPrimaryKey(timerId));
                        if (logger.isLoggable(JeusMessage_EJB7._4830_LEVEL)) {
                            logger.logp(JeusMessage_EJB7._4830_LEVEL, "TimerContainer", "tryRedeliverTimeout", JeusMessage_EJB7._4830);
                        }
                        this.printTimerIdsInDB();
                    }
                    catch (Exception e) {
                        if (!logger.isLoggable(JeusMessage_EJB7._4831_LEVEL)) break block12;
                        logger.logp(JeusMessage_EJB7._4831_LEVEL, "TimerContainer", "tryRedeliverTimeout", JeusMessage_EJB7._4831, (Throwable)e);
                    }
                }
            }
            this.expungeTimer(timerId);
        }
        if (logger.isLoggable(JeusMessage_EJB7._4832_LEVEL)) {
            logger.logp(JeusMessage_EJB7._4832_LEVEL, "TimerContainer", "tryRedeliverTimeout", JeusMessage_EJB7._4832);
        }
    }

    private void prepareNextPeriodicTimeout(TimerState timerState, Long timerId) {
        if (logger.isLoggable(JeusMessage_EJB7._4833_LEVEL)) {
            logger.logp(JeusMessage_EJB7._4833_LEVEL, "TimerContainer", "prepareNextPeriodicTimeout", JeusMessage_EJB7._4833, (Object)timerId);
        }
        Date expiration = this.calcNextFixedRateExpiration(timerState);
        this.scheduleTask(timerId, expiration);
        if (logger.isLoggable(JeusMessage_EJB7._4834_LEVEL)) {
            logger.logp(JeusMessage_EJB7._4834_LEVEL, "TimerContainer", "prepareNextPeriodicTimeout", JeusMessage_EJB7._4834);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void taskExpired(Long timerId) {
        TimerState timerState = this.getTimerState(timerId);
        if (timerState != null) {
            TimerState timerState2 = timerState;
            synchronized (timerState2) {
                if (timerState.isScheduled()) {
                    timerState.delivered();
                    TimeWorker tw = new TimeWorker(timerId);
                    this.executionPool.execute((Runnable)tw);
                } else if (logger.isLoggable(JeusMessage_EJB7._4848_LEVEL)) {
                    logger.log(JeusMessage_EJB7._4848_LEVEL, JeusMessage_EJB7._4848, (Object)timerId);
                }
            }
        }
    }

    public boolean timerExists(Long timerId) {
        TimerState state;
        if (logger.isLoggable(JeusMessage_EJB7._4835_LEVEL)) {
            logger.logp(JeusMessage_EJB7._4835_LEVEL, "TimerContainer", "timerExists", JeusMessage_EJB7._4835);
        }
        if ((state = this.timerCache.get(timerId)) == null) {
            if (logger.isLoggable(JeusMessage_EJB7._4836_LEVEL)) {
                logger.logp(JeusMessage_EJB7._4836_LEVEL, "TimerContainer", "timerExists", JeusMessage_EJB7._4836);
            }
            return false;
        }
        try {
            if (logger.isLoggable(JeusMessage_EJB7._4837_LEVEL)) {
                logger.logp(JeusMessage_EJB7._4837_LEVEL, "TimerContainer", "timerExists", JeusMessage_EJB7._4837);
            }
            Transaction transaction = this.txManager.getTransaction();
            if (logger.isLoggable(JeusMessage_EJB7._4838_LEVEL)) {
                logger.logp(JeusMessage_EJB7._4838_LEVEL, "TimerContainer", "timerExists", JeusMessage_EJB7._4838);
            }
            boolean visible = state.doesExistForTransaction(transaction);
            if (logger.isLoggable(JeusMessage_EJB7._4839_LEVEL)) {
                logger.logp(JeusMessage_EJB7._4839_LEVEL, "TimerContainer", "timerExists", JeusMessage_EJB7._4839, (Object)(visible ? "" : "not "));
            }
            return visible;
        }
        catch (SystemException e) {
            if (logger.isLoggable(JeusMessage_EJB7._4840_LEVEL)) {
                logger.logp(JeusMessage_EJB7._4840_LEVEL, "TimerContainer", "timerExists", JeusMessage_EJB7._4840, (Throwable)e);
            }
            throw new EJBException((Exception)((Object)e));
        }
    }

    private BeanContainer getContainer(String moduleName, String beanName) {
        return EJBEngine.getContainer(moduleName, beanName);
    }

    public TimerState getTimerState(Long timerId) {
        return this.timerCache.get(timerId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Long getNextTimerId() {
        Class<TimerContainer> clazz = TimerContainer.class;
        synchronized (TimerContainer.class) {
            nextTimerId = nextTimerId == 0L ? System.currentTimeMillis() : ++nextTimerId;
            // ** MonitorExit[var0] (shouldn't be in output)
            return nextTimerId;
        }
    }

    private long getMinimumDeliveryInterval() {
        return this.minDeliveryInterval;
    }

    private int getMaxRedeliveryCount() {
        return this.maxRedeliveryCount;
    }

    private long getRedeliveryInterval() {
        return this.redeliveryInterval;
    }

    public ClassLoader getTimerClassLoader(Long timerId) {
        TimerState state = this.getTimerState(timerId);
        return state == null ? null : state.getClassLoader();
    }

    public void setCommitted(Long timerId) {
        TimerState state = this.getTimerState(timerId);
        if (state != null) {
            state.setCommitted();
        }
    }

    public void setLastExpiration(TimerState timerState, boolean isRedeliver) {
        block6: {
            if (logger.isLoggable(JeusMessage_EJB7._4841_LEVEL)) {
                logger.logp(JeusMessage_EJB7._4841_LEVEL, "TimerContainer", "setLastExpiration", JeusMessage_EJB7._4841, (Object)timerState.timerId);
            }
            try {
                if (timerState.isEnableDurable() && !isRedeliver) {
                    TimerPrimaryKey timerPrimKey = new TimerPrimaryKey(timerState.getTimerId());
                    if (timerState.isPeriodic()) {
                        TimerLocal dbTimer = this.timerBeanHome.findByPrimaryKey(timerPrimKey);
                        dbTimer.setLastExpiration(new Date());
                    } else {
                        this.timerBeanHome.remove(timerPrimKey);
                        this.printTimerIdsInDB();
                    }
                }
            }
            catch (Exception ex) {
                if (!logger.isLoggable(JeusMessage_EJB7._4842_LEVEL)) break block6;
                logger.logp(JeusMessage_EJB7._4842_LEVEL, "TimerContainer", "setLastExpiration", JeusMessage_EJB7._4842, (Throwable)ex);
            }
        }
    }

    public void initDurableTimers(AbstractContainer container, boolean isDeleteTimers, ClassLoader timerClassLoader) {
        if (this.supportDurable) {
            String ejbId = container.getEJBId();
            String moduleName = container.getModuleName();
            String beanName = container.getBeanName();
            if (logger.isLoggable(JeusMessage_EJB7._4843_LEVEL)) {
                logger.logp(JeusMessage_EJB7._4843_LEVEL, "TimerContainer", "initDurableTimers", JeusMessage_EJB7._4843, new Object[]{beanName, moduleName});
            }
            try {
                Set timers = this.timerBeanHome.selectTimersByContainer(ejbId);
                for (TimerLocal timerLocal : timers) {
                    if (isDeleteTimers) {
                        if (logger.isLoggable(JeusMessage_EJB7._4844_LEVEL)) {
                            logger.logp(JeusMessage_EJB7._4844_LEVEL, "TimerContainer", "initDurableTimers", JeusMessage_EJB7._4844);
                        }
                        timerLocal.remove();
                        continue;
                    }
                    this.createTimer(moduleName, beanName, timerLocal.getTimedObjectPrimaryKey(timerClassLoader), timerLocal.getInitialExpiration(), timerLocal.getIntervalDuration(), timerLocal.getInfo(timerClassLoader), true, false, timerLocal.getTimerId());
                    if (!logger.isLoggable(JeusMessage_EJB7._4845_LEVEL)) continue;
                    logger.logp(JeusMessage_EJB7._4845_LEVEL, "TimerContainer", "initDurableTimers", JeusMessage_EJB7._4845);
                }
            }
            catch (Exception ex) {
                if (logger.isLoggable(JeusMessage_EJB7._4846_LEVEL)) {
                    logger.logp(JeusMessage_EJB7._4846_LEVEL, "TimerContainer", "createTimer", JeusMessage_EJB7._4846, new Object[]{beanName, moduleName}, (Throwable)ex);
                }
                throw new JeusRuntimeException(JeusMessage_EJB7._4846, (Object[])new String[]{beanName, moduleName}, (Throwable)ex);
            }
        }
    }

    public void down() {
        this.executionPool.shutdownNow();
    }

    private class TimeWorker
    implements Runnable {
        private Long timerId;

        TimeWorker(Long timerId) {
            this.timerId = timerId;
        }

        public void run() {
            block2: {
                try {
                    TimerContainer.this.deliverTimeout(this.timerId);
                }
                catch (Throwable t) {
                    if (!logger.isLoggable(JeusMessage_EJB7._4849_LEVEL)) break block2;
                    logger.log(JeusMessage_EJB7._4849_LEVEL, JeusMessage_EJB7._4849, t);
                }
            }
        }
    }
}

