/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.container;

import java.io.Serializable;
import java.util.Date;
import javax.transaction.Transaction;
import jeus.ejb.BeanContainer;
import jeus.ejb.container.EJBTimerTask;

public class TimerState {
    private static final int CREATED = 0;
    private static final int SCHEDULED = 1;
    private static final int BEING_DELIVERED = 2;
    private static final int CANCELED = 3;
    public static final String[] timerstate = new String[]{"CREATED", "SCHEDULED", "BEING_DELIVERED", "CANCELED"};
    protected Long timerId;
    private Serializable info;
    private Date initialExpiration;
    private BeanContainer container;
    private Object pkey;
    private int state = 0;
    private long intervalDuration;
    private EJBTimerTask currentTask = null;
    private int numExpirations;
    private int numFailedDeliveries;
    private ClassLoader loader;
    private boolean isEnableDurable;
    private boolean isCommitted;
    private Transaction transaction;
    private int transactionState;
    private static final int WAIT_NONE = 0;
    private static final int WAIT_CREATE = 1;
    private static final int WAIT_CANCEL = 2;
    private static final int WAIT_CREATE_CANCEL = 3;
    public static final String[] txstate = new String[]{"WAIT_NONE", "WAIT_CREATE", "WAIT_CANCEL", "WAIT_CREATE_CANCEL"};

    public TimerState(Long timerId, Serializable info, Date initialExpiration, long intervalDuration, BeanContainer container, Object pkey, boolean isEnableDurable) {
        this.timerId = timerId;
        this.info = info;
        this.initialExpiration = initialExpiration;
        this.intervalDuration = intervalDuration;
        this.pkey = pkey;
        this.container = container;
        this.isEnableDurable = isEnableDurable;
    }

    public void setClassLoader(ClassLoader loader) {
        this.loader = loader;
    }

    public Long getTimerId() {
        return this.timerId;
    }

    public Serializable getInfo() {
        return this.info;
    }

    public Date getInitialExpiration() {
        return this.initialExpiration;
    }

    public BeanContainer getContainer() {
        return this.container;
    }

    public Object getPrimaryKey() {
        return this.pkey;
    }

    public long getIntervalDuration() {
        return this.intervalDuration;
    }

    public void scheduled(EJBTimerTask timerTask) {
        this.currentTask = timerTask;
        this.state = 1;
        this.numFailedDeliveries = 0;
    }

    public void rescheduled(EJBTimerTask timerTask) {
        this.currentTask = timerTask;
        this.state = 1;
        ++this.numFailedDeliveries;
    }

    public void delivered() {
        this.currentTask = null;
        if (this.numFailedDeliveries == 0) {
            ++this.numExpirations;
        }
        this.state = 2;
    }

    public void cancelled() {
        this.currentTask = null;
        this.state = 3;
    }

    public EJBTimerTask getCurrentTimerTask() {
        return this.currentTask;
    }

    public boolean isEntity() {
        return this.pkey != null;
    }

    public boolean isCancelled(Transaction transaction) {
        if (this.state == 3) {
            switch (this.transactionState) {
                case 2: {
                    return this.transaction.equals(transaction);
                }
            }
            return true;
        }
        return false;
    }

    public boolean isCreated() {
        return this.state == 0;
    }

    public boolean isBeingDelivered() {
        return this.state == 2;
    }

    public boolean isScheduled() {
        return this.state == 1;
    }

    public boolean isRescheduled() {
        return this.isScheduled() && this.numFailedDeliveries > 0;
    }

    public int getNumFailedDeliveryCount() {
        return this.numFailedDeliveries;
    }

    public Date getNextTimeout() {
        if (!this.isScheduled() && !this.isRescheduled()) {
            throw new IllegalStateException();
        }
        return this.currentTask.getTimeout();
    }

    public long getTimeRemaining() {
        Date timeout = this.getNextTimeout();
        Date now = new Date();
        return timeout.getTime() - now.getTime();
    }

    public boolean isPeriodic() {
        return this.intervalDuration > 0L;
    }

    public int hashCode() {
        return this.timerId.hashCode();
    }

    public boolean equals(Object other) {
        boolean result = false;
        if (other instanceof TimerState) {
            result = this.timerId.equals(((TimerState)other).timerId);
        }
        return result;
    }

    public ClassLoader getClassLoader() {
        return this.loader;
    }

    public synchronized void setCommitted() {
        this.transaction = null;
        this.transactionState = 0;
        this.notifyAll();
    }

    public synchronized void setTransaction(Transaction transaction, boolean created) {
        this.transaction = transaction;
        if (created) {
            this.transactionState = 1;
        } else if (this.transactionState == 0) {
            this.transactionState = 2;
        } else if (this.transactionState == 1) {
            this.transactionState = 3;
        }
    }

    public synchronized boolean doesExistForTransaction(Transaction transaction) {
        switch (this.transactionState) {
            case 0: {
                return true;
            }
            case 1: {
                return this.transaction.equals(transaction);
            }
            case 2: {
                return !this.transaction.equals(transaction);
            }
            case 3: {
                return false;
            }
        }
        return true;
    }

    public boolean isEnableDurable() {
        return this.isEnableDurable;
    }

    public boolean isWaitCanceled() {
        return this.transactionState == 2;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (this.pkey != null) {
            buffer.append("pkey : ").append(this.pkey).append(", ");
        }
        if (this.currentTask != null) {
            buffer.append("currentTask : ").append(this.currentTask).append(", ");
        }
        if (this.currentTask != null) {
            buffer.append("state : ").append(timerstate[this.state]).append(", ");
        }
        buffer.append("tx state : ");
        if (this.transaction != null) {
            buffer.append(txstate[this.transactionState]);
        } else {
            buffer.append("null");
        }
        return buffer.toString();
    }
}

