/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.container3;

import java.lang.reflect.Method;
import javax.ejb.EJBException;
import javax.jms.Message;
import javax.jms.MessageListener;
import jeus.ejb.baseimpl.MessageDrivenContextImpl;
import jeus.ejb.container3.MessageDrivenContainer;
import jeus.ejb.interceptor.UserInterceptorManager;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_EJB12;

public class MessageListenerWrapper
implements MessageListener {
    private MessageDrivenContainer container;
    private MessageDrivenContextImpl beanContext;
    private boolean isMessageListenerImpl;
    private Method onMessageMethod;
    private UserInterceptorManager interceptor;
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.ejb.mdb");

    public MessageListenerWrapper(MessageDrivenContainer container, MessageDrivenContextImpl ctx) {
        this.container = container;
        this.beanContext = ctx;
        this.isMessageListenerImpl = container.isJMSMessageListenerImpl();
        this.onMessageMethod = container.getOnMessageMethod();
        this.interceptor = container.getUserInterceptorManager();
        assert (this.interceptor != null);
    }

    public void onMessage(Message message) {
        try {
            if (logger.isLoggable(JeusMessage_EJB12._9025_LEVEL)) {
                logger.log(JeusMessage_EJB12._9025_LEVEL, JeusMessage_EJB12._9025, new Object[]{this.container.getBeanName(), message});
            }
            this.interceptor.invoke(this.beanContext, this.onMessageMethod, new Object[]{message});
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new EJBException(ex);
        }
    }
}

