/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.container3;

import jeus.ejb.container.TimerContainer;
import jeus.ejb.container.TimerState;
import jeus.ejb.container3.BaseBeanContainer;
import jeus.ejb.interceptor.Interceptor;
import jeus.ejb.interceptor.Invocation;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_EJB4;

public class RedeliverTimerInterceptor
implements Interceptor {
    protected static final JeusLogger timerLogger = (JeusLogger)JeusLogger.getLogger((String)"jeus.ejb.timer");
    protected BaseBeanContainer container;
    protected TimerContainer timerContainer = TimerContainer.currentTimerContainer();

    public RedeliverTimerInterceptor(BaseBeanContainer container) {
        this.container = container;
    }

    public String getName() {
        return "RedeliverTimerInterceptor";
    }

    public Object invoke(Invocation invocation) throws Exception {
        invocation.invokeNext();
        boolean redeliver = false;
        if (!this.container.isBeanManagedTx()) {
            if (BaseBeanContainer.txManager.getTransaction() != null) {
                if (BaseBeanContainer.txManager.getTransaction().getStatus() == 1) {
                    redeliver = true;
                    if (timerLogger.isLoggable(JeusMessage_EJB4._3055_LEVEL)) {
                        timerLogger.logp(JeusMessage_EJB4._3055_LEVEL, "Container", "invokeEJBTimeout", JeusMessage_EJB4._3055);
                    }
                }
            }
        }
        TimerState timerState = (TimerState)invocation.getContext("timerState");
        assert (timerState != null);
        this.timerContainer.setLastExpiration(timerState, redeliver);
        invocation.setContext("redeliver", redeliver);
        return null;
    }
}

