/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.container3;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.ejb.EJBException;
import jeus.ejb.baseimpl.EJBSessionIfObject;
import jeus.ejb.container3.EJBIfObjectPool;
import jeus.ejb.container3.SessionContainer;
import jeus.ejb.util.InstanceCreateException;
import jeus.ejb.util.InstancePool;
import jeus.ejb.util.SimpleInstancePool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionIfObjectPool<T extends EJBSessionIfObject>
implements EJBIfObjectPool {
    protected boolean isCleared;
    protected SessionContainer container;
    protected boolean isStateful;
    protected Class ifObjectClass;
    protected ConcurrentMap<String, T> activeObjects;
    protected InstancePool<T> pool;
    protected T singletonObject;

    public SessionIfObjectPool(SessionContainer container, boolean isStateful, Class ifObjectClass) throws InstanceCreateException {
        assert (container != null && ifObjectClass != null);
        this.container = container;
        this.isStateful = isStateful;
        this.ifObjectClass = ifObjectClass;
        if (isStateful) {
            this.pool = new SimpleInstancePool<T>();
            this.pool.initialize(ifObjectClass, 10, 10, 20, Integer.MAX_VALUE, null);
            this.activeObjects = new ConcurrentHashMap<String, T>();
        } else {
            try {
                EJBSessionIfObject ifObject = (EJBSessionIfObject)ifObjectClass.newInstance();
                ifObject._activate(container, "");
                this.singletonObject = ifObject;
            }
            catch (Throwable ex) {
                throw new InstanceCreateException("business object instance creation failed ", ex);
            }
        }
    }

    public T create(String sessionID) throws IllegalStateException, InstanceCreateException {
        Object ifObject;
        if (this.isStateful) {
            ifObject = (EJBSessionIfObject)this.pool.fetch();
            if (ifObject == null) {
                throw new EJBException("Could not fetch bean instance - pool is full or destroyed");
            }
            ifObject._activate(this.container, sessionID);
            this.activeObjects.put(sessionID, ifObject);
        } else {
            ifObject = this.singletonObject;
        }
        return (T)ifObject;
    }

    public T get(String sessionID) {
        if (this.isStateful) {
            return (T)((EJBSessionIfObject)this.activeObjects.get(sessionID));
        }
        return this.singletonObject;
    }

    public T getOrCreate(String sessionID) {
        T t = this.get(sessionID);
        if (t == null) {
            return this.create(sessionID);
        }
        return t;
    }

    public void remove(T ifObject) throws IllegalStateException {
        if (ifObject == null) {
            return;
        }
        if (!this.isStateful) {
            throw new IllegalStateException("Could not call on stateless object pool");
        }
        this.activeObjects.remove(ifObject._getSessionID());
        ifObject._deactivate();
        this.pool.putback(ifObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll() {
        if (!this.isStateful) {
            throw new IllegalStateException("Could not call on stateless object pool");
        }
        ConcurrentMap<String, T> concurrentMap = this.activeObjects;
        synchronized (concurrentMap) {
            for (String id : this.activeObjects.keySet()) {
                EJBSessionIfObject ifObject = (EJBSessionIfObject)this.activeObjects.get(id);
                ifObject._deactivate();
                this.pool.putback(ifObject);
            }
            this.activeObjects.clear();
        }
    }

    public void clear() {
        if (this.isCleared) {
            return;
        }
        this.isCleared = true;
        if (this.isStateful) {
            this.removeAll();
            this.pool.clear(true);
        } else {
            this.singletonObject._deactivate();
        }
    }

    public static void main(String[] args) {
    }

    public int getActiveSize() {
        if (this.pool != null) {
            return this.pool.actives();
        }
        return 1;
    }

    public int getPoolSize() {
        if (this.pool != null) {
            return this.pool.size();
        }
        return 1;
    }
}

