/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.ejbserver;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import jeus.ejb.ejbserver.EJBServerException;
import jeus.ejb.interop.ORBReceiver;
import jeus.ejb.interop.ORBUtil;
import jeus.transaction.ots.Configuration;
import jeus.transaction.ots.CoordinatorResourceServantActivator;
import jeus.transaction.ots.RecoveryCoordinatorServantActivator;
import jeus.transaction.ots.RecoveryManager;
import jeus.util.ErrorMsgManager;
import jeus.util.JeusRuntimeException;
import jeus.util.StringUtil;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_EJB11;
import jeus.util.message.JeusMessage_EJB8;
import jeus.util.message.JeusMessage_OTS0;
import jeus.util.properties.JeusEJBProperties;
import jeus.util.properties.JeusManagerProperties;
import jeus.util.properties.JeusManagerPropertyValues;
import jeus.util.properties.JeusPropertyValues;
import jeus.xml.binding.jeusDD.KeystoreConfigType;
import jeus.xml.binding.jeusDD.SecurityInteropType;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Policy;
import org.omg.PortableServer.LifespanPolicyValue;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAPackage.AdapterAlreadyExists;
import org.omg.PortableServer.POAPackage.InvalidPolicy;
import org.omg.PortableServer.POAPackage.WrongPolicy;
import org.omg.PortableServer.RequestProcessingPolicyValue;
import org.omg.PortableServer.ServantManager;

public class EJBORBManager {
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.ejb.ejbserver.orb");
    private static final String ORB_SINGLETON_CLASS = "com.sun.corba.ee.impl.orb.ORBSingleton";
    private static final String ORB_SE_SINGLETON_CLASS = "com.sun.corba.se.impl.orb.ORBSingleton";
    private static final String IIOP_SSL_SOCKET_FACTORY_CLASS = "jeus.ejb.interop.csi.CSISocketFactoryFor5";
    private static final String RMI_UTIL_CLASS = "com.sun.corba.ee.impl.javax.rmi.CORBA.Util";
    private static final String RMI_STUB_CLASS = "com.sun.corba.ee.impl.javax.rmi.CORBA.StubDelegateImpl";
    private static final String RMI_PRO_CLASS = "com.sun.corba.ee.impl.javax.rmi.PortableRemoteObject";
    public static final String JNDI_PROVIDER_URL_PROPERTY = "java.naming.provider.url";
    public static final String JNDI_CORBA_ORB_PROPERTY = "java.naming.corba.orb";
    public static final String ORB_UTIL_CLASS_PROPERTY = "javax.rmi.CORBA.UtilClass";
    public static final String RMIIIOP_STUB_DELEGATE_CLASS_PROPERTY = "javax.rmi.CORBA.StubClass";
    public static final String RMIIIOP_PRO_DELEGATE_CLASS_PROPERTY = "javax.rmi.CORBA.PortableRemoteObjectClass";
    public static final String OMG_ORB_CLASS_PROPERTY = "org.omg.CORBA.ORBClass";
    public static final String OMG_ORB_SINGLETON_CLASS_PROPERTY = "org.omg.CORBA.ORBSingletonClass";
    public static final String OMG_ORB_INIT_HOST_PROPERTY = "org.omg.CORBA.ORBInitialHost";
    public static final String OMG_ORB_INIT_PORT_PROPERTY = "org.omg.CORBA.ORBInitialPort";
    public static final String SUN_USER_CONFIGURATOR_PREFIX = "com.sun.corba.ee.ORBUserConfigurators.";
    public static final String SUN_ORB_ID_PROPERTY = "org.omg.CORBA.ORBId";
    public static final String SUN_ORB_SERVER_HOST_PROPERTY = "com.sun.corba.ee.ORBServerHost";
    public static final String SUN_ORB_SERVER_PORT_PROPERTY = "com.sun.corba.ee.ORBServerPort";
    public static final String SUN_ORB_SOCKET_FACTORY_CLASS_PROPERTY = "com.sun.corba.ee.transport.ORBSocketFactoryClass";
    public static final String SUN_ORB_IOR_TO_SOCKETINFO_CLASS_PROPERTY = "com.sun.corba.ee.transport.ORBIORToSocketInfoClass";
    public static final String SUN_MAX_CONNECTIONS_PROPERTY = "com.sun.corba.ee.connection.ORBHighWaterMark";
    public static final String ORB_LISTEN_SOCKET_PROPERTY = "com.sun.corba.ee.transport.ORBListenSocket";
    public static final String ORB_DISABLED_PORTS_PROPERTY = "com.sun.CORBA.connection.ORBDisabledListenPorts";
    private static Vector<ORBReceiver> orbReceivers = new Vector();
    private static ORB orb;
    private static ORB defaultORB;
    private static boolean enableInterop;
    private static ArrayList trustHosts;
    private static Hashtable ejbDescs;
    private static ORB clientORB;
    private static Object sync;
    private static int orbPort;
    private static int orbSSLPort;
    private static int orbSSLMutualAuthPort;
    private static POA m_rootPOA;
    private static POA m_recoveryPOA;
    private static POA coordinatorPOA;
    private static final String JEUS_INTEROP_ORB = "jeus.ejb.interop.csi.CSIEJBORB";
    private static final RecoveryManager rManager;

    public static void setORB(ORB orb) {
        for (int i = 0; i < orbReceivers.size(); ++i) {
            ORBReceiver orbReceiver = orbReceivers.get(i);
            orbReceiver.setORB(orb);
        }
        ORBUtil.initORB(orb);
    }

    public static void init(boolean enableInterop, KeystoreConfigType sslConfig) throws EJBServerException {
        if (sslConfig != null) {
            sslConfig.strip();
            if (sslConfig.getKeystorePath() != null) {
                JeusManagerProperties.INTEROP_SSL_KEYSTORE = sslConfig.getKeystorePath();
            }
            if (sslConfig.getKeystorePassword() != null) {
                JeusManagerProperties.INTEROP_SSL_KEYPASS = sslConfig.getKeystorePassword();
            }
            if (sslConfig.getTruststorePath() != null) {
                JeusManagerProperties.INTEROP_SSL_TRUSTSTORE = sslConfig.getTruststorePath();
            }
            if (sslConfig.getTruststorePassword() != null) {
                JeusManagerProperties.INTEROP_SSL_TRUSTPASS = sslConfig.getTruststorePassword();
            }
        }
        EJBORBManager.init(enableInterop);
    }

    private static void init(boolean enableInterop) throws EJBServerException {
        try {
            EJBORBManager.enableInterop = enableInterop;
            Properties orbProps = new Properties();
            if (enableInterop) {
                if (JeusPropertyValues.JEUS_CATEGORY != 0) {
                    int containerBasePort = JeusManagerPropertyValues.getContainerBasePort();
                    orbPort = containerBasePort + 1;
                    orbSSLPort = containerBasePort + 2;
                    orbSSLMutualAuthPort = containerBasePort + 3;
                }
                EJBORBManager.setORBSystemProperties();
                orbProps.put(OMG_ORB_CLASS_PROPERTY, JEUS_INTEROP_ORB);
                orbProps.put("org.omg.CORBA.ORBServerId", "1");
                orbProps.put("org.omg.PortableInterceptor.ORBInitializerClass.jeus.ejb.interop.EJBORBInitializer", "");
                orbProps.put(SUN_ORB_SERVER_PORT_PROPERTY, String.valueOf(orbPort));
                orbProps.put("com.sun.corba.ee.POA.ORBPersistentServerPort", String.valueOf(orbPort));
                orbProps.put(SUN_ORB_SOCKET_FACTORY_CLASS_PROPERTY, IIOP_SSL_SOCKET_FACTORY_CLASS);
                orbProps.put(ORB_LISTEN_SOCKET_PROPERTY, "SSL:" + orbSSLPort + "," + "SSL_MUTUALAUTH" + ":" + orbSSLMutualAuthPort);
                orbProps.put(SUN_ORB_IOR_TO_SOCKETINFO_CLASS_PROPERTY, "jeus.ejb.interop.csi.CSIIORToSocketInfo");
                orbProps.put("com.sun.corba.ee.giop.ORBFragmentSize", "4096");
                StringUtil.setPropertiesToMap((String)JeusEJBProperties.CORBA_PROP, (Map)orbProps);
                if (logger.isLoggable(JeusMessage_EJB11._7176_LEVEL)) {
                    logger.log(JeusMessage_EJB11._7176_LEVEL, JeusMessage_EJB11._7176, (Object)orbProps.toString());
                }
                orb = ORB.init((String[])new String[0], (Properties)orbProps);
                EJBORBManager.setORB(orb);
                defaultORB = orb;
                Configuration.setORB(orb);
                m_rootPOA = (POA)orb.resolve_initial_references("RootPOA");
                EJBORBManager.initOTS();
            } else {
                orbProps.put("com.sun.CORBA.ORBServerPort", "0");
                defaultORB = ORB.init((String[])new String[0], (Properties)orbProps);
                m_rootPOA = (POA)defaultORB.resolve_initial_references("RootPOA");
            }
            if (logger.isLoggable(JeusMessage_EJB8._5001_LEVEL)) {
                logger.logp(JeusMessage_EJB8._5001_LEVEL, "EJBORBManager", "init", JeusMessage_EJB8._5001, (Object)(enableInterop ? "(interoparable) " : ""));
            }
        }
        catch (Throwable t) {
            if (logger.isLoggable(JeusMessage_EJB8._5002_LEVEL)) {
                logger.logp(JeusMessage_EJB8._5002_LEVEL, "EJBORBManager", "init", JeusMessage_EJB8._5002, t);
            }
            throw new EJBServerException(JeusMessage_EJB8._5002, t);
        }
    }

    public static void setORBSystemProperties() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (System.getProperty(EJBORBManager.OMG_ORB_CLASS_PROPERTY) == null) {
                    System.setProperty(EJBORBManager.OMG_ORB_CLASS_PROPERTY, EJBORBManager.JEUS_INTEROP_ORB);
                }
                if (System.getProperty(EJBORBManager.OMG_ORB_SINGLETON_CLASS_PROPERTY) == null) {
                    System.setProperty(EJBORBManager.OMG_ORB_SINGLETON_CLASS_PROPERTY, EJBORBManager.ORB_SE_SINGLETON_CLASS);
                }
                System.setProperty(EJBORBManager.ORB_UTIL_CLASS_PROPERTY, EJBORBManager.RMI_UTIL_CLASS);
                System.setProperty(EJBORBManager.RMIIIOP_STUB_DELEGATE_CLASS_PROPERTY, EJBORBManager.RMI_STUB_CLASS);
                System.setProperty(EJBORBManager.RMIIIOP_PRO_DELEGATE_CLASS_PROPERTY, EJBORBManager.RMI_PRO_CLASS);
                return null;
            }
        });
    }

    public static ORB getDefaultORB() {
        return defaultORB;
    }

    public static ORB getORB() {
        if (orb == null) {
            throw new JeusRuntimeException("Interoperable ORB is not initialized. Please check server configuration.");
        }
        return orb;
    }

    public static int getORBPort() {
        return orbPort;
    }

    public static int getORBSSLPort() {
        return orbSSLPort;
    }

    public static int getORBSSLMutualAuthPort() {
        return orbSSLMutualAuthPort;
    }

    public static POA getRootPOA() {
        if (!enableInterop) {
            throw new JeusRuntimeException("Interoperable ORB is not initialized. Please check server configuration.");
        }
        return m_rootPOA;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ORB getORBForNaming(boolean isInServer) {
        if (isInServer) {
            if (enableInterop) {
                return orb;
            }
            return defaultORB;
        }
        if (clientORB == null) {
            Object object = sync;
            synchronized (object) {
                if (clientORB == null) {
                    EJBORBManager.createClientORB();
                }
            }
        }
        return clientORB;
    }

    private static void createClientORB() {
        try {
            EJBORBManager.init(JeusEJBProperties.CLIENT_INTEROP, null);
            clientORB = JeusEJBProperties.CLIENT_INTEROP ? orb : defaultORB;
        }
        catch (Throwable t) {
            if (logger.isLoggable(JeusMessage_EJB8._5003_LEVEL)) {
                logger.logp(JeusMessage_EJB8._5003_LEVEL, "EJBORBManager", "createClientORB", JeusMessage_EJB8._5003);
            }
            throw new RuntimeException(ErrorMsgManager.getLocalizedString((int)JeusMessage_EJB8._5003));
        }
    }

    public static boolean isEnableInterop() {
        return enableInterop;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void destroy() {
        if (enableInterop) {
            try {
                orb.destroy();
            }
            catch (Throwable t) {
            }
            finally {
                orb = null;
            }
        }
        if (!System.getProperty("java.version").startsWith("1.3")) {
            try {
                defaultORB.destroy();
            }
            catch (Throwable throwable) {
            }
            finally {
                defaultORB = null;
            }
        }
        orbReceivers.clear();
        clientORB = null;
    }

    public static void addORBReceiver(ORBReceiver interceptor) {
        orbReceivers.add(interceptor);
    }

    public static boolean isTrustedHost(String ipAddr) {
        return trustHosts.indexOf(ipAddr) != -1;
    }

    public static SecurityInteropType getEJBCSIDescriptor(String ejbName) {
        return (SecurityInteropType)ejbDescs.get(ejbName);
    }

    public static void addEJBCSIDescriptor(String ejbName, SecurityInteropType desc) {
        ejbDescs.put(ejbName, desc);
    }

    public static void removeEJBCSIDescriptor(String ejbName) {
        ejbDescs.remove(ejbName);
    }

    private static void initOTS() {
        try {
            coordinatorPOA = EJBORBManager.createCoordinatorPOA(m_rootPOA);
            m_recoveryPOA = EJBORBManager.createRecoveryPOA(m_rootPOA);
            m_rootPOA.the_POAManager().activate();
            coordinatorPOA.the_POAManager().activate();
            if (logger.isLoggable(JeusMessage_OTS0._1001_LEVEL)) {
                logger.log(JeusMessage_OTS0._1001_LEVEL, JeusMessage_OTS0._1001);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void startOTSRecovery() {
        rManager.startOtsRecovery();
    }

    private static POA createRecoveryPOA(POA rootPOA) throws InvalidPolicy, AdapterAlreadyExists, WrongPolicy {
        Policy[] policies = new Policy[]{rootPOA.create_lifespan_policy(LifespanPolicyValue.PERSISTENT), rootPOA.create_request_processing_policy(RequestProcessingPolicyValue.USE_SERVANT_MANAGER)};
        POA rcoordPOA = rootPOA.create_POA("OTSrecoveryPOA", rootPOA.the_POAManager(), policies);
        Configuration.setPOA("OTSrecoveryPOA", rcoordPOA);
        RecoveryCoordinatorServantActivator rcrsa = new RecoveryCoordinatorServantActivator(orb);
        rcoordPOA.set_servant_manager((ServantManager)rcrsa);
        return rcoordPOA;
    }

    private static POA createCoordinatorPOA(POA rootPOA) throws InvalidPolicy, AdapterAlreadyExists, WrongPolicy {
        Policy[] tpolicy = new Policy[]{rootPOA.create_lifespan_policy(LifespanPolicyValue.PERSISTENT), rootPOA.create_request_processing_policy(RequestProcessingPolicyValue.USE_SERVANT_MANAGER)};
        POA coordPOA = rootPOA.create_POA("OTSCoordinatorPOA", null, tpolicy);
        Configuration.setPOA("OTSCoordinatorPOA", coordPOA);
        CoordinatorResourceServantActivator crsa = new CoordinatorResourceServantActivator(orb);
        coordPOA.set_servant_manager((ServantManager)crsa);
        return coordPOA;
    }

    public static POA getCoordinatorPOA() {
        return coordinatorPOA;
    }

    public static POA getRecoveryPOA() {
        return m_recoveryPOA;
    }

    public static RecoveryManager getRecoveryManager() {
        return rManager;
    }

    static {
        trustHosts = new ArrayList();
        ejbDescs = new Hashtable();
        sync = new Object();
        rManager = new RecoveryManager();
        String temp = JeusEJBProperties.CSI_TRUSTHOSTS;
        if (temp != null) {
            int idx;
            while ((idx = temp.indexOf(59)) != -1) {
                trustHosts.add(temp.substring(0, idx));
                temp = temp.substring(idx + 1);
            }
            trustHosts.add(temp);
        }
    }
}

