/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.generator;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import javax.ejb.EJBException;
import jeus.deploy.archivist.FileArchive;
import jeus.ejb.MethodInterfaceType;
import jeus.ejb.baseimpl.BusinessObjectHandler;
import jeus.ejb.generator.CodeGenerationException;
import jeus.ejb.generator.EJBClassGenerator;
import jeus.ejb.generator.MethodInfo;
import jeus.ejb.generator.SessionImplHelper;
import jeus.ejb.metadata.SessionBeanInfo;
import jeus.util.codegen.ClassWriter;
import jeus.util.codegen.CodeUtil;

public class BusinessObjectImplGenerator
extends EJBClassGenerator {
    protected SessionBeanInfo beanInfo;
    protected SessionImplHelper sessionImplHelper;
    protected String[] interfaces;
    protected Class[] interfaceClasses;

    public BusinessObjectImplGenerator(FileArchive archive, ClassLoader loader, SessionBeanInfo beanInfo) throws CodeGenerationException {
        super(archive, loader, beanInfo);
        this.beanInfo = beanInfo;
        this.sessionImplHelper = new SessionImplHelper(archive, loader, beanInfo);
        try {
            this.packageName = CodeUtil.getPackageName(this.beanClassName);
            this.baseClassName = BusinessObjectHandler.class.getName();
            String moduleName = beanInfo.getModuleInfo().getModuleName();
            String prefix = CodeUtil.getSimpleClassName(this.beanClassName);
            String postfix = "BizImpl";
            this.implClassName = BusinessObjectImplGenerator.constructClassName(moduleName, this.packageName, prefix, postfix);
            this.fullImplClassName = CodeUtil.getFullClassName(this.packageName, this.implClassName);
            this.interfaces = this.getToBeImplementedInterfaces();
            this.interfaceClasses = new Class[this.interfaces.length];
            for (int i = 0; i < this.interfaces.length; ++i) {
                this.interfaceClasses[i] = loader.loadClass(this.interfaces[i]);
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new CodeGenerationException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate() throws CodeGenerationException, IOException {
        int modifiers = 17;
        ClassWriter classWriter = new ClassWriter(this.packageName, modifiers, this.implClassName, this.baseClassName, this.interfaces);
        classWriter.addHeadComment("// This is generated source. DO NOT MODIFY THIS.");
        classWriter.addDefaultConstructor();
        MethodInfo[] methods = this.collectMethods(this.interfaceClasses);
        int count = 0;
        for (MethodInfo method : methods) {
            MethodInterfaceType mIntfType = MethodInterfaceType.Remote;
            this.sessionImplHelper.writeBusinessMethod(classWriter, method, count, mIntfType, EJBException.class);
            ++count;
        }
        OutputStream output = null;
        try {
            output = this.makeFileOf(this.fullImplClassName);
            classWriter.writeCode(output);
            output.flush();
        }
        finally {
            if (output != null) {
                output.close();
            }
        }
    }

    protected String[] getToBeImplementedInterfaces() {
        Vector<String> interfaces = new Vector<String>();
        interfaces.add("java.rmi.Remote");
        return interfaces.toArray(new String[0]);
    }
}

