/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.generator;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import jeus.deploy.archivist.FileArchive;
import jeus.ejb.generator.ClassGenerator;
import jeus.ejb.generator.CodeGenerationException;
import jeus.ejb.generator.MethodInfo;
import jeus.ejb.metadata.BeanInfo;
import jeus.ejb.util.MethodConvertor;
import jeus.util.StringUtil;
import jeus.util.codegen.ClassWriter;
import jeus.util.codegen.CodeUtil;
import jeus.util.codegen.MethodWriter;

public abstract class EJBClassGenerator
extends ClassGenerator {
    protected BeanInfo beanInfo;
    protected String beanClassName;
    protected Class beanClass;
    protected String packageName;
    protected String baseClassName;
    protected String implClassName;
    protected String fullImplClassName;

    protected EJBClassGenerator(FileArchive archive, ClassLoader loader, BeanInfo beanInfo) {
        super(archive, loader);
        this.beanInfo = beanInfo;
        this.beanClassName = beanInfo.getBeanClassFullName();
        this.beanClass = beanInfo.getBeanClass();
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getBaseClassName() {
        return this.baseClassName;
    }

    public String getImplClassName() {
        return this.implClassName;
    }

    public String getFullImplClassName() {
        return this.fullImplClassName;
    }

    public static String constructClassName(String moduleName, String packageName, String prefix, String postfix) {
        String implClassName = MethodConvertor.removeSlash(prefix).replace('.', '_') + postfix;
        int hashCode = (packageName + "." + implClassName).hashCode();
        implClassName = MethodConvertor.removeSlash(prefix).replace('.', '_') + postfix;
        implClassName = implClassName + (hashCode & Integer.MAX_VALUE);
        implClassName = EJBClassGenerator.checkImplName(implClassName);
        return implClassName;
    }

    protected Method[] getUserDefinedMethods(Class baseInterface, Class userInterface) throws CodeGenerationException {
        Method[] baseMethods = baseInterface.getMethods();
        Method[] userMethods = userInterface.getMethods();
        ArrayList<Method> result = new ArrayList<Method>();
        block0: for (int i = 0; i < userMethods.length; ++i) {
            for (int j = 0; j < baseMethods.length; ++j) {
                if (userMethods[i].equals(baseMethods[j])) continue block0;
            }
            result.add(userMethods[i]);
        }
        return result.toArray(new Method[result.size()]);
    }

    protected MethodInfo[] collectMethods(Class[] interfaces) throws CodeGenerationException {
        Hashtable<String, MethodInfo> methods = new Hashtable<String, MethodInfo>();
        for (int i = 0; i < interfaces.length; ++i) {
            Method[] mm = interfaces[i].getMethods();
            for (int j = 0; j < mm.length; ++j) {
                MethodInfo found = new MethodInfo(mm[j]);
                String key = found.getMethodDeclaration();
                MethodInfo existing = (MethodInfo)methods.get(key);
                if (existing != null) {
                    if (!existing.getReturnType().equals(found.getReturnType())) {
                        throw new CodeGenerationException("return types of interfaces do not match : " + existing + ", " + found);
                    }
                    methods.put(key, existing.mergeWith(found));
                    continue;
                }
                methods.put(key, found);
            }
        }
        Collection methodInfos = methods.values();
        return methodInfos.toArray(new MethodInfo[methodInfos.size()]);
    }

    protected void checkToBeAddedMethod(Method m) throws CodeGenerationException {
    }

    protected void writeMethodField(ClassWriter classWriter, String fieldName, String className, MethodInfo m) {
        classWriter.addField("private static java.lang.reflect.Method " + fieldName + ";");
        MethodWriter mw = classWriter.addStatic();
        mw.wtry();
        String name = m.getName();
        Class[] paramTypes = m.getParameterTypes();
        String paramTypeList = "";
        for (int i = 0; i < paramTypes.length; ++i) {
            if (i > 0) {
                paramTypeList = paramTypeList + ", ";
            }
            paramTypeList = paramTypeList + CodeUtil.getClassName(paramTypes[i]) + ".class";
        }
        mw.wln(fieldName + " = " + className + ".class.getMethod(\"" + name + "\", new Class[]{" + paramTypeList + "});");
        mw.wcatch("java.lang.NoSuchMethodException ex");
        mw.wln("throw new java.lang.RuntimeException(ex);");
        mw.wtryend();
    }

    protected void writeResourceAccessor(ClassWriter classWriter, String[] fieldNames) {
        for (int i = 0; i < fieldNames.length; ++i) {
            MethodWriter mw = classWriter.addMethod("public javax.security.jacc.EJBMethodPermission get" + StringUtil.getUpperLeadString((String)fieldNames[i]) + "()");
            mw.wln("return " + fieldNames[i] + ";");
        }
    }

    protected void writeResourceInitialization(ClassWriter classWriter, String interfaceName, String interfaceType, String[] fieldNames, String[] methodNames, String[] methodParamTypes) {
        for (int i = 0; i < fieldNames.length; ++i) {
            classWriter.addField("transient private static javax.security.jacc.EJBMethodPermission " + fieldNames[i] + ";");
            MethodWriter mw = classWriter.addStatic();
            mw.wtry();
            String EJBName = this.beanInfo.getBeanName();
            String methodInterface = interfaceType;
            String method = interfaceName + ".class.getMethod(\"" + methodNames[i] + "\", new Class[]{" + methodParamTypes[i] + "} )";
            mw.wln(fieldNames[i] + " = new javax.security.jacc.EJBMethodPermission(" + "\"" + EJBName + "\", \"" + methodInterface + "\", " + method + ");");
            mw.wcatch("java.lang.NoSuchMethodException ex");
            mw.wln("throw new java.lang.RuntimeException(ex);");
            mw.wtryend();
        }
    }
}

