/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.generator;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.rmi.UnexpectedException;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import jeus.deploy.archivist.FileArchive;
import jeus.ejb.SessionType;
import jeus.ejb.bean.rmi.JEUSRMIStub;
import jeus.ejb.bean.rmi.RMIStub;
import jeus.ejb.compiler.JEUSRMICompilerConstant;
import jeus.ejb.compiler.JavaRMICompilerConstant;
import jeus.ejb.compiler.RMICompilerConstant;
import jeus.ejb.generator.ClassGenerator;
import jeus.ejb.generator.CodeGenerationException;
import jeus.ejb.generator.MethodInfo;
import jeus.ejb.util.MethodTable;
import jeus.ejb.util.MethodUtils;
import jeus.util.codegen.ClassWriter;
import jeus.util.codegen.CodeUtil;
import jeus.util.codegen.MethodWriter;

public class EJBRMIGenerator
extends ClassGenerator {
    protected ClassWriter stubWriter;
    protected ClassWriter skelWriter;
    protected String packageName;
    protected String[] interfaces;
    protected Class[] interfaceClasses;
    protected String implClassName;
    protected boolean clustering;
    private boolean isHome;
    private SessionType sessionType;
    private Class unexpectedExceptionType = UnexpectedException.class;
    private static final JEUSRMICompilerConstant jeusCompilerConstant = new JEUSRMICompilerConstant();
    private static final JavaRMICompilerConstant javaCompilerConstant = new JavaRMICompilerConstant();
    private RMICompilerConstant compilerConstant;
    private boolean useJeusRmi;
    private MethodTable idempotentMethods;

    public EJBRMIGenerator(FileArchive archive, ClassLoader loader, String implClassName, String[] interfaces, boolean isClustered, MethodTable idempotentMethods, boolean isHome, SessionType sessionType, boolean jeusRmi) throws CodeGenerationException {
        super(archive, loader);
        try {
            this.packageName = CodeUtil.getPackageName(implClassName);
            this.interfaces = interfaces;
            this.implClassName = implClassName;
            this.isHome = isHome;
            this.sessionType = sessionType;
            this.interfaceClasses = new Class[interfaces.length];
            for (int i = 0; i < interfaces.length; ++i) {
                this.interfaceClasses[i] = loader.loadClass(interfaces[i]);
            }
            this.clustering = isClustered;
            this.idempotentMethods = idempotentMethods;
            this.useJeusRmi = jeusRmi;
            this.compilerConstant = this.useJeusRmi ? jeusCompilerConstant : javaCompilerConstant;
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new CodeGenerationException(e.getException());
        }
    }

    public String getStubClassName() {
        return this.stubWriter.getFullClassName();
    }

    public String getSkelClassName() {
        if (this.skelWriter != null) {
            return this.skelWriter.getFullClassName();
        }
        return null;
    }

    public Class getUnexpectedExceptionType() {
        return this.unexpectedExceptionType;
    }

    protected String composeStubName(String simpleClassName) {
        return simpleClassName + "_Stub";
    }

    protected String composeSkeletonName(String simpleClassName) {
        return simpleClassName + "_Skel";
    }

    public void setUnexpectedExceptionType(Class exception) {
        this.unexpectedExceptionType = exception;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate() throws IOException, CodeGenerationException {
        String implName = CodeUtil.getSimpleClassName(this.implClassName);
        int modifiers = 17;
        String stubName = this.composeStubName(implName);
        String skelName = this.composeSkeletonName(implName);
        String stubBase = this.useJeusRmi ? JEUSRMIStub.class.getName() : RMIStub.class.getName();
        String[] stubInterfaces = this.interfaces;
        this.stubWriter = new ClassWriter(this.packageName, modifiers, stubName, stubBase, stubInterfaces);
        this.stubWriter.addHeadComment("// Stub class generated by rmi generator, do not edit.");
        this.stubWriter.addImport("java.rmi.RemoteException");
        if (!this.useJeusRmi) {
            this.skelWriter = new ClassWriter(this.packageName, modifiers, skelName, "jeus.ejb.bean.rmi.RMISkeleton", null);
            this.skelWriter.addHeadComment("// Skeleton class generated by rmi generator, do not edit.");
            this.skelWriter.addImport("java.rmi.RemoteException");
        }
        this.compilerConstant.addImport(this.stubWriter);
        MethodInfo[] methods = this.collectMethods(this.interfaceClasses);
        this.writeOperationsArray(methods);
        this.writeInterfaceHash(methods);
        this.compilerConstant.writeStubStaticInitializer(this.stubWriter, this.interfaceClasses, implName);
        this.writeConstructors();
        for (int index = 0; index < methods.length; ++index) {
            this.compilerConstant.writeMethodInitializer(this.stubWriter, methods[index].getOriginalMethod(), (Class[])methods[index].getOriginalMethod().getParameterTypes());
            this.writeStubMethod(methods[index], index, this.clustering && this.isIdempotentMethod(MethodUtils.getSignature(methods[index].getOriginalMethod())));
        }
        OutputStream stubOutput = null;
        try {
            stubOutput = this.makeFileOf(this.stubWriter.getFullClassName());
            this.stubWriter.writeCode(stubOutput);
            stubOutput.flush();
        }
        finally {
            try {
                if (stubOutput != null) {
                    stubOutput.close();
                }
            }
            catch (Exception ex) {}
        }
        if (!this.useJeusRmi) {
            this.writeSkeletonGetOperations();
            this.writeSkeletonDispatch(methods);
            OutputStream skelOutput = null;
            try {
                skelOutput = this.makeFileOf(this.skelWriter.getFullClassName());
                this.skelWriter.writeCode(skelOutput);
                skelOutput.flush();
            }
            finally {
                try {
                    if (skelOutput != null) {
                        skelOutput.close();
                    }
                }
                catch (Exception ex) {}
            }
        }
    }

    private boolean isIdempotentMethod(String methodSig) {
        Boolean bool = (Boolean)this.idempotentMethods.getValue(methodSig);
        if (bool == null) {
            return false;
        }
        return bool;
    }

    protected MethodInfo[] collectMethods(Class[] interfaces) throws CodeGenerationException {
        Hashtable<String, MethodInfo> methods = new Hashtable<String, MethodInfo>();
        for (int i = 0; i < interfaces.length; ++i) {
            Method[] mm = interfaces[i].getMethods();
            for (int j = 0; j < mm.length; ++j) {
                MethodInfo found = new MethodInfo(mm[j]);
                String key = found.getMethodDeclaration();
                MethodInfo existing = (MethodInfo)methods.get(key);
                if (existing != null) {
                    if (!existing.getReturnType().equals(found.getReturnType())) {
                        throw new CodeGenerationException("return types of interfaces do not match : " + existing + ", " + found);
                    }
                    methods.put(key, existing.mergeWith(found));
                    continue;
                }
                for (Class ex : found.getExceptionTypes()) {
                    if (Exception.class.isAssignableFrom(ex)) continue;
                    String error = "the method should throw java.lang.Exception or its subclass only";
                    throw new CodeGenerationException(error);
                }
                methods.put(key, found);
            }
        }
        Collection methodInfos = methods.values();
        return methodInfos.toArray(new MethodInfo[methodInfos.size()]);
    }

    protected void writeSkeletonGetOperations() {
        MethodWriter mw = this.skelWriter.addMethod("public java.rmi.server.Operation[] getOperations()");
        mw.wln("return (java.rmi.server.Operation[]) operations.clone();");
    }

    protected void writeSkeletonDispatch(MethodInfo[] methods) {
        MethodWriter mw = this.skelWriter.addMethod("public void dispatch(java.rmi.Remote obj, java.rmi.server.RemoteCall call, int opnum, long hash) throws java.lang.Exception");
        mw.wlnI("if (hash != interfaceHash)");
        mw.wlnO("throw new java.rmi.server.SkeletonMismatchException(\"interface hash mismatch\");");
        mw.wln();
        mw.wln(this.implClassName + " server = (" + this.implClassName + ") obj;");
        mw.wln("if (server instanceof jeus.ejb.bean.rmi.RMIInterceptorProvider) {");
        mw.wln("\tsetServerInterceptor((jeus.ejb.bean.rmi.RMIInterceptorProvider) server);");
        mw.wln("}");
        mw.wlnI("switch (opnum) {");
        for (int opnum = 0; opnum < methods.length; ++opnum) {
            this.writeSkeletonDispatchCase(mw, methods[opnum], opnum);
        }
        mw.wOlnI("default:");
        mw.wln("throw new java.rmi.UnmarshalException(\"invalid method number\");");
        mw.wOln("}");
    }

    protected void writeConstructors() {
        this.stubWriter.addDefaultConstructor();
        MethodWriter mw = this.stubWriter.addConstructor(1, this.compilerConstant.getRemoteRefQualifiedClassName() + " ref", null);
        mw.wln("super(ref);");
    }

    protected void writeOperationsArray(MethodInfo[] methods) {
        String f = "private static final java.rmi.server.Operation[] operations = {";
        for (int i = 0; i < methods.length; ++i) {
            if (i > 0) {
                f = f + ", ";
            }
            f = f + "new java.rmi.server.Operation(\"" + this.getOperationString(methods[i]) + "\")";
        }
        f = f + "};";
        this.stubWriter.addField(f);
        if (!this.useJeusRmi) {
            this.skelWriter.addField(f);
        }
    }

    protected String getOperationString(MethodInfo method) {
        return method.getSignature();
    }

    protected void writeInterfaceHash(MethodInfo[] methods) {
        String f = "private static final long interfaceHash = " + this.computeInterfaceHash(methods) + "L;";
        this.stubWriter.addField(f);
        if (!this.useJeusRmi) {
            this.skelWriter.addField(f);
        }
    }

    protected void writeStubMethod(MethodInfo method, int opnum, boolean idempotent) {
        Class returnType = method.getReturnType();
        String methodName = method.getName();
        Class[] paramTypes = method.getParameterTypes();
        String[] paramNames = CodeUtil.nameParameters(paramTypes);
        Class[] exceptions = method.getExceptionTypes();
        MethodWriter mw = this.stubWriter.addMethod(1, returnType, methodName, paramTypes, exceptions);
        Vector<Class> catchList = this.computeUniqueCatchList(exceptions);
        boolean isReturn = true;
        if (returnType == Void.TYPE) {
            isReturn = false;
        } else {
            this.compilerConstant.writeReturnVariable(mw, returnType);
        }
        if (catchList.size() > 0) {
            mw.wtry();
        }
        mw.wln("String currExportName = null;");
        mw.wln(this.compilerConstant.getRemoteObjectClassName() + " currStub = this;");
        mw.wln();
        mw.wln("while(true) {");
        mw.indentIn();
        mw.wln("if(clusterSupport != null) //clustered");
        mw.wlnI("{");
        mw.wlnI("synchronized(clusterSupport) {");
        mw.wln("currExportName = clusterSupport.getExportName();");
        mw.wln("currStub = (" + this.compilerConstant.getRemoteObjectClassName() + ") clusterSupport.getStub();");
        mw.wOln("}");
        mw.wOln("}");
        mw.wln();
        mw.wln(this.compilerConstant.getRemoteRefQualifiedClassName() + " ref = currStub.getRef();");
        mw.wtry();
        this.compilerConstant.writeCallOperation(mw, "currStub", opnum, method.getOriginalMethod(), paramNames, paramTypes);
        this.compilerConstant.writeAfterCallOperation(mw, "currStub", opnum, paramTypes, paramNames, returnType);
        if (isReturn) {
            if (this.isHome) {
                mw.wlnI("if(clusterSupport != null && (Object)result instanceof jeus.ejb.bean.objectbase.JEUSClusterStub) {");
                mw.wln("((jeus.ejb.bean.objectbase.JEUSClusterStub)(Object)result).__jeus_setCluster(clusterSupport.getExportName(), clusterSupport.getCluster());");
                mw.wOln("}");
            }
            this.compilerConstant.writeReturnOperation(mw, returnType);
        } else {
            mw.wln("return;");
        }
        mw.wcatch("java.rmi.RemoteException ex");
        mw.wlnI("if(clusterSupport != null) {");
        mw.wln("clusterSupport.handleException(ex, currExportName, " + idempotent + ");");
        mw.wOlnI("} else {");
        mw.wln("throw ex;");
        mw.wOln("}");
        mw.wtryend();
        mw.wOln("}");
        if (catchList.size() > 0) {
            Enumeration<Class> enumeration = catchList.elements();
            while (enumeration.hasMoreElements()) {
                Class ex = enumeration.nextElement();
                mw.wcatch(ex.getName() + " e");
                mw.wln("throw e;");
            }
            if (!catchList.contains(Exception.class)) {
                mw.wcatch("java.lang.Exception e");
                mw.wln("throw new " + this.unexpectedExceptionType.getName() + "(\"undeclared checked exception\", e);");
            }
            mw.wtryend();
        }
    }

    protected void writeSkeletonDispatchCase(MethodWriter mw, MethodInfo method, int opnum) {
        Class[] paramTypes = method.getParameterTypes();
        String[] paramNames = CodeUtil.nameParameters(paramTypes);
        Class returnType = method.getReturnType();
        Class[] exceptions = method.getExceptionTypes();
        mw.wlnI("case " + opnum + ": { // " + method.getSignature());
        for (int i = 0; i < paramTypes.length; ++i) {
            mw.wln(CodeUtil.getClassName(paramTypes[i]) + " " + paramNames[i] + ";");
        }
        mw.wtry();
        mw.wtry();
        mw.wln("callServerInterceptor(call);");
        mw.wln("java.io.ObjectInput in = call.getInputStream();");
        boolean objectsRead = EJBRMIGenerator.writeUnmarshalArguments(mw, "in", paramTypes, paramNames);
        mw.wcatch("java.rmi.RemoteException e");
        mw.wln("throw e;");
        mw.wcatch("java.io.IOException e");
        mw.wln("throw new java.rmi.UnmarshalException(\"error unmarshalling arguments\", e);");
        if (objectsRead) {
            mw.wcatch("java.lang.ClassNotFoundException e");
            mw.wln("throw new java.rmi.UnmarshalException(\"error unmarshalling arguments\", e);");
        }
        mw.wfinally();
        mw.wln("call.releaseInputStream();");
        mw.wtryend();
        boolean isReturn = false;
        if (returnType != Void.TYPE) {
            isReturn = true;
            mw.wln(CodeUtil.getClassName(returnType) + " $result;");
        }
        mw.wtry();
        if (isReturn) {
            mw.w("$result = ");
        }
        mw.w("server." + method.getName() + "(");
        for (int i = 0; i < paramNames.length; ++i) {
            if (i > 0) {
                mw.w(", ");
            }
            mw.w(paramNames[i]);
        }
        mw.wln(");");
        mw.wcatch("java.lang.Exception e");
        mw.wtry();
        mw.wln("exceptionOccurred(e);");
        mw.wcatch("Throwable ex");
        mw.wln("if (ex instanceof Exception)");
        mw.wIlnO("throw (Exception) ex;");
        mw.wln("else");
        mw.wIlnO("throw (Error) ex;");
        mw.wtryend();
        mw.wln();
        mw.wln("throw e;");
        mw.wtryend();
        mw.wtry();
        if (!isReturn) {
            mw.wln("callAfterServerInterceptor(call);");
        } else {
            mw.w("java.io.ObjectOutput out = ");
            mw.wln("callAfterServerInterceptor(call);");
            EJBRMIGenerator.writeMarshalArgument(mw, "out", returnType, "$result");
            mw.wln(";");
        }
        mw.wcatch("java.io.IOException e");
        mw.wln("throw new java.rmi.MarshalException(\"error marshalling return\", e);");
        mw.wtryend();
        mw.wfinally();
        mw.wln("handleFinally();");
        mw.wtryend();
        mw.wln("break;");
        mw.wOln("}");
        mw.wln();
    }

    private static void writeMarshalArgument(MethodWriter p, String streamName, Class clsType, String name) {
        if (clsType == Boolean.TYPE) {
            p.w(streamName + ".writeBoolean(" + name + ")");
        } else if (clsType == Byte.TYPE) {
            p.w(streamName + ".writeByte(" + name + ")");
        } else if (clsType == Character.TYPE) {
            p.w(streamName + ".writeChar(" + name + ")");
        } else if (clsType == Short.TYPE) {
            p.w(streamName + ".writeShort(" + name + ")");
        } else if (clsType == Integer.TYPE) {
            p.w(streamName + ".writeInt(" + name + ")");
        } else if (clsType == Long.TYPE) {
            p.w(streamName + ".writeLong(" + name + ")");
        } else if (clsType == Float.TYPE) {
            p.w(streamName + ".writeFloat(" + name + ")");
        } else if (clsType == Double.TYPE) {
            p.w(streamName + ".writeDouble(" + name + ")");
        } else {
            p.w(streamName + ".writeObject(" + name + ")");
        }
    }

    private static void writeMarshalArguments(MethodWriter p, String streamName, Class[] types, String[] names) {
        if (types.length != names.length) {
            throw new Error("paramter type and name arrays different sizes");
        }
        for (int i = 0; i < types.length; ++i) {
            EJBRMIGenerator.writeMarshalArgument(p, streamName, types[i], names[i]);
            p.wln(";");
        }
    }

    private static boolean writeUnmarshalArgument(MethodWriter p, String streamName, Class clsType, String name) {
        boolean readObject = false;
        if (name != null) {
            p.w(name + " = ");
        }
        if (clsType == Boolean.TYPE) {
            p.w(streamName + ".readBoolean()");
        } else if (clsType == Byte.TYPE) {
            p.w(streamName + ".readByte()");
        } else if (clsType == Character.TYPE) {
            p.w(streamName + ".readChar()");
        } else if (clsType == Short.TYPE) {
            p.w(streamName + ".readShort()");
        } else if (clsType == Integer.TYPE) {
            p.w(streamName + ".readInt()");
        } else if (clsType == Long.TYPE) {
            p.w(streamName + ".readLong()");
        } else if (clsType == Float.TYPE) {
            p.w(streamName + ".readFloat()");
        } else if (clsType == Double.TYPE) {
            p.w(streamName + ".readDouble()");
        } else {
            p.w("(" + CodeUtil.getClassName(clsType) + ") " + streamName + ".readObject()");
            readObject = true;
        }
        return readObject;
    }

    private static boolean writeUnmarshalArguments(MethodWriter p, String streamName, Class[] types, String[] names) {
        if (types.length != names.length) {
            throw new Error("paramter type and name arrays different sizes");
        }
        boolean readObject = false;
        for (int i = 0; i < types.length; ++i) {
            if (EJBRMIGenerator.writeUnmarshalArgument(p, streamName, types[i], names[i])) {
                readObject = true;
            }
            p.wln(";");
        }
        return readObject;
    }

    private long computeInterfaceHash(MethodInfo[] remoteMethods) {
        long hash = 0L;
        ByteArrayOutputStream sink = new ByteArrayOutputStream(512);
        try {
            MessageDigest md = MessageDigest.getInstance("SHA");
            DataOutputStream out = new DataOutputStream(new DigestOutputStream(sink, md));
            out.writeInt(1);
            for (int i = 0; i < remoteMethods.length; ++i) {
                out.writeUTF(this.getOperationString(remoteMethods[i]));
            }
            out.flush();
            byte[] hashArray = md.digest();
            for (int i = 0; i < Math.min(8, hashArray.length); ++i) {
                hash += (long)(hashArray[i] & 0xFF) << i * 8;
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
        return hash;
    }
}

