/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.interceptor;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import jeus.ejb.BeanState;
import jeus.ejb.EJBLoggers;
import jeus.ejb.baseimpl.EJBContextImpl;
import jeus.ejb.container3.BaseBeanContainer;
import jeus.ejb.interceptor.CallbackException;
import jeus.ejb.interceptor.CallbackInvocationContextImpl;
import jeus.ejb.interceptor.CallbackType;
import jeus.ejb.interceptor.Interceptor;
import jeus.ejb.interceptor.Invocation;
import jeus.ejb.interceptor.InvocationChain;
import jeus.ejb.interceptor.InvocationContextImpl;
import jeus.ejb.metadata.BeanInfo;
import jeus.ejb.metadata.InterceptorBindingInfo;
import jeus.ejb.metadata.InterceptorInfo;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_EJB12;

public class UserInterceptorManager
implements Interceptor {
    private static JeusLogger logger = EJBLoggers.logger;
    private BaseBeanContainer container;
    private BeanInfo beanInfo;
    private ConcurrentMap<CallbackType, InvocationChain> callbackChainMap = new ConcurrentHashMap<CallbackType, InvocationChain>();
    private ConcurrentMap<Method, InvocationChain> aroundInvokeChainMap = new ConcurrentHashMap<Method, InvocationChain>();
    protected InterceptorInfo[] interceptorInfos;
    protected Map<InterceptorInfo, Integer> interceptorIndexMap;
    protected List<InterceptorInfo> classLevelInterceptorList;
    protected InvocationChain commonAroundInvokeChain;

    public UserInterceptorManager(BaseBeanContainer container) {
        this.container = container;
        this.beanInfo = container.getBeanInfo();
        this.initInterceptors();
    }

    public String getName() {
        return "User Interceptor Handler";
    }

    public Object invoke(Invocation invocation) throws Exception {
        Object[] params;
        Method method;
        EJBContextImpl beanContext = invocation.getEJBContext();
        InvocationContextImpl invContext = this.getInvocationContext(beanContext, method = invocation.getMethod(), params = invocation.getParameters(), invocation);
        if (invContext != null) {
            return invContext.proceed();
        }
        return invocation.invokeNext();
    }

    public Object invoke(EJBContextImpl beanContext, Method method, Object[] params) throws Exception {
        InvocationContextImpl invContext = this.getInvocationContext(beanContext, method, params, null);
        if (invContext != null) {
            return invContext.proceed();
        }
        try {
            if (logger.isLoggable(JeusMessage_EJB12._9065_LEVEL)) {
                logger.log(JeusMessage_EJB12._9065_LEVEL, JeusMessage_EJB12._9065, (Object)method.toString());
            }
            return method.invoke(beanContext.getBean(), params);
        }
        catch (InvocationTargetException ex) {
            Throwable t = ex.getTargetException();
            if (t instanceof Exception) {
                throw (Exception)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            t.printStackTrace();
            throw new RuntimeException(t);
        }
    }

    public void invokeCallback(CallbackType type, EJBContextImpl ejbContext) throws CallbackException {
        InvocationChain chain = (InvocationChain)this.callbackChainMap.get((Object)type);
        if (chain == null) {
            chain = this.getCallbackInvocationChain(type);
            this.callbackChainMap.putIfAbsent(type, chain);
        }
        if (chain.size() == 0) {
            return;
        }
        BeanState old = ejbContext.getStatus();
        BeanState state = null;
        switch (type) {
            case POST_CONSTRUCT: {
                state = BeanState.POST_CONSTRUCT;
                break;
            }
            case PRE_DESTROY: {
                state = BeanState.PRE_DESTROY;
                break;
            }
            case POST_ACTIVATE: {
                state = BeanState.POST_ACTIVATE;
                break;
            }
            case PRE_PASSIVATE: {
                state = BeanState.PRE_PASSIVATE;
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        ejbContext.setStatus(state);
        try {
            CallbackInvocationContextImpl invocation = new CallbackInvocationContextImpl(ejbContext, chain);
            invocation.proceed();
        }
        catch (Throwable ex) {
            throw new CallbackException("Exception during callback", ex);
        }
        finally {
            ejbContext.setStatus(old);
        }
        if (logger.isLoggable(JeusMessage_EJB12._9066_LEVEL)) {
            logger.log(JeusMessage_EJB12._9066_LEVEL, JeusMessage_EJB12._9066, new Object[]{type.name(), ejbContext});
        }
    }

    private InvocationContextImpl getInvocationContext(EJBContextImpl beanContext, Method method, Object[] params, Invocation invocation) {
        InvocationChain chain = (InvocationChain)this.aroundInvokeChainMap.get(method);
        if (chain == null) {
            chain = this.getAroundInvokeChain(method);
            this.aroundInvokeChainMap.putIfAbsent(method, chain);
        }
        if (chain.size() == 0) {
            return null;
        }
        return new InvocationContextImpl(beanContext, method, params, chain, invocation);
    }

    private void initInterceptors() {
        boolean isFullOrder;
        LinkedHashMap<InterceptorInfo, InterceptorInfo> interceptors = new LinkedHashMap<InterceptorInfo, InterceptorInfo>();
        LinkedList<InterceptorInfo> classLevelList = new LinkedList<InterceptorInfo>();
        InterceptorBindingInfo defaultBinding = this.beanInfo.getModuleInfo().getDefaultInterceptorBinding();
        InterceptorBindingInfo classBinding = this.beanInfo.getClassInterceptorBinding();
        boolean excludeDefaultInterceptors = classBinding != null && classBinding.isExcludeDefaultInterceptors();
        boolean bl = isFullOrder = classBinding != null && classBinding.isFullOrder();
        if (!excludeDefaultInterceptors && !isFullOrder && defaultBinding != null) {
            for (InterceptorInfo itc : defaultBinding.getInterceptorList()) {
                interceptors.put(itc, itc);
                classLevelList.add(itc);
            }
        }
        if (classBinding != null) {
            for (InterceptorInfo itc : classBinding.getInterceptorList()) {
                interceptors.put(itc, itc);
                classLevelList.add(itc);
            }
        }
        Map<Method, InterceptorBindingInfo> methodBindings = this.beanInfo.getMethodInterceptorBindingMap();
        for (InterceptorBindingInfo binding : methodBindings.values()) {
            for (InterceptorInfo itc : binding.getInterceptorList()) {
                interceptors.put(itc, itc);
            }
        }
        if (interceptors.size() > 0) {
            this.interceptorInfos = new InterceptorInfo[interceptors.size()];
            this.interceptorIndexMap = new HashMap<InterceptorInfo, Integer>();
            int index = 0;
            Iterator i$ = interceptors.values().iterator();
            while (i$.hasNext()) {
                InterceptorInfo interceptorInfo;
                this.interceptorInfos[index] = interceptorInfo = (InterceptorInfo)i$.next();
                this.interceptorIndexMap.put(interceptorInfo, index++);
            }
            this.classLevelInterceptorList = classLevelList;
        }
    }

    private InvocationChain getAroundInvokeChain(Method method) {
        InvocationChain c;
        InterceptorBindingInfo methodBinding = this.beanInfo.getMethodInterceptorBinding(method);
        if (methodBinding == null) {
            if (this.commonAroundInvokeChain != null) {
                return this.commonAroundInvokeChain;
            }
            c = new InvocationChain(this);
            c.addAllAroundInvokes(this.classLevelInterceptorList);
        } else {
            c = new InvocationChain(this);
            if (methodBinding.isFullOrder()) {
                List<InterceptorInfo> list = methodBinding.getInterceptorList();
                c.addAllAroundInvokes(list);
            } else {
                boolean excludeDefaultInterceptors = methodBinding.isExcludeDefaultInterceptors();
                boolean excludeClassInterceptors = methodBinding.isExcludeClassInterceptors();
                InterceptorBindingInfo defaultBinding = this.beanInfo.getModuleInfo().getDefaultInterceptorBinding();
                InterceptorBindingInfo classBinding = this.beanInfo.getClassInterceptorBinding();
                if (classBinding != null && classBinding.isExcludeDefaultInterceptors()) {
                    excludeDefaultInterceptors = true;
                }
                if (!excludeDefaultInterceptors || !excludeClassInterceptors) {
                    if (excludeDefaultInterceptors) {
                        if (classBinding != null && classBinding.hasInterceptors()) {
                            List<InterceptorInfo> classOnes = classBinding.getInterceptorList();
                            if (classBinding.isFullOrder() && defaultBinding != null) {
                                List<InterceptorInfo> defaultOnes = defaultBinding.getInterceptorList();
                                LinkedList<InterceptorInfo> list = new LinkedList<InterceptorInfo>();
                                for (InterceptorInfo itc : classOnes) {
                                    if (defaultOnes.contains(itc)) continue;
                                    list.add(itc);
                                }
                                c.addAllAroundInvokes(list);
                            } else {
                                c.addAllAroundInvokes(classOnes);
                            }
                        }
                    } else if (excludeClassInterceptors) {
                        if (defaultBinding != null && defaultBinding.hasInterceptors()) {
                            List<InterceptorInfo> defaultOnes = defaultBinding.getInterceptorList();
                            if (classBinding != null && classBinding.isFullOrder()) {
                                LinkedList<InterceptorInfo> list = new LinkedList<InterceptorInfo>();
                                for (InterceptorInfo itc : classBinding.getInterceptorList()) {
                                    if (!defaultOnes.contains(itc)) continue;
                                    list.add(itc);
                                }
                                c.addAllAroundInvokes(list);
                            } else {
                                c.addAllAroundInvokes(defaultOnes);
                            }
                        }
                    } else {
                        c.addAllAroundInvokes(this.classLevelInterceptorList);
                    }
                }
                if (methodBinding.hasInterceptors()) {
                    c.addAllAroundInvokes(methodBinding.getInterceptorList());
                }
            }
        }
        c.addBeanAroundInvokes(this.beanInfo.getBeanClassInterceptorInfo());
        if (methodBinding == null) {
            this.commonAroundInvokeChain = c;
        }
        return c;
    }

    private InvocationChain getCallbackInvocationChain(CallbackType type) {
        InvocationChain c = new InvocationChain(this);
        c.addAllCallbacks(type, this.classLevelInterceptorList);
        c.addBeanCallbacks(type, this.beanInfo.getBeanClassInterceptorInfo());
        return c;
    }

    public Object[] createInterceptorInstances() throws IllegalAccessException, InstantiationException {
        if (this.interceptorInfos == null) {
            return null;
        }
        Object[] interceptors = new Object[this.interceptorInfos.length];
        for (int i = 0; i < interceptors.length; ++i) {
            Class cls = this.interceptorInfos[i].getInterceptorClass();
            interceptors[i] = cls.newInstance();
            if (!logger.isLoggable(JeusMessage_EJB12._9067_LEVEL)) continue;
            logger.log(JeusMessage_EJB12._9067_LEVEL, JeusMessage_EJB12._9067, interceptors[i]);
        }
        return interceptors;
    }

    public InterceptorInfo[] getInterceptorInfos() {
        return this.interceptorInfos;
    }
}

