/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.interop.csi;

import com.sun.corba.ee.pept.transport.Acceptor;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.transport.ORBSocketFactory;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.security.KeyStore;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_EJB11;
import jeus.util.properties.JeusManagerProperties;

public class CSISocketFactoryFor5
implements ORBSocketFactory,
Serializable {
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.ejb.interop.csi");
    private static SSLServerSocketFactory ssf;
    private static SSLSocketFactory sf;
    private static boolean sslInitialized;
    private ORB orb;

    private static synchronized void initSSL() {
        if (sslInitialized) {
            return;
        }
        try {
            String trustpass;
            String trustfile;
            String keypass;
            String keyfile = JeusManagerProperties.INTEROP_SSL_KEYSTORE;
            if (keyfile == null) {
                keyfile = JeusManagerProperties.SSL_KEYSTORE;
            }
            if ((keypass = JeusManagerProperties.INTEROP_SSL_KEYPASS) == null) {
                keypass = JeusManagerProperties.SSL_KEYPASS;
            }
            if ((trustfile = JeusManagerProperties.INTEROP_SSL_TRUSTSTORE) == null) {
                trustfile = JeusManagerProperties.SSL_TRUSTSTORE;
            }
            if ((trustpass = JeusManagerProperties.INTEROP_SSL_TRUSTPASS) == null) {
                trustpass = JeusManagerProperties.SSL_TRUSTPASS;
            }
            KeyStore ks = KeyStore.getInstance("JKS");
            char[] passphrase = keypass.toCharArray();
            FileInputStream fin = new FileInputStream(keyfile);
            ks.load(fin, passphrase);
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(ks, passphrase);
            fin.close();
            KeyStore ts = KeyStore.getInstance("JKS");
            passphrase = trustpass.toCharArray();
            fin = new FileInputStream(trustfile);
            ts.load(fin, passphrase);
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(ts);
            fin.close();
            SSLContext ctx = SSLContext.getInstance("TLS");
            ctx.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
            ssf = ctx.getServerSocketFactory();
            sf = ctx.getSocketFactory();
            if (logger.isLoggable(JeusMessage_EJB11._7093_LEVEL)) {
                logger.log(JeusMessage_EJB11._7093_LEVEL, JeusMessage_EJB11._7093);
            }
            sslInitialized = true;
        }
        catch (Throwable ex) {
            if (logger.isLoggable(JeusMessage_EJB11._7094_LEVEL)) {
                logger.log(JeusMessage_EJB11._7094_LEVEL, JeusMessage_EJB11._7094, ex);
            }
            throw new RuntimeException(ex.getMessage());
        }
    }

    public void setORB(ORB orb) {
        this.orb = orb;
    }

    public ServerSocket createServerSocket(String type, InetSocketAddress inetSocketAddress) throws IOException {
        ServerSocket serverSocket;
        SSLServerSocket ss;
        if (type.equals("SSL_MUTUALAUTH")) {
            CSISocketFactoryFor5.initSSL();
            ss = (SSLServerSocket)ssf.createServerSocket();
            ss.setNeedClientAuth(true);
            serverSocket = ss;
        } else if (type.equals("SSL")) {
            CSISocketFactoryFor5.initSSL();
            ss = (SSLServerSocket)ssf.createServerSocket();
            ss.setWantClientAuth(true);
            serverSocket = ss;
        } else if (this.orb != null && this.orb.getORBData().acceptorSocketType().equals("SocketChannel")) {
            ServerSocketChannel serverSocketChannel = ServerSocketChannel.open();
            serverSocket = serverSocketChannel.socket();
        } else {
            serverSocket = new ServerSocket();
        }
        try {
            serverSocket.bind(inetSocketAddress);
        }
        catch (IOException ex) {
            IOException e = new IOException("Exception in binding socket - " + inetSocketAddress);
            e.initCause(ex);
            throw e;
        }
        return serverSocket;
    }

    public Socket createSocket(String type, InetSocketAddress inetSocketAddress) throws IOException {
        Socket socket;
        if (type.equals("SSL_MUTUALAUTH") || type.equals("SSL")) {
            CSISocketFactoryFor5.initSSL();
            socket = sf.createSocket(inetSocketAddress.getHostName(), inetSocketAddress.getPort());
        } else if (this.orb != null && this.orb.getORBData().connectionSocketType().equals("SocketChannel")) {
            SocketChannel socketChannel = SocketChannel.open(inetSocketAddress);
            socket = socketChannel.socket();
        } else {
            socket = new Socket(inetSocketAddress.getHostName(), inetSocketAddress.getPort());
        }
        socket.setTcpNoDelay(true);
        return socket;
    }

    public void setAcceptedSocketOptions(Acceptor acceptor, ServerSocket serverSocket, Socket socket) throws SocketException {
        socket.setTcpNoDelay(true);
    }
}

