/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.io;

import java.io.IOException;
import java.lang.reflect.Proxy;
import jeus.ejb.BeanContainer;
import jeus.ejb.EJBEngine;
import jeus.ejb.baseimpl.BusinessObjectHandler;
import jeus.ejb.container3.SessionContainer;
import jeus.ejb.io.SerializableObjectFactory;

public class SerializableBusinessObjectHandler
implements SerializableObjectFactory {
    private String ejbId;
    private String sessionId;
    private String interfaceName;

    public SerializableBusinessObjectHandler(String ejbId, String sessionId, String interfaceName) {
        this.ejbId = ejbId;
        this.sessionId = sessionId;
        this.interfaceName = interfaceName;
    }

    public Object createObject() throws IOException {
        if (this.ejbId == null) {
            throw new IOException("ejbId is null");
        }
        BeanContainer container = EJBEngine.getContainer(this.ejbId);
        if (container == null) {
            throw new IOException("EJB " + this.ejbId + " does not exist");
        }
        BusinessObjectHandler handler = ((SessionContainer)container).getBusinessObjectHandler(this.sessionId);
        Class<?> interfaze = null;
        try {
            interfaze = Thread.currentThread().getContextClassLoader().loadClass(this.interfaceName);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        Proxy proxy = (Proxy)handler.getClientProxy(interfaze);
        return Proxy.getInvocationHandler(proxy);
    }
}

