/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.metadata;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import jeus.ejb.metadata.InterceptorInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterceptorBindingInfo {
    private List<InterceptorInfo> interceptorList = new LinkedList<InterceptorInfo>();
    private boolean isFullOrder;
    private boolean excludeDefaultInterceptors;
    private boolean excludeClassInterceptors;

    public boolean hasInterceptors() {
        return this.interceptorList.size() > 0;
    }

    public boolean isFullOrder() {
        return this.isFullOrder;
    }

    public void setFullOrder(boolean fullOrder) {
        this.isFullOrder = fullOrder;
    }

    public List<InterceptorInfo> getInterceptorList() {
        return Collections.unmodifiableList(this.interceptorList);
    }

    public void addInterceptor(InterceptorInfo interceptor) {
        this.interceptorList.add(interceptor);
        interceptor.setIsBound(true);
    }

    public boolean isExcludeDefaultInterceptors() {
        return this.excludeDefaultInterceptors;
    }

    public void setExcludeDefaultInterceptors(boolean excludeDefaultInterceptors) {
        this.excludeDefaultInterceptors = excludeDefaultInterceptors;
    }

    public boolean isExcludeClassInterceptors() {
        return this.excludeClassInterceptors;
    }

    public void setExcludeClassInterceptors(boolean excludeClassInterceptors) {
        this.excludeClassInterceptors = excludeClassInterceptors;
    }

    public void resetInterceptorList() {
        for (InterceptorInfo interceptor : this.interceptorList) {
            interceptor.setIsBound(false);
        }
        this.interceptorList.clear();
    }
}

