/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.metadata;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import jeus.ejb.EJBDeploymentException;
import jeus.ejb.EJBUtils;
import jeus.ejb.EnterpriseBeanType;
import jeus.ejb.SessionType;
import jeus.ejb.metadata.BeanInfo;
import jeus.ejb.metadata.InitMethodTable;
import jeus.xml.binding.jeusDD.JeusBeanType;

public class SessionBeanInfo
extends BeanInfo {
    protected SessionType sessionType;
    protected Set<Class> remoteBusinessInterfaces = new HashSet<Class>();
    protected Set<Class> localBusinessInterfaces = new HashSet<Class>();
    protected Set<String> additionalHomeStubInterfaces = new HashSet<String>();
    protected String remoteBusinessBaseJndiName;
    protected String localBusinessBaseJndiName;
    protected String serviceEndpoint;
    protected String serviceEndpointImpl;
    protected InitMethodTable initMethods = new InitMethodTable();
    protected Map<Method, Boolean> removeMethods = new HashMap<Method, Boolean>();

    SessionBeanInfo(String name, Class beanClass, SessionType sessionType) {
        super(name, beanClass, EnterpriseBeanType.SESSION);
        this.sessionType = sessionType;
    }

    public boolean isConManagedEntityBean() {
        return false;
    }

    public boolean isAutoKeyGenerator() {
        return false;
    }

    void setSessionType(SessionType type) {
        this.sessionType = type;
    }

    public SessionType getSessionType() {
        return this.sessionType;
    }

    public boolean isStateless() {
        return this.sessionType == SessionType.STATELESS;
    }

    public boolean isStateful() {
        return this.sessionType == SessionType.STATEFUL;
    }

    public boolean isStatefulClustered() {
        return this.isClustered() && this.isStateful();
    }

    public boolean hasRemoteView() {
        return this.hasRemoteEjbHome() || this.hasRemoteBusinessView();
    }

    public boolean hasLocalView() {
        return this.hasLocalEjbHome() || this.hasLocalBusinessView();
    }

    public boolean hasBusinessView() {
        return this.hasRemoteBusinessView() || this.hasLocalBusinessView();
    }

    public boolean hasRemoteBusinessView() {
        return this.remoteBusinessInterfaces.size() > 0;
    }

    public boolean hasLocalBusinessView() {
        return this.localBusinessInterfaces.size() > 0;
    }

    public boolean hasSingleRemoteBusinessView() {
        return !this.hasRemoteEjbHome() && this.remoteBusinessInterfaces.size() == 1;
    }

    public boolean hasSingleLocalBusinessView() {
        return !this.hasLocalEjbHome() && this.localBusinessInterfaces.size() == 1;
    }

    public Class[] getRemoteBusinessInterfaces() {
        return this.remoteBusinessInterfaces.toArray(new Class[this.remoteBusinessInterfaces.size()]);
    }

    public Class[] getLocalBusinessInterfaces() {
        return this.localBusinessInterfaces.toArray(new Class[this.localBusinessInterfaces.size()]);
    }

    public void addRemoteBusinessInterface(Class interfaze) {
        this.remoteBusinessInterfaces.add(interfaze);
    }

    public void addLocalBusinessInterface(Class interfaze) {
        this.localBusinessInterfaces.add(interfaze);
    }

    public boolean containsRemoteBusinessInterface(Class interfaze) {
        return this.remoteBusinessInterfaces.contains(interfaze);
    }

    public boolean containsLocalBusinessInterface(Class interfaze) {
        return this.localBusinessInterfaces.contains(interfaze);
    }

    public void removeRemoteBusinessInterface(Class interfaze) {
        this.remoteBusinessInterfaces.remove(interfaze);
    }

    public void removeLocalBusinessInterface(Class interfaze) {
        this.localBusinessInterfaces.remove(interfaze);
    }

    public String getRemoteBusinessBaseJndiName() {
        return this.remoteBusinessBaseJndiName;
    }

    public String getRemoteBusinessJndiName(String interfaze) {
        return EJBUtils.getActualEjbJndiName(this.remoteBusinessBaseJndiName, true, interfaze);
    }

    public void setRemoteBusinessBaseJndiName(String jndiName) {
        this.remoteBusinessBaseJndiName = jndiName;
    }

    public String getLocalBusinessBaseJndiName() {
        return this.localBusinessBaseJndiName;
    }

    public String getLocalBusinessJndiName(String interfaze) {
        return EJBUtils.getActualEjbJndiName(this.localBusinessBaseJndiName, true, interfaze);
    }

    public void setLocalBusinessBaseJndiName(String jndiName) {
        this.localBusinessBaseJndiName = jndiName;
    }

    public String getServiceEndpointClassName() {
        return this.serviceEndpoint;
    }

    public void setServiceEndpoint(String serviceEndpointClassName) {
        this.serviceEndpoint = serviceEndpointClassName;
    }

    public String getServiceEndpointImplClassName() {
        return this.serviceEndpointImpl;
    }

    public void setServiceEndpointImplClassName(String endpointImpl) {
        this.serviceEndpointImpl = endpointImpl;
    }

    public void addInitMethod(String createMethodName, Method initMethod) {
        this.initMethods.add(createMethodName, initMethod);
    }

    public Method getInitMethod(String createMethodName, Class[] paramTypes) {
        return this.initMethods.get(createMethodName, paramTypes);
    }

    public void clearRemoveMethods() {
        this.removeMethods.clear();
    }

    public void addRemoveMethod(Method method, boolean retainIfException) {
        this.removeMethods.put(method, retainIfException);
    }

    public boolean isRemoveMethod(Method method) {
        return this.removeMethods.get(method) != null;
    }

    public boolean retainIfException(Method removeMethod) {
        Boolean retain = this.removeMethods.get(removeMethod);
        if (retain != null) {
            return retain;
        }
        return false;
    }

    public boolean isPoolingBeans() {
        return this.jeusBean.isPoolingBean();
    }

    public void setJeusBean(JeusBeanType jeusBean) throws EJBDeploymentException {
        super.setJeusBean(jeusBean);
        if (this.isStateful()) {
            this.additionalHomeStubInterfaces.add("jeus.ejb.bean.objectbase.SessionCluster");
        }
    }

    public String getJndiName(String interfaze, Boolean isRemote) {
        String jndiName = super.getJndiName(interfaze, isRemote);
        if (jndiName != null) {
            return jndiName;
        }
        if (this.hasRemoteBusinessView()) {
            if (interfaze != null && this.containsRemoteBusiness(interfaze)) {
                return this.getRemoteBusinessJndiName(interfaze);
            }
            if (interfaze == null && isRemote.booleanValue()) {
                return this.getRemoteBusinessBaseJndiName();
            }
        }
        if (this.hasLocalBusinessView()) {
            if (interfaze != null && this.containsLocalBusiness(interfaze)) {
                return this.getLocalBusinessJndiName(interfaze);
            }
            if (interfaze == null && !isRemote.booleanValue()) {
                return this.getLocalBusinessBaseJndiName();
            }
        }
        return null;
    }

    boolean containsRemoteBusiness(String businessInterface) {
        for (Class interfaze : this.remoteBusinessInterfaces) {
            if (!interfaze.getName().equals(businessInterface)) continue;
            return true;
        }
        return false;
    }

    boolean containsLocalBusiness(String businessInterface) {
        for (Class interfaze : this.localBusinessInterfaces) {
            if (!interfaze.getName().equals(businessInterface)) continue;
            return true;
        }
        return false;
    }

    public String[] getHomeImplStubInterfaces() {
        String[] interfaces = new String[this.additionalHomeStubInterfaces.size() + 1];
        int i = 0;
        for (String interfaceName : this.additionalHomeStubInterfaces) {
            interfaces[i++] = interfaceName;
        }
        interfaces[this.additionalHomeStubInterfaces.size()] = this.home;
        return interfaces;
    }
}

