/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.metadata.annotation;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ejb.MessageDriven;
import javax.ejb.PostActivate;
import javax.ejb.PrePassivate;
import javax.ejb.Stateful;
import javax.ejb.Stateless;
import javax.ejb.Timeout;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.ejb.TransactionManagement;
import javax.ejb.TransactionManagementType;
import javax.interceptor.AroundInvoke;
import javax.interceptor.ExcludeClassInterceptors;
import javax.interceptor.ExcludeDefaultInterceptors;
import javax.interceptor.Interceptors;
import jeus.container.annotation.AnnotationProcessor;
import jeus.container.annotation.ClassAnnotationReader;
import jeus.container.namingenv.EnvironmentAnnotationProcessor;
import jeus.container.security.SecurityAnnotationProcessor;
import jeus.deploy.InvalidAnnotationException;
import jeus.deploy.InvalidDescriptorException;
import jeus.ejb.Clustered;
import jeus.ejb.interceptor.CallbackType;
import jeus.ejb.metadata.BeanInfo;
import jeus.ejb.metadata.EJBMetadataProcessor;
import jeus.ejb.metadata.InterceptorBindingInfo;
import jeus.ejb.metadata.InterceptorInfo;
import jeus.ejb.metadata.ModuleInfo;
import jeus.ejb.metadata.SessionBeanInfo;
import jeus.ejb.metadata.annotation.EJBClusteringAnnotationProcessor;
import jeus.ejb.metadata.annotation.MDBAnnotationProcessor;
import jeus.ejb.metadata.annotation.SessionAnnotationProcessor;
import jeus.util.StringUtil;
import jeus.xml.binding.jeusDD.ClusteringType;
import jeus.xml.binding.jeusDD.JeusBeanType;

public abstract class EJBAnnotationProcessor
extends EJBMetadataProcessor
implements AnnotationProcessor {
    protected ModuleInfo moduleInfo;
    protected BeanInfo beanInfo;
    protected EnvironmentAnnotationProcessor envProcessor;
    protected SecurityAnnotationProcessor securityProcessor;
    protected EJBClusteringAnnotationProcessor clusteringProcessor;

    protected EJBAnnotationProcessor(ModuleInfo moduleInfo, BeanInfo beanInfo) {
        this.moduleInfo = moduleInfo;
        this.beanInfo = beanInfo;
        this.envProcessor = new EnvironmentAnnotationProcessor();
        this.securityProcessor = new SecurityAnnotationProcessor();
        this.clusteringProcessor = new EJBClusteringAnnotationProcessor(this.isStatefulSessionBean());
    }

    public BeanInfo getBeanInfo() {
        return this.beanInfo;
    }

    public static boolean isSessionBean(Class cls) {
        if (cls.isAnnotationPresent(Stateless.class)) {
            return true;
        }
        return cls.isAnnotationPresent(Stateful.class);
    }

    public static boolean isMessageDrivenBean(Class cls) {
        return cls.isAnnotationPresent(MessageDriven.class);
    }

    public void process(Class cls) throws InvalidAnnotationException {
        ClusteringType cluster;
        boolean clusterAnnotationEnabled = true;
        ClassAnnotationReader reader = new ClassAnnotationReader(cls);
        reader.addAnnotationProcessor(this);
        reader.addAnnotationProcessor(this.envProcessor);
        reader.addAnnotationProcessor(this.securityProcessor);
        JeusBeanType jeusBean = this.beanInfo.getJeusBeanType();
        if (!cls.isAnnotationPresent(Clustered.class)) {
            clusterAnnotationEnabled = false;
        }
        if (jeusBean != null && (cluster = jeusBean.getClustering()) != null && cluster.isSetEnableClustering()) {
            clusterAnnotationEnabled = cluster.isEnableClustering() != false;
        }
        if (clusterAnnotationEnabled) {
            reader.addAnnotationProcessor(this.clusteringProcessor);
        }
        reader.process();
        this.beanInfo.setBeanNamingEnvironment(this.envProcessor.getNamingEnvironment());
        this.beanInfo.setSecurityAnnotationInfo(this.securityProcessor.getSecurityInfo());
        if (clusterAnnotationEnabled) {
            this.beanInfo.setClustered(true);
            this.beanInfo.setHomeIdempotentMethods(this.clusteringProcessor.getHomeIdempotentMethods());
            this.beanInfo.setRemoteIdempotentMethods(this.clusteringProcessor.getRemoteIdempotentMethods());
            this.beanInfo.setReplicationModeOfMethods(this.clusteringProcessor.getReplicationModeOfMethods());
            this.beanInfo.setReplicationModeOfBean(this.clusteringProcessor.getReplicationModeOfClass());
        }
    }

    public abstract void processClass(Class var1) throws InvalidAnnotationException, InvalidDescriptorException;

    public void processField(Field f) throws InvalidAnnotationException {
    }

    public void processConstructor(Constructor constructor) throws InvalidAnnotationException {
    }

    public void processMethod(Method m) throws InvalidAnnotationException {
        InterceptorBindingInfo bindingInfo;
        int modifiers = m.getModifiers();
        InterceptorInfo beanClsInterceptorInfo = this.beanInfo.getBeanClassInterceptorInfo();
        if (m.isAnnotationPresent(AroundInvoke.class)) {
            beanClsInterceptorInfo.addAroundInvokeMethod(m);
        }
        if (m.isAnnotationPresent(PostConstruct.class)) {
            beanClsInterceptorInfo.addCallbackMethod(CallbackType.POST_CONSTRUCT, m);
        }
        if (m.isAnnotationPresent(PreDestroy.class)) {
            beanClsInterceptorInfo.addCallbackMethod(CallbackType.PRE_DESTROY, m);
        }
        if (m.isAnnotationPresent(PrePassivate.class)) {
            beanClsInterceptorInfo.addCallbackMethod(CallbackType.PRE_PASSIVATE, m);
        }
        if (m.isAnnotationPresent(PostActivate.class)) {
            beanClsInterceptorInfo.addCallbackMethod(CallbackType.POST_ACTIVATE, m);
        }
        if (Modifier.isPublic(modifiers) && (m.isAnnotationPresent(Interceptors.class) || m.isAnnotationPresent(ExcludeDefaultInterceptors.class) || m.isAnnotationPresent(ExcludeClassInterceptors.class)) && (bindingInfo = this.composeInterceptorBindingInfo(m, this.beanInfo)) != null) {
            this.beanInfo.setMethodInterceptorBinding(m, bindingInfo);
        }
        if (m.isAnnotationPresent(Timeout.class)) {
            if (!this.isValidTimeoutMethod(m)) {
                throw new InvalidAnnotationException("Invalid Timeout method");
            }
            if (this.beanInfo.getTimeoutMethod() != null) {
                throw new InvalidAnnotationException("Duplicate @Timeout method");
            }
            this.beanInfo.setTimeoutMethod(m);
        }
        String methodName = StringUtil.getMethodNameFromFullMethodName((String)m.getName());
        if (m.isAnnotationPresent(TransactionAttribute.class)) {
            TransactionAttributeType txAttr = m.getAnnotation(TransactionAttribute.class).value();
            this.beanInfo.getTxAttrTable().set(methodName, m.getParameterTypes(), null, txAttr);
        } else {
            Class<?> declClass = m.getDeclaringClass();
            if (declClass != null && declClass.isAnnotationPresent(TransactionAttribute.class)) {
                TransactionAttributeType txAttr = declClass.getAnnotation(TransactionAttribute.class).value();
                this.beanInfo.getTxAttrTable().set(methodName, m.getParameterTypes(), null, txAttr);
            }
        }
    }

    public void processFinished() {
    }

    public static String determineBeanName(String nameInAnnotation, Class beanClass) {
        String beanName = nameInAnnotation;
        if (beanName == null || beanName.equals("")) {
            beanName = beanClass.getSimpleName();
        }
        return beanName;
    }

    protected static String getDefaultName(Class cls, Field f) {
        return cls.getName() + "/" + f.getName();
    }

    protected void processInterceptors(Class cls, BeanInfo beanInfo) throws InvalidAnnotationException {
        InterceptorBindingInfo bindingInfo = this.composeInterceptorBindingInfo(cls, beanInfo);
        beanInfo.setClassInterceptorBinding(bindingInfo);
    }

    protected InterceptorBindingInfo composeInterceptorBindingInfo(AnnotatedElement element, BeanInfo beanInfo) throws InvalidAnnotationException {
        Class[] interceptorClasses;
        Interceptors interceptors = element.getAnnotation(Interceptors.class);
        boolean excludeDefaultInterceptors = element.isAnnotationPresent(ExcludeDefaultInterceptors.class);
        boolean excludeClassInterceptors = element.isAnnotationPresent(ExcludeClassInterceptors.class);
        InterceptorBindingInfo bindingInfo = new InterceptorBindingInfo();
        if (interceptors != null && (interceptorClasses = interceptors.value()).length > 0) {
            for (Class cls : interceptorClasses) {
                InterceptorInfo info = beanInfo.getModuleInfo().getInterceptorInfo(cls);
                if (info == null) {
                    info = this.composeInterceptorInfo(cls, false);
                    beanInfo.getModuleInfo().putInterceptorInfo(cls, info);
                }
                bindingInfo.addInterceptor(info);
            }
        }
        bindingInfo.setExcludeDefaultInterceptors(excludeDefaultInterceptors);
        bindingInfo.setExcludeClassInterceptors(excludeClassInterceptors);
        return bindingInfo;
    }

    protected void processTransactionManagement(Class cls, BeanInfo beanInfo) {
        boolean beanManagedTx = false;
        if (cls.isAnnotationPresent(TransactionManagement.class)) {
            TransactionManagement tx = cls.getAnnotation(TransactionManagement.class);
            beanManagedTx = tx.value() == TransactionManagementType.BEAN;
            beanInfo.setBeanManagedTx(beanManagedTx);
        }
    }

    public static EJBAnnotationProcessor getProcessor(ModuleInfo moduleInfo, BeanInfo beanInfo) {
        switch (beanInfo.getEJBType()) {
            case SESSION: {
                return new SessionAnnotationProcessor(moduleInfo, beanInfo);
            }
            case MESSAGE_DRIVEN: {
                return new MDBAnnotationProcessor(moduleInfo, beanInfo);
            }
            case ENTITY: {
                return null;
            }
        }
        return null;
    }

    protected boolean isStatefulSessionBean() {
        if (this.beanInfo instanceof SessionBeanInfo) {
            SessionBeanInfo sessionBeanInfo = (SessionBeanInfo)this.beanInfo;
            return sessionBeanInfo.isStateful();
        }
        return false;
    }
}

