/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.metadata.annotation;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import jeus.container.annotation.AnnotationProcessor;
import jeus.deploy.InvalidAnnotationException;
import jeus.ejb.CreateIdempotent;
import jeus.ejb.Idempotent;
import jeus.ejb.Replication;
import jeus.ejb.ReplicationMode;
import jeus.ejb.util.MethodTable;
import jeus.util.StringUtil;

public class EJBClusteringAnnotationProcessor
implements AnnotationProcessor {
    protected MethodTable remoteIdempotentMethods = new MethodTable();
    protected MethodTable homeIdempotentMethods = new MethodTable();
    private boolean isStateful;
    protected MethodTable replicationModeOfMethods;
    protected ReplicationMode replicationModeOfClass;

    public EJBClusteringAnnotationProcessor(boolean isStateful) {
        this.isStateful = isStateful;
        this.replicationModeOfMethods = new MethodTable();
        this.replicationModeOfClass = ReplicationMode.SYNC;
    }

    public void processClass(Class cls) throws InvalidAnnotationException {
        if (cls.isAnnotationPresent(CreateIdempotent.class)) {
            Boolean bool = cls.getAnnotation(CreateIdempotent.class).value();
            if (bool.booleanValue()) {
                this.homeIdempotentMethods.add("create", null, Boolean.TRUE);
            }
        } else if (!this.isStateful) {
            this.homeIdempotentMethods.add("create", null, Boolean.TRUE);
        }
        if (cls.isAnnotationPresent(Replication.class)) {
            this.replicationModeOfClass = cls.getAnnotation(Replication.class).value();
        }
        this.replicationModeOfMethods.add(null, null, this.replicationModeOfClass);
    }

    public void processMethod(Method method) throws InvalidAnnotationException {
        Class<?> declClass;
        String methodName = StringUtil.getMethodNameFromFullMethodName((String)method.getName());
        boolean idempotent = false;
        if (method.isAnnotationPresent(Idempotent.class)) {
            idempotent = method.getAnnotation(Idempotent.class).value();
            if (idempotent) {
                this.remoteIdempotentMethods.add(methodName, method.getParameterTypes(), Boolean.TRUE);
            }
        } else {
            declClass = method.getDeclaringClass();
            if (declClass.isAnnotationPresent(Idempotent.class) && (idempotent = declClass.getAnnotation(Idempotent.class).value())) {
                this.remoteIdempotentMethods.add(methodName, method.getParameterTypes(), Boolean.TRUE);
            }
        }
        if (method.isAnnotationPresent(Replication.class)) {
            this.replicationModeOfMethods.add(methodName, method.getParameterTypes(), method.getAnnotation(Replication.class).value());
        } else if (idempotent) {
            this.replicationModeOfMethods.add(methodName, method.getParameterTypes(), ReplicationMode.NONE);
        } else {
            declClass = method.getDeclaringClass();
            if (declClass != null && declClass.isAnnotationPresent(Replication.class)) {
                this.replicationModeOfMethods.add(methodName, method.getParameterTypes(), declClass.getAnnotation(Replication.class).value());
            } else {
                this.replicationModeOfMethods.add(methodName, method.getParameterTypes(), this.replicationModeOfClass);
            }
        }
    }

    public void processField(Field field) throws InvalidAnnotationException {
    }

    public void processConstructor(Constructor constructor) throws InvalidAnnotationException {
    }

    public void processFinished() {
    }

    public MethodTable getRemoteIdempotentMethods() {
        return this.remoteIdempotentMethods;
    }

    public MethodTable getHomeIdempotentMethods() {
        return this.homeIdempotentMethods;
    }

    public MethodTable getReplicationModeOfMethods() {
        return this.replicationModeOfMethods;
    }

    public void setReplicationModeOfMethods(MethodTable replicationModeOfMethods) {
        this.replicationModeOfMethods = replicationModeOfMethods;
    }

    public ReplicationMode getReplicationModeOfClass() {
        return this.replicationModeOfClass;
    }
}

