/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.metadata.annotation;

import java.io.Externalizable;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.ejb.Init;
import javax.ejb.Local;
import javax.ejb.LocalHome;
import javax.ejb.Remote;
import javax.ejb.RemoteHome;
import javax.ejb.Remove;
import javax.ejb.Stateful;
import javax.ejb.Stateless;
import jeus.deploy.InvalidAnnotationException;
import jeus.deploy.InvalidDescriptorException;
import jeus.ejb.metadata.BeanInfo;
import jeus.ejb.metadata.ModuleInfo;
import jeus.ejb.metadata.SessionBeanInfo;
import jeus.ejb.metadata.annotation.EJBAnnotationProcessor;
import jeus.util.StringUtil;

public class SessionAnnotationProcessor
extends EJBAnnotationProcessor {
    public SessionAnnotationProcessor(ModuleInfo moduleInfo, BeanInfo beanInfo) {
        super(moduleInfo, beanInfo);
    }

    public void processClass(Class cls) throws InvalidAnnotationException, InvalidDescriptorException {
        SessionBeanInfo sessionBeanInfo;
        Class compInterface;
        Stateless ann;
        assert (this.beanInfo != null);
        String mappedName = null;
        Stateless annotation = cls.getAnnotation(Stateless.class);
        if (annotation != null) {
            ann = annotation;
            mappedName = ann.mappedName();
        } else {
            annotation = cls.getAnnotation(Stateful.class);
            if (annotation != null) {
                ann = (Stateful)annotation;
                mappedName = ann.mappedName();
            }
        }
        if (!StringUtil.isNullOrEmpty((String)mappedName)) {
            this.beanInfo.setMappedJndiName(mappedName.trim());
        }
        if (cls.isAnnotationPresent(RemoteHome.class)) {
            Class remoteHome = cls.getAnnotation(RemoteHome.class).value();
            this.beanInfo.setEJBHomeClassName(remoteHome.getName());
            compInterface = this.findComponentInterface(remoteHome);
            if (compInterface != null) {
                this.beanInfo.setEJBObjectClassName(compInterface.getName());
            }
        }
        if (cls.isAnnotationPresent(LocalHome.class)) {
            Class localHome = cls.getAnnotation(LocalHome.class).value();
            this.beanInfo.setEJBLocalHomeClassName(localHome.getName());
            compInterface = this.findComponentInterface(localHome);
            if (compInterface != null) {
                this.beanInfo.setEJBLocalObjectClassName(compInterface.getName());
            }
        }
        if ((sessionBeanInfo = (SessionBeanInfo)this.beanInfo).getSessionType() == null) {
            throw new InvalidAnnotationException("No session type is defined in descriptor or annotation");
        }
        this.processBusinessInterfaces(cls, sessionBeanInfo);
        this.processInterceptors(cls, sessionBeanInfo);
        this.processTransactionManagement(cls, sessionBeanInfo);
    }

    public void processMethod(Method m) throws InvalidAnnotationException {
        super.processMethod(m);
        SessionBeanInfo sessionBeanInfo = (SessionBeanInfo)this.beanInfo;
        if (this.isStatefulSessionBean()) {
            if (m.isAnnotationPresent(Init.class)) {
                String createMethodName = m.getAnnotation(Init.class).value().trim();
                if (createMethodName.equals("")) {
                    createMethodName = null;
                } else if (!createMethodName.startsWith("create")) {
                    throw new InvalidAnnotationException(m + ": @Init.value should start with 'create'");
                }
                sessionBeanInfo.addInitMethod(createMethodName, m);
            }
            if (m.isAnnotationPresent(Remove.class)) {
                boolean retainIfException = m.getAnnotation(Remove.class).retainIfException();
                sessionBeanInfo.addRemoveMethod(m, retainIfException);
            }
        }
    }

    private Class findComponentInterface(Class homeInterface) {
        for (Method method : homeInterface.getMethods()) {
            if (!method.getName().startsWith("create")) continue;
            return method.getReturnType();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private void processBusinessInterfaces(Class cls, SessionBeanInfo beanInfo) throws InvalidDescriptorException {
        int len$;
        Class[] arr$;
        Remote remote = cls.getAnnotation(Remote.class);
        Local local = cls.getAnnotation(Local.class);
        boolean emptyRemote = false;
        boolean emptyLocal = false;
        if (remote != null) {
            void var10_12;
            Class[] remotes;
            arr$ = remotes = remote.value();
            len$ = arr$.length;
            boolean bl = false;
            while (var10_12 < len$) {
                Class remoteIntf = arr$[var10_12];
                beanInfo.addRemoteBusinessInterface(remoteIntf);
                ++var10_12;
            }
            if (remotes.length < 1) {
                emptyRemote = true;
            }
        }
        if (local != null) {
            void var10_14;
            Class[] locals = local.value();
            arr$ = locals;
            len$ = arr$.length;
            boolean bl = false;
            while (var10_14 < len$) {
                Class localIntf = arr$[var10_14];
                beanInfo.addLocalBusinessInterface(localIntf);
                ++var10_14;
            }
            if (locals.length < 1) {
                emptyLocal = true;
            }
        }
        if (emptyRemote && emptyLocal) {
            throw new InvalidDescriptorException("A bean class or a business interface can not have empty @Remote and empty @Local together ", beanInfo.getModuleName(), beanInfo.getBeanName());
        }
        Class<?>[] interfaces = cls.getInterfaces();
        ArrayList list = new ArrayList();
        for (Class<?> anInterface : interfaces) {
            if (anInterface == Serializable.class || anInterface == Externalizable.class || anInterface.getName().startsWith("javax.ejb.")) continue;
            list.add(anInterface);
        }
        if (list.size() == 1) {
            Class<?> iface = interfaces[0];
            if (!beanInfo.containsRemoteBusinessInterface(iface) && !beanInfo.containsLocalBusinessInterface(iface)) {
                if (iface.isAnnotationPresent(Remote.class)) {
                    beanInfo.addRemoteBusinessInterface(iface);
                } else if (iface.isAnnotationPresent(Local.class)) {
                    beanInfo.addLocalBusinessInterface(iface);
                } else if (emptyRemote) {
                    beanInfo.addRemoteBusinessInterface(iface);
                } else {
                    beanInfo.addLocalBusinessInterface(iface);
                }
            }
        } else {
            for (Class clazz : list) {
                if (clazz.isAnnotationPresent(Remote.class)) {
                    beanInfo.addRemoteBusinessInterface(clazz);
                    continue;
                }
                if (!clazz.isAnnotationPresent(Local.class)) continue;
                beanInfo.addLocalBusinessInterface(clazz);
            }
        }
    }
}

