/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.metadata.descriptor;

import java.lang.reflect.Method;
import java.util.List;
import jeus.container.namingenv.EnvironmentDescriptorProcessor;
import jeus.container.namingenv.JndiEnvironmentRefsGroup;
import jeus.container.namingenv.NamingEnvironment;
import jeus.deploy.InvalidDescriptorException;
import jeus.ejb.interceptor.CallbackType;
import jeus.ejb.metadata.InterceptorInfo;
import jeus.ejb.metadata.ModuleInfo;
import jeus.ejb.metadata.SessionBeanInfo;
import jeus.ejb.metadata.descriptor.EJBDescProcessor;
import jeus.xml.binding.j2ee.FullyQualifiedClassType;
import jeus.xml.binding.j2ee.HomeType;
import jeus.xml.binding.j2ee.InitMethodType;
import jeus.xml.binding.j2ee.LocalHomeType;
import jeus.xml.binding.j2ee.LocalType;
import jeus.xml.binding.j2ee.RemoteType;
import jeus.xml.binding.j2ee.RemoveMethodType;
import jeus.xml.binding.j2ee.SecurityIdentityType;
import jeus.xml.binding.j2ee.SessionBeanType;

public class SessionDescProcessor
extends EJBDescProcessor {
    public SessionDescProcessor(ModuleInfo moduleInfo) {
        super(moduleInfo);
    }

    public void process(SessionBeanType bean, SessionBeanInfo beanInfo) throws InvalidDescriptorException {
        FullyQualifiedClassType endpoint;
        LocalType localType;
        RemoteType remoteType;
        LocalHomeType localHomeType;
        HomeType homeType;
        assert (beanInfo != null);
        String ejbName = bean.getEjbName().getValue();
        Class ejbClass = beanInfo.getBeanClass();
        if (ejbClass == null) {
            throw new InvalidDescriptorException("<ejb-class> is not defined");
        }
        if (beanInfo.getSessionType() == null) {
            throw new InvalidDescriptorException("<session-type> is not defined");
        }
        boolean stateful = beanInfo.isStateful();
        if (bean.isSetMappedName()) {
            beanInfo.setMappedJndiName(bean.getMappedName().getValue().trim());
        }
        if ((homeType = bean.getHome()) != null) {
            beanInfo.setEJBHomeClassName(homeType.getValue());
        }
        if ((localHomeType = bean.getLocalHome()) != null) {
            beanInfo.setEJBLocalHomeClassName(localHomeType.getValue());
        }
        if ((remoteType = bean.getRemote()) != null) {
            beanInfo.setEJBObjectClassName(remoteType.getValue());
        }
        if ((localType = bean.getLocal()) != null) {
            beanInfo.setEJBLocalObjectClassName(localType.getValue());
        }
        try {
            List bizRemoteList;
            Class[] remoteBiz;
            List bizLocalList = bean.getBusinessLocal();
            Class[] localBiz = this.getClassesOf(bizLocalList);
            if (localBiz != null) {
                for (Class intf : localBiz) {
                    beanInfo.addLocalBusinessInterface(intf);
                    beanInfo.removeRemoteBusinessInterface(intf);
                }
            }
            if ((remoteBiz = this.getClassesOf(bizRemoteList = bean.getBusinessRemote())) != null) {
                for (Class intf : remoteBiz) {
                    beanInfo.addRemoteBusinessInterface(intf);
                    beanInfo.removeLocalBusinessInterface(intf);
                }
            }
        }
        catch (ClassNotFoundException e) {
            throw new InvalidDescriptorException("EJB " + ejbName + ": " + e.getMessage(), e);
        }
        if (!stateful && (endpoint = bean.getServiceEndpoint()) != null) {
            beanInfo.setServiceEndpoint(endpoint.getValue());
        }
        this.processTimeoutMethod(bean.getTimeoutMethod(), ejbClass, beanInfo);
        if (stateful) {
            List initMethodList = bean.getInitMethod();
            for (InitMethodType initMethod : initMethodList) {
                try {
                    String createMethodName = initMethod.getCreateMethod().getMethodName().getValue().trim();
                    Method beanMethod = this.getMethod(ejbClass, initMethod.getBeanMethod());
                    if (createMethodName.equals("")) {
                        createMethodName = null;
                    } else if (!createMethodName.startsWith("create")) {
                        throw new InvalidDescriptorException("create method should start with 'create'");
                    }
                    beanInfo.addInitMethod(createMethodName, beanMethod);
                }
                catch (NoSuchMethodException e) {
                    throw new InvalidDescriptorException(e);
                }
            }
            List removeList = bean.getRemoveMethod();
            if (removeList != null && removeList.size() > 0) {
                for (RemoveMethodType remove : removeList) {
                    try {
                        Method m = this.getMethod(ejbClass, remove.getBeanMethod());
                        boolean retainIfException = beanInfo.retainIfException(m);
                        if (remove.isSetRetainIfException()) {
                            retainIfException = remove.getRetainIfException().isValue();
                        }
                        beanInfo.addRemoveMethod(m, retainIfException);
                    }
                    catch (NoSuchMethodException e) {
                        throw new InvalidDescriptorException(e);
                    }
                }
            }
        }
        this.processTransactionType(bean.getTransactionType(), beanInfo);
        InterceptorInfo beanClsInterceptorInfo = beanInfo.getBeanClassInterceptorInfo();
        if (bean.isSetAroundInvoke()) {
            this.processAroundInvokeMethod(bean.getAroundInvoke(), ejbClass, beanClsInterceptorInfo);
        }
        if (bean.isSetPostConstruct()) {
            this.processLifecycleCallbackMethod(CallbackType.POST_CONSTRUCT, bean.getPostConstruct(), null, ejbClass, beanClsInterceptorInfo);
        }
        if (bean.isSetPreDestroy()) {
            this.processLifecycleCallbackMethod(CallbackType.PRE_DESTROY, bean.getPreDestroy(), null, ejbClass, beanClsInterceptorInfo);
        }
        if (stateful) {
            if (bean.isSetPrePassivate()) {
                this.processLifecycleCallbackMethod(CallbackType.PRE_PASSIVATE, bean.getPrePassivate(), null, ejbClass, beanClsInterceptorInfo);
            }
            if (bean.isSetPostActivate()) {
                this.processLifecycleCallbackMethod(CallbackType.POST_ACTIVATE, bean.getPostActivate(), null, ejbClass, beanClsInterceptorInfo);
            }
        }
        NamingEnvironment env = beanInfo.getBeanNamingEnvironment();
        JndiEnvironmentRefsGroup envRefs = new JndiEnvironmentRefsGroup();
        envRefs.simpleEnvEntryList = bean.getEnvEntry();
        envRefs.ejbRefList = bean.getEjbRef();
        envRefs.ejbLocalRefList = bean.getEjbLocalRef();
        if (this.moduleInfo.getEjbVersion() > 2.1) {
            envRefs.serviceRefList = bean.getServiceRef();
        }
        envRefs.resourceRefList = bean.getResourceRef();
        envRefs.resourceEnvRefList = bean.getResourceEnvRef();
        envRefs.messageDestinationRefList = bean.getMessageDestinationRef();
        envRefs.persistenceContextRefList = bean.getPersistenceContextRef();
        envRefs.persistenceUnitRefList = bean.getPersistenceUnitRef();
        EnvironmentDescriptorProcessor envProcessor = new EnvironmentDescriptorProcessor(env, this.loader);
        envProcessor.process(envRefs);
        beanInfo.setBeanNamingEnvironment(envProcessor.getNamingEnvironment());
        beanInfo.setServiceRefs(bean.getServiceRef());
        beanInfo.setRoleLinkList(bean.getSecurityRoleRef());
        SecurityIdentityType securityIdentity = bean.getSecurityIdentity();
        if (securityIdentity != null && securityIdentity.isSetRunAs()) {
            beanInfo.setRunAsRole(securityIdentity.getRunAs().getRoleName().getValue());
        }
    }
}

