/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.persistence.database;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Map;
import javax.transaction.UserTransaction;
import jeus.ejb.schema.FieldRW;
import jeus.jdbc.common.JeusStatement;
import jeus.jdbc.connectionpool.JeusSQLException;
import jeus.jdbc.stmt.StatementWrapper;
import jeus.transaction.TxHelper;
import jeus.util.ErrorMsgManager;
import jeus.util.message.JeusMessage_EJB11;
import oracle.jdbc.OracleStatement;

public final class PLConnection
implements Connection {
    private Connection con = null;
    private boolean closed = false;
    private int driver;
    private boolean virtualAutoCommit;

    public PLConnection(Connection con, int driver) {
        this.con = con;
        this.driver = driver;
    }

    public Statement createStatement() throws SQLException {
        this.checkClosed();
        return this.con.createStatement();
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        this.checkClosed();
        return this.con.prepareStatement(sql);
    }

    public PreparedStatement prepareStatementWithType(String sql, int[] typeIDs) throws SQLException {
        this.checkClosed();
        PreparedStatement stat = this.con.prepareStatement(sql);
        if (this.driver == 1) {
            for (int i = 0; i < typeIDs.length; ++i) {
                Statement pstat = stat instanceof StatementWrapper ? ((StatementWrapper)((Object)stat)).getDelegateStatement() : stat;
                if (pstat instanceof JeusStatement) {
                    pstat = ((JeusStatement)pstat).getDelegate();
                }
                ((OracleStatement)pstat).defineColumnType(i + 1, typeIDs[i]);
            }
        }
        return stat;
    }

    public PreparedStatement prepareStatementWithType(String sql, FieldRW[] fields) throws SQLException {
        this.checkClosed();
        PreparedStatement stat = this.con.prepareStatement(sql);
        if (this.driver == 1) {
            for (int i = 0; i < fields.length; ++i) {
                Statement pstat = stat instanceof StatementWrapper ? ((StatementWrapper)((Object)stat)).getDelegateStatement() : stat;
                if (pstat instanceof JeusStatement) {
                    pstat = ((JeusStatement)pstat).getDelegate();
                }
                ((OracleStatement)pstat).defineColumnType(i + 1, fields[i].type);
            }
        }
        return stat;
    }

    public CallableStatement prepareCall(String sql) throws SQLException {
        this.checkClosed();
        return this.con.prepareCall(sql);
    }

    public String nativeSQL(String sql) throws SQLException {
        this.checkClosed();
        return this.con.nativeSQL(sql);
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.checkClosed();
        this.con.setAutoCommit(autoCommit);
    }

    public boolean getAutoCommit() throws SQLException {
        this.checkClosed();
        return this.con.getAutoCommit();
    }

    public void commit() throws SQLException {
        this.checkClosed();
        this.con.commit();
    }

    public void rollback() throws SQLException {
        this.checkClosed();
        this.con.rollback();
    }

    public void close() throws SQLException {
        this.checkClosed();
        this.closed = true;
        this.con.close();
        if (this.virtualAutoCommit) {
            try {
                UserTransaction userTx = TxHelper.getUserTransaction();
                userTx.commit();
            }
            catch (Throwable ex) {
                throw new JeusSQLException(JeusMessage_EJB11._7125, ex);
            }
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        this.checkClosed();
        return this.con.getMetaData();
    }

    public void setReadOnly(boolean readOnly) throws SQLException {
        this.checkClosed();
        this.con.setReadOnly(readOnly);
    }

    private void checkClosed() throws SQLException {
        if (this.closed) {
            throw new SQLException(ErrorMsgManager.getLocalizedString((int)JeusMessage_EJB11._7075));
        }
    }

    public boolean isReadOnly() throws SQLException {
        this.checkClosed();
        return this.con.isReadOnly();
    }

    public void setCatalog(String catalog) throws SQLException {
        this.checkClosed();
        this.con.setCatalog(catalog);
    }

    public String getCatalog() throws SQLException {
        this.checkClosed();
        return this.con.getCatalog();
    }

    public void setTransactionIsolation(int level) throws SQLException {
        this.checkClosed();
        this.con.setTransactionIsolation(level);
    }

    public int getTransactionIsolation() throws SQLException {
        this.checkClosed();
        return this.con.getTransactionIsolation();
    }

    public SQLWarning getWarnings() throws SQLException {
        this.checkClosed();
        return this.con.getWarnings();
    }

    public void clearWarnings() throws SQLException {
        this.checkClosed();
        this.con.clearWarnings();
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkClosed();
        return this.con.createStatement(resultSetType, resultSetConcurrency);
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkClosed();
        return this.con.prepareStatement(sql, resultSetType, resultSetConcurrency);
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkClosed();
        return this.con.prepareCall(sql, resultSetType, resultSetConcurrency);
    }

    public Map getTypeMap() throws SQLException {
        this.checkClosed();
        return this.con.getTypeMap();
    }

    public void setTypeMap(Map map) throws SQLException {
        this.checkClosed();
        this.con.setTypeMap(map);
    }

    public void setVirtualAutoCommit() throws SQLException {
        this.checkClosed();
        this.virtualAutoCommit = true;
    }

    public void setHoldability(int i) throws SQLException {
        this.checkClosed();
        this.con.setHoldability(i);
    }

    public int getHoldability() throws SQLException {
        this.checkClosed();
        return this.con.getHoldability();
    }

    public Savepoint setSavepoint() throws SQLException {
        this.checkClosed();
        return this.con.setSavepoint();
    }

    public Savepoint setSavepoint(String name) throws SQLException {
        this.checkClosed();
        return this.con.setSavepoint(name);
    }

    public void rollback(Savepoint s) throws SQLException {
        this.checkClosed();
        this.con.rollback(s);
    }

    public void releaseSavepoint(Savepoint s) throws SQLException {
        this.checkClosed();
        this.con.releaseSavepoint(s);
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkClosed();
        return this.con.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkClosed();
        return this.con.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkClosed();
        return this.con.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkClosed();
        return this.con.prepareStatement(sql, autoGeneratedKeys);
    }

    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        this.checkClosed();
        return this.con.prepareStatement(sql, columnIndexes);
    }

    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        this.checkClosed();
        return this.con.prepareStatement(sql, columnNames);
    }
}

