/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.persistence.database;

import java.sql.Connection;
import java.sql.SQLException;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import javax.transaction.UserTransaction;
import jeus.ejb.container.ContainerException;
import jeus.ejb.persistence.database.PLConnection;
import jeus.jdbc.JEUSDataSource;
import jeus.jdbc.connectionpool.JeusSQLException;
import jeus.transaction.TxHelper;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_EJB11;

public final class PersistenceLayer {
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.ejb.persistence.database");
    public static final int ORACLE_DRIVER = 1;
    public static final int SYBASE_DRIVER = 2;
    public static final int JEUS_MSSQL_DRIVER = 3;
    public static final int DB2_DRIVER = 4;
    public static final int INETGATE_DRIVER = 5;
    public static final int OTHER_DRIVER = 6;
    private int db;
    private int type;
    private DataSource dataSource;
    private boolean requireVirtualAC;
    private UserTransaction userTx = TxHelper.getUserTransaction();

    public PersistenceLayer(String dataSourceName) throws ContainerException {
        this.initDataSource(dataSourceName);
    }

    private void initDataSource(String dataSourceName) throws ContainerException {
        JEUSDataSource jeusDataSource;
        try {
            InitialContext ctx = new InitialContext();
            this.dataSource = (DataSource)ctx.lookup(dataSourceName);
            if (!(this.dataSource instanceof JEUSDataSource)) {
                throw new ContainerException(JeusMessage_EJB11._7189);
            }
            jeusDataSource = (JEUSDataSource)this.dataSource;
        }
        catch (Throwable ex) {
            throw new ContainerException(JeusMessage_EJB11._7120, dataSourceName, ex);
        }
        String name = jeusDataSource.getDriverVendorName();
        if (name.equals("oracle")) {
            this.db = 1;
        } else if (name.equals("sybase")) {
            this.db = 2;
        } else if (name.equals("mssql")) {
            this.db = 3;
        } else if (name.equals("db2")) {
            this.db = 4;
        } else if (name.equals("inet")) {
            this.db = 5;
        } else if (name.equals("others")) {
            this.db = 6;
        } else {
            throw new ContainerException(JeusMessage_EJB11._7119);
        }
        this.type = jeusDataSource.getType();
        this.requireVirtualAC = 1 <= this.db && this.db <= 6 && (this.type == 2 || this.type == 3) && !jeusDataSource.isHandleNullTransaction();
    }

    public Connection getConnectionForDDL() throws SQLException {
        if (this.type == 2) {
            return this.getConnection(true);
        }
        return this.getConnection(false);
    }

    public Connection getConnection(boolean inTx) throws SQLException {
        Connection con = null;
        boolean txStarted = false;
        try {
            if (!inTx && this.requireVirtualAC) {
                this.userTx.begin();
                txStarted = true;
            }
            con = this.dataSource.getConnection();
            PLConnection pcon = new PLConnection(con, this.db);
            if (txStarted) {
                pcon.setVirtualAutoCommit();
            } else if (!inTx) {
                con.setAutoCommit(true);
            }
            return pcon;
        }
        catch (Throwable ex) {
            block13: {
                block12: {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable e) {
                            if (!logger.isLoggable(JeusMessage_EJB11._7121_LEVEL)) break block12;
                            logger.log(JeusMessage_EJB11._7121_LEVEL, JeusMessage_EJB11._7121, e);
                        }
                    }
                }
                if (txStarted) {
                    try {
                        this.userTx.rollback();
                    }
                    catch (Throwable t) {
                        if (!logger.isLoggable(JeusMessage_EJB11._7123_LEVEL)) break block13;
                        logger.log(JeusMessage_EJB11._7123_LEVEL, JeusMessage_EJB11._7123, t);
                    }
                }
            }
            throw new JeusSQLException(JeusMessage_EJB11._7122, ex);
        }
    }
}

