/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.persistence.database;

import java.io.Serializable;
import java.math.BigDecimal;
import java.rmi.Remote;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Hashtable;
import jeus.ejb.schema.EJBSQLGeneratorException;
import jeus.util.message.JeusMessage_EJB11;

public final class SQLTypeTable {
    private static Hashtable jdbcTypeTable = new Hashtable();
    private static Hashtable oracleTypeTable = new Hashtable();
    private static Hashtable sybaseTypeTable = new Hashtable();
    private static Hashtable mssqlTypeTable = new Hashtable();
    private static Hashtable db2TypeTable = new Hashtable();
    private static Hashtable cloudscapeTypeTable = new Hashtable();
    private static Hashtable informixTypeTable = new Hashtable();
    private static Hashtable mysqlTypeTable = new Hashtable();
    private static Hashtable hsqlTypeTable = new Hashtable();

    public static int convertToJDBCType(Class cl) throws EJBSQLGeneratorException {
        Integer type = (Integer)jdbcTypeTable.get(cl);
        if (type != null) {
            return type;
        }
        if (Serializable.class.isAssignableFrom(cl) || Remote.class.isAssignableFrom(cl) || cl.isInterface()) {
            return 2000;
        }
        throw new EJBSQLGeneratorException(JeusMessage_EJB11._7127, cl.toString());
    }

    public static String convert(Class cl, String db) throws EJBSQLGeneratorException {
        Hashtable typeTable;
        int type = SQLTypeTable.convertToJDBCType(cl);
        if (db.equals("oracle")) {
            typeTable = oracleTypeTable;
        } else if (db.equals("sybase")) {
            typeTable = sybaseTypeTable;
        } else if (db.equals("mssql")) {
            typeTable = mssqlTypeTable;
        } else if (db.equals("db2")) {
            typeTable = db2TypeTable;
        } else if (db.equals("informix")) {
            typeTable = informixTypeTable;
        } else if (db.equals("cloudscape")) {
            typeTable = cloudscapeTypeTable;
        } else if (db.equals("mysql")) {
            typeTable = mysqlTypeTable;
        } else if (db.equals("hsql")) {
            typeTable = hsqlTypeTable;
        } else {
            throw new EJBSQLGeneratorException(JeusMessage_EJB11._7128, db);
        }
        String sqlType = (String)typeTable.get(new Integer(type));
        if (sqlType == null) {
            throw new EJBSQLGeneratorException(JeusMessage_EJB11._7129, cl.toString());
        }
        return sqlType;
    }

    private static void makeJDBCTypeTable() {
        jdbcTypeTable.put(String.class, new Integer(12));
        jdbcTypeTable.put(BigDecimal.class, new Integer(2));
        jdbcTypeTable.put(Boolean.class, new Integer(-7));
        jdbcTypeTable.put(Boolean.TYPE, new Integer(-7));
        jdbcTypeTable.put(Byte.class, new Integer(-6));
        jdbcTypeTable.put(Byte.TYPE, new Integer(-6));
        jdbcTypeTable.put(Character.class, new Integer(1));
        jdbcTypeTable.put(Character.TYPE, new Integer(1));
        jdbcTypeTable.put(Short.class, new Integer(5));
        jdbcTypeTable.put(Short.TYPE, new Integer(5));
        jdbcTypeTable.put(Integer.class, new Integer(4));
        jdbcTypeTable.put(Integer.TYPE, new Integer(4));
        jdbcTypeTable.put(Long.class, new Integer(-5));
        jdbcTypeTable.put(Long.TYPE, new Integer(-5));
        jdbcTypeTable.put(Float.class, new Integer(7));
        jdbcTypeTable.put(Float.TYPE, new Integer(7));
        jdbcTypeTable.put(Double.class, new Integer(8));
        jdbcTypeTable.put(Double.TYPE, new Integer(8));
        jdbcTypeTable.put(byte[].class, new Integer(-4));
        jdbcTypeTable.put(java.sql.Date.class, new Integer(91));
        jdbcTypeTable.put(Time.class, new Integer(92));
        jdbcTypeTable.put(Timestamp.class, new Integer(93));
        jdbcTypeTable.put(Date.class, new Integer(93));
    }

    private static void makeOracleTypeTable() {
        oracleTypeTable.put(new Integer(-7), "SMALLINT");
        oracleTypeTable.put(new Integer(-6), "SMALLINT");
        oracleTypeTable.put(new Integer(-5), "NUMERIC(22,0)");
        oracleTypeTable.put(new Integer(-4), "LONG RAW");
        oracleTypeTable.put(new Integer(1), "CHAR(4)");
        oracleTypeTable.put(new Integer(2), "NUMERIC(15,5)");
        oracleTypeTable.put(new Integer(4), "INTEGER");
        oracleTypeTable.put(new Integer(5), "SMALLINT");
        oracleTypeTable.put(new Integer(7), "REAL");
        oracleTypeTable.put(new Integer(12), "VARCHAR(255)");
        oracleTypeTable.put(new Integer(93), "DATE");
        oracleTypeTable.put(new Integer(8), "DOUBLE PRECISION");
        oracleTypeTable.put(new Integer(91), "DATE");
        oracleTypeTable.put(new Integer(92), "DATE");
        oracleTypeTable.put(new Integer(2000), "LONG RAW");
    }

    private static void makeSybaseTypeTable() {
        sybaseTypeTable.put(new Integer(-7), "BIT");
        sybaseTypeTable.put(new Integer(-6), "TINYINT");
        sybaseTypeTable.put(new Integer(-5), "NUMERIC(22,0)");
        sybaseTypeTable.put(new Integer(-4), "IMAGE");
        sybaseTypeTable.put(new Integer(1), "CHAR(4)");
        sybaseTypeTable.put(new Integer(2), "NUMERIC(15,5)");
        sybaseTypeTable.put(new Integer(4), "INT");
        sybaseTypeTable.put(new Integer(5), "SMALLINT");
        sybaseTypeTable.put(new Integer(7), "REAL");
        sybaseTypeTable.put(new Integer(12), "VARCHAR(255)");
        sybaseTypeTable.put(new Integer(8), "DOUBLE PRECISION");
        sybaseTypeTable.put(new Integer(91), "DATETIME");
        sybaseTypeTable.put(new Integer(92), "DATETIME");
        sybaseTypeTable.put(new Integer(2000), "IMAGE");
    }

    private static void makeMSSQLTypeTable() {
        mssqlTypeTable.put(new Integer(-7), "BIT");
        mssqlTypeTable.put(new Integer(-6), "TINYINT");
        mssqlTypeTable.put(new Integer(-5), "NUMERIC(22,0)");
        mssqlTypeTable.put(new Integer(-4), "IMAGE");
        mssqlTypeTable.put(new Integer(1), "CHAR(4)");
        mssqlTypeTable.put(new Integer(2), "NUMERIC(15,5)");
        mssqlTypeTable.put(new Integer(4), "INT");
        mssqlTypeTable.put(new Integer(5), "SMALLINT");
        mssqlTypeTable.put(new Integer(7), "REAL");
        mssqlTypeTable.put(new Integer(12), "VARCHAR(255)");
        mssqlTypeTable.put(new Integer(93), "DATETIME");
        mssqlTypeTable.put(new Integer(8), "FLOAT");
        mssqlTypeTable.put(new Integer(91), "DATETIME");
        mssqlTypeTable.put(new Integer(92), "DATETIME");
        mssqlTypeTable.put(new Integer(2000), "IMAGE");
    }

    private static void makeDB2TypeTable() {
        db2TypeTable.put(new Integer(-7), "SMALLINT");
        db2TypeTable.put(new Integer(-6), "SMALLINT");
        db2TypeTable.put(new Integer(-5), "BIGINT");
        db2TypeTable.put(new Integer(-4), "VARCHAR(255)");
        db2TypeTable.put(new Integer(1), "CHARACTER(4)");
        db2TypeTable.put(new Integer(2), "DECIMAL(15,5)");
        db2TypeTable.put(new Integer(4), "INTEGER");
        db2TypeTable.put(new Integer(5), "SMALLINT");
        db2TypeTable.put(new Integer(7), "REAL");
        db2TypeTable.put(new Integer(12), "VARCHAR(255)");
        db2TypeTable.put(new Integer(-1), "LONG VARCHAR");
        db2TypeTable.put(new Integer(93), "TIMESTAMP");
        db2TypeTable.put(new Integer(8), "DOUBLE");
        db2TypeTable.put(new Integer(91), "DATE");
        db2TypeTable.put(new Integer(92), "TIME");
        db2TypeTable.put(new Integer(2000), "LONG VARCHAR");
    }

    private static void makeCloudscapeTypeTable() {
        cloudscapeTypeTable.put(new Integer(-7), "BOOLEAN");
        cloudscapeTypeTable.put(new Integer(-6), "TINYINT");
        cloudscapeTypeTable.put(new Integer(-5), "LONGINT");
        cloudscapeTypeTable.put(new Integer(-4), "LONG BIT VARYING");
        cloudscapeTypeTable.put(new Integer(1), "CHAR(4)");
        cloudscapeTypeTable.put(new Integer(2), "DECIMAL(15,5)");
        cloudscapeTypeTable.put(new Integer(4), "INTEGER");
        cloudscapeTypeTable.put(new Integer(5), "SMALLINT");
        cloudscapeTypeTable.put(new Integer(7), "REAL");
        cloudscapeTypeTable.put(new Integer(12), "VARCHAR(255)");
        cloudscapeTypeTable.put(new Integer(-1), "LONG VARCHAR");
        cloudscapeTypeTable.put(new Integer(93), "TIMESTAMP");
        cloudscapeTypeTable.put(new Integer(8), "DOUBLE PRECISION");
        cloudscapeTypeTable.put(new Integer(91), "DATE");
        cloudscapeTypeTable.put(new Integer(92), "TIME");
        cloudscapeTypeTable.put(new Integer(2000), "LONG BIT VARYING");
    }

    private static void makeInformixTypeTable() {
        informixTypeTable.put(new Integer(-7), "VARCHAR");
        informixTypeTable.put(new Integer(-6), "SMALLINT");
        informixTypeTable.put(new Integer(-5), "SERIAL8");
        informixTypeTable.put(new Integer(-4), "VARCHAR(255)");
        informixTypeTable.put(new Integer(1), "CHAR");
        informixTypeTable.put(new Integer(2), "DECIMAL(15,5)");
        informixTypeTable.put(new Integer(4), "INTEGER");
        informixTypeTable.put(new Integer(5), "SMALLINT");
        informixTypeTable.put(new Integer(7), "REAL");
        informixTypeTable.put(new Integer(12), "VARCHAR(255)");
        informixTypeTable.put(new Integer(-1), "VARCHAR(255)");
        informixTypeTable.put(new Integer(93), "DATETIME YEAR TO SECOND");
        informixTypeTable.put(new Integer(8), "DOUBLE PRECISION");
        informixTypeTable.put(new Integer(91), "DATE");
        informixTypeTable.put(new Integer(92), "DATETIME HOUR TO SECOND");
        informixTypeTable.put(new Integer(2000), "BYTE");
    }

    private static void makeMYSQLTypeTable() {
        mysqlTypeTable.put(new Integer(-7), "BIT");
        mysqlTypeTable.put(new Integer(-6), "TINYINT");
        mysqlTypeTable.put(new Integer(5), "SMALLINT");
        mysqlTypeTable.put(new Integer(4), "INTEGER");
        mysqlTypeTable.put(new Integer(-5), "BIGINT");
        mysqlTypeTable.put(new Integer(6), "FLOAT");
        mysqlTypeTable.put(new Integer(7), "REAL");
        mysqlTypeTable.put(new Integer(8), "DOUBLE");
        mysqlTypeTable.put(new Integer(2), "NUMERIC");
        mysqlTypeTable.put(new Integer(3), "DECIMAL");
        mysqlTypeTable.put(new Integer(1), "CHAR(4)");
        mysqlTypeTable.put(new Integer(12), "VARCHAR(255)");
        mysqlTypeTable.put(new Integer(-1), "MEDIUMTEXT");
        mysqlTypeTable.put(new Integer(91), "DATE");
        mysqlTypeTable.put(new Integer(92), "TIME");
        mysqlTypeTable.put(new Integer(93), "TIMESTAMP(14)");
        mysqlTypeTable.put(new Integer(-4), "MEDIUMBLOB");
        mysqlTypeTable.put(new Integer(2000), "MEDIUMBLOB");
        mysqlTypeTable.put(new Integer(16), "BOOL");
    }

    private static void makeHSQLTypeTable() {
        hsqlTypeTable.put(new Integer(-7), "BIT");
        hsqlTypeTable.put(new Integer(-6), "TINYINT");
        hsqlTypeTable.put(new Integer(5), "SMALLINT");
        hsqlTypeTable.put(new Integer(4), "INTEGER");
        hsqlTypeTable.put(new Integer(-5), "BIGINT");
        hsqlTypeTable.put(new Integer(6), "FLOAT");
        hsqlTypeTable.put(new Integer(7), "REAL");
        hsqlTypeTable.put(new Integer(8), "DOUBLE");
        hsqlTypeTable.put(new Integer(2), "NUMERIC");
        hsqlTypeTable.put(new Integer(3), "DECIMAL");
        hsqlTypeTable.put(new Integer(1), "CHAR(4)");
        hsqlTypeTable.put(new Integer(12), "VARCHAR(255)");
        hsqlTypeTable.put(new Integer(-1), "LONGVARCHAR");
        hsqlTypeTable.put(new Integer(91), "DATE");
        hsqlTypeTable.put(new Integer(92), "TIME");
        hsqlTypeTable.put(new Integer(93), "TIMESTAMP");
        hsqlTypeTable.put(new Integer(-4), "LONGVARBINARY");
        hsqlTypeTable.put(new Integer(2000), "OBJECT");
        hsqlTypeTable.put(new Integer(16), "BIT");
    }

    private static String getMYSQLFunction(String funcName, String[] argList) throws EJBSQLGeneratorException {
        if (funcName.equals("CONCAT")) {
            return "CONCAT(" + argList[0] + "," + argList[1] + ")";
        }
        if (funcName.equals("SUBSTRING")) {
            return "SUBSTRING(" + argList[0] + "," + argList[1] + "," + argList[2] + ")";
        }
        if (funcName.equals("LENGTH")) {
            return "LENGTH(" + argList[0] + ")";
        }
        if (funcName.equals("LOCATE")) {
            String str = "LOCATE(" + argList[0] + "," + argList[1];
            str = argList.length == 2 ? str + ")" : str + "," + argList[2] + ")";
            return str;
        }
        if (funcName.equals("ABS")) {
            return "ABS(" + argList[0] + ")";
        }
        if (funcName.equals("SQRT")) {
            return "SQRT(" + argList[0] + ")";
        }
        if (funcName.equals("MOD")) {
            return "MOD(" + argList[0] + "," + argList[1] + ")";
        }
        throw new EJBSQLGeneratorException("[SQLTypeTable] MYSQL doesn't support '" + funcName + "' function");
    }

    private static String getHSQLFunction(String funcName, String[] argList) throws EJBSQLGeneratorException {
        if (funcName.equals("CONCAT")) {
            return "CONCAT(" + argList[0] + "," + argList[1] + ")";
        }
        if (funcName.equals("SUBSTRING")) {
            String str = "SUBSTRING(" + argList[0] + "," + argList[1];
            str = argList.length == 2 ? str + ")" : str + "," + argList[2] + ")";
            return str;
        }
        if (funcName.equals("LENGTH")) {
            return "LENGHT(" + argList[0] + ")";
        }
        if (funcName.equals("LOCATE")) {
            String str = "LOCATE(" + argList[0] + "," + argList[1];
            str = argList.length == 2 ? str + ")" : str + "," + argList[2] + ")";
            return str;
        }
        if (funcName.equals("ABS")) {
            return "ABS(" + argList[0] + ")";
        }
        if (funcName.equals("SQRT")) {
            return "SQRT(" + argList[0] + ")";
        }
        if (funcName.equals("MOD")) {
            return "MOD(" + argList[0] + "," + argList[1] + ")";
        }
        throw new EJBSQLGeneratorException("[SQLTypeTable] HSQL doesn't support '" + funcName + "' function");
    }

    static {
        SQLTypeTable.makeJDBCTypeTable();
        SQLTypeTable.makeOracleTypeTable();
        SQLTypeTable.makeSybaseTypeTable();
        SQLTypeTable.makeMSSQLTypeTable();
        SQLTypeTable.makeDB2TypeTable();
        SQLTypeTable.makeCloudscapeTypeTable();
        SQLTypeTable.makeInformixTypeTable();
        SQLTypeTable.makeMYSQLTypeTable();
        SQLTypeTable.makeHSQLTypeTable();
    }
}

