/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.schema;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import javax.xml.bind.JAXBException;
import jeus.ejb.persistence.database.SQLBuilder;
import jeus.ejb.persistence.database.SQLTypeTable;
import jeus.ejb.schema.AbstractSchemaHandlerFactory;
import jeus.ejb.schema.BeanSchema;
import jeus.ejb.schema.CMPField;
import jeus.ejb.schema.CMPFieldRW;
import jeus.ejb.schema.CMRFieldRW;
import jeus.ejb.schema.ClassFieldRW;
import jeus.ejb.schema.EJBCacher;
import jeus.ejb.schema.EJBCreator;
import jeus.ejb.schema.EJBFinder;
import jeus.ejb.schema.EJBKeyGenerator;
import jeus.ejb.schema.EJBLoader;
import jeus.ejb.schema.EJBRemover;
import jeus.ejb.schema.EJBSQLGeneratorException;
import jeus.ejb.schema.EJBStorer;
import jeus.ejb.schema.EJBTableChecker;
import jeus.ejb.schema.EJBTableCreator;
import jeus.ejb.schema.EJBTableRemover;
import jeus.ejb.schema.FieldRW;
import jeus.ejb.schema.ModuleSchema;
import jeus.ejb.schema.cmp20.CMPFieldRWForCMP20;
import jeus.ejb.util.MethodConvertor;
import jeus.service.archive.ArchiveArrayClassLoader;
import jeus.util.StringUtil;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_EJB11;
import jeus.util.message.JeusMessage_EJB9;
import jeus.util.properties.JeusEJBProperties;
import jeus.xml.binding.ejbHelper.CMEntityBeanPair;
import jeus.xml.binding.ejbHelper.FindMethodPair;
import jeus.xml.binding.ejbHelper.RelationshipRolePair;
import jeus.xml.binding.j2ee.CmpFieldType;
import jeus.xml.binding.jeusDD.CmFieldType;
import jeus.xml.binding.jeusDD.CreatingTableType;

public final class EJBSQLGenerator {
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.ejb.schema.generator");
    public ModuleSchema mSchema;
    public BeanSchema bSchema;
    String ejbName;
    int cmpVersion = 1;
    private AbstractSchemaHandlerFactory factory;
    private Class ejbBeanClass;
    private Class ejbHomeClass;
    private Class ejbLocalHomeClass;
    public Class pkeyClass;
    public String dbVendor;
    public String tableName;
    public CreatingTableType creatingTable;
    public boolean deletingTable;
    public ArrayList pkeyClassFields = new ArrayList();
    public ArrayList pkeyClassFieldRWs = new ArrayList();
    public boolean isPkeyField;
    public ArrayList cmFieldRWs = new ArrayList();
    public ArrayList cmPkeyFieldRWs = new ArrayList();
    public ArrayList cmNPkeyFieldRWs = new ArrayList();
    public ArrayList cmNormalFieldRWs = new ArrayList();
    public ArrayList cmNPkeyClobFieldRWs = new ArrayList();
    public ArrayList cmNPkeyBlobFieldRWs = new ArrayList();
    public ArrayList cmNPkeyNormalFieldRWs = new ArrayList();
    private ArrayList cmFields = new ArrayList();
    private ArrayList cmPkeyFields = new ArrayList();
    public ArrayList findMethods = new ArrayList();
    public ArrayList findSQLs = new ArrayList();
    private EJBTableCreator tableCreator;
    private EJBTableRemover tableRemover;
    private EJBCreator ejbCreator;
    private EJBRemover ejbRemover;
    private EJBLoader ejbLoader;
    private EJBStorer ejbStorer;
    private EJBFinder ejbFinder;
    private EJBCacher ejbCacher;
    private EJBTableChecker ejbTableChecker;
    private EJBKeyGenerator ejbKeyGenerator;
    public SQLBuilder sqlBuilder;
    private boolean isAutoPK;
    private CMRFieldRW[] sharedReadOnlyCMRFieldRWs;
    public CMEntityBeanPair beanPair;
    private ArchiveArrayClassLoader loader;

    public EJBSQLGenerator(CMEntityBeanPair desc, ModuleSchema moduleSchema) {
        this.beanPair = desc;
        this.mSchema = moduleSchema;
        this.loader = this.mSchema.getLoader();
        this.cmpVersion = desc.getCMPVersion();
        this.factory = AbstractSchemaHandlerFactory.createSchemaHandlerFactory(this.cmpVersion);
        if (logger.isLoggable(JeusMessage_EJB9._5601_LEVEL)) {
            logger.logp(JeusMessage_EJB9._5601_LEVEL, "EJBSQLGenerator", "<init>", JeusMessage_EJB9._5601, new Object[]{desc.getBeanName(), moduleSchema.getModuleName()});
        }
    }

    public void getPkeyFieldInfo() throws EJBSQLGeneratorException, JAXBException {
        if (logger.isLoggable(JeusMessage_EJB9._5602_LEVEL)) {
            logger.logp(JeusMessage_EJB9._5602_LEVEL, "EJBSQLGenerator", "getPkeyFieldInfo", JeusMessage_EJB9._5602);
        }
        this.ejbName = this.beanPair.getBeanName();
        this.bSchema = this.mSchema.getBeanSchema(this.ejbName, this.cmpVersion);
        this.initClassInfo();
        if (!this.beanPair.isPkeyField()) {
            if (this.isPkeyField) {
                if (logger.isLoggable(JeusMessage_EJB9._5603_LEVEL)) {
                    logger.logp(JeusMessage_EJB9._5603_LEVEL, "EJBSQLGenerator", "getPkeyFieldInfo", JeusMessage_EJB9._5603);
                }
                throw new EJBSQLGeneratorException(JeusMessage_EJB9._5603);
            }
            if (this.beanPair.getCMPkeyFields().size() == 0) {
                if (logger.isLoggable(JeusMessage_EJB9._5604_LEVEL)) {
                    logger.logp(JeusMessage_EJB9._5604_LEVEL, "EJBSQLGenerator", "getPkeyFieldInfo", JeusMessage_EJB9._5604);
                }
                Field[] pkeyFields = this.pkeyClass.getFields();
                for (int i = 0; i < pkeyFields.length; ++i) {
                    String name = pkeyFields[i].getName();
                    if (logger.isLoggable(JeusMessage_EJB9._5605_LEVEL)) {
                        logger.logp(JeusMessage_EJB9._5605_LEVEL, "EJBSQLGenerator", "getPkeyFieldInfo", JeusMessage_EJB9._5605, (Object)name);
                    }
                    this.beanPair.addCMPkeyField(name);
                }
            }
        }
        if (logger.isLoggable(JeusMessage_EJB9._5606_LEVEL)) {
            logger.logp(JeusMessage_EJB9._5606_LEVEL, "EJBSQLGenerator", "getPkeyFieldInfo", JeusMessage_EJB9._5606);
        }
    }

    public void analyzeDataSchema(String moduleName, boolean isCmp20) throws EJBSQLGeneratorException {
        if (logger.isLoggable(JeusMessage_EJB9._5607_LEVEL)) {
            logger.logp(JeusMessage_EJB9._5607_LEVEL, "EJBSQLGenerator", "analyzeDataSchema", JeusMessage_EJB9._5607, (Object)this.ejbName);
        }
        try {
            this.dbVendor = this.beanPair.getDBVendor();
            this.tableName = this.getTableName(moduleName);
            this.creatingTable = this.beanPair.getCreatingTable();
            this.deletingTable = this.beanPair.isDeletingTable();
            String ejbBeanClassName = this.beanPair.getFullEJBBeanClassName();
            try {
                if (logger.isLoggable(JeusMessage_EJB9._5608_LEVEL)) {
                    logger.logp(JeusMessage_EJB9._5608_LEVEL, "EJBSQLGenerator", "analyzeDataSchema", JeusMessage_EJB9._5608);
                }
                this.ejbBeanClass = this.loader.loadClass(ejbBeanClassName);
                if (logger.isLoggable(JeusMessage_EJB9._5609_LEVEL)) {
                    logger.logp(JeusMessage_EJB9._5609_LEVEL, "EJBSQLGenerator", "analyzeDataSchema", JeusMessage_EJB9._5609);
                }
            }
            catch (ClassNotFoundException ex) {
                if (logger.isLoggable(JeusMessage_EJB9._5610_LEVEL)) {
                    logger.logp(JeusMessage_EJB9._5610_LEVEL, "EJBSQLGenerator", "analyzeDataSchema", JeusMessage_EJB9._5610, (Object)ejbBeanClassName, (Throwable)ex);
                }
                throw new EJBSQLGeneratorException(JeusMessage_EJB9._5610, ejbBeanClassName, (Throwable)ex);
            }
            this.getEJBBeanCMFields(isCmp20);
            this.getPkeyClassFields();
            this.beanPair.setTableName(this.tableName);
            this.beanPair.setPkeyClassFieldListForContainer(this.pkeyClassFields);
            this.bSchema.cmFieldRWs = this.cmFieldRWs;
            this.getFindMethods();
        }
        catch (Throwable t) {
            if (logger.isLoggable(JeusMessage_EJB9._5611_LEVEL)) {
                logger.logp(JeusMessage_EJB9._5611_LEVEL, "EJBSQLGenerator", "analyzeDataSchema", JeusMessage_EJB9._5611, (Object)this.ejbName, t);
            }
            throw new EJBSQLGeneratorException(JeusMessage_EJB9._5611, this.ejbName, t);
        }
        if (logger.isLoggable(JeusMessage_EJB9._5612_LEVEL)) {
            logger.logp(JeusMessage_EJB9._5612_LEVEL, "EJBSQLGenerator", "analyzeDataSchema", JeusMessage_EJB9._5612);
        }
    }

    public void analyzeColumnSharing() throws EJBSQLGeneratorException {
        if (this.cmpVersion == 2) {
            this.checkColumnSharing();
        }
    }

    public void generateSQLs() throws EJBSQLGeneratorException {
        if (logger.isLoggable(JeusMessage_EJB9._5613_LEVEL)) {
            logger.logp(JeusMessage_EJB9._5613_LEVEL, "EJBSQLGenerator", "generateSQLs", JeusMessage_EJB9._5613, (Object)this.beanPair.getBeanName());
        }
        try {
            this.generateSQL();
        }
        catch (Throwable t) {
            if (logger.isLoggable(JeusMessage_EJB9._5614_LEVEL)) {
                logger.logp(JeusMessage_EJB9._5614_LEVEL, "EJBSQLGenerator", "generateSQLs", JeusMessage_EJB9._5614, (Object)this.beanPair.getBeanName(), t);
            }
            throw new EJBSQLGeneratorException(JeusMessage_EJB9._5614, this.beanPair.getBeanName(), t);
        }
        if (logger.isLoggable(JeusMessage_EJB9._5615_LEVEL)) {
            logger.logp(JeusMessage_EJB9._5615_LEVEL, "EJBSQLGenerator", "generateSQLs", JeusMessage_EJB9._5615);
        }
    }

    public void updateDBInfo() throws EJBSQLGeneratorException {
        if (logger.isLoggable(JeusMessage_EJB9._5613_LEVEL)) {
            logger.logp(JeusMessage_EJB9._5613_LEVEL, "EJBSQLGenerator", "generateSQLs", JeusMessage_EJB9._5613, (Object)this.beanPair.getBeanName());
        }
        try {
            this.updateEJBDBInfo();
            this.printAll();
        }
        catch (Throwable t) {
            if (logger.isLoggable(JeusMessage_EJB9._5614_LEVEL)) {
                logger.logp(JeusMessage_EJB9._5614_LEVEL, "EJBSQLGenerator", "generateSQLs", JeusMessage_EJB9._5614, (Object)this.beanPair.getBeanName(), t);
            }
            throw new EJBSQLGeneratorException(JeusMessage_EJB9._5614, this.beanPair.getBeanName(), t);
        }
        if (logger.isLoggable(JeusMessage_EJB9._5615_LEVEL)) {
            logger.logp(JeusMessage_EJB9._5615_LEVEL, "EJBSQLGenerator", "generateSQLs", JeusMessage_EJB9._5615);
        }
    }

    private void printAll() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("ejbName : ").append(this.beanPair.getBeanName()).append(StringUtil.lineSeparator);
        buffer.append("tableName : ").append(this.tableName).append(StringUtil.lineSeparator);
        buffer.append("creatingTable : ").append(this.creatingTable != null).append(StringUtil.lineSeparator);
        buffer.append("deletingTable : ").append(this.deletingTable).append(StringUtil.lineSeparator);
        buffer.append("cmFields : ").append(StringUtil.lineSeparator);
        this.printALForCMFields(this.beanPair.getCMFields(), buffer);
        buffer.append("cmPkeyFields : ").append(StringUtil.lineSeparator);
        this.printAL(this.cmPkeyFields, buffer);
        buffer.append("cmNPkeyFields : ").append(StringUtil.lineSeparator);
        this.printAL(this.cmNPkeyFieldRWs, buffer);
        buffer.append("pkeyClassFields : ").append(StringUtil.lineSeparator);
        this.printAL(this.pkeyClassFields, buffer);
        buffer.append("isPkeyField : ").append(this.isPkeyField).append(StringUtil.lineSeparator);
        if (this.cmpVersion == 2) {
            buffer.append("cmrFields : ").append(StringUtil.lineSeparator);
            this.printCMRFields(buffer);
        }
        buffer.append("findMethods : ").append(StringUtil.lineSeparator);
        buffer.append(this.ejbFinder.toString()).append(StringUtil.lineSeparator);
        if (this.creatingTable != null) {
            buffer.append("createTableSQL : ").append(StringUtil.lineSeparator);
            buffer.append(this.tableCreator.toString()).append(StringUtil.lineSeparator);
        }
        if (this.creatingTable != null && this.creatingTable.getForceCreatingTable() != null || this.deletingTable) {
            buffer.append("deleteTableSQL : ").append(StringUtil.lineSeparator);
            buffer.append(this.tableRemover.toString()).append(StringUtil.lineSeparator);
        }
        buffer.append("ejbCreateSQL : ").append(StringUtil.lineSeparator);
        buffer.append(this.ejbCreator.toString()).append(StringUtil.lineSeparator);
        buffer.append("ejbRemoveSQL : ").append(StringUtil.lineSeparator);
        buffer.append(this.ejbRemover.toString()).append(StringUtil.lineSeparator);
        buffer.append("ejbLoadSQL : ").append(StringUtil.lineSeparator);
        buffer.append(this.ejbLoader.toString()).append(StringUtil.lineSeparator);
        buffer.append("ejbStoreSQL : ").append(StringUtil.lineSeparator);
        buffer.append(this.ejbStorer.toString()).append(StringUtil.lineSeparator);
        buffer.append("cachingSQL : ").append(StringUtil.lineSeparator);
        buffer.append(this.ejbCacher.toString()).append(StringUtil.lineSeparator);
        if (this.ejbKeyGenerator != null) {
            buffer.append("keyGenerator : ").append(StringUtil.lineSeparator);
            buffer.append(this.ejbKeyGenerator.toString()).append(StringUtil.lineSeparator);
        }
        logger.log(Level.CONFIG, buffer.toString());
    }

    private void printALForCMFields(List cmFields, StringBuffer buffer) {
        for (int i = 0; i < cmFields.size(); ++i) {
            CmFieldType cmFieldType = (CmFieldType)cmFields.get(i);
            buffer.append("\tCMField[" + i + "]").append(StringUtil.lineSeparator);
            buffer.append("\t\tField : ").append(cmFieldType.getField()).append(StringUtil.lineSeparator);
            buffer.append("\t\tColumn : ").append(cmFieldType.getColumnName()).append(StringUtil.lineSeparator);
            buffer.append("\t\tType : ").append(cmFieldType.getType()).append(StringUtil.lineSeparator);
        }
    }

    private void printAL(ArrayList a, StringBuffer buffer) {
        for (int i = 0; i < a.size(); ++i) {
            buffer.append("\t" + a.get(i)).append(StringUtil.lineSeparator);
        }
    }

    private void printCMRFields(StringBuffer buffer) {
        Enumeration e = this.bSchema.relations.elements();
        while (e.hasMoreElements()) {
            int i;
            RelationshipRolePair rdesc = (RelationshipRolePair)e.nextElement();
            String tmp = "[" + rdesc.getCMRFieldName() + "][" + rdesc.getFieldRW().getIndex() + "] " + rdesc.getEJBName() + "(" + (rdesc.isMany() ? "M" : "1") + ")";
            CMRFieldRW frw = rdesc.getFieldRW();
            if (frw.keyClassColNames != null) {
                tmp = tmp + "(";
                for (i = 0; i < frw.keyClassColNames.length; ++i) {
                    if (i != 0) {
                        tmp = tmp + ",";
                    }
                    tmp = tmp + frw.keyClassColNames[i];
                }
                tmp = tmp + ")";
            }
            tmp = tmp + " => ";
            rdesc = rdesc.getPair();
            tmp = tmp + rdesc.getEJBName() + "(" + (rdesc.isMany() ? "M" : "1") + ")";
            frw = rdesc.getFieldRW();
            if (frw.keyClassColNames != null) {
                tmp = tmp + "(";
                for (i = 0; i < frw.keyClassColNames.length; ++i) {
                    if (i != 0) {
                        tmp = tmp + ",";
                    }
                    tmp = tmp + frw.keyClassColNames[i];
                }
                tmp = tmp + ")";
            }
            buffer.append("\t" + tmp).append(StringUtil.lineSeparator);
        }
    }

    private void initClassInfo() throws EJBSQLGeneratorException {
        String localHomeClassName;
        String homeClassName = this.beanPair.getEJBHomeClassName();
        if (homeClassName != null) {
            try {
                if (logger.isLoggable(JeusMessage_EJB9._5617_LEVEL)) {
                    logger.logp(JeusMessage_EJB9._5617_LEVEL, "EJBSQLGenerator", "initClassInfo", JeusMessage_EJB9._5617);
                }
                this.ejbHomeClass = this.loader.loadClass(homeClassName);
                if (logger.isLoggable(JeusMessage_EJB9._5618_LEVEL)) {
                    logger.logp(JeusMessage_EJB9._5618_LEVEL, "EJBSQLGenerator", "initClassInfo", JeusMessage_EJB9._5618);
                }
            }
            catch (ClassNotFoundException ex) {
                if (logger.isLoggable(JeusMessage_EJB9._5619_LEVEL)) {
                    logger.logp(JeusMessage_EJB9._5619_LEVEL, "EJBSQLGenerator", "initClassInfo", JeusMessage_EJB9._5619, (Object)homeClassName, (Throwable)ex);
                }
                throw new EJBSQLGeneratorException(JeusMessage_EJB9._5619, homeClassName, (Throwable)ex);
            }
        }
        if ((localHomeClassName = this.beanPair.getEJBLocalHomeClassName()) != null) {
            try {
                if (logger.isLoggable(JeusMessage_EJB9._5620_LEVEL)) {
                    logger.logp(JeusMessage_EJB9._5620_LEVEL, "EJBSQLGenerator", "initClassInfo", JeusMessage_EJB9._5620);
                }
                this.ejbLocalHomeClass = this.loader.loadClass(localHomeClassName);
                if (logger.isLoggable(JeusMessage_EJB9._5621_LEVEL)) {
                    logger.logp(JeusMessage_EJB9._5621_LEVEL, "EJBSQLGenerator", "initClassInfo", JeusMessage_EJB9._5621);
                }
            }
            catch (ClassNotFoundException ex) {
                if (logger.isLoggable(JeusMessage_EJB9._5622_LEVEL)) {
                    logger.logp(JeusMessage_EJB9._5622_LEVEL, "EJBSQLGenerator", "initClassInfo", JeusMessage_EJB9._5622, (Object)localHomeClassName, (Throwable)ex);
                }
                throw new EJBSQLGeneratorException(JeusMessage_EJB9._5622, localHomeClassName, (Throwable)ex);
            }
        }
        this.isPkeyField = this.beanPair.isPkeyField();
        if (!this.isPkeyField) {
            String pkeyClassName = this.beanPair.getPkeyClassName();
            try {
                if (logger.isLoggable(JeusMessage_EJB9._5623_LEVEL)) {
                    logger.logp(JeusMessage_EJB9._5623_LEVEL, "EJBSQLGenerator", "initClassInfo", JeusMessage_EJB9._5623);
                }
                this.pkeyClass = this.loader.loadClass(pkeyClassName);
                if (logger.isLoggable(JeusMessage_EJB9._5624_LEVEL)) {
                    logger.logp(JeusMessage_EJB9._5624_LEVEL, "EJBSQLGenerator", "initClassInfo", JeusMessage_EJB9._5624);
                }
            }
            catch (ClassNotFoundException ex) {
                if (logger.isLoggable(JeusMessage_EJB9._5625_LEVEL)) {
                    logger.logp(JeusMessage_EJB9._5625_LEVEL, "EJBSQLGenerator", "initClassInfo", JeusMessage_EJB9._5625, (Object)pkeyClassName, (Throwable)ex);
                }
                throw new EJBSQLGeneratorException(JeusMessage_EJB9._5625, pkeyClassName, (Throwable)ex);
            }
        }
        if (logger.isLoggable(JeusMessage_EJB9._5626_LEVEL)) {
            logger.logp(JeusMessage_EJB9._5626_LEVEL, "EJBSQLGenerator", "initClassInfo", JeusMessage_EJB9._5626);
        }
    }

    private String getTableName(String moduleName) {
        char head;
        String tname;
        if (logger.isLoggable(JeusMessage_EJB9._5627_LEVEL)) {
            logger.logp(JeusMessage_EJB9._5627_LEVEL, "EJBSQLGenerator", "getTableName", JeusMessage_EJB9._5627, (Object)moduleName);
        }
        if ((tname = this.beanPair.getTableName()) != null) {
            if (logger.isLoggable(JeusMessage_EJB9._5628_LEVEL)) {
                logger.logp(JeusMessage_EJB9._5628_LEVEL, "EJBSQLGenerator", "getTableName", JeusMessage_EJB9._5628, (Object)tname);
            }
            return tname;
        }
        tname = moduleName + MethodConvertor.removeSlash(this.beanPair.getBeanName());
        tname = this.removeMark(tname);
        if ((tname = tname + (tname.hashCode() & Integer.MAX_VALUE)).length() > 15) {
            tname = tname.substring(tname.length() - 15);
        }
        if (!Character.isJavaIdentifierStart(head = tname.charAt(0))) {
            tname = "jh" + tname;
        }
        tname = tname.replaceAll("_", "jh");
        if (logger.isLoggable(JeusMessage_EJB9._5629_LEVEL)) {
            logger.logp(JeusMessage_EJB9._5629_LEVEL, "EJBSQLGenerator", "getTableName", JeusMessage_EJB9._5629, (Object)tname);
        }
        return tname;
    }

    private String removeMark(String a) {
        if (logger.isLoggable(JeusMessage_EJB9._5630_LEVEL)) {
            logger.logp(JeusMessage_EJB9._5630_LEVEL, "EJBSQLGenerator", "removeMark", JeusMessage_EJB9._5630, (Object)a);
        }
        String result = "";
        StringTokenizer tokens = new StringTokenizer(a, ".");
        while (tokens.hasMoreTokens()) {
            result = result + tokens.nextToken();
        }
        return result;
    }

    private CMPField getCMPField(String fieldname) throws Exception {
        CMPField field = null;
        if (this.cmpVersion == 2) {
            String getMethodName = "get" + fieldname.substring(0, 1).toUpperCase() + fieldname.substring(1);
            String setMethodName = "set" + fieldname.substring(0, 1).toUpperCase() + fieldname.substring(1);
            Method method = this.ejbBeanClass.getMethod(getMethodName, null);
            if (!Modifier.isAbstract(method.getModifiers())) {
                throw new EJBSQLGeneratorException(3588, getMethodName);
            }
            Class<?> returnType = method.getReturnType();
            method = this.ejbBeanClass.getMethod(setMethodName, returnType);
            if (!Modifier.isAbstract(method.getModifiers())) {
                throw new EJBSQLGeneratorException(3587, setMethodName);
            }
            field = new CMPField(fieldname, returnType);
        } else {
            Field f = this.ejbBeanClass.getField(fieldname);
            field = new CMPField(f.getName(), f.getType());
            field.setFieldObject(f);
        }
        return field;
    }

    private void getEJBBeanCMFields(boolean isCmp20) throws EJBSQLGeneratorException {
        if (logger.isLoggable(JeusMessage_EJB9._5631_LEVEL)) {
            logger.logp(JeusMessage_EJB9._5631_LEVEL, "EJBSQLGenerator", "getEJBBeanCMFields", JeusMessage_EJB9._5631);
        }
        try {
            ArrayList<CmFieldType> orderedCMPkeyFields = new ArrayList<CmFieldType>();
            List cmFields = this.beanPair.getCMFieldsInJar();
            for (int i = 0; i < cmFields.size(); ++i) {
                String type;
                CmFieldType fieldType;
                String colName;
                CmpFieldType cmpFieldType = (CmpFieldType)cmFields.get(i);
                String fieldName = cmpFieldType.getFieldName().getValue();
                if (logger.isLoggable(JeusMessage_EJB9._5632_LEVEL)) {
                    logger.logp(JeusMessage_EJB9._5632_LEVEL, "EJBSQLGenerator", "getEJBBeanCMFields", JeusMessage_EJB9._5632, (Object)fieldName);
                }
                CMPField f = this.getCMPField(fieldName);
                if (logger.isLoggable(JeusMessage_EJB9._5633_LEVEL)) {
                    logger.logp(JeusMessage_EJB9._5633_LEVEL, "EJBSQLGenerator", "getEJBBeanCMFields", JeusMessage_EJB9._5633);
                }
                if ((colName = (fieldType = this.beanPair.getCMFieldInDD(fieldName)).getColumnName()) == null) {
                    String colNameFromFieldName = this.makeDBColumnName(fieldName);
                    if (logger.isLoggable(JeusMessage_EJB9._5634_LEVEL)) {
                        logger.logp(JeusMessage_EJB9._5634_LEVEL, "EJBSQLGenerator", "getEJBBeanCMFields", JeusMessage_EJB9._5634, new Object[]{fieldName, colNameFromFieldName});
                    }
                    fieldType.setColumnName(colNameFromFieldName);
                    colName = colNameFromFieldName;
                }
                if ((type = fieldType.getType()) == null) {
                    if (logger.isLoggable(JeusMessage_EJB9._5635_LEVEL)) {
                        logger.logp(JeusMessage_EJB9._5635_LEVEL, "EJBSQLGenerator", "getEJBBeanCMFields", JeusMessage_EJB9._5635, (Object)fieldName);
                    }
                    type = SQLTypeTable.convert(f.getType(), this.dbVendor);
                    if (logger.isLoggable(JeusMessage_EJB9._5636_LEVEL)) {
                        logger.logp(JeusMessage_EJB9._5636_LEVEL, "EJBSQLGenerator", "getEJBBeanCMFields", JeusMessage_EJB9._5636, (Object)type);
                    }
                    fieldType.setType(type);
                }
                if (logger.isLoggable(JeusMessage_EJB9._5637_LEVEL)) {
                    logger.logp(JeusMessage_EJB9._5637_LEVEL, "EJBSQLGenerator", "getEJBBeanCMFields", JeusMessage_EJB9._5637, (Object)f);
                }
                this.cmFields.add(f);
                if (this.beanPair.isSetAsPkeyField(fieldName)) {
                    if (logger.isLoggable(JeusMessage_EJB9._5638_LEVEL)) {
                        logger.logp(JeusMessage_EJB9._5638_LEVEL, "EJBSQLGenerator", "getEJBBeanCMFields", JeusMessage_EJB9._5638, (Object)f);
                    }
                    this.cmPkeyFields.add(f);
                    orderedCMPkeyFields.add(fieldType);
                }
                if (logger.isLoggable(JeusMessage_EJB9._5639_LEVEL)) {
                    logger.logp(JeusMessage_EJB9._5639_LEVEL, "EJBSQLGenerator", "getEJBBeanCMFields", JeusMessage_EJB9._5639, new Object[]{colName, fieldName, String.valueOf(i)});
                }
                CMPFieldRW frw = this.factory.createCMPFieldRW();
                frw.fieldName = fieldName;
                frw.fieldIdx = i;
                type = type.toUpperCase();
                if (logger.isLoggable(JeusMessage_EJB9._5640_LEVEL)) {
                    logger.logp(JeusMessage_EJB9._5640_LEVEL, "EJBSQLGenerator", "getEJBBeanCMFields", JeusMessage_EJB9._5640, (Object)frw);
                }
                this.cmFieldRWs.add(frw);
                if (this.beanPair.isSetAsPkeyField(fieldName)) {
                    if (logger.isLoggable(JeusMessage_EJB9._5641_LEVEL)) {
                        logger.logp(JeusMessage_EJB9._5641_LEVEL, "EJBSQLGenerator", "getEJBBeanCMFields", JeusMessage_EJB9._5641, (Object)frw);
                    }
                    this.cmPkeyFieldRWs.add(frw);
                    this.cmNormalFieldRWs.add(frw);
                    frw.type = SQLTypeTable.convertToJDBCType(f.getType());
                    frw.setPrimaryKeyField();
                } else {
                    if (logger.isLoggable(JeusMessage_EJB9._5642_LEVEL)) {
                        logger.logp(JeusMessage_EJB9._5642_LEVEL, "EJBSQLGenerator", "getEJBBeanCMFields", JeusMessage_EJB9._5642, (Object)frw);
                    }
                    this.cmNPkeyFieldRWs.add(frw);
                    if (type.equals("CLOB") && this.dbVendor.equals("oracle")) {
                        frw.type = 2005;
                        if (logger.isLoggable(JeusMessage_EJB9._5643_LEVEL)) {
                            logger.logp(JeusMessage_EJB9._5643_LEVEL, "EJBSQLGenerator", "getEJBBeanCMFields", JeusMessage_EJB9._5643, (Object)frw);
                        }
                        this.cmNPkeyClobFieldRWs.add(frw);
                    } else if (type.equals("BLOB") && this.dbVendor.equals("oracle")) {
                        frw.type = 2004;
                        if (logger.isLoggable(JeusMessage_EJB9._5644_LEVEL)) {
                            logger.logp(JeusMessage_EJB9._5644_LEVEL, "EJBSQLGenerator", "getEJBBeanCMFields", JeusMessage_EJB9._5644, (Object)frw);
                        }
                        this.cmNPkeyBlobFieldRWs.add(frw);
                    } else {
                        frw.type = SQLTypeTable.convertToJDBCType(f.getType());
                        if (logger.isLoggable(JeusMessage_EJB9._5645_LEVEL)) {
                            logger.logp(JeusMessage_EJB9._5645_LEVEL, "EJBSQLGenerator", "getEJBBeanCMFields", JeusMessage_EJB9._5645, (Object)frw);
                        }
                        this.cmNormalFieldRWs.add(frw);
                        if (logger.isLoggable(JeusMessage_EJB9._5646_LEVEL)) {
                            logger.logp(JeusMessage_EJB9._5646_LEVEL, "EJBSQLGenerator", "getEJBBeanCMFields", JeusMessage_EJB9._5646, (Object)frw);
                        }
                        this.cmNPkeyNormalFieldRWs.add(frw);
                    }
                }
                frw.isPrimitive = f.getType().isPrimitive();
                frw.colNames = new String[]{colName};
                frw.typeName = type;
                if (isCmp20) continue;
                frw.fieldObject = f.getFieldObject();
            }
            this.beanPair.setPrimaryKeyFields(orderedCMPkeyFields);
            this.beanPair.setCMFieldTypeIDs(this.getJDBCTypesForFields(this.cmFieldRWs));
        }
        catch (Throwable ex) {
            if (logger.isLoggable(JeusMessage_EJB9._5647_LEVEL)) {
                logger.logp(JeusMessage_EJB9._5647_LEVEL, "EJBSQLGenerator", "getEJBBeanCMFields", JeusMessage_EJB9._5647, ex);
            }
            throw new EJBSQLGeneratorException(JeusMessage_EJB9._5647, ex);
        }
        if (logger.isLoggable(JeusMessage_EJB9._5648_LEVEL)) {
            logger.logp(JeusMessage_EJB9._5648_LEVEL, "EJBSQLGenerator", "getEJBBeanCMFields", JeusMessage_EJB9._5648);
        }
    }

    private String makeDBColumnName(String fieldName) {
        if (logger.isLoggable(JeusMessage_EJB9._5649_LEVEL)) {
            logger.logp(JeusMessage_EJB9._5649_LEVEL, "EJBSQLGenerator", "makeDBColumnName", JeusMessage_EJB9._5649);
        }
        if (fieldName.equals("number")) {
            return "number" + ("number".hashCode() & Integer.MAX_VALUE);
        }
        return fieldName;
    }

    private int[] getJDBCTypesForFields(ArrayList fields) {
        if (logger.isLoggable(JeusMessage_EJB9._5650_LEVEL)) {
            logger.logp(JeusMessage_EJB9._5650_LEVEL, "EJBSQLGenerator", "getJDBCTypesForFields", JeusMessage_EJB9._5650);
        }
        int[] types = new int[fields.size()];
        for (int i = 0; i < fields.size(); ++i) {
            types[i] = ((CMPFieldRW)fields.get((int)i)).type;
        }
        return types;
    }

    private void getPkeyClassFields() throws EJBSQLGeneratorException {
        if (logger.isLoggable(JeusMessage_EJB9._5651_LEVEL)) {
            logger.logp(JeusMessage_EJB9._5651_LEVEL, "EJBSQLGenerator", "getPkeyClassFields", JeusMessage_EJB9._5651);
        }
        try {
            if (this.isPkeyField) {
                if (logger.isLoggable(JeusMessage_EJB9._5652_LEVEL)) {
                    logger.logp(JeusMessage_EJB9._5652_LEVEL, "EJBSQLGenerator", "getPkeyClassFields", JeusMessage_EJB9._5652);
                }
                if (this.cmPkeyFieldRWs.size() != 1) {
                    if (logger.isLoggable(JeusMessage_EJB9._5653_LEVEL)) {
                        logger.logp(JeusMessage_EJB9._5653_LEVEL, "EJBSQLGenerator", "getPkeyClassFields", JeusMessage_EJB9._5653);
                    }
                    throw new EJBSQLGeneratorException(JeusMessage_EJB9._5653);
                }
                ClassFieldRW frw = new ClassFieldRW();
                frw.type = ((CMPFieldRW)this.cmPkeyFieldRWs.get((int)0)).type;
                if (logger.isLoggable(JeusMessage_EJB9._5654_LEVEL)) {
                    logger.logp(JeusMessage_EJB9._5654_LEVEL, "EJBSQLGenerator", "getPkeyClassFields", JeusMessage_EJB9._5654);
                }
                this.pkeyClassFieldRWs.add(frw);
            } else {
                if (logger.isLoggable(JeusMessage_EJB9._5655_LEVEL)) {
                    logger.logp(JeusMessage_EJB9._5655_LEVEL, "EJBSQLGenerator", "getPkeyClassFields", JeusMessage_EJB9._5655);
                }
                List pkeyFields = this.beanPair.getCMPkeyFields();
                for (int i = 0; i < pkeyFields.size(); ++i) {
                    String fieldName = ((CmFieldType)pkeyFields.get(i)).getField();
                    if (logger.isLoggable(JeusMessage_EJB9._5656_LEVEL)) {
                        logger.logp(JeusMessage_EJB9._5656_LEVEL, "EJBSQLGenerator", "getPkeyClassFields", JeusMessage_EJB9._5656, (Object)fieldName);
                    }
                    Field f = this.pkeyClass.getField(fieldName);
                    if (logger.isLoggable(JeusMessage_EJB9._5657_LEVEL)) {
                        logger.logp(JeusMessage_EJB9._5657_LEVEL, "EJBSQLGenerator", "getPkeyClassFields", JeusMessage_EJB9._5657);
                    }
                    if (logger.isLoggable(JeusMessage_EJB9._5658_LEVEL)) {
                        logger.logp(JeusMessage_EJB9._5658_LEVEL, "EJBSQLGenerator", "getPkeyClassFields", JeusMessage_EJB9._5658, (Object)f);
                    }
                    this.pkeyClassFields.add(f);
                    if (logger.isLoggable(JeusMessage_EJB9._5659_LEVEL)) {
                        logger.logp(JeusMessage_EJB9._5659_LEVEL, "EJBSQLGenerator", "getPkeyClassFields", JeusMessage_EJB9._5659, (Object)fieldName);
                    }
                    ClassFieldRW frw = new ClassFieldRW();
                    frw.fieldName = fieldName;
                    frw.type = SQLTypeTable.convertToJDBCType(f.getType());
                    frw.isPrimitive = f.getType().isPrimitive();
                    frw.fieldObject = f;
                    if (logger.isLoggable(JeusMessage_EJB9._5660_LEVEL)) {
                        logger.logp(JeusMessage_EJB9._5660_LEVEL, "EJBSQLGenerator", "getPkeyClassFields", JeusMessage_EJB9._5660, (Object)frw);
                    }
                    this.pkeyClassFieldRWs.add(frw);
                }
            }
        }
        catch (Throwable ex) {
            if (logger.isLoggable(JeusMessage_EJB9._5661_LEVEL)) {
                logger.logp(JeusMessage_EJB9._5661_LEVEL, "EJBSQLGenerator", "getPkeyClassFields", JeusMessage_EJB9._5661, ex);
            }
            throw new EJBSQLGeneratorException(JeusMessage_EJB9._5661, ex);
        }
        if (logger.isLoggable(JeusMessage_EJB9._5662_LEVEL)) {
            logger.logp(JeusMessage_EJB9._5662_LEVEL, "EJBSQLGenerator", "getPkeyClassFields", JeusMessage_EJB9._5662);
        }
    }

    private void getFindMethods() throws EJBSQLGeneratorException {
        if (logger.isLoggable(JeusMessage_EJB9._5663_LEVEL)) {
            logger.logp(JeusMessage_EJB9._5663_LEVEL, "EJBSQLGenerator", "getFindMethods", JeusMessage_EJB9._5663);
        }
        try {
            List findMethods = this.beanPair.getFindMethods();
            for (int i = 0; i < findMethods.size(); ++i) {
                Class[] args;
                String mName;
                block15: {
                    FindMethodPair findMethodPair = (FindMethodPair)findMethods.get(i);
                    mName = findMethodPair.getMethodName();
                    if (logger.isLoggable(JeusMessage_EJB9._5664_LEVEL)) {
                        logger.logp(JeusMessage_EJB9._5664_LEVEL, "EJBSQLGenerator", "getFindMethods", JeusMessage_EJB9._5664, (Object)mName);
                    }
                    if (mName.startsWith("findByPrimaryKey") && this.cmpVersion == 2) {
                        if (!logger.isLoggable(JeusMessage_EJB9._5665_LEVEL)) continue;
                        logger.logp(JeusMessage_EJB9._5665_LEVEL, "EJBSQLGenerator", "getFindMethods", JeusMessage_EJB9._5665);
                        continue;
                    }
                    args = this.getMethodArgs(findMethodPair.getMethodParams());
                    if (mName.startsWith("ejbSelect")) {
                        if (logger.isLoggable(JeusMessage_EJB9._5666_LEVEL)) {
                            logger.logp(JeusMessage_EJB9._5666_LEVEL, "EJBSQLGenerator", "getFindMethods", JeusMessage_EJB9._5666);
                        }
                        this.findMethods.add(this.ejbBeanClass.getMethod(mName, args));
                        if (!logger.isLoggable(JeusMessage_EJB9._5667_LEVEL)) continue;
                        logger.logp(JeusMessage_EJB9._5667_LEVEL, "EJBSQLGenerator", "getFindMethods", JeusMessage_EJB9._5667);
                        continue;
                    }
                    if (this.ejbLocalHomeClass != null) {
                        try {
                            if (logger.isLoggable(JeusMessage_EJB9._5668_LEVEL)) {
                                logger.logp(JeusMessage_EJB9._5668_LEVEL, "EJBSQLGenerator", "getFindMethods", JeusMessage_EJB9._5668);
                            }
                            this.findMethods.add(this.ejbLocalHomeClass.getMethod(mName, args));
                            if (!logger.isLoggable(JeusMessage_EJB9._5669_LEVEL)) continue;
                            logger.logp(JeusMessage_EJB9._5669_LEVEL, "EJBSQLGenerator", "getFindMethods", JeusMessage_EJB9._5669);
                            continue;
                        }
                        catch (NoSuchMethodException e) {
                            if (!logger.isLoggable(JeusMessage_EJB9._5670_LEVEL)) break block15;
                            logger.logp(JeusMessage_EJB9._5670_LEVEL, "EJBSQLGenerator", "getFindMethods", JeusMessage_EJB9._5670);
                        }
                    }
                }
                if (logger.isLoggable(JeusMessage_EJB9._5671_LEVEL)) {
                    logger.logp(JeusMessage_EJB9._5671_LEVEL, "EJBSQLGenerator", "getFindMethods", JeusMessage_EJB9._5671);
                }
                this.findMethods.add(this.ejbHomeClass.getMethod(mName, args));
                if (!logger.isLoggable(JeusMessage_EJB9._5672_LEVEL)) continue;
                logger.logp(JeusMessage_EJB9._5672_LEVEL, "EJBSQLGenerator", "getFindMethods", JeusMessage_EJB9._5672);
            }
        }
        catch (Throwable ex) {
            if (logger.isLoggable(JeusMessage_EJB9._5673_LEVEL)) {
                logger.logp(JeusMessage_EJB9._5673_LEVEL, "EJBSQLGenerator", "getFindMethods", JeusMessage_EJB9._5673, ex);
            }
            throw new EJBSQLGeneratorException(JeusMessage_EJB9._5673, ex);
        }
        if (logger.isLoggable(JeusMessage_EJB9._5674_LEVEL)) {
            logger.logp(JeusMessage_EJB9._5674_LEVEL, "EJBSQLGenerator", "getFindMethods", JeusMessage_EJB9._5674);
        }
    }

    private Class[] getMethodArgs(List argList) throws EJBSQLGeneratorException {
        if (logger.isLoggable(JeusMessage_EJB9._5675_LEVEL)) {
            logger.logp(JeusMessage_EJB9._5675_LEVEL, "EJBSQLGenerator", "getMethodArgs", JeusMessage_EJB9._5675);
        }
        try {
            ArrayList args = new ArrayList();
            for (int i = 0; i < argList.size(); ++i) {
                Class<?> argclass;
                String paramName = (String)argList.get(i);
                if (logger.isLoggable(JeusMessage_EJB9._5676_LEVEL)) {
                    logger.logp(JeusMessage_EJB9._5676_LEVEL, "EJBSQLGenerator", "getMethodArgs", JeusMessage_EJB9._5676, (Object)paramName);
                }
                if ((argclass = this.primitiveClassMapping(paramName)) == null) {
                    argclass = Class.forName(paramName, false, this.loader);
                }
                args.add(argclass);
            }
            if (logger.isLoggable(JeusMessage_EJB9._5677_LEVEL)) {
                logger.logp(JeusMessage_EJB9._5677_LEVEL, "EJBSQLGenerator", "getMethodArgs", JeusMessage_EJB9._5677);
            }
            return args.toArray(new Class[0]);
        }
        catch (Throwable e) {
            if (logger.isLoggable(JeusMessage_EJB9._5678_LEVEL)) {
                logger.logp(JeusMessage_EJB9._5678_LEVEL, "EJBSQLGenerator", "getMethodArgs", JeusMessage_EJB9._5678, e);
            }
            throw new EJBSQLGeneratorException(JeusMessage_EJB9._5678, e);
        }
    }

    private Class primitiveClassMapping(String s) throws Exception {
        if (s.equals("boolean")) {
            return Boolean.TYPE;
        }
        if (s.equals("char")) {
            return Character.TYPE;
        }
        if (s.equals("byte")) {
            return Byte.TYPE;
        }
        if (s.equals("short")) {
            return Short.TYPE;
        }
        if (s.equals("int")) {
            return Integer.TYPE;
        }
        if (s.equals("long")) {
            return Long.TYPE;
        }
        if (s.equals("float")) {
            return Float.TYPE;
        }
        if (s.equals("double")) {
            return Double.TYPE;
        }
        return null;
    }

    private void generateSQL() throws EJBSQLGeneratorException {
        this.sqlBuilder = SQLBuilder.createSQLBuilder(this.dbVendor);
        this.sqlBuilder.setCommonWhereClause(this.cmPkeyFieldRWs);
        if (this.beanPair.isAutoKeyGenerator()) {
            try {
                this.isAutoPK = true;
                this.ejbKeyGenerator = new EJBKeyGenerator(this.beanPair);
                this.ejbKeyGenerator.initKeyGenerator();
            }
            catch (Exception ex) {
                throw new EJBSQLGeneratorException("exception occurred during initialization of key generator", (Throwable)ex);
            }
        }
        if (this.creatingTable != null) {
            this.generateCreateTableSQL();
        }
        if (this.creatingTable != null && this.creatingTable.getForceCreatingTable() != null || this.deletingTable) {
            this.generateDeleteTableSQL();
        }
        this.generateEJBCreateSQL();
        this.generateEJBRemoveSQL();
        this.generateEJBLoadSQL();
        this.generateEJBStoreSQL();
        this.generateEJBFindSQLs();
        this.generateCachingSQL();
        this.generateEJBTableCheckSQL();
    }

    private void checkColumnSharing() throws EJBSQLGeneratorException {
        if (logger.isLoggable(JeusMessage_EJB9._5679_LEVEL)) {
            logger.logp(JeusMessage_EJB9._5679_LEVEL, "EJBSQLGenerator", "checkColumnSharing", JeusMessage_EJB9._5679);
        }
        Hashtable columnShare = new Hashtable();
        ArrayList<CMRFieldRW> sharedReadOnlyCMRFieldRWList = new ArrayList<CMRFieldRW>();
        for (int i = 0; i < this.bSchema.relations.size(); ++i) {
            int j;
            CMPFieldRW cmpFieldRW;
            RelationshipRolePair relation = (RelationshipRolePair)this.bSchema.relations.elementAt(i);
            if (!relation.isManagedRelationType()) continue;
            CMRFieldRW fieldRW = relation.getFieldRW();
            Integer cmrFieldID = new Integer(fieldRW.getIndex());
            ArrayList<Integer> list = null;
            ArrayList<CMPFieldRW> cmpFieldRWs = null;
            String[] fkeyColNames = relation.getFkeyColNames();
            for (int j2 = 0; j2 < fkeyColNames.length; ++j2) {
                for (int k = 0; k < this.cmFieldRWs.size(); ++k) {
                    cmpFieldRW = (CMPFieldRW)this.cmFieldRWs.get(k);
                    if (!fkeyColNames[j2].equals(cmpFieldRW.getColName())) continue;
                    if (!cmpFieldRW.isPrimaryKeyField() && cmpFieldRW.isPrimitive()) {
                        if (logger.isLoggable(JeusMessage_EJB9._5680_LEVEL)) {
                            logger.logp(JeusMessage_EJB9._5680_LEVEL, "EJBSQLGenerator", "checkColumnSharing", JeusMessage_EJB9._5680, new Object[]{cmpFieldRW.fieldName, relation.getCMRFieldName()});
                        }
                        throw new EJBSQLGeneratorException("Primitive type cmp fields cannot be shared with a cmr field : " + cmpFieldRW.fieldName + ", " + relation.getCMRFieldName());
                    }
                    if (list == null) {
                        list = new ArrayList<Integer>();
                        columnShare.put(cmrFieldID, list);
                        cmpFieldRWs = new ArrayList<CMPFieldRW>();
                    }
                    list.add(new Integer(k));
                    cmpFieldRWs.add(cmpFieldRW);
                }
            }
            if (list == null) continue;
            if (list.size() != fkeyColNames.length) {
                throw new EJBSQLGeneratorException(JeusMessage_EJB11._7133, relation.getCMRFieldName());
            }
            if (!fieldRW.isSharableWithCMPField()) {
                throw new EJBSQLGeneratorException("CMR field whose primary key field type is a primitive type cannot be shared with CMP field : " + relation.getCMRFieldName());
            }
            boolean isPrimaryKeyField = ((CMPFieldRW)cmpFieldRWs.get(0)).isPrimaryKeyField();
            for (j = 1; j < cmpFieldRWs.size(); ++j) {
                cmpFieldRW = (CMPFieldRW)cmpFieldRWs.get(j);
                if (!cmpFieldRW.isPrimaryKeyField()) continue;
                if (!isPrimaryKeyField) {
                    throw new EJBSQLGeneratorException("If a cmp field shared with a cmr field is a primary key field, all cmp fields should be primary key fields : " + cmpFieldRW.fieldName + ", " + relation.getCMRFieldName());
                }
                if (!isPrimaryKeyField) continue;
                throw new EJBSQLGeneratorException("If a cmp field shared with a cmr field is a non-primary key field, all cmp fields should be non-primary key fields : " + cmpFieldRW.fieldName + ", " + relation.getCMRFieldName());
            }
            if (fieldRW.isCollection) {
                throw new EJBSQLGeneratorException("A collection-valued cmr field cannot be shared with cmp fields : " + fieldRW.fieldName);
            }
            fieldRW.setSharedCMPFieldRWIndex(cmpFieldRWs);
            if (isPrimaryKeyField) {
                fieldRW.setReadOnly();
                sharedReadOnlyCMRFieldRWList.add(fieldRW);
                continue;
            }
            if (JeusEJBProperties.ALLOW_MODIFY_SHARED_CMP_CMR) continue;
            for (j = 1; j < cmpFieldRWs.size(); ++j) {
                cmpFieldRW = (CMPFieldRW)cmpFieldRWs.get(j);
                cmpFieldRW.setReadOnly();
            }
        }
        for (int k = 0; k < this.cmFieldRWs.size(); ++k) {
            ((CMPFieldRWForCMP20)this.cmFieldRWs.get(k)).setSharedCMRFieldIndex(columnShare);
        }
        this.sharedReadOnlyCMRFieldRWs = sharedReadOnlyCMRFieldRWList.toArray(CMRFieldRW.dummyArray);
    }

    private void generateCreateTableSQL() throws EJBSQLGeneratorException {
        if (logger.isLoggable(JeusMessage_EJB9._5681_LEVEL)) {
            logger.logp(JeusMessage_EJB9._5681_LEVEL, "EJBSQLGenerator", "generateCreateTableSQL", JeusMessage_EJB9._5681);
        }
        try {
            this.tableCreator = this.factory.createEJBTableCreator();
            this.tableCreator.initTableCreator(this);
        }
        catch (Throwable ex) {
            if (logger.isLoggable(JeusMessage_EJB9._5682_LEVEL)) {
                logger.logp(JeusMessage_EJB9._5682_LEVEL, "EJBSQLGenerator", "generateCreateTableSQL", JeusMessage_EJB9._5682, ex);
            }
            throw new EJBSQLGeneratorException(JeusMessage_EJB9._5682, ex);
        }
        if (logger.isLoggable(JeusMessage_EJB9._5683_LEVEL)) {
            logger.logp(JeusMessage_EJB9._5683_LEVEL, "EJBSQLGenerator", "generateCreateTableSQL", JeusMessage_EJB9._5683);
        }
    }

    private void generateDeleteTableSQL() throws EJBSQLGeneratorException {
        if (logger.isLoggable(JeusMessage_EJB9._5684_LEVEL)) {
            logger.logp(JeusMessage_EJB9._5684_LEVEL, "EJBSQLGenerator", "generateDeleteTableSQL", JeusMessage_EJB9._5684);
        }
        try {
            this.tableRemover = this.factory.createEJBTableRemover();
            this.tableRemover.initTableRemover(this);
        }
        catch (Throwable ex) {
            if (logger.isLoggable(JeusMessage_EJB9._5685_LEVEL)) {
                logger.logp(JeusMessage_EJB9._5685_LEVEL, "EJBSQLGenerator", "generateDeleteTableSQL", JeusMessage_EJB9._5685, ex);
            }
            throw new EJBSQLGeneratorException(JeusMessage_EJB9._5685, ex);
        }
        if (logger.isLoggable(JeusMessage_EJB9._5686_LEVEL)) {
            logger.logp(JeusMessage_EJB9._5686_LEVEL, "EJBSQLGenerator", "generateDeleteTableSQL", JeusMessage_EJB9._5686);
        }
    }

    private void generateEJBLoadSQL() throws EJBSQLGeneratorException {
        if (logger.isLoggable(JeusMessage_EJB9._5687_LEVEL)) {
            logger.logp(JeusMessage_EJB9._5687_LEVEL, "EJBSQLGenerator", "generateEJBLoadSQL", JeusMessage_EJB9._5687);
        }
        try {
            this.ejbLoader = this.factory.createEJBLoader();
            this.ejbLoader.cmPkeyFieldRWs = this.cmPkeyFieldRWs.toArray(CMPFieldRW.dummyArray);
            this.ejbLoader.cmNPkeyFieldRWs = this.cmNPkeyFieldRWs.toArray(CMPFieldRW.dummyArray);
            this.ejbLoader.initLoader(this);
        }
        catch (Throwable ex) {
            if (logger.isLoggable(JeusMessage_EJB9._5688_LEVEL)) {
                logger.logp(JeusMessage_EJB9._5688_LEVEL, "EJBSQLGenerator", "generateEJBLoadSQL", JeusMessage_EJB9._5688, ex);
            }
            throw new EJBSQLGeneratorException(JeusMessage_EJB9._5688, ex);
        }
        if (logger.isLoggable(JeusMessage_EJB9._5689_LEVEL)) {
            logger.logp(JeusMessage_EJB9._5689_LEVEL, "EJBSQLGenerator", "generateEJBLoadSQL", JeusMessage_EJB9._5689);
        }
    }

    private void generateEJBStoreSQL() throws EJBSQLGeneratorException {
        if (logger.isLoggable(JeusMessage_EJB9._5690_LEVEL)) {
            logger.logp(JeusMessage_EJB9._5690_LEVEL, "EJBSQLGenerator", "generateEJBStoreSQL", JeusMessage_EJB9._5690);
        }
        try {
            this.ejbStorer = this.factory.createEJBStorer();
            ArrayList<CMRFieldRW> fieldRWlist = new ArrayList<CMRFieldRW>(this.cmNPkeyNormalFieldRWs);
            if (this.cmpVersion == 2) {
                for (int i = 0; i < this.bSchema.relations.size(); ++i) {
                    RelationshipRolePair relation = (RelationshipRolePair)this.bSchema.relations.elementAt(i);
                    if (!relation.isManagedRelationType()) continue;
                    fieldRWlist.add(relation.getFieldRW());
                }
            }
            this.ejbStorer.cmNPkeyNormalFieldRWsInBeanTable = fieldRWlist.toArray(new FieldRW[0]);
            this.ejbStorer.cmNPkeyClobFieldRWs = this.cmNPkeyClobFieldRWs.toArray(CMPFieldRW.dummyArray);
            this.ejbStorer.cmNPkeyBlobFieldRWs = this.cmNPkeyBlobFieldRWs.toArray(CMPFieldRW.dummyArray);
            this.ejbStorer.cmPkeyFieldRWs = this.cmPkeyFieldRWs.toArray(CMPFieldRW.dummyArray);
            if (this.cmpVersion == 2) {
                ArrayList<CMRFieldRW> relationFieldRWs = new ArrayList<CMRFieldRW>();
                for (int i = 0; i < this.bSchema.relations.size(); ++i) {
                    RelationshipRolePair relation = (RelationshipRolePair)this.bSchema.relations.elementAt(i);
                    if (!relation.isManagedJoinRelation()) continue;
                    relation = (RelationshipRolePair)this.bSchema.relations.elementAt(i);
                    relationFieldRWs.add(relation.getFieldRW());
                }
                this.ejbStorer.joinRelationFieldRWs = relationFieldRWs.toArray(CMRFieldRW.dummyArray);
            }
            this.ejbStorer.initStorer(this);
        }
        catch (Throwable ex) {
            if (logger.isLoggable(JeusMessage_EJB9._5691_LEVEL)) {
                logger.logp(JeusMessage_EJB9._5691_LEVEL, "EJBSQLGenerator", "generateEJBStoreSQL", JeusMessage_EJB9._5691, ex);
            }
            throw new EJBSQLGeneratorException(JeusMessage_EJB9._5691, ex);
        }
        if (logger.isLoggable(JeusMessage_EJB9._5692_LEVEL)) {
            logger.logp(JeusMessage_EJB9._5692_LEVEL, "EJBSQLGenerator", "generateEJBStoreSQL", JeusMessage_EJB9._5692);
        }
    }

    private void generateEJBCreateSQL() throws EJBSQLGeneratorException {
        if (logger.isLoggable(JeusMessage_EJB9._5693_LEVEL)) {
            logger.logp(JeusMessage_EJB9._5693_LEVEL, "EJBSQLGenerator", "generateEJBCreateSQL", JeusMessage_EJB9._5693);
        }
        try {
            this.ejbCreator = this.factory.createEJBCreator();
            if (this.cmNPkeyClobFieldRWs.size() != 0 || this.cmNPkeyBlobFieldRWs.size() != 0) {
                this.ejbCreator.cmPkeyFieldRWs = this.cmPkeyFieldRWs.toArray(CMPFieldRW.dummyArray);
            }
            this.ejbCreator.cmNPkeyClobFieldRWs = this.cmNPkeyClobFieldRWs.toArray(CMPFieldRW.dummyArray);
            this.ejbCreator.cmNPkeyBlobFieldRWs = this.cmNPkeyBlobFieldRWs.toArray(CMPFieldRW.dummyArray);
            if (this.cmpVersion == 2) {
                ArrayList<CMRFieldRW> cmrFieldList = new ArrayList<CMRFieldRW>();
                for (int i = 0; i < this.bSchema.relations.size(); ++i) {
                    RelationshipRolePair relation = (RelationshipRolePair)this.bSchema.relations.elementAt(i);
                    if (!relation.isManagedRelationType()) continue;
                    cmrFieldList.add(relation.getFieldRW());
                }
                this.ejbCreator.managableCMRFieldList = cmrFieldList.toArray(CMRFieldRW.dummyArray);
            }
            this.ejbCreator.cmNormalFieldRWs = this.isAutoPK && !this.ejbKeyGenerator.isGenKeyBeforeInsert() ? this.cmNPkeyNormalFieldRWs.toArray(CMPFieldRW.dummyArray) : this.cmNormalFieldRWs.toArray(CMPFieldRW.dummyArray);
            this.ejbCreator.initCreator(this);
        }
        catch (Throwable ex) {
            if (logger.isLoggable(JeusMessage_EJB9._5694_LEVEL)) {
                logger.logp(JeusMessage_EJB9._5694_LEVEL, "EJBSQLGenerator", "generateEJBCreateSQL", JeusMessage_EJB9._5694, ex);
            }
            throw new EJBSQLGeneratorException(JeusMessage_EJB9._5694, ex);
        }
        if (logger.isLoggable(JeusMessage_EJB9._5695_LEVEL)) {
            logger.logp(JeusMessage_EJB9._5695_LEVEL, "EJBSQLGenerator", "generateEJBCreateSQL", JeusMessage_EJB9._5695);
        }
    }

    private void generateEJBRemoveSQL() throws EJBSQLGeneratorException {
        if (logger.isLoggable(JeusMessage_EJB9._5696_LEVEL)) {
            logger.logp(JeusMessage_EJB9._5696_LEVEL, "EJBSQLGenerator", "generateEJBRemoveSQL", JeusMessage_EJB9._5696);
        }
        try {
            this.ejbRemover = this.factory.createEJBRemover();
            this.ejbRemover.cmPkeyFIeldRWs = this.cmPkeyFieldRWs.toArray(CMPFieldRW.dummyArray);
            this.ejbRemover.initRemover(this);
        }
        catch (Throwable ex) {
            if (logger.isLoggable(JeusMessage_EJB9._5697_LEVEL)) {
                logger.logp(JeusMessage_EJB9._5697_LEVEL, "EJBSQLGenerator", "generateEJBRemoveSQL", JeusMessage_EJB9._5697, ex);
            }
            throw new EJBSQLGeneratorException(JeusMessage_EJB9._5697, ex);
        }
        if (logger.isLoggable(JeusMessage_EJB9._5698_LEVEL)) {
            logger.logp(JeusMessage_EJB9._5698_LEVEL, "EJBSQLGenerator", "generateEJBRemoveSQL", JeusMessage_EJB9._5698);
        }
    }

    private void generateEJBFindSQLs() throws EJBSQLGeneratorException {
        if (logger.isLoggable(JeusMessage_EJB9._5699_LEVEL)) {
            logger.logp(JeusMessage_EJB9._5699_LEVEL, "EJBSQLGenerator", "generateEJBFindSQLs", JeusMessage_EJB9._5699);
        }
        try {
            this.ejbFinder = this.factory.createEJBFinder();
            this.ejbFinder.findMethods = this.findMethods.toArray(new Method[0]);
            this.ejbFinder.isPkeyField = this.isPkeyField;
            this.ejbFinder.pkeyClassFieldRWs = this.pkeyClassFieldRWs.toArray(ClassFieldRW.dummyArray);
            this.ejbFinder.pkeyClass = this.pkeyClass;
            this.ejbFinder.initFinder(this);
        }
        catch (Throwable ex) {
            if (logger.isLoggable(JeusMessage_EJB9._5700_LEVEL)) {
                logger.logp(JeusMessage_EJB9._5700_LEVEL, "EJBSQLGenerator", "generateEJBFindSQLs", JeusMessage_EJB9._5700, ex);
            }
            throw new EJBSQLGeneratorException(JeusMessage_EJB9._5700, ex);
        }
        if (logger.isLoggable(JeusMessage_EJB9._5701_LEVEL)) {
            logger.logp(JeusMessage_EJB9._5701_LEVEL, "EJBSQLGenerator", "generateEJBFindSQLs", JeusMessage_EJB9._5701);
        }
    }

    private void generateCachingSQL() throws EJBSQLGeneratorException {
        if (logger.isLoggable(JeusMessage_EJB9._5702_LEVEL)) {
            logger.logp(JeusMessage_EJB9._5702_LEVEL, "EJBSQLGenerator", "generateCachingSQL", JeusMessage_EJB9._5702);
        }
        this.ejbCacher = this.factory.createEJBCacher();
        this.ejbCacher.cmFieldRWs = this.cmFieldRWs.toArray(CMPFieldRW.dummyArray);
        this.ejbCacher.cmPkeyFieldRWs = this.cmPkeyFieldRWs.toArray(CMPFieldRW.dummyArray);
        this.ejbCacher.pkeyClassFieldRWs = this.pkeyClassFieldRWs.toArray(ClassFieldRW.dummyArray);
        this.ejbCacher.isPkeyField = this.isPkeyField;
        this.ejbCacher.pkeyClass = this.pkeyClass;
        this.ejbCacher.initCacher(this);
        if (logger.isLoggable(JeusMessage_EJB9._5703_LEVEL)) {
            logger.logp(JeusMessage_EJB9._5703_LEVEL, "EJBSQLGenerator", "generateCachingSQL", JeusMessage_EJB9._5703);
        }
    }

    private void generateEJBTableCheckSQL() {
        if (logger.isLoggable(JeusMessage_EJB9._5704_LEVEL)) {
            logger.logp(JeusMessage_EJB9._5704_LEVEL, "EJBSQLGenerator", "generateEJBTableCheckSQL", JeusMessage_EJB9._5704);
        }
        this.ejbTableChecker = this.factory.createEJBTableChecker();
        this.ejbTableChecker.cmFieldRWs = this.cmFieldRWs.toArray(CMPFieldRW.dummyArray);
        this.ejbTableChecker.beanTableName = this.tableName;
        this.ejbTableChecker.initTableChecker(this);
        if (logger.isLoggable(JeusMessage_EJB9._5705_LEVEL)) {
            logger.logp(JeusMessage_EJB9._5705_LEVEL, "EJBSQLGenerator", "generateEJBTableCheckSQL", JeusMessage_EJB9._5705);
        }
    }

    private void updateEJBDBInfo() {
        this.beanPair.setCMFieldsForContainer(this.cmFields);
        this.beanPair.setCMPkeyFieldsForContainer(this.cmPkeyFields);
        this.beanPair.setFindSQLsForContainer(this.findSQLs);
        this.beanPair.setSharedReadOnlyCMRFieldRWsForContainer(this.sharedReadOnlyCMRFieldRWs);
        this.beanPair.setEJBTableCreatorForContainer(this.tableCreator);
        this.beanPair.setEJBTableRemoverForContainer(this.tableRemover);
        this.beanPair.setEJBCreatorForContainer(this.ejbCreator);
        this.beanPair.setEJBLoaderForContainer(this.ejbLoader);
        this.beanPair.setEJBStorerForContainer(this.ejbStorer);
        this.beanPair.setEJBRemoverForContainer(this.ejbRemover);
        this.beanPair.setEJBFinderForContainer(this.ejbFinder);
        this.beanPair.setEJBCacherForContainer(this.ejbCacher);
        this.beanPair.setEJBTableCheckerForContainer(this.ejbTableChecker);
        this.beanPair.setEJBKeyGeneratorForContainer(this.ejbKeyGenerator);
    }

    public FieldRW getFieldRWByFieldName(String methodName) {
        int i;
        for (i = 0; i < this.cmFieldRWs.size(); ++i) {
            CMPFieldRW fieldRW = (CMPFieldRW)this.cmFieldRWs.get(i);
            if (!fieldRW.fieldName.equals(methodName)) continue;
            return fieldRW;
        }
        for (i = 0; i < this.bSchema.relations.size(); ++i) {
            RelationshipRolePair relation = (RelationshipRolePair)this.bSchema.relations.elementAt(i);
            if (!relation.isManagedRelationType()) continue;
            CMRFieldRW fieldRW = relation.getFieldRW();
            if (!fieldRW.fieldName.equals(methodName)) continue;
            return fieldRW;
        }
        return null;
    }

    public int getCMFieldIndex(Object o) {
        return 0;
    }
}

