/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.schema;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.ejb.EntityBean;
import jeus.ejb.container.ContainerException;
import jeus.ejb.persistence.database.SQLBuilder;
import jeus.ejb.schema.CMPFieldRW;
import jeus.ejb.schema.CMRFieldRW;
import jeus.ejb.schema.EJBSQLGenerator;
import jeus.ejb.schema.EJBSQLGeneratorException;
import jeus.ejb.schema.FieldRW;
import jeus.util.Serializer;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_EJB12;
import jeus.util.message.JeusMessage_EJB9;
import oracle.sql.BLOB;
import oracle.sql.CLOB;

public abstract class EJBStorer {
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.ejb.schema.storer");
    public CMRFieldRW[] joinRelationFieldRWs;
    public FieldRW[] cmNPkeyNormalFieldRWsInBeanTable;
    public CMPFieldRW[] cmNPkeyClobFieldRWs;
    public CMPFieldRW[] cmNPkeyBlobFieldRWs;
    public SQLBuilder BlobClobSelectorBuilder;
    public String BlobClobSelectorTailSQL;
    public CMPFieldRW[] cmPkeyFieldRWs;
    protected PreparedStatement stat;
    public SQLBuilder ejbStoreBuilder;

    protected void setBlobClobSelectorBuilder(EJBSQLGenerator generator) {
        this.BlobClobSelectorBuilder = (SQLBuilder)generator.sqlBuilder.clone();
        this.BlobClobSelectorBuilder.initSelectSQL();
        this.BlobClobSelectorBuilder.mark();
        SQLBuilder BlobClobSelectorTailBuilder = (SQLBuilder)generator.sqlBuilder.clone();
        BlobClobSelectorTailBuilder.initEmpty();
        BlobClobSelectorTailBuilder.beginFromClause();
        BlobClobSelectorTailBuilder.setTableName(generator.tableName);
        BlobClobSelectorTailBuilder.finishFromClause();
        BlobClobSelectorTailBuilder.addCommonWhereClause();
        BlobClobSelectorTailBuilder.addForUpdate();
        this.BlobClobSelectorTailSQL = BlobClobSelectorTailBuilder.getSQL();
    }

    public abstract void store(EntityBean var1, Connection var2) throws ContainerException;

    public abstract void initStorer(EJBSQLGenerator var1) throws EJBSQLGeneratorException;

    protected void setUpdateBuilder(EJBSQLGenerator generator) {
        generator.sqlBuilder.initUpdateSQL();
        generator.sqlBuilder.setTableName(generator.tableName);
        generator.sqlBuilder.beginSetClause();
        generator.sqlBuilder.mark();
        this.ejbStoreBuilder = (SQLBuilder)generator.sqlBuilder.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void storeBLOBCLOB(EntityBean ejbBean, Connection con, boolean[] modified, SQLBuilder storeBuilder) throws ContainerException {
        this.stat = null;
        try {
            SQLBuilder bcSelectorBuilder = (SQLBuilder)this.BlobClobSelectorBuilder.clone();
            ArrayList modifiedBlobFields = new ArrayList();
            ArrayList modifiedBlobObjects = new ArrayList();
            this.setModifiedBlob(ejbBean, this.cmNPkeyBlobFieldRWs, modified, modifiedBlobFields, modifiedBlobObjects, bcSelectorBuilder);
            ArrayList modifiedClobFields = new ArrayList();
            ArrayList modifiedClobObjects = new ArrayList();
            this.setModifiedClob(ejbBean, this.cmNPkeyClobFieldRWs, modified, modifiedClobFields, modifiedClobObjects, bcSelectorBuilder);
            if (bcSelectorBuilder.getCurrentElement() == 0) {
                return;
            }
            boolean flag = false;
            if (con.getAutoCommit()) {
                flag = true;
                con.setAutoCommit(false);
            }
            try {
                ResultSet rs = this.executeBlobClobSelectSQL(con, ejbBean, bcSelectorBuilder);
                if (rs.next()) {
                    int i;
                    Blob[] modifiedBlobReferences = null;
                    ArrayList blobIndexlistForReSelectNeed = null;
                    Clob[] modifiedClobReferences = null;
                    ArrayList clobIndexlistForReSelectNeed = null;
                    if (modifiedBlobObjects.size() > 0) {
                        modifiedBlobReferences = new Blob[modifiedBlobObjects.size()];
                        blobIndexlistForReSelectNeed = new ArrayList();
                        this.getModifiedBlobReferences(modifiedBlobFields, modifiedBlobObjects, modifiedBlobReferences, blobIndexlistForReSelectNeed, rs, 1, bcSelectorBuilder, storeBuilder);
                    }
                    if (modifiedClobObjects.size() > 0) {
                        modifiedClobReferences = new Clob[modifiedClobObjects.size()];
                        clobIndexlistForReSelectNeed = new ArrayList();
                        this.getModifiedClobReferences(modifiedClobFields, modifiedClobObjects, modifiedClobReferences, clobIndexlistForReSelectNeed, rs, modifiedBlobObjects.size() + 1, bcSelectorBuilder, storeBuilder);
                    }
                    if (storeBuilder.getCurrentElement() > 0) {
                        storeBuilder.finishSetClause();
                        storeBuilder.addCommonWhereClause();
                        String updateSql = storeBuilder.getSQL();
                        storeBuilder.reset();
                        if (logger.isLoggable(JeusMessage_EJB9._5752_LEVEL)) {
                            logger.log(JeusMessage_EJB9._5752_LEVEL, JeusMessage_EJB9._5752, (Object)updateSql);
                        }
                        this.executeUpdateBlobClobSQL(con, updateSql, ejbBean);
                    }
                    if (bcSelectorBuilder.getCurrentElement() > 0) {
                        int i2;
                        ResultSet rss = this.executeBlobClobSelectSQL(con, ejbBean, bcSelectorBuilder);
                        rss.next();
                        if (blobIndexlistForReSelectNeed != null) {
                            for (i2 = 0; i2 < blobIndexlistForReSelectNeed.size(); ++i2) {
                                modifiedBlobReferences[((Integer)blobIndexlistForReSelectNeed.get((int)i2)).intValue()] = rss.getBlob(i2 + 1);
                            }
                        }
                        if (clobIndexlistForReSelectNeed != null) {
                            for (i2 = 0; i2 < clobIndexlistForReSelectNeed.size(); ++i2) {
                                modifiedClobReferences[((Integer)clobIndexlistForReSelectNeed.get((int)i2)).intValue()] = rss.getClob(i2 + blobIndexlistForReSelectNeed.size());
                            }
                        }
                    }
                    for (i = 0; i < modifiedBlobObjects.size(); ++i) {
                        if (modifiedBlobReferences[i] == null) {
                            throw new SQLException(" Could not get java.sql.Blob to write");
                        }
                        OutputStream os = ((BLOB)modifiedBlobReferences[i]).getBinaryOutputStream();
                        try {
                            os.write((byte[])modifiedBlobObjects.get(i));
                            os.flush();
                            continue;
                        }
                        finally {
                            os.close();
                        }
                    }
                    for (i = 0; i < modifiedClobObjects.size(); ++i) {
                        if (modifiedClobReferences[i] == null) {
                            throw new SQLException(" Could not get java.sql.Clob to write");
                        }
                        Writer writer = ((CLOB)modifiedClobReferences[i]).getCharacterOutputStream();
                        try {
                            writer.write((char[])modifiedClobObjects.get(i));
                            writer.flush();
                            continue;
                        }
                        finally {
                            writer.close();
                        }
                    }
                } else {
                    throw new SQLException(" Could not get java.sql.Blob or java.sql.Clob to write");
                }
                if (flag) {
                    con.commit();
                    con.setAutoCommit(true);
                }
            }
            catch (Throwable t) {
                if (flag && this.stat != null) {
                    con.rollback();
                }
                throw t;
            }
            finally {
                if (this.stat != null) {
                    try {
                        this.stat.close();
                    }
                    catch (Throwable t) {}
                }
            }
        }
        catch (ContainerException e) {
            throw e;
        }
        catch (Throwable ex) {
            if (logger.isLoggable(JeusMessage_EJB9._5751_LEVEL)) {
                logger.logp(JeusMessage_EJB9._5751_LEVEL, "EJBStorer", "storeBLOBCLOB", JeusMessage_EJB9._5751, ex);
            }
            throw new ContainerException(JeusMessage_EJB9._5751, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeUpdateBlobClobSQL(Connection con, String updateSql, EntityBean ejbBean) throws Exception {
        PreparedStatement stat = con.prepareStatement(updateSql);
        for (int i = 0; i < this.cmPkeyFieldRWs.length; ++i) {
            this.cmPkeyFieldRWs[i].setToDBStatement(ejbBean, stat, i + 1);
        }
        try {
            stat.execute();
        }
        finally {
            try {
                stat.close();
            }
            catch (Throwable t) {}
        }
    }

    private ResultSet executeBlobClobSelectSQL(Connection con, EntityBean ejbBean, SQLBuilder builder) throws Exception {
        builder.merge(this.BlobClobSelectorTailSQL);
        String BlobClobSelectSQL = builder.getSQL();
        builder.reset();
        try {
            this.stat = con.prepareStatement(BlobClobSelectSQL);
            for (int i = 0; i < this.cmPkeyFieldRWs.length; ++i) {
                try {
                    this.cmPkeyFieldRWs[i].setToDBStatement(ejbBean, this.stat, i + 1);
                    continue;
                }
                catch (Exception ex) {
                    if (logger.isLoggable(JeusMessage_EJB12._9095_LEVEL)) {
                        logger.log(JeusMessage_EJB12._9095_LEVEL, JeusMessage_EJB12._9095, (Object)this.cmPkeyFieldRWs[i]);
                    }
                    throw ex;
                }
            }
            ResultSet rs = this.stat.executeQuery();
            return rs;
        }
        catch (Exception ex) {
            if (logger.isLoggable(JeusMessage_EJB12._9096_LEVEL)) {
                logger.log(JeusMessage_EJB12._9096_LEVEL, JeusMessage_EJB12._9096, (Object)BlobClobSelectSQL);
            }
            throw ex;
        }
    }

    private void getModifiedBlobReferences(ArrayList fieldRWs, ArrayList modifiedObjects, Blob[] modifiedReferences, ArrayList reselectList, ResultSet rs, int initIndex, SQLBuilder builder, SQLBuilder storeBuilder) throws SQLException {
        for (int j = 0; j < modifiedReferences.length; ++j) {
            modifiedReferences[j] = rs.getBlob(j + initIndex);
            byte[] buf = (byte[])modifiedObjects.get(j);
            if (modifiedReferences[j] != null && buf != null && modifiedReferences[j].length() <= (long)buf.length) continue;
            CMPFieldRW field = (CMPFieldRW)fieldRWs.get(j);
            storeBuilder.addSetColumn(field.getColName(), "EMPTY_BLOB()");
            if (buf == null) continue;
            builder.addColumnName(field.getColName());
            reselectList.add(new Integer(j));
        }
    }

    private void getModifiedClobReferences(ArrayList fieldRWs, ArrayList modifiedObjects, Clob[] modifiedReferences, ArrayList reselectList, ResultSet rs, int initIndex, SQLBuilder builder, SQLBuilder storeBuilder) throws SQLException {
        for (int j = 0; j < modifiedReferences.length; ++j) {
            modifiedReferences[j] = rs.getClob(j + initIndex);
            char[] buf = (char[])modifiedObjects.get(j);
            if (modifiedReferences[j] != null && buf != null && modifiedReferences[j].length() <= (long)buf.length) continue;
            CMPFieldRW field = (CMPFieldRW)fieldRWs.get(j);
            storeBuilder.addSetColumn(field.getColName(), "EMPTY_CLOB()");
            if (buf == null) continue;
            builder.addColumnName(field.getColName());
            reselectList.add(new Integer(j));
        }
    }

    private void setModifiedBlob(EntityBean ejbBean, CMPFieldRW[] fieldRWs, boolean[] modified, ArrayList modifiedBlobFields, ArrayList modifiedBlobObjects, SQLBuilder builder) throws IOException {
        for (int i = 0; i < fieldRWs.length; ++i) {
            CMPFieldRW field = fieldRWs[i];
            if (modified != null && !modified[field.getIndex()]) continue;
            Object content = field.getFieldContent(ejbBean);
            byte[] buf = null;
            Serializer serial = new Serializer();
            if (content != null) {
                buf = serial.serialize(content);
            }
            modifiedBlobFields.add(field);
            modifiedBlobObjects.add(buf);
            builder.addColumnName(field.getColName());
        }
    }

    private void setModifiedClob(EntityBean ejbBean, CMPFieldRW[] fieldRWs, boolean[] modified, ArrayList modifiedClobFields, ArrayList modifiedClobObjects, SQLBuilder builder) {
        for (int i = 0; i < fieldRWs.length; ++i) {
            CMPFieldRW field = fieldRWs[i];
            if (modified != null && !modified[field.getIndex()]) continue;
            String content = (String)field.getFieldContent(ejbBean);
            char[] buf = content.toCharArray();
            modifiedClobFields.add(field);
            modifiedClobObjects.add(buf);
            builder.addColumnName(field.getColName());
        }
    }
}

