/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.schema;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import jeus.ejb.container.ContainerException;
import jeus.ejb.container.RelationManager;
import jeus.ejb.persistence.database.SQLBuilder;
import jeus.ejb.schema.CMPFieldRW;
import jeus.ejb.schema.EJBSQLGenerator;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_EJB9;

public abstract class EJBTableChecker {
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.ejb.schema.tableChecker");
    protected CMPFieldRW[] cmFieldRWs;
    protected String beanTableName;
    protected SQLBuilder sqlBuilder;

    public void initTableChecker(EJBSQLGenerator generator) {
        this.sqlBuilder = (SQLBuilder)generator.sqlBuilder.clone();
    }

    public abstract void checkTable(Connection var1, RelationManager var2) throws Exception;

    protected void checkExistenceOfColumns(Statement stat) throws SQLException {
        this.sqlBuilder.initEmpty();
        this.sqlBuilder.beginFromClause();
        this.sqlBuilder.setTableName(this.beanTableName);
        this.sqlBuilder.finishFromClause();
        this.sqlBuilder.beginWhereClause();
        this.sqlBuilder.addString("1 = 0");
        this.sqlBuilder.finishWhereClause();
        String tail = this.sqlBuilder.getSQL();
        this.sqlBuilder.initSelectSQL();
        this.sqlBuilder.mark();
        for (int i = 0; i < this.cmFieldRWs.length; ++i) {
            this.sqlBuilder.addColumnName(this.cmFieldRWs[i].getColName());
            String sql = this.sqlBuilder.merge(tail).getSQL();
            this.sqlBuilder.reset();
            ResultSet result = stat.executeQuery(sql);
            result.close();
        }
    }

    protected void checkExistenceOfTable(Connection con, String table) throws ContainerException {
        try {
            this.sqlBuilder.initSelectSQL();
            this.sqlBuilder.addAsteriskToListIfNeeded();
            this.sqlBuilder.beginFromClause();
            this.sqlBuilder.setTableName(table);
            this.sqlBuilder.finishFromClause();
            this.sqlBuilder.beginWhereClause();
            this.sqlBuilder.addString("1 = 0");
            this.sqlBuilder.finishWhereClause();
            Statement stat = con.createStatement();
            stat.setFetchSize(1);
            ResultSet result = stat.executeQuery(this.sqlBuilder.getSQL());
            result.close();
            stat.close();
        }
        catch (Throwable ex) {
            throw new ContainerException(JeusMessage_EJB9._5801, table, ex);
        }
    }
}

