/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.schema;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import javax.xml.bind.JAXBException;
import jeus.deploy.archivist.FileArchive;
import jeus.ejb.container.RelationManager;
import jeus.ejb.ejbserver.EJBServerException;
import jeus.ejb.ejbserver.FailedBeanInfo;
import jeus.ejb.schema.BeanSchema;
import jeus.ejb.schema.CMRFieldRW;
import jeus.ejb.schema.ClassFieldRW;
import jeus.ejb.schema.EJBSQLGenerator;
import jeus.ejb.schema.cmp20.EJBDynamicFinder;
import jeus.ejb.util.EJBCompiler;
import jeus.service.archive.ArchiveArrayClassLoader;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_EJB9;
import jeus.xml.binding.ejbHelper.BeanPair;
import jeus.xml.binding.ejbHelper.CMEntityBeanPair;
import jeus.xml.binding.ejbHelper.RelationPair;
import jeus.xml.binding.ejbHelper.RelationshipRolePair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleSchema {
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.ejb.schema.ModuleSchema");
    public static final String defaultLocalHomeClassName = "jeus.ejb.bean.objectbase.DefaultLocalHome";
    public static final String defaultLocalObjectClassName = "jeus.ejb.bean.objectbase.DefaultLocalObject";
    public Hashtable entitiesCMP2 = new Hashtable();
    public Hashtable entitiesCMP1 = new Hashtable();
    private String moduleName;
    private FileArchive tempArchive;
    private ArchiveArrayClassLoader loader;
    private FileArchive jarArchive;

    public ModuleSchema(String moduleName, FileArchive jarArchive, FileArchive tempArchive, ArchiveArrayClassLoader loader) {
        if (logger.isLoggable(JeusMessage_EJB9._5851_LEVEL)) {
            logger.logp(JeusMessage_EJB9._5851_LEVEL, "ModuleSchema", "<init>", JeusMessage_EJB9._5851, (Object)moduleName);
        }
        this.moduleName = moduleName;
        this.tempArchive = tempArchive;
        this.jarArchive = jarArchive;
        this.loader = loader;
        if (logger.isLoggable(JeusMessage_EJB9._5852_LEVEL)) {
            logger.logp(JeusMessage_EJB9._5852_LEVEL, "ModuleSchema", "<init>", JeusMessage_EJB9._5852);
        }
    }

    public List<FailedBeanInfo> generateModuleSchema(List<BeanPair> beanList, List<RelationPair> relationList, boolean fastDeploy, boolean compileAllBeans, boolean isOnlyGenerating, EJBCompiler compiler) throws Exception {
        BeanSchema bSchema;
        String ejbName;
        BeanSchema bSchema2;
        if (logger.isLoggable(JeusMessage_EJB9._5853_LEVEL)) {
            logger.logp(JeusMessage_EJB9._5853_LEVEL, "ModuleSchema", "generateModuleSchema", JeusMessage_EJB9._5853, (Object)this.moduleName);
        }
        ArrayList<FailedBeanInfo> failedGenBeans = new ArrayList<FailedBeanInfo>();
        for (BeanPair next : beanList) {
            if (!next.isConManagedEntityBean()) continue;
            String beanName = next.getBeanName();
            if (((CMEntityBeanPair)next).getCMPVersion() > 1) {
                if (logger.isLoggable(JeusMessage_EJB9._5854_LEVEL)) {
                    logger.logp(JeusMessage_EJB9._5854_LEVEL, "ModuleSchema", "generateModuleSchema", JeusMessage_EJB9._5854, (Object)beanName);
                }
                this.entitiesCMP2.put(beanName, new BeanSchema((CMEntityBeanPair)next, this, this.jarArchive, this.tempArchive, this.moduleName, this.loader, compiler));
                continue;
            }
            if (logger.isLoggable(JeusMessage_EJB9._5855_LEVEL)) {
                logger.logp(JeusMessage_EJB9._5855_LEVEL, "ModuleSchema", "generateModuleSchema", JeusMessage_EJB9._5855, (Object)beanName);
            }
            this.entitiesCMP1.put(beanName, new BeanSchema((CMEntityBeanPair)next, this, this.jarArchive, this.tempArchive, this.moduleName, this.loader, compiler));
        }
        for (RelationPair aRelationList : relationList) {
            this.initRelationSchema(aRelationList);
        }
        if (logger.isLoggable(JeusMessage_EJB9._5856_LEVEL)) {
            logger.logp(JeusMessage_EJB9._5856_LEVEL, "ModuleSchema", "generateModuleSchema", JeusMessage_EJB9._5856);
        }
        Enumeration<Object> e = this.entitiesCMP2.elements();
        while (e.hasMoreElements()) {
            bSchema2 = (BeanSchema)e.nextElement();
            CMEntityBeanPair desc = bSchema2.beanPair;
            if (desc.getEJBLocalHomeClassName() != null || bSchema2.relations.isEmpty()) continue;
            if (logger.isLoggable(JeusMessage_EJB9._5857_LEVEL)) {
                logger.logp(JeusMessage_EJB9._5857_LEVEL, "ModuleSchema", "generateModuleSchema", JeusMessage_EJB9._5857);
            }
            desc.setEJBLocalHomeClassName(defaultLocalHomeClassName);
            desc.setEJBLocalObjectClassName(defaultLocalObjectClassName);
            if (!logger.isLoggable(JeusMessage_EJB9._5858_LEVEL)) continue;
            logger.logp(JeusMessage_EJB9._5858_LEVEL, "ModuleSchema", "generateModuleSchema", JeusMessage_EJB9._5858);
        }
        if (logger.isLoggable(JeusMessage_EJB9._5859_LEVEL)) {
            logger.logp(JeusMessage_EJB9._5859_LEVEL, "ModuleSchema", "generateModuleSchema", JeusMessage_EJB9._5859);
        }
        if (logger.isLoggable(JeusMessage_EJB9._5860_LEVEL)) {
            logger.logp(JeusMessage_EJB9._5860_LEVEL, "ModuleSchema", "generateModuleSchema", JeusMessage_EJB9._5860);
        }
        e = this.entitiesCMP2.keys();
        while (e.hasMoreElements()) {
            ejbName = (String)e.nextElement();
            try {
                if (logger.isLoggable(JeusMessage_EJB9._5861_LEVEL)) {
                    logger.logp(JeusMessage_EJB9._5861_LEVEL, "ModuleSchema", "generateModuleSchema", JeusMessage_EJB9._5861, (Object)ejbName);
                }
                bSchema = (BeanSchema)this.entitiesCMP2.get(ejbName);
                bSchema.sortRelations();
                bSchema.setCMRFieldName();
                bSchema.sqlGen.getPkeyFieldInfo();
                bSchema.sqlGen.analyzeDataSchema(this.moduleName, true);
                if (!logger.isLoggable(JeusMessage_EJB9._5862_LEVEL)) continue;
                logger.logp(JeusMessage_EJB9._5862_LEVEL, "ModuleSchema", "generateModuleSchema", JeusMessage_EJB9._5862, (Object)ejbName);
            }
            catch (Exception t) {
                if (logger.isLoggable(JeusMessage_EJB9._5863_LEVEL)) {
                    logger.logp(JeusMessage_EJB9._5863_LEVEL, "ModuleSchema", "generateModuleSchema", JeusMessage_EJB9._5863, (Throwable)t);
                }
                failedGenBeans.add(new FailedBeanInfo(ejbName, t));
                if (!compileAllBeans) {
                    throw t;
                }
                if (!logger.isLoggable(JeusMessage_EJB9._5864_LEVEL)) continue;
                logger.logp(JeusMessage_EJB9._5864_LEVEL, "ModuleSchema", "generateModuleSchema", JeusMessage_EJB9._5864);
            }
        }
        if (logger.isLoggable(JeusMessage_EJB9._5865_LEVEL)) {
            logger.logp(JeusMessage_EJB9._5865_LEVEL, "ModuleSchema", "generateModuleSchema", JeusMessage_EJB9._5865);
        }
        if (logger.isLoggable(JeusMessage_EJB9._5866_LEVEL)) {
            logger.logp(JeusMessage_EJB9._5866_LEVEL, "ModuleSchema", "generateModuleSchema", JeusMessage_EJB9._5866);
        }
        e = this.entitiesCMP1.keys();
        while (e.hasMoreElements()) {
            bSchema2 = (BeanSchema)this.entitiesCMP1.get(e.nextElement());
            bSchema2.sqlGen.getPkeyFieldInfo();
            bSchema2.sqlGen.analyzeDataSchema(this.moduleName, false);
        }
        if (logger.isLoggable(JeusMessage_EJB9._5867_LEVEL)) {
            logger.logp(JeusMessage_EJB9._5867_LEVEL, "ModuleSchema", "generateModuleSchema", JeusMessage_EJB9._5867);
        }
        e = this.entitiesCMP2.keys();
        while (e.hasMoreElements()) {
            ejbName = (String)e.nextElement();
            this.makeCMRFields((BeanSchema)this.entitiesCMP2.get(ejbName), ejbName);
        }
        e = this.entitiesCMP2.keys();
        while (e.hasMoreElements()) {
            ejbName = (String)e.nextElement();
            ((BeanSchema)this.entitiesCMP2.get((Object)ejbName)).sqlGen.analyzeColumnSharing();
        }
        if (!isOnlyGenerating) {
            e = this.entitiesCMP2.keys();
            while (e.hasMoreElements()) {
                ejbName = (String)e.nextElement();
                bSchema = (BeanSchema)this.entitiesCMP2.get(ejbName);
                RelationshipRolePair[] rdescs = new RelationshipRolePair[bSchema.relations.size()];
                for (int k = 0; k < bSchema.relations.size(); ++k) {
                    rdescs[k] = (RelationshipRolePair)bSchema.relations.elementAt(k);
                }
                CMEntityBeanPair beanPair = bSchema.beanPair;
                RelationManager rMan = new RelationManager(rdescs, beanPair.getCMFields().size());
                beanPair.setRelationManager(rMan);
                if (!beanPair.isEnableInstantQL()) continue;
                if (logger.isLoggable(JeusMessage_EJB9._5868_LEVEL)) {
                    logger.logp(JeusMessage_EJB9._5868_LEVEL, "ModuleSchema", "generateModuleSchema", JeusMessage_EJB9._5868, (Object)beanPair.getBeanName());
                }
                EJBDynamicFinder finder = new EJBDynamicFinder(this, ejbName, beanPair.getDBVendor());
                beanPair.setEJBDynamicFinder(finder);
                if (!logger.isLoggable(JeusMessage_EJB9._5869_LEVEL)) continue;
                logger.logp(JeusMessage_EJB9._5869_LEVEL, "ModuleSchema", "generateModuleSchema", JeusMessage_EJB9._5869, (Object)beanPair.getBeanName());
            }
            if (logger.isLoggable(JeusMessage_EJB9._5870_LEVEL)) {
                logger.logp(JeusMessage_EJB9._5870_LEVEL, "ModuleSchema", "generateModuleSchema", JeusMessage_EJB9._5870);
            }
            e = this.entitiesCMP1.keys();
            while (e.hasMoreElements()) {
                ejbName = (String)e.nextElement();
                ((BeanSchema)this.entitiesCMP1.get((Object)ejbName)).sqlGen.generateSQLs();
            }
            if (logger.isLoggable(JeusMessage_EJB9._5871_LEVEL)) {
                logger.logp(JeusMessage_EJB9._5871_LEVEL, "ModuleSchema", "generateModuleSchema", JeusMessage_EJB9._5871);
            }
            if (logger.isLoggable(JeusMessage_EJB9._5872_LEVEL)) {
                logger.logp(JeusMessage_EJB9._5872_LEVEL, "ModuleSchema", "generateModuleSchema", JeusMessage_EJB9._5872);
            }
            e = this.entitiesCMP2.keys();
            while (e.hasMoreElements()) {
                ejbName = (String)e.nextElement();
                ((BeanSchema)this.entitiesCMP2.get((Object)ejbName)).sqlGen.generateSQLs();
            }
        }
        e = this.entitiesCMP2.keys();
        while (e.hasMoreElements()) {
            ejbName = (String)e.nextElement();
            bSchema = (BeanSchema)this.entitiesCMP2.get(ejbName);
            bSchema.sourceGen.generateCMPBaseClass(fastDeploy);
        }
        if (!isOnlyGenerating) {
            e = this.entitiesCMP1.keys();
            while (e.hasMoreElements()) {
                ejbName = (String)e.nextElement();
                ((BeanSchema)this.entitiesCMP1.get((Object)ejbName)).sqlGen.updateDBInfo();
            }
            e = this.entitiesCMP2.keys();
            while (e.hasMoreElements()) {
                ejbName = (String)e.nextElement();
                ((BeanSchema)this.entitiesCMP2.get((Object)ejbName)).sqlGen.updateDBInfo();
            }
        }
        if (logger.isLoggable(JeusMessage_EJB9._5873_LEVEL)) {
            logger.logp(JeusMessage_EJB9._5873_LEVEL, "ModuleSchema", "generateModuleSchema", JeusMessage_EJB9._5873);
        }
        if (logger.isLoggable(JeusMessage_EJB9._5874_LEVEL)) {
            logger.logp(JeusMessage_EJB9._5874_LEVEL, "ModuleSchema", "generateModuleSchema", JeusMessage_EJB9._5874, (Object)String.valueOf(failedGenBeans.size()));
        }
        return failedGenBeans;
    }

    private void initRelationSchema(RelationPair relation) throws EJBServerException {
        if (logger.isLoggable(JeusMessage_EJB9._5875_LEVEL)) {
            logger.logp(JeusMessage_EJB9._5875_LEVEL, "ModuleSchema", "initRelationSchema", JeusMessage_EJB9._5875, (Object)relation);
        }
        RelationshipRolePair desc1 = relation.getRelationshipRole1();
        RelationshipRolePair desc2 = relation.getRelationshipRole2();
        String ejbName = desc1.getEJBName();
        BeanSchema bSchema = (BeanSchema)this.entitiesCMP2.get(ejbName);
        if (bSchema == null) {
            if (logger.isLoggable(JeusMessage_EJB9._5876_LEVEL)) {
                logger.logp(JeusMessage_EJB9._5876_LEVEL, "ModuleSchema", "initRelationSchema", JeusMessage_EJB9._5876, new Object[]{ejbName, relation});
            }
            throw new EJBServerException(JeusMessage_EJB9._5876, new String[]{ejbName, relation.toString()});
        }
        bSchema.relations.add(desc1);
        ejbName = desc2.getEJBName();
        bSchema = (BeanSchema)this.entitiesCMP2.get(ejbName);
        if (bSchema == null) {
            if (logger.isLoggable(JeusMessage_EJB9._5877_LEVEL)) {
                logger.logp(JeusMessage_EJB9._5877_LEVEL, "ModuleSchema", "initRelationSchema", JeusMessage_EJB9._5877, new Object[]{ejbName, relation});
            }
            throw new EJBServerException(JeusMessage_EJB9._5877, new String[]{ejbName, relation.toString()});
        }
        bSchema.relations.add(desc2);
        if (logger.isLoggable(JeusMessage_EJB9._5878_LEVEL)) {
            logger.logp(JeusMessage_EJB9._5878_LEVEL, "ModuleSchema", "initRelationSchema", JeusMessage_EJB9._5878);
        }
    }

    private void makeCMRFields(BeanSchema bSchema, String ejbName) throws EJBServerException {
        if (logger.isLoggable(JeusMessage_EJB9._5879_LEVEL)) {
            logger.logp(JeusMessage_EJB9._5879_LEVEL, "ModuleSchema", "makeCMRFields", JeusMessage_EJB9._5879, (Object)ejbName);
        }
        try {
            int fkeyColNum = 0;
            int fkeyTableNum = 0;
            CMEntityBeanPair beanPair = bSchema.beanPair;
            int cmrfieldIdx = beanPair.getCMFields().size();
            for (int k = 0; k < bSchema.relations.size(); ++k) {
                RelationshipRolePair rdesc = (RelationshipRolePair)bSchema.relations.elementAt(k);
                if (logger.isLoggable(JeusMessage_EJB9._5880_LEVEL)) {
                    logger.logp(JeusMessage_EJB9._5880_LEVEL, "ModuleSchema", "makeCMRFields", JeusMessage_EJB9._5880, (Object)rdesc);
                }
                BeanSchema targetBeanSchema = (BeanSchema)this.entitiesCMP2.get(rdesc.getTargetEJBName());
                CMEntityBeanPair targetBeanPair = targetBeanSchema.beanPair;
                if (rdesc.isResponsibleRelation()) {
                    String tableName;
                    fkeyColNum = this.setFkeyColNames(targetBeanPair, rdesc, fkeyColNum);
                    if (rdesc.isManagedRelationType()) {
                        tableName = beanPair.getTableName();
                        if (logger.isLoggable(JeusMessage_EJB9._5881_LEVEL)) {
                            logger.logp(JeusMessage_EJB9._5881_LEVEL, "ModuleSchema", "makeCMRFields", JeusMessage_EJB9._5881);
                        }
                        rdesc.setRelationTableName(tableName);
                    } else if (rdesc.isManagedJoinRelation()) {
                        this.setMyFkeyColNames(beanPair, rdesc);
                        this.setMyFkeyColNames(targetBeanPair, rdesc.getPair());
                        tableName = this.getTableName(rdesc, ejbName, fkeyTableNum);
                        ++fkeyTableNum;
                        if (logger.isLoggable(JeusMessage_EJB9._5882_LEVEL)) {
                            logger.logp(JeusMessage_EJB9._5882_LEVEL, "ModuleSchema", "makeCMRFields", JeusMessage_EJB9._5882, (Object)tableName);
                        }
                        rdesc.setRelationTableName(tableName);
                    }
                } else if (logger.isLoggable(JeusMessage_EJB9._5883_LEVEL)) {
                    logger.logp(JeusMessage_EJB9._5883_LEVEL, "ModuleSchema", "makeCMRFields", JeusMessage_EJB9._5883);
                }
                CMRFieldRW frw = new CMRFieldRW();
                cmrfieldIdx = this.initCMRFieldRW(beanPair.getModuleName(), cmrfieldIdx, frw, rdesc, targetBeanSchema.sqlGen);
                rdesc.setFieldRW(frw);
            }
        }
        catch (Throwable t) {
            if (logger.isLoggable(JeusMessage_EJB9._5884_LEVEL)) {
                logger.logp(JeusMessage_EJB9._5884_LEVEL, "ModuleSchema", "makeCMRFields", JeusMessage_EJB9._5884, (Object)ejbName, t);
            }
            throw new EJBServerException(JeusMessage_EJB9._5884, ejbName, t);
        }
        if (logger.isLoggable(JeusMessage_EJB9._5885_LEVEL)) {
            logger.logp(JeusMessage_EJB9._5885_LEVEL, "ModuleSchema", "makeCMRFields", JeusMessage_EJB9._5885);
        }
    }

    private int initCMRFieldRW(String moduleName, int cmrfieldIdx, CMRFieldRW frw, RelationshipRolePair rdesc, EJBSQLGenerator dbInfo) {
        if (logger.isLoggable(JeusMessage_EJB9._5886_LEVEL)) {
            logger.logp(JeusMessage_EJB9._5886_LEVEL, "ModuleSchema", "initCMRFieldRW", JeusMessage_EJB9._5886, (Object)rdesc.getTargetEJBName());
        }
        frw.fieldIdx = cmrfieldIdx++;
        frw.pairInterfaceHash = moduleName.hashCode() + rdesc.getTargetEJBName().hashCode();
        frw.isCollection = rdesc.isMultipleRelationType();
        frw.type = rdesc.getRelationType();
        if (frw.isCollection) {
            frw.isSet = rdesc.isSet();
        }
        frw.keyClass = dbInfo.isPkeyField ? null : dbInfo.pkeyClass;
        frw.keyClassFieldRWs = dbInfo.pkeyClassFieldRWs.toArray(ClassFieldRW.dummyArray);
        if (rdesc.isManagedRelationType()) {
            frw.keyClassColNames = rdesc.getFkeyColNames();
        }
        frw.moduleName = moduleName;
        frw.beanName = rdesc.getTargetEJBName();
        frw.fieldName = rdesc.getCMRFieldName();
        if (logger.isLoggable(JeusMessage_EJB9._5887_LEVEL)) {
            logger.logp(JeusMessage_EJB9._5887_LEVEL, "ModuleSchema", "initCMRFieldRW", JeusMessage_EJB9._5887);
        }
        return cmrfieldIdx;
    }

    private String getTableName(RelationshipRolePair rdesc, String ejbName, int fkeyTableNum) {
        String tableName;
        if (logger.isLoggable(JeusMessage_EJB9._5888_LEVEL)) {
            logger.logp(JeusMessage_EJB9._5888_LEVEL, "ModuleSchema", "getTableName", JeusMessage_EJB9._5888);
        }
        if ((tableName = rdesc.getRelationTableName()) == null && (tableName = ejbName + "ft" + fkeyTableNum).length() > 15) {
            tableName = tableName.substring(tableName.length() - 15);
        }
        if (logger.isLoggable(JeusMessage_EJB9._5889_LEVEL)) {
            logger.logp(JeusMessage_EJB9._5889_LEVEL, "ModuleSchema", "getTableName", JeusMessage_EJB9._5889, (Object)tableName);
        }
        return tableName;
    }

    private void setMyFkeyColNames(CMEntityBeanPair beanPair, RelationshipRolePair rdesc) throws JAXBException {
        rdesc.arrangeMyFkeyMap(beanPair.getCMPkeyFields());
    }

    private int setFkeyColNames(CMEntityBeanPair targetBeanPair, RelationshipRolePair rdesc, int fkeyColNum) throws JAXBException {
        List cmPkeyFields = targetBeanPair.getCMPkeyFields();
        return rdesc.arrangeFkeyMap(cmPkeyFields, fkeyColNum);
    }

    public BeanSchema getBeanSchema(String ejbName, int cmpVersion) {
        if (cmpVersion == 1) {
            return (BeanSchema)this.entitiesCMP1.get(ejbName);
        }
        return (BeanSchema)this.entitiesCMP2.get(ejbName);
    }

    public EJBSQLGenerator getTargetBeanDBInfo(RelationshipRolePair relation) {
        return ((BeanSchema)this.entitiesCMP2.get((Object)relation.getTargetEJBName())).sqlGen;
    }

    public BeanSchema getBeanSchemaForAbstractSchemaName(String abstractName) {
        Enumeration e1 = this.entitiesCMP2.elements();
        while (e1.hasMoreElements()) {
            BeanSchema bs = (BeanSchema)e1.nextElement();
            if (!bs.beanPair.getSchemaName().equals(abstractName)) continue;
            return bs;
        }
        return null;
    }

    public boolean isAbstractSchemaName(String name) {
        Enumeration e1 = this.entitiesCMP2.elements();
        while (e1.hasMoreElements()) {
            BeanSchema bs = (BeanSchema)e1.nextElement();
            if (!bs.beanPair.getSchemaName().toLowerCase().equals(name)) continue;
            return true;
        }
        return false;
    }

    public boolean isBeanName(String newVarName) {
        Enumeration e1 = this.entitiesCMP2.keys();
        while (e1.hasMoreElements()) {
            if (!((String)e1.nextElement()).toLowerCase().equals(newVarName)) continue;
            return true;
        }
        return false;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public ArchiveArrayClassLoader getLoader() {
        return this.loader;
    }
}

