/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.schema.cmp11;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.ejb.FinderException;
import javax.ejb.ObjectNotFoundException;
import jeus.ejb.container.CMEntityContainer;
import jeus.ejb.container.ContainerException;
import jeus.ejb.persistence.database.DBUtil;
import jeus.ejb.persistence.database.PLConnection;
import jeus.ejb.persistence.database.SQLTypeTable;
import jeus.ejb.schema.EJBFinder;
import jeus.ejb.schema.EJBSQLGenerator;
import jeus.ejb.schema.EJBSQLGeneratorException;
import jeus.ejb.util.MethodConvertor;
import jeus.util.ErrorMsgManager;
import jeus.util.message.JeusMessage_EJB11;
import jeus.xml.binding.ejbHelper.EJBDescriptorValidationException;

public class EJBFinderForCMP11
extends EJBFinder {
    private String[] findSQLs;
    private ArrayList findMethodNames = new ArrayList();
    private int[][] findIndexes;

    public Object find(Connection con, String methodName, Object[] args, boolean isLocal, boolean isLocalIntf, int fetchSize) throws Exception {
        Object pkey;
        if (methodName.startsWith("findByPrimaryKey")) {
            if (this.checkForPrimaryKeyExistence(args[0], con)) {
                return this.container.getEJBObjectOfInternal(args[0], isLocalIntf, isLocal);
            }
            throw new ObjectNotFoundException();
        }
        int idx = this.findMethodNames.indexOf(methodName);
        Method findMethod = this.findMethods[idx];
        String sqlstr = this.findSQLs[idx];
        int[] findIndex = this.findIndexes[idx];
        PreparedStatement stat = ((PLConnection)con).prepareStatementWithType(sqlstr, this.pkeyClassFieldRWs);
        for (int i = 0; i < findIndex.length; ++i) {
            Object arg = args[findIndex[i]];
            DBUtil.setObjectToDBStatement(arg, stat, i + 1, SQLTypeTable.convertToJDBCType(arg.getClass()));
        }
        stat.setFetchSize(fetchSize);
        ResultSet result = stat.executeQuery();
        Vector pkeys = new Vector();
        while (result.next()) {
            if (this.isPkeyField) {
                pkey = this.pkeyClassFieldRWs[0].restoreFromDBField(result, 1);
            } else {
                pkey = this.pkeyClass.newInstance();
                for (int i = 0; i < this.pkeyClassFieldRWs.length; ++i) {
                    this.pkeyClassFieldRWs[i].restoreFromDBField(pkey, result, i + 1);
                }
            }
            pkeys.add(pkey);
        }
        result.close();
        stat.close();
        if (findMethod.getReturnType() == Collection.class) {
            pkey = pkeys;
        } else if (findMethod.getReturnType() == Enumeration.class) {
            pkey = pkeys.elements();
        } else {
            if (pkeys.size() == 0) {
                throw new ObjectNotFoundException();
            }
            if (pkeys.size() == 1) {
                pkey = pkeys.elementAt(0);
            } else {
                throw new FinderException(ErrorMsgManager.getLocalizedString((int)JeusMessage_EJB11._7136));
            }
        }
        if (pkey == null) {
            throw new ContainerException(JeusMessage_EJB11._7137);
        }
        return this.container.getEJBObjectOfInternal(pkey, isLocalIntf, isLocal);
    }

    public void initFinder(EJBSQLGenerator generator) throws EJBSQLGeneratorException, EJBDescriptorValidationException {
        int i;
        this.writePreparedSelectSQL(generator);
        ArrayList<String> findSQLs = new ArrayList<String>();
        generator.sqlBuilder.addCommonWhereClause();
        if (generator.beanPair.isWriteLockingFindNeeded()) {
            generator.sqlBuilder.addForUpdate();
        }
        this.findByPrimaryKeySQL = generator.sqlBuilder.getSQL();
        generator.sqlBuilder.reset();
        ArrayList<List> findIndexesList = new ArrayList<List>();
        for (i = 0; i < this.findMethods.length; ++i) {
            ArrayList findIndex;
            Method m = this.findMethods[i];
            if (m.getName().equals("findByPrimaryKey")) {
                findSQLs.add(this.findByPrimaryKeySQL);
                this.findMethodNames.add(MethodConvertor.getMethodDeclaration(m));
                findIndexesList.add(Collections.EMPTY_LIST);
                continue;
            }
            String findSQL = generator.beanPair.getFindSQL(m);
            if (findSQL != null && !findSQL.equals("")) {
                findIndex = new ArrayList();
                generator.sqlBuilder.beginWhereClause();
                generator.sqlBuilder.addString(this.convertSQL(findSQL, findIndex));
                generator.sqlBuilder.finishWhereClause();
            } else {
                findIndex = Collections.EMPTY_LIST;
            }
            findIndexesList.add(findIndex);
            if (generator.beanPair.isWriteLockingFindNeeded()) {
                generator.sqlBuilder.addForUpdate();
            }
            findSQLs.add(generator.sqlBuilder.getSQL());
            generator.sqlBuilder.reset();
            this.findMethodNames.add(MethodConvertor.getMethodDeclaration(m));
        }
        this.findSQLs = findSQLs.toArray(new String[0]);
        this.findIndexes = new int[findIndexesList.size()][];
        for (i = 0; i < findIndexesList.size(); ++i) {
            List index = (List)findIndexesList.get(i);
            this.findIndexes[i] = new int[index.size()];
            for (int j = 0; j < index.size(); ++j) {
                Integer integer = (Integer)index.get(j);
                this.findIndexes[i][j] = integer - 1;
            }
        }
    }

    public void setContainer(CMEntityContainer con) {
        this.container = con;
    }

    public String toString() {
        String temp = "findByPrimaryKey : " + this.findByPrimaryKeySQL;
        for (int i = 0; i < this.findSQLs.length; ++i) {
            temp = temp + "\n\tMethod[" + i + "] : " + this.findMethodNames.get(i);
            temp = temp + "\n\tSQL[" + i + "] : " + this.findSQLs[i];
        }
        return temp;
    }

    private String convertSQL(String sql, List indexList) {
        StringBuffer convertSQL = new StringBuffer();
        int type = 0;
        char[] chars = sql.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] == '?') {
                int begin = i + 1;
                if (begin < chars.length && this.isNumber(chars[i + 1])) {
                    i = this.endPositionOfNumber(chars, begin);
                    if (type == 1) {
                        throw new IllegalArgumentException("invalid SQL Format Error : " + sql);
                    }
                    type = 2;
                    indexList.add(new Integer(sql.substring(begin, i + 1)));
                } else {
                    if (type == 2) {
                        throw new IllegalArgumentException("invalid SQL Format Error : " + sql);
                    }
                    type = 1;
                    indexList.add(new Integer(indexList.size() + 1));
                }
                convertSQL.append('?');
                continue;
            }
            convertSQL.append(chars[i]);
        }
        return convertSQL.toString();
    }

    private int endPositionOfNumber(char[] chars, int startIndex) {
        while (this.isNumber(chars[startIndex]) && startIndex < chars.length - 1) {
            ++startIndex;
        }
        if (startIndex == chars.length - 1) {
            return startIndex;
        }
        return --startIndex;
    }

    private boolean isNumber(char num) {
        return num >= '0' && num <= '9';
    }
}

