/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.schema.cmp11;

import java.sql.Connection;
import java.sql.PreparedStatement;
import javax.ejb.EntityBean;
import jeus.ejb.container.ContainerException;
import jeus.ejb.persistence.database.SQLBuilder;
import jeus.ejb.schema.CMPFieldRW;
import jeus.ejb.schema.EJBSQLGenerator;
import jeus.ejb.schema.EJBSQLGeneratorException;
import jeus.ejb.schema.EJBStorer;
import jeus.util.message.JeusMessage_EJB11;

public class EJBStorerForCMP11
extends EJBStorer {
    String ejbStoreSQL;

    public String toString() {
        String temp = "ejbStoreSQL : " + this.ejbStoreSQL;
        if (this.BlobClobSelectorBuilder != null) {
            temp = temp + "\n\tejbStoreBuilder : " + this.ejbStoreBuilder.getSQL() + "\n\tejbBlobClobSelectorBuilder : " + this.BlobClobSelectorBuilder.getSQL() + "\n\tejbBlobClobSelectorBuilder : " + this.BlobClobSelectorBuilder.getSQL();
        }
        return temp;
    }

    public void initStorer(EJBSQLGenerator generator) throws EJBSQLGeneratorException {
        try {
            generator.sqlBuilder.initUpdateSQL();
            generator.sqlBuilder.setTableName(generator.tableName);
            generator.sqlBuilder.beginSetClause();
            for (int i = 0; i < generator.cmNPkeyNormalFieldRWs.size(); ++i) {
                generator.sqlBuilder.addSetColumn(((CMPFieldRW)generator.cmNPkeyNormalFieldRWs.get(i)).getColName());
            }
            generator.sqlBuilder.finishSetClause();
            generator.sqlBuilder.addCommonWhereClause();
            this.ejbStoreSQL = generator.sqlBuilder.getSQL();
            if (this.cmNPkeyClobFieldRWs.length != 0 || this.cmNPkeyBlobFieldRWs.length != 0) {
                this.setUpdateBuilder(generator);
                this.setBlobClobSelectorBuilder(generator);
            }
        }
        catch (Throwable ex) {
            throw new EJBSQLGeneratorException(JeusMessage_EJB11._7146, ex);
        }
    }

    public void store(EntityBean ejbBean, Connection con) throws ContainerException {
        PreparedStatement stat = null;
        try {
            int i;
            stat = con.prepareStatement(this.ejbStoreSQL);
            int idx = 1;
            for (i = 0; i < this.cmNPkeyNormalFieldRWsInBeanTable.length; ++i) {
                this.cmNPkeyNormalFieldRWsInBeanTable[i].setToDBStatement(ejbBean, stat, idx++);
            }
            for (i = 0; i < this.cmPkeyFieldRWs.length; ++i) {
                this.cmPkeyFieldRWs[i].setToDBStatement(ejbBean, stat, idx++);
            }
            int rc = stat.executeUpdate();
            if (rc == 0) {
                throw new ContainerException(JeusMessage_EJB11._7143);
            }
            if (rc > 1) {
                throw new ContainerException(JeusMessage_EJB11._7144, Integer.toString(rc));
            }
            if (this.BlobClobSelectorBuilder != null) {
                this.storeBLOBCLOB(ejbBean, con, null, (SQLBuilder)this.ejbStoreBuilder.clone());
            }
        }
        catch (ContainerException e) {
            throw e;
        }
        catch (Throwable ex) {
            throw new ContainerException(JeusMessage_EJB11._7145, ex);
        }
        finally {
            try {
                stat.close();
            }
            catch (Exception ex) {}
        }
    }
}

