/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.schema.cmp20;

import java.sql.Connection;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.ejb.FinderException;
import javax.transaction.TransactionManager;
import jeus.ejb.container.CMEntityContainer;
import jeus.ejb.persistence.database.PersistenceLayer;
import jeus.ejb.schema.ModuleSchema;
import jeus.ejb.schema.cmp20.EJBQLHandler;
import jeus.ejb.schema.cmp20.EJBSelector;
import jeus.transaction.TMService;
import jeus.transaction.TxHelper;
import jeus.util.ErrorMsgManager;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_EJB11;

public class EJBDynamicFinder {
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.ejb.schema.dynamicFinder");
    private static final int cacheSize = 100;
    private ModuleSchema mSchema;
    private String beanName;
    private String dbVendor;
    private PersistenceLayer pLayer;
    private TransactionManager txManager = TxHelper.getTransactionManager();
    private CMEntityContainer container;
    private Hashtable qlCache = new Hashtable();

    public EJBDynamicFinder(ModuleSchema mSchema, String beanName, String dbVendor) {
        this.mSchema = mSchema;
        this.beanName = beanName;
        this.dbVendor = dbVendor;
    }

    public void setPersistenceLayer(PersistenceLayer pLayer) {
        this.pLayer = pLayer;
    }

    public void setContainer(CMEntityContainer container) {
        this.container = container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection find(String ejbQL, boolean isLocal, boolean isLocalIntf) throws FinderException {
        Connection con = null;
        try {
            EJBSelector selector = (EJBSelector)this.qlCache.get(ejbQL);
            if (selector == null) {
                EJBQLHandler handler = new EJBQLHandler();
                handler.generate(this.mSchema, this.beanName, null, ejbQL, false, this.dbVendor);
                selector = handler.ejbSelector;
                selector.setContainer(this.container);
                if (this.qlCache.size() >= 100) {
                    try {
                        Hashtable hashtable = this.qlCache;
                        synchronized (hashtable) {
                            Enumeration e = this.qlCache.keys();
                            this.qlCache.remove(e.nextElement());
                        }
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                }
                this.qlCache.put(ejbQL, selector);
            }
            con = this.txManager.getTransaction() == TMService.nullTransaction ? this.pLayer.getConnection(false) : this.pLayer.getConnection(true);
            Collection collection = (Collection)selector.select(con, null, isLocal, isLocalIntf, this.container.fetchSize);
            return collection;
        }
        catch (FinderException ex1) {
            if (logger.isLoggable(JeusMessage_EJB11._7150_LEVEL)) {
                logger.log(JeusMessage_EJB11._7150_LEVEL, JeusMessage_EJB11._7150, (Object)ejbQL, (Throwable)ex1);
            }
            throw ex1;
        }
        catch (Throwable t) {
            if (logger.isLoggable(JeusMessage_EJB11._7150_LEVEL)) {
                logger.log(JeusMessage_EJB11._7150_LEVEL, JeusMessage_EJB11._7150, (Object)ejbQL, t);
            }
            throw new FinderException(ErrorMsgManager.getLocalizedString((int)JeusMessage_EJB11._7150, (Object)ejbQL));
        }
        finally {
            block21: {
                if (con != null) {
                    try {
                        con.close();
                    }
                    catch (Throwable e) {
                        if (!logger.isLoggable(JeusMessage_EJB11._7149_LEVEL)) break block21;
                        logger.log(JeusMessage_EJB11._7149_LEVEL, JeusMessage_EJB11._7149, e);
                    }
                }
            }
        }
    }
}

