/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.schema.cmp20;

import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Set;
import jeus.ejb.persistence.database.SQLTypeTable;
import jeus.ejb.schema.AbstractSchemaHandlerFactory;
import jeus.ejb.schema.BeanSchema;
import jeus.ejb.schema.CMPFieldRW;
import jeus.ejb.schema.CMRFieldRW;
import jeus.ejb.schema.ClassFieldRW;
import jeus.ejb.schema.EJBSQLGenerator;
import jeus.ejb.schema.EJBSQLGeneratorException;
import jeus.ejb.schema.FieldRW;
import jeus.ejb.schema.ModuleSchema;
import jeus.ejb.schema.cmp20.EJBSelector;
import jeus.ejb.schema.ejbql.SQLBuilderVisitor;
import jeus.ejb.schema.ejbql.ValidationVisitor;
import jeus.ejb.schema.ejbql.element.EJBQLParseException;
import jeus.ejb.schema.ejbql.element.EJBQLQuery;
import jeus.ejb.schema.ejbql.parser.EJBQLParser;
import jeus.util.message.JeusMessage_EJB11;
import jeus.xml.binding.ejbHelper.RelationshipRolePair;

public class EJBQLHandler {
    public ModuleSchema mSchema;
    public String ejbName;
    public Method m;
    public String ejbQL;
    public String dbVendor;
    public EJBQLQuery sentence;
    public EJBSelector ejbSelector = new EJBSelector();
    public Hashtable idTable = new Hashtable();
    public boolean isReturnTypeRemote;
    public int idenIdx;
    public boolean isFind;
    public boolean isCollection;
    public boolean isSet;
    private static final AbstractSchemaHandlerFactory factory = AbstractSchemaHandlerFactory.createSchemaHandlerFactory(2);
    public boolean isResultSet;

    public String generate(ModuleSchema mSchema, String ejbName, Method m, String ejbQL, boolean isReturnTypeRemote, String dbVendor) throws EJBSQLGeneratorException {
        try {
            this.mSchema = mSchema;
            this.ejbName = ejbName;
            this.m = m;
            this.ejbQL = ejbQL;
            this.isReturnTypeRemote = isReturnTypeRemote;
            this.dbVendor = dbVendor;
            if (m == null) {
                this.isFind = true;
                this.isCollection = true;
            } else {
                this.isFind = m.getName().startsWith("find");
                Class<?> returnType = m.getReturnType();
                if (Collection.class.isAssignableFrom(returnType)) {
                    this.isCollection = true;
                    if (Set.class.isAssignableFrom(returnType)) {
                        this.isSet = true;
                    }
                } else if (ResultSet.class.isAssignableFrom(returnType)) {
                    this.isResultSet = true;
                    this.ejbSelector.setResultSet();
                }
            }
            this.sentence = EJBQLParser.parse(ejbQL);
            ValidationVisitor validation = new ValidationVisitor(this.sentence, this);
            validation.validate();
            SQLBuilderVisitor builder = new SQLBuilderVisitor(this.sentence, this, dbVendor);
            this.sentence = builder.generateSQL();
            this.ejbSelector.sql = this.sentence.getSQL();
            BeanSchema bschema = mSchema.getBeanSchema(ejbName, 2);
            if (bschema.beanPair.isWriteLockingFindNeeded()) {
                this.ejbSelector.sql = this.ejbSelector.sql + "FOR UPDATE";
            }
            this.ejbSelector.outField = this.sentence.getOutField();
            if (m == null) {
                this.ejbSelector.inputIdx = new int[0];
                this.ejbSelector.inFields = FieldRW.dummyArray;
            } else {
                int i;
                ArrayList inputIdxList = this.sentence.getParamIndexList();
                ArrayList inputFieldRWList = this.sentence.getParamFieldRWList();
                this.ejbSelector.inputIdx = new int[inputIdxList.size()];
                this.ejbSelector.inFields = new FieldRW[m.getParameterTypes().length];
                for (i = 0; i < inputIdxList.size(); ++i) {
                    int inputIndex;
                    this.ejbSelector.inputIdx[i] = inputIndex = ((Integer)inputIdxList.get(i)).intValue();
                    this.ejbSelector.inFields[inputIndex] = (FieldRW)inputFieldRWList.get(i);
                }
                for (i = 0; i < this.ejbSelector.inputIdx.length; ++i) {
                    if (this.ejbSelector.inFields[this.ejbSelector.inputIdx[i]] != null) continue;
                    throw new EJBSQLGeneratorException(JeusMessage_EJB11._7156, Integer.toString(i));
                }
            }
            return this.ejbSelector.sql;
        }
        catch (Throwable t) {
            throw new EJBSQLGeneratorException(JeusMessage_EJB11._7157, new String[]{m == null ? "" : m.toString(), ejbQL}, t);
        }
    }

    public Class getReturnType() {
        if (this.m == null) {
            return Collection.class;
        }
        return this.m.getReturnType();
    }

    public Class[] getParameterTypes() {
        return this.m.getParameterTypes();
    }

    public boolean isInstantQL() {
        return this.m == null;
    }

    public CMPFieldRW getCMPField(BeanSchema bSchema, String cmpFieldName) {
        ArrayList list = bSchema.cmFieldRWs;
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            CMPFieldRW frw = (CMPFieldRW)list.get(i);
            if (!frw.fieldName.equals(cmpFieldName)) continue;
            return frw;
        }
        return null;
    }

    public RelationshipRolePair getDescriptorForCMRField(BeanSchema bSchema, String cmrFieldName) {
        Enumeration e = bSchema.relations.elements();
        while (e.hasMoreElements()) {
            RelationshipRolePair rDesc = (RelationshipRolePair)e.nextElement();
            if (!rDesc.getCMRFieldName().equals(cmrFieldName)) continue;
            return rDesc;
        }
        return null;
    }

    public BeanSchema getBeanSchema(String ejbName) throws EJBQLParseException {
        BeanSchema bSchema = (BeanSchema)this.mSchema.entitiesCMP2.get(ejbName);
        if (bSchema == null) {
            throw new EJBQLParseException(JeusMessage_EJB11._7158, ejbName);
        }
        return bSchema;
    }

    public CMRFieldRW createCMRFieldRW(BeanSchema bSchema, CMRFieldRW cmrField) {
        CMRFieldRW frw = new CMRFieldRW();
        if (bSchema != null) {
            EJBSQLGenerator dbInfo = bSchema.sqlGen;
            frw.keyClass = dbInfo.pkeyClass;
            frw.keyClassFieldRWs = dbInfo.pkeyClassFieldRWs.toArray(ClassFieldRW.dummyArray);
            frw.moduleName = this.mSchema.getModuleName();
            frw.beanName = bSchema.beanPair.getBeanName();
        } else {
            frw.keyClass = cmrField.keyClass;
            frw.keyClassFieldRWs = cmrField.keyClassFieldRWs;
            frw.moduleName = cmrField.moduleName;
            frw.beanName = cmrField.beanName;
        }
        return frw;
    }

    public CMPFieldRW createCMPFieldRW(CMPFieldRW cmpField) {
        CMPFieldRW frw = factory.createCMPFieldRW();
        frw.type = cmpField.type;
        return frw;
    }

    public void removePairRelation(Hashtable info) {
        int i;
        RelationshipRolePair[] rDescs = new RelationshipRolePair[info.size()];
        int k = 0;
        Enumeration e = info.keys();
        while (e.hasMoreElements()) {
            rDescs[k++] = (RelationshipRolePair)e.nextElement();
        }
        ArrayList<RelationshipRolePair> removeList = new ArrayList<RelationshipRolePair>();
        block1: for (i = 0; i < rDescs.length; ++i) {
            if (rDescs[i] == null) continue;
            RelationshipRolePair pairDescs = rDescs[i].getPair();
            for (int j = i + 1; j < rDescs.length; ++j) {
                if (rDescs[j] == null || rDescs[j] != pairDescs) continue;
                removeList.add(rDescs[j]);
                rDescs[j] = null;
                continue block1;
            }
        }
        for (i = 0; i < removeList.size(); ++i) {
            info.remove(removeList.get(i));
        }
    }

    public int getNumberOfParameters() {
        if (this.m != null) {
            return this.m.getParameterTypes().length;
        }
        return Integer.MAX_VALUE;
    }

    public CMPFieldRW createCMPFieldRW(Class cmpField) throws EJBSQLGeneratorException {
        CMPFieldRW frw = factory.createCMPFieldRW();
        frw.type = SQLTypeTable.convertToJDBCType(cmpField);
        return frw;
    }
}

