/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.schema.cmp20;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import javax.ejb.EntityBean;
import javax.transaction.Transaction;
import jeus.ejb.bean.objectbase.FieldAccessor;
import jeus.ejb.container.ContainerException;
import jeus.ejb.schema.EJBRemover;
import jeus.ejb.schema.EJBSQLGenerator;
import jeus.util.message.JeusMessage_EJB11;
import jeus.xml.binding.ejbHelper.RelationshipRolePair;

public class EJBRemoverForCMP20
extends EJBRemover {
    public int[] allRelationFieldsIdx;
    public int[] casDelFieldIdx;
    private ArrayList removeSQLs = new ArrayList();

    public void remove(EntityBean bean, Connection con, Transaction tx) throws Exception {
        FieldAccessor ejbBean = (FieldAccessor)bean;
        this.rMan.removeRelations(ejbBean, this.allRelationFieldsIdx, tx);
        Object[] fieldsToBeRemovedCascade = null;
        if (this.casDelFieldIdx.length != 0) {
            fieldsToBeRemovedCascade = this.rMan.getFieldValuesForCascadeRemove(ejbBean, this.casDelFieldIdx);
        }
        for (int j = 0; j < this.removeSQLs.size(); ++j) {
            PreparedStatement stat = con.prepareStatement((String)this.removeSQLs.get(j));
            for (int i = 0; i < this.cmPkeyFIeldRWs.length; ++i) {
                this.cmPkeyFIeldRWs[i].setToDBStatement(bean, stat, i + 1);
            }
            int rc = stat.executeUpdate();
            if (j == 0) {
                if (rc == 0) {
                    throw new ContainerException(JeusMessage_EJB11._7159);
                }
                if (rc > 1) {
                    throw new ContainerException(JeusMessage_EJB11._7160, Integer.toString(rc));
                }
            }
            stat.close();
        }
        if (this.casDelFieldIdx.length != 0) {
            this.rMan.cascadeRemove(this.casDelFieldIdx, fieldsToBeRemovedCascade);
        }
    }

    public void initRemover(EJBSQLGenerator generator) {
        this.removeSQLs.add(this.writeRemoveBeanEntitySQL(generator));
        ArrayList<RelationshipRolePair> allRelations = new ArrayList<RelationshipRolePair>();
        ArrayList<RelationshipRolePair> relationToBeRemovedCascade = new ArrayList<RelationshipRolePair>();
        for (int i = 0; i < generator.bSchema.relations.size(); ++i) {
            RelationshipRolePair relation = (RelationshipRolePair)generator.bSchema.relations.elementAt(i);
            allRelations.add(relation);
            if (relation.isManagedJoinRelation()) {
                generator.sqlBuilder.initDeleteSQL();
                generator.sqlBuilder.setTableName(relation.getRelationTableName());
                generator.sqlBuilder.beginWhereClause();
                generator.sqlBuilder.addWhereQuestion(relation.getMyfkeyColNames());
                generator.sqlBuilder.finishWhereClause();
                this.removeSQLs.add(generator.sqlBuilder.getSQL());
            }
            if (!relation.getPair().isCascadeDeletedByOtherBean()) continue;
            relationToBeRemovedCascade.add(relation);
        }
        this.allRelationFieldsIdx = this.makeIntArray(allRelations);
        this.casDelFieldIdx = this.makeIntArray(relationToBeRemovedCascade);
    }

    private int[] makeIntArray(ArrayList removeIdx) {
        int[] intArray = new int[removeIdx.size()];
        for (int i = 0; i < removeIdx.size(); ++i) {
            intArray[i] = ((RelationshipRolePair)removeIdx.get(i)).getFieldRW().getIndex();
        }
        return intArray;
    }

    public String toString() {
        int i;
        String tmp = "";
        for (i = 0; i < this.removeSQLs.size(); ++i) {
            tmp = tmp + "\t" + this.removeSQLs.get(i) + lineSep;
        }
        tmp = tmp + "\t[";
        for (i = 0; i < this.casDelFieldIdx.length; ++i) {
            if (i != 0) {
                tmp = tmp + ",";
            }
            tmp = tmp + this.casDelFieldIdx[i];
        }
        tmp = tmp + "]";
        return tmp;
    }
}

