/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.schema.cmp20;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import jeus.ejb.container.CMEntityContainer;
import jeus.ejb.container.Container;
import jeus.ejb.schema.CMRFieldRW;
import jeus.ejb.schema.FieldRW;
import jeus.ejb.schema.cmp20.EJBResultSet;

public class EJBSelector {
    public String sql;
    public FieldRW outField;
    public FieldRW[] inFields;
    public int[] inputIdx;
    private boolean isResultSet;

    public void setContainer(Container con) {
        if (this.outField instanceof CMRFieldRW) {
            ((CMRFieldRW)this.outField).myContainer = (CMEntityContainer)con;
        }
    }

    public Object select(Connection con, Object[] args, boolean isLocal, boolean isLocalIntf, int fetchSize) throws Exception {
        PreparedStatement stat = con.prepareStatement(this.sql);
        stat.setFetchSize(fetchSize);
        int idx = 1;
        for (int i = 0; i < this.inputIdx.length; ++i) {
            idx += this.inFields[this.inputIdx[i]].write(args[this.inputIdx[i]], stat, idx);
        }
        ResultSet result = stat.executeQuery();
        if (this.isResultSet) {
            return new EJBResultSet(result, con, stat);
        }
        Object returnValue = this.outField.read(result, 1, isLocal, isLocalIntf);
        result.close();
        stat.close();
        return returnValue;
    }

    public String toString() {
        StringBuffer tmp = new StringBuffer(this.sql);
        if (this.inputIdx.length > 0) {
            tmp.append(", input index order : ");
            for (int i = 0; i < this.inputIdx.length; ++i) {
                tmp.append("[").append(this.inputIdx[i]).append("]");
            }
        }
        return tmp.toString();
    }

    public void setResultSet() {
        this.isResultSet = true;
    }
}

