/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.schema.cmp20;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import jeus.ejb.container.RelationManager;
import jeus.ejb.schema.EJBTableChecker;
import jeus.xml.binding.ejbHelper.RelationshipRolePair;

public class EJBTableCheckerForCMP20
extends EJBTableChecker {
    public void checkTable(Connection con, RelationManager rMan) throws Exception {
        this.checkExistenceOfTable(con, this.beanTableName);
        Statement stat = con.createStatement();
        stat.setFetchSize(1);
        this.checkExistenceOfColumns(stat);
        RelationshipRolePair[] rdescs = rMan.getEJBRDescs();
        for (int i = 0; i < rdescs.length; ++i) {
            if (rdescs[i].isManagedRelationType()) {
                this.checkExistenceOfColumns(stat, this.beanTableName, rdescs[i].getFkeyColNames());
                continue;
            }
            if (!rdescs[i].isManagedJoinRelation()) continue;
            this.checkExistenceOfTable(con, rdescs[i].getRelationTableName());
            this.checkExistenceOfColumns(stat, rdescs[i].getRelationTableName(), rdescs[i].getFkeyColNames());
            this.checkExistenceOfColumns(stat, rdescs[i].getRelationTableName(), rdescs[i].getMyfkeyColNames());
        }
        stat.close();
    }

    private void checkExistenceOfColumns(Statement stat, String tableName, String[] columns) throws SQLException {
        this.sqlBuilder.initEmpty();
        this.sqlBuilder.beginFromClause();
        this.sqlBuilder.setTableName(tableName);
        this.sqlBuilder.finishFromClause();
        this.sqlBuilder.beginWhereClause();
        this.sqlBuilder.addString("1 = 0");
        this.sqlBuilder.finishWhereClause();
        String tail = this.sqlBuilder.getSQL();
        this.sqlBuilder.initSelectSQL();
        this.sqlBuilder.mark();
        for (int i = 0; i < columns.length; ++i) {
            this.sqlBuilder.addColumnName(columns[i]);
            String sql = this.sqlBuilder.merge(tail).getSQL();
            this.sqlBuilder.reset();
            ResultSet result = stat.executeQuery(sql);
            result.close();
        }
    }
}

