/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.schema.cmp20;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import jeus.ejb.schema.EJBSQLGenerator;
import jeus.ejb.schema.EJBTableCreator;
import jeus.util.message.JeusMessage_EJB11;
import jeus.xml.binding.ejbHelper.RelationshipRolePair;

public class EJBTableCreatorForCMP20
extends EJBTableCreator {
    ArrayList relationTableCreateSQLs = new ArrayList();

    public void initTableCreator(EJBSQLGenerator generator) {
        this.writeCreatingBeanTable(generator);
        for (int i = 0; i < generator.bSchema.relations.size(); ++i) {
            RelationshipRolePair relation = (RelationshipRolePair)generator.bSchema.relations.elementAt(i);
            if (!relation.isManagedJoinRelation()) continue;
            this.relationTableCreateSQLs.add(this.writeCreatingRelationTable(relation, generator));
        }
    }

    public void createTable(Connection con) throws SQLException {
        try {
            Statement stat = con.createStatement();
            stat.addBatch(this.beanTableCreateSQL);
            for (int i = 0; i < this.relationTableCreateSQLs.size(); ++i) {
                stat.addBatch((String)this.relationTableCreateSQLs.get(i));
            }
            stat.executeBatch();
            stat.close();
        }
        catch (SQLException ex) {
            if (logger.isLoggable(JeusMessage_EJB11._7173_LEVEL)) {
                logger.log(JeusMessage_EJB11._7173_LEVEL, JeusMessage_EJB11._7173, (Object)this.beanTableCreateSQL);
            }
            for (int i = 0; i < this.relationTableCreateSQLs.size(); ++i) {
                if (!logger.isLoggable(JeusMessage_EJB11._7173_LEVEL)) continue;
                logger.log(JeusMessage_EJB11._7173_LEVEL, JeusMessage_EJB11._7173, this.relationTableCreateSQLs.get(i));
            }
            throw ex;
        }
    }

    protected void addColumnDeclarationForOtherFields(EJBSQLGenerator generator) {
        for (int i = 0; i < generator.bSchema.relations.size(); ++i) {
            RelationshipRolePair relation = (RelationshipRolePair)generator.bSchema.relations.elementAt(i);
            if (!relation.isManagedRelationType() || relation.isSharedWithCMPFields()) continue;
            String[] fkeyColNames = relation.getFkeyColNames();
            String[] fkeyColTypeIDs = relation.getFkeyColTypeIDs();
            for (int j = 0; j < fkeyColNames.length; ++j) {
                generator.sqlBuilder.addColumnDeclaration(fkeyColNames[j], fkeyColTypeIDs[j]);
            }
        }
    }

    private String writeCreatingRelationTable(RelationshipRolePair relation, EJBSQLGenerator generator) {
        int j;
        generator.sqlBuilder.initCreateTableSQL();
        generator.sqlBuilder.setTableName(relation.getRelationTableName());
        generator.sqlBuilder.beginColumnDeclaration();
        String[] myfkeyColNames = relation.getMyfkeyColNames();
        String[] myfkeyColTypeIDs = relation.getMyfkeyColTypeIDs();
        for (int j2 = 0; j2 < myfkeyColNames.length; ++j2) {
            generator.sqlBuilder.addColumnDeclaration(myfkeyColNames[j2], myfkeyColTypeIDs[j2]);
        }
        String[] fkeyColNames = relation.getFkeyColNames();
        String[] fkeyColTypeIDs = relation.getFkeyColTypeIDs();
        for (j = 0; j < fkeyColNames.length; ++j) {
            generator.sqlBuilder.addColumnDeclaration(fkeyColNames[j], fkeyColTypeIDs[j]);
        }
        generator.sqlBuilder.beginPrimaryKeyConstraint();
        for (j = 0; j < myfkeyColNames.length; ++j) {
            generator.sqlBuilder.addColumnName(myfkeyColNames[j]);
        }
        for (j = 0; j < fkeyColNames.length; ++j) {
            generator.sqlBuilder.addColumnName(fkeyColNames[j]);
        }
        generator.sqlBuilder.finishPrimaryKeyConstraint();
        generator.sqlBuilder.finishColumnDeclaration();
        return generator.sqlBuilder.getSQL();
    }

    public String toString() {
        String temp = "beanTableCreateSQL : " + this.beanTableCreateSQL;
        for (int i = 0; i < this.relationTableCreateSQLs.size(); ++i) {
            temp = temp + "\n\trelationTableCreateSQL[" + i + "] :" + this.relationTableCreateSQLs.get(i);
        }
        return temp;
    }
}

