/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.schema.cmp20;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import jeus.ejb.bean.objectbase.EJBLocalObjectImpl;
import jeus.ejb.container.CMEntityContainer;
import jeus.ejb.container.RelationManager;
import jeus.transaction.TransactionImpl;
import jeus.transaction.TxHelper;
import jeus.util.ErrorMsgManager;
import jeus.util.JeusRuntimeException;
import jeus.util.message.JeusMessage_EJB11;

public class RelationSet
implements Set {
    private RelationManager rMan;
    private HashSet set = new HashSet();
    private TransactionManager txManager = TxHelper.getTransactionManager();
    private TransactionImpl tx = null;
    private EJBLocalObjectImpl[] listAtTxStart;
    private int fieldIdx;
    private EJBLocalObjectImpl ejbBean;
    private boolean modifiedInTx;
    private int pairInterfaceHash;

    public RelationSet(EJBLocalObjectImpl[] refs, CMEntityContainer container, int fieldIdx, EJBLocalObjectImpl ejbBean, int pairInterfaceHash) {
        try {
            this.rMan = container.rMan;
            this.tx = (TransactionImpl)this.txManager.getTransaction();
            this.fieldIdx = fieldIdx;
            this.ejbBean = ejbBean;
            this.pairInterfaceHash = pairInterfaceHash;
            if (refs == null) {
                this.listAtTxStart = EJBLocalObjectImpl.dummyArray;
            } else {
                for (int i = 0; i < refs.length; ++i) {
                    this.set.add(refs[i]);
                }
                this.listAtTxStart = refs;
            }
        }
        catch (Throwable t) {
            throw new JeusRuntimeException(JeusMessage_EJB11._7163, t);
        }
    }

    public void setTransaction(Transaction tx) {
        if (this.tx != tx) {
            this.listAtTxStart = this.set.toArray(EJBLocalObjectImpl.dummyArray);
            this.tx = (TransactionImpl)tx;
        }
    }

    public int size() {
        this.checkRunningInSameTx();
        return this.set.size();
    }

    public boolean isEmpty() {
        this.checkRunningInSameTx();
        return this.set.isEmpty();
    }

    private void checkRunningInSameTx() {
        Transaction currTx = null;
        try {
            currTx = this.txManager.getTransaction();
        }
        catch (Throwable t) {
            throw new JeusRuntimeException(JeusMessage_EJB11._7164, t);
        }
        if (!this.tx.equals(currTx)) {
            throw new IllegalStateException(ErrorMsgManager.getLocalizedString((int)JeusMessage_EJB11._7165));
        }
    }

    public boolean contains(Object o) {
        this.checkRunningInSameTx();
        if (!(o instanceof EJBLocalObjectImpl) || ((EJBLocalObjectImpl)o).getInterfaceHash() != this.pairInterfaceHash || ((EJBLocalObjectImpl)o).isUnexported()) {
            throw new IllegalArgumentException(ErrorMsgManager.getLocalizedString((int)JeusMessage_EJB11._7166));
        }
        return this.set.contains(o);
    }

    public Iterator iterator() {
        this.checkRunningInSameTx();
        return new RelationIterator();
    }

    public Iterator getInnerIterator() {
        return this.set.iterator();
    }

    public Object[] toArray() {
        this.checkRunningInSameTx();
        return this.set.toArray();
    }

    public Object[] toArray(Object[] a) {
        this.checkRunningInSameTx();
        return this.set.toArray(a);
    }

    public boolean add(Object o) {
        this.checkRunningInSameTx();
        if (!(o instanceof EJBLocalObjectImpl) || ((EJBLocalObjectImpl)o).getInterfaceHash() != this.pairInterfaceHash || ((EJBLocalObjectImpl)o).isUnexported()) {
            throw new IllegalArgumentException(ErrorMsgManager.getLocalizedString((int)JeusMessage_EJB11._7166));
        }
        if (this.set.add(o)) {
            this.rMan.addRelation(this.ejbBean, this.fieldIdx, (EJBLocalObjectImpl)o);
            this.modifiedInTx = true;
            return true;
        }
        return false;
    }

    public boolean remove(Object o) {
        this.checkRunningInSameTx();
        if (!(o instanceof EJBLocalObjectImpl) || ((EJBLocalObjectImpl)o).getInterfaceHash() != this.pairInterfaceHash || ((EJBLocalObjectImpl)o).isUnexported()) {
            throw new IllegalArgumentException(ErrorMsgManager.getLocalizedString((int)JeusMessage_EJB11._7166));
        }
        if (this.set.remove(o)) {
            this.rMan.removeRelation(this.ejbBean, this.fieldIdx, (EJBLocalObjectImpl)o);
            this.modifiedInTx = true;
            return true;
        }
        return false;
    }

    public boolean containsAll(Collection c) {
        this.checkRunningInSameTx();
        if (!(c instanceof RelationSet)) {
            Iterator iter = c.iterator();
            while (iter.hasNext()) {
                if (((EJBLocalObjectImpl)iter.next()).getInterfaceHash() == this.pairInterfaceHash) continue;
                throw new IllegalArgumentException(ErrorMsgManager.getLocalizedString((int)JeusMessage_EJB11._7166));
            }
        }
        return this.set.containsAll(c);
    }

    public boolean addAll(Collection c) {
        this.checkRunningInSameTx();
        boolean modified = false;
        if (c instanceof RelationSet) {
            RelationSet rset = (RelationSet)c;
            if (!rset.isEmpty()) {
                Iterator iter = rset.getInnerIterator();
                while (iter.hasNext()) {
                    EJBLocalObjectImpl targetObject = (EJBLocalObjectImpl)iter.next();
                    if (!this.set.add(targetObject)) continue;
                    this.rMan.addRelation(this.ejbBean, this.fieldIdx, targetObject);
                    modified = true;
                }
            }
        } else if (!c.isEmpty()) {
            Iterator iter = c.iterator();
            while (iter.hasNext()) {
                if (((EJBLocalObjectImpl)iter.next()).getInterfaceHash() == this.pairInterfaceHash) continue;
                throw new IllegalArgumentException(ErrorMsgManager.getLocalizedString((int)JeusMessage_EJB11._7166));
            }
            for (EJBLocalObjectImpl targetObject : c) {
                if (!this.set.add(targetObject)) continue;
                this.rMan.addRelation(this.ejbBean, this.fieldIdx, targetObject);
                modified = true;
            }
        }
        if (modified) {
            this.modifiedInTx = true;
        }
        return modified;
    }

    public boolean removeAll(Collection c) {
        this.checkRunningInSameTx();
        boolean modified = false;
        if (c instanceof RelationSet) {
            RelationSet rset = (RelationSet)c;
            if (!rset.isEmpty()) {
                Iterator iter = rset.getInnerIterator();
                while (iter.hasNext()) {
                    EJBLocalObjectImpl targetObject = (EJBLocalObjectImpl)iter.next();
                    if (!this.set.remove(targetObject)) continue;
                    this.rMan.removeRelation(this.ejbBean, this.fieldIdx, targetObject);
                    modified = true;
                }
            }
        } else if (!c.isEmpty()) {
            Iterator iter = c.iterator();
            while (iter.hasNext()) {
                if (((EJBLocalObjectImpl)iter.next()).getInterfaceHash() == this.pairInterfaceHash) continue;
                throw new IllegalArgumentException(ErrorMsgManager.getLocalizedString((int)JeusMessage_EJB11._7166));
            }
            for (EJBLocalObjectImpl targetObject : c) {
                if (!this.set.remove(targetObject)) continue;
                this.rMan.removeRelation(this.ejbBean, this.fieldIdx, targetObject);
                modified = true;
            }
        }
        if (modified) {
            this.modifiedInTx = true;
        }
        return modified;
    }

    public boolean retainAll(Collection c) {
        this.checkRunningInSameTx();
        c.isEmpty();
        boolean modified = false;
        Iterator iter = this.set.iterator();
        while (iter.hasNext()) {
            EJBLocalObjectImpl targetObject = (EJBLocalObjectImpl)iter.next();
            if (c.contains(targetObject)) continue;
            iter.remove();
            this.rMan.removeRelation(this.ejbBean, this.fieldIdx, targetObject);
            modified = true;
        }
        if (modified) {
            this.modifiedInTx = true;
        }
        return modified;
    }

    public void clear() {
        this.checkRunningInSameTx();
        Iterator iter = this.set.iterator();
        while (iter.hasNext()) {
            this.rMan.removeRelation(this.ejbBean, this.fieldIdx, (EJBLocalObjectImpl)iter.next());
        }
        this.set.clear();
    }

    public boolean equals(Object o) {
        this.checkRunningInSameTx();
        return this.set.equals(o);
    }

    public int hashCode() {
        this.checkRunningInSameTx();
        return this.set.hashCode();
    }

    public void innerAdd(Object o) {
        if (this.set.add(o)) {
            this.modifiedInTx = true;
        }
    }

    public void innerClear() {
        this.set.clear();
    }

    public void innerRemove(Object o) {
        if (this.set.remove(o)) {
            this.modifiedInTx = true;
        }
    }

    public void setModified() {
        this.modifiedInTx = true;
    }

    public EJBLocalObjectImpl[][] set(Collection rSet) {
        EJBLocalObjectImpl[] newlist = rSet.toArray(EJBLocalObjectImpl.dummyArray);
        EJBLocalObjectImpl[] newlistCopy = new EJBLocalObjectImpl[newlist.length];
        System.arraycopy(newlist, 0, newlistCopy, 0, newlist.length);
        EJBLocalObjectImpl[][] lists = this.makeDiff(this.set.toArray(EJBLocalObjectImpl.dummyArray), newlistCopy);
        if (lists[0].length != 0 || lists[1].length != 0) {
            this.set.clear();
            for (int i = 0; i < newlist.length; ++i) {
                this.set.add(newlist[i]);
            }
            this.modifiedInTx = true;
        }
        return lists;
    }

    private EJBLocalObjectImpl[][] makeDiff(EJBLocalObjectImpl[] prevList, EJBLocalObjectImpl[] currList) {
        int i;
        EJBLocalObjectImpl[][] lists = new EJBLocalObjectImpl[2][];
        int numUnchangedRef = 0;
        block0: for (int i2 = 0; i2 < prevList.length; ++i2) {
            for (int j = 0; j < currList.length; ++j) {
                if (currList[j] == null || !prevList[i2].equals(currList[j])) continue;
                prevList[i2] = null;
                currList[j] = null;
                ++numUnchangedRef;
                continue block0;
            }
        }
        lists[0] = new EJBLocalObjectImpl[prevList.length - numUnchangedRef];
        int idx = 0;
        for (i = 0; i < prevList.length; ++i) {
            if (prevList[i] == null) continue;
            lists[0][idx] = prevList[i];
            ++idx;
        }
        lists[1] = new EJBLocalObjectImpl[currList.length - numUnchangedRef];
        idx = 0;
        for (i = 0; i < currList.length; ++i) {
            if (currList[i] == null) continue;
            lists[1][idx] = currList[i];
            ++idx;
        }
        return lists;
    }

    public EJBLocalObjectImpl[][] getModification() {
        if (!this.modifiedInTx) {
            return null;
        }
        EJBLocalObjectImpl[][] lists = this.makeDiff(this.listAtTxStart, this.set.toArray(EJBLocalObjectImpl.dummyArray));
        this.modifiedInTx = false;
        return lists;
    }

    public String toString() {
        return super.toString() + ", set : " + this.set.toString();
    }

    private class RelationIterator
    implements Iterator {
        private Iterator iter;
        private Object lastAccessedObject;

        public RelationIterator() {
            this.iter = RelationSet.this.set.iterator();
        }

        public boolean hasNext() {
            RelationSet.this.checkRunningInSameTx();
            return this.iter.hasNext();
        }

        public Object next() {
            RelationSet.this.checkRunningInSameTx();
            this.lastAccessedObject = this.iter.next();
            return this.lastAccessedObject;
        }

        public void remove() {
            RelationSet.this.checkRunningInSameTx();
            RelationSet.this.setModified();
            this.iter.remove();
            RelationSet.this.rMan.removeRelation(RelationSet.this.ejbBean, RelationSet.this.fieldIdx, (EJBLocalObjectImpl)this.lastAccessedObject);
        }
    }
}

