/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.schema.ejbql.element;

import jeus.ejb.schema.FieldRW;
import jeus.ejb.schema.ejbql.VariableInfo;
import jeus.ejb.schema.ejbql.Visitor;
import jeus.ejb.schema.ejbql.element.AbstractSchemaName;
import jeus.ejb.schema.ejbql.element.EJBQLParseException;
import jeus.ejb.schema.ejbql.element.EJBQLQuery;
import jeus.ejb.schema.ejbql.element.FromClause;
import jeus.ejb.schema.ejbql.element.FromClauseForSubQuery;
import jeus.ejb.schema.ejbql.element.GroupByClause;
import jeus.ejb.schema.ejbql.element.NewIdentificationVar;
import jeus.ejb.schema.ejbql.element.RangeVarDecl;
import jeus.ejb.schema.ejbql.element.SelectClauseForSubQuery;
import jeus.ejb.schema.ejbql.element.SelectHint;
import jeus.ejb.schema.ejbql.element.WhereClause;

public class EJBQLSubQuery
extends EJBQLQuery {
    private int expressionType;
    public int expectedTypeAtParsingTime;
    public static int UNKNOWN = 0;
    public static int STRING = 1;
    public static int ARITHMETIC = 2;
    public static int STRING_OR_ARITHMETIC = 3;
    private int quantifier;
    public static final int QUANTIFIER_NONE = 0;
    public static final int QUANTIFIER_ALL = 1;
    public static final int QUANTIFIER_ANY = 2;
    public static final int QUANTIFIER_SOME = 3;
    private EJBQLQuery outerQuery;
    private boolean isPretendMainQueryToVisitor;

    public EJBQLSubQuery(SelectClauseForSubQuery select, FromClause from, WhereClause where, GroupByClause groupBy, SelectHint selectHint) {
        super(select, from, where, null, groupBy, selectHint);
    }

    public void accept(Visitor visitor) throws EJBQLParseException {
        if (this.isPretendMainQueryToVisitor) {
            visitor.visitEJBQLQuery(this);
        } else {
            visitor.visitEJBQLSubQuery(this);
        }
    }

    public void setType(int string_or_arithmetic) {
        this.expectedTypeAtParsingTime = string_or_arithmetic;
    }

    public void setExpressionType(int type) {
        this.expressionType = type;
    }

    public void setQuantifier(int quantifier) {
        this.quantifier = quantifier;
    }

    public void setOuterQuery(EJBQLQuery query) {
        this.outerQuery = query;
    }

    public EJBQLQuery getOuterQuery() {
        return this.outerQuery;
    }

    public VariableInfo getVariableInfo(String newVarName) {
        VariableInfo info = (VariableInfo)this.variableTable.get(newVarName);
        if (info == null) {
            info = this.outerQuery.getVariableInfoForOuterVariable(newVarName);
            if (info == null) {
                return null;
            }
            NewIdentificationVar newVar = new NewIdentificationVar(newVarName);
            RangeVarDecl outerVarDecl = new RangeVarDecl(new AbstractSchemaName(), newVar);
            VariableInfo varInfo = new VariableInfo();
            varInfo.setVariableDecl(outerVarDecl);
            varInfo.setBeanSchema(info.getBeanSchema());
            varInfo.setTableReference(info.getTableReference());
            varInfo.attachTableReferenceInfix(info.getTableReferenceInfix() + "_SUB_");
            newVar.setVariableInfo(varInfo);
            this.variableTable.put(newVarName, varInfo);
            ((FromClauseForSubQuery)this.from).addVarDecl(outerVarDecl);
            return varInfo;
        }
        return info;
    }

    public VariableInfo getVariableInfoForOuterVariable(String newVarName) {
        VariableInfo info = (VariableInfo)this.variableTable.get(newVarName);
        if (info == null) {
            info = this.outerQuery.getVariableInfoForOuterVariable(newVarName);
        }
        return info;
    }

    public String getSQL() {
        StringBuffer buffer = new StringBuffer();
        switch (this.quantifier) {
            case 1: {
                buffer.append("ALL ( ");
                break;
            }
            case 2: {
                buffer.append("ANY ( ");
                break;
            }
            case 3: {
                buffer.append("SOME ( ");
                break;
            }
            default: {
                buffer.append("( ");
            }
        }
        buffer.append(super.getSQL()).append(") ");
        return buffer.toString();
    }

    public int getType() {
        return this.expressionType;
    }

    public void setMainQuery() {
        this.isPretendMainQueryToVisitor = true;
    }

    public void addInputParamIndex(int index, FieldRW fieldRW) {
        this.outerQuery.addInputParamIndex(index, fieldRW);
    }
}

